/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.db.CTEDBException;
import commvault.cte.workflow.EngineQueue;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EventManager;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.ExecutionState;
import commvault.cte.workflow.FileUploadMonitor;
import commvault.cte.workflow.JobManager;
import commvault.cte.workflow.JobManagerContext;
import commvault.cte.workflow.ProcessManager;
import commvault.cte.workflow.ThreadManager;
import commvault.cte.workflow.WorkflowAlert;
import commvault.cte.workflow.WorkflowEngine;
import commvault.cte.workflow.WorkflowProcess;
import commvault.cte.workflow.WorkflowThread;
import commvault.cte.workflow.db.cs.JMJobOptions_t;
import commvault.cte.workflow.db.cs.JMMisc_t;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.CommServUtils;
import commvault.msgs.App.EventSeverity;
import commvault.msgs.Workflow.AlertType;

public class WorkflowManager
extends ProcessManager {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(WorkflowManager.class);
    private JobManagerContext jobManager;
    private WorkflowThread thread;
    protected volatile EngineQueue queue = null;
    protected int cleanupTime;

    protected WorkflowManager(WorkflowProcess workflowProcess) {
        super(workflowProcess);
        logger.debug(this.getJobId(), "initializing workflow manager for [%s], workflow [%s]", this.getJobId(), this.getName());
        try {
            this.jobManager = this.createJobManager(workflowProcess);
            workflowProcess.registerJobManager(this.jobManager);
        }
        catch (CTEDBException cTEDBException) {
            logger.error(this.getJobId(), "failed to initialize job manager for workflow [" + this.getName() + "]", cTEDBException);
            this.workflow.setFailureReason(new EvMessageContainer(cTEDBException.getMessage()));
            this.workflow.setStatus(ProcessStatus.PENDING);
            return;
        }
        try {
            workflowProcess.initialize();
        }
        catch (EvFailureException evFailureException) {
            this.workflow.setFailureReason(evFailureException.getMessageContainer());
            this.workflow.setStatus(ProcessStatus.PENDING);
            return;
        }
        if (workflowProcess.isDisabled()) {
            logger.error(workflowProcess.getJobId(), "cannot start workflow [" + this.getName() + "] because activity is disabled");
            EvMessageContainer evMessageContainer = new EvMessageContainer("workflow activity is disabled");
            evMessageContainer.setErrorCode(1301);
            workflowProcess.setFailureReason(evMessageContainer);
            workflowProcess.setStatus(ProcessStatus.PENDING);
            return;
        }
        if (this.workflow.getExecutionState() == ExecutionState.STARTING && this.workflow.getStatus() != ProcessStatus.FAILED) {
            logger.info(this.getJobId(), "initializing job [%s] for workflow [%s]", this.getJobId(), this.getName());
            try {
                EventManager.getInstance().fireWorkflowStartEvent(workflowProcess);
            }
            catch (Throwable throwable) {
                logger.error(this.getJobId(), "failed to initialize workflow [" + this.getName() + "]", throwable);
                this.workflow.setFailureReason(new EvMessageContainer(throwable.getMessage()));
                this.workflow.setStatus(ProcessStatus.PENDING);
                return;
            }
        }
    }

    protected JobManagerContext createJobManager(WorkflowProcess workflowProcess) throws CTEDBException {
        return new JobManager(workflowProcess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        Object object = this.workflow.getLock();
        synchronized (object) {
            if (this.jobManager != null) {
                this.jobManager.save();
            }
            this.workflow.save();
            if (this.getWorkflow().getStatus() == ProcessStatus.SUSPENDED && !this.getWorkflow().isApiWorkflow()) {
                logger.debug(this.getWorkflow().getJobId(), "configuring JM tables for suspending job");
                JMMisc_t jMMisc_t = new JMMisc_t();
                try {
                    if (!jMMisc_t.fill("itemType = 21 and jobid=" + this.workflow.getJobId())) {
                        jMMisc_t.zero();
                        jMMisc_t.jobId.set(Integer.valueOf(Long.valueOf(this.workflow.getJobId()).intValue()));
                        jMMisc_t.itemType.set(Integer.valueOf(21));
                        jMMisc_t.data.set("");
                        jMMisc_t.commcellId.set(Integer.valueOf(2));
                    }
                    jMMisc_t.intData.set(Integer.valueOf(CommServUtils.getCommCellTimeUnix()));
                    jMMisc_t.save();
                }
                catch (CTEDBException cTEDBException) {
                    logger.error(this.workflow.getJobId(), "failed to update JMMisc table with suspend information", cTEDBException);
                    return;
                }
                if (this.workflow.getAutoResumeInterval() > 0) {
                    JMJobOptions_t jMJobOptions_t = new JMJobOptions_t();
                    try {
                        if (!jMJobOptions_t.fill("attributeName='Job AutoResume interval' and jobid=" + this.workflow.getJobId())) {
                            jMJobOptions_t.jobId.set(Integer.valueOf(Long.valueOf(this.workflow.getJobId()).intValue()));
                            jMJobOptions_t.commCellId.set(Integer.valueOf(2));
                            jMJobOptions_t.attributeId.set(Integer.valueOf(42));
                            jMJobOptions_t.attributeName.set("Job AutoResume interval");
                            jMJobOptions_t.attributeValue.set("");
                        }
                        jMJobOptions_t.attributeValueInt.set(Long.valueOf(this.workflow.getAutoResumeInterval()));
                        jMJobOptions_t.save();
                    }
                    catch (CTEDBException cTEDBException) {
                        logger.error(this.workflow.getJobId(), "failed to update JMJobOptions table with auto resume information", cTEDBException);
                        return;
                    }
                }
            }
        }
    }

    @Override
    public WorkflowProcess getWorkflow() {
        return (WorkflowProcess)super.getWorkflow();
    }

    public void dispose() {
        ((WorkflowProcess)this.workflow).dispose();
    }

    public void start() {
        if (this.thread == null) {
            logger.debug(this.getJobId(), "starting thread manager for workflow [%s]", this.getName());
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        WorkflowManager.this.worker();
                    }
                    catch (Throwable throwable) {
                        logger.error(WorkflowManager.this.workflow.getJobId(), "uncaught exception in executing workflow manager, exiting workflow manager!", throwable);
                    }
                    String string = ((WorkflowProcess)WorkflowManager.this.workflow).getFailureReport();
                    if (string.length() > 0) {
                        logger.info(WorkflowManager.this.getJobId(), "workflow [%s] exiting with status [%s], failed activities [%s]", WorkflowManager.this.workflow.getWorkflowName(), WorkflowManager.this.workflow.getStatus().toString(), string);
                    } else {
                        logger.info(WorkflowManager.this.getJobId(), "workflow [%s] exiting with status [%s]", WorkflowManager.this.workflow.getWorkflowName(), WorkflowManager.this.workflow.getStatus().toString());
                    }
                    ThreadManager.getInstance().remove(WorkflowManager.this.thread.getId());
                    WorkflowManager.this.thread = null;
                    WorkflowEngine.getInstance().completeManager(WorkflowManager.this);
                }
            };
            this.thread = new WorkflowThread(runnable, "WorkflowThread-" + this.workflow.getJobId(), this.workflow);
            ThreadManager.getInstance().add(this.thread);
            this.thread.start();
        } else {
            logger.warn(this.getJobId(), "workflow thread manager was already started");
        }
    }

    @Override
    protected void worker() {
        if (this.workflow.isLoggingDisabled()) {
            logger.info(this.getJobId(), "logging for job id [%s] is being disabled", this.getJobId());
            logger.setJobDisabled(this.getJobId());
        }
        if (this.workflow.getExecutionState() == ExecutionState.STARTING) {
            try {
                FileUploadMonitor fileUploadMonitor = new FileUploadMonitor(this.workflow.getWorkflowExecution().getWorkflowInputs(), this.workflow);
                fileUploadMonitor.upload();
            }
            catch (EvFailureException evFailureException) {
                logger.error(this.getJobId(), "failed to upload inputted files");
                this.workflow.setFailureReason(evFailureException.getMessageContainer());
                this.workflow.setStatus(ProcessStatus.FAILED);
                return;
            }
            catch (InterruptedException interruptedException) {
                logger.error(this.getJobId(), "file upload process was interrupted");
                this.workflow.setFailureReason(new EvMessageContainer("file upload process was interrupted"));
                this.workflow.setStatus(ProcessStatus.FAILED);
                return;
            }
            if (this.workflow.getJobInputs() != null) {
                logger.info(this.getJobId(), "starting workflow [%s] with inputs [%s]", this.getName(), this.workflow.getWorkflowExecution().getInputs());
            } else {
                logger.info(this.getJobId(), "starting workflow [%s] with inputs []", this.getName());
            }
        }
        ((WorkflowProcess)this.workflow).clearFailureReport();
        super.worker();
        if (this.workflow.isAutoEnableLogging()) {
            logger.setJobEnabled(this.getJobId());
        }
        logger.debug(this.getJobId(), "process manager thread for workflow [%s] has completed with status [%s], step size [%s]", this.getName(), this.workflow.getStatus(), this.getSize());
        this.complete();
        logger.setJobEnabled(this.getJobId());
    }

    protected void complete() {
        if (this.getSize() == 0) {
            if (this.workflow.getStatus() == ProcessStatus.RUNNING) {
                if (this.workflow.isCompletedWithErrors()) {
                    this.workflow.setStatus(ProcessStatus.COMPLETED_PARTIAL);
                } else {
                    this.workflow.setStatus(ProcessStatus.COMPLETED);
                }
            }
            if (this.workflow.getStatus() == ProcessStatus.INTERRUPT_PENDING) {
                this.workflow.setStatus(ProcessStatus.FAILED);
            }
            if (this.workflow.getStatus() == ProcessStatus.KILL_PENDING) {
                this.workflow.setStatus(ProcessStatus.KILLED);
            }
            if (this.workflow.getStatus() == ProcessStatus.SUSPEND_PENDING) {
                this.workflow.setStatus(ProcessStatus.SUSPENDED);
            }
        }
        if (this.getWorkflow().getStatus().isJobComplete()) {
            if (this.workflow.getStatus() == ProcessStatus.FAILED) {
                this.workflow.setFailureReason(EventMessage.getContainer("JM_WORKFLOW_JOB_FAILED", this.workflow.getName()));
            } else if (this.workflow.getStatus() == ProcessStatus.COMPLETED_PARTIAL) {
                this.workflow.setFailureReason(EventMessage.getContainer("JM_WORKFLOW_JOB_COMPLETED_PARTIAL", this.workflow.getName()));
            }
        }
        this.save();
        if (this.getWorkflow().getStatus().isJobComplete()) {
            if (this.workflow.getStatus() == ProcessStatus.FAILED) {
                EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_JOB_FAILED", this.workflow.getName());
                this.workflow.getJobManager().writeEvent(EventSeverity.MAJOR, evMessageContainer);
                WorkflowAlert workflowAlert = new WorkflowAlert(AlertType.NT_FAILED, this.workflow);
                this.getWorkflow().getJobManager().writeAlert(workflowAlert);
            } else if (this.workflow.getStatus() == ProcessStatus.COMPLETED_PARTIAL) {
                EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_JOB_COMPLETED_PARTIAL", this.workflow.getName());
                this.workflow.getJobManager().writeEvent(EventSeverity.MINOR, evMessageContainer);
                WorkflowAlert workflowAlert = new WorkflowAlert(AlertType.NT_SUCCESS_WITH_ERRORS, this.workflow);
                this.getWorkflow().getJobManager().writeAlert(workflowAlert);
            } else if (!this.workflow.isApiWorkflow()) {
                EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_JOB_COMPLETED", this.workflow.getName());
                this.workflow.getJobManager().writeEvent(EventSeverity.INFO, evMessageContainer);
                WorkflowAlert workflowAlert = new WorkflowAlert(AlertType.NT_SUCCEEDED, this.workflow);
                this.getWorkflow().getJobManager().writeAlert(workflowAlert);
            }
        }
    }

    public boolean isAlive() {
        return this.thread.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isResumable() {
        Object object = this.workflow.getLock();
        synchronized (object) {
            if (this.thread != null) {
                return false;
            }
            return super.isResumable();
        }
    }

    protected JobManagerContext getJobManager() {
        return this.jobManager;
    }
}

