/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.common.xml.XMLDecoder;
import commvault.cte.common.xml.XMLEncoder;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.JobSettings;
import commvault.cte.workflow.WorkflowContext;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.db.cs.UMUsers_t;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.WorkflowUtils;
import commvault.msgs.App.Email;
import commvault.msgs.App.EmailAttachment;
import commvault.msgs.App.GenericResp;
import commvault.msgs.App.SendEmailReq;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeUtility;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.MultiPartEmail;
import workflow.types.Binary;

public class WorkflowMail {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(WorkflowMail.class);
    private static final String CID_IMAGE_TAG = "<img src=\"cid:%s\">";
    private MultiPartEmail mail;
    private WorkflowContext context;
    private JobSettings settings;
    private Long jobId;

    public static List<String> split(String string) {
        return WorkflowUtils.split(string);
    }

    public WorkflowMail(WorkflowContext workflowContext) {
        this.context = workflowContext;
        this.settings = workflowContext.getJobSettings();
        this.jobId = workflowContext.getJobId();
    }

    public WorkflowMail() {
    }

    public WorkflowMail(JobSettings jobSettings, Long l) {
        this.settings = jobSettings;
        this.jobId = l;
    }

    public String send(String string, String string2, String string3) throws EvFailureException {
        return this.send(null, string, string2, string3);
    }

    public String send(String string, String string2, String string3, String string4) throws EvFailureException {
        return this.send(string, string2, string3, string4, false);
    }

    public String send(String string, String string2, String string3, String string4, boolean bl) throws EvFailureException {
        return this.send(string, WorkflowMail.split(string2), string3, string4, bl);
    }

    public String send(String string, String string2, String string3, String string4, String string5, boolean bl) throws EvFailureException {
        return this.send(string, WorkflowMail.split(string2), string3, string4, WorkflowMail.split(string5), bl);
    }

    public String send(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) throws EvFailureException {
        return this.send(string, WorkflowMail.split(string2), WorkflowMail.split(string3), string4, string5, WorkflowMail.split(string6), bl);
    }

    public String send(String string, List<String> list, String string2, String string3, boolean bl) throws EvFailureException {
        return this.send(string, list, string2, string3, null, bl);
    }

    public String send(String string, List<String> list, String string2, String string3, Collection collection, boolean bl) throws EvFailureException {
        return this.send(string, list, null, string2, string3, collection, bl);
    }

    public String send(String string, List<String> list, List<String> list2, String string2, String string3, Collection collection, boolean bl) throws EvFailureException {
        return this.send(string, list, list2, null, string2, string3, collection, bl);
    }

    public String send(String string, List<String> list, List<String> list2, List<String> list3, String string2, String string3, Collection collection, boolean bl) throws EvFailureException {
        return this.send(string, null, list, list2, list3, string2, string3, collection, bl);
    }

    public String send(WorkflowContext workflowContext, List<String> list, workflow.types.Email email) throws EvFailureException {
        this.context = workflowContext;
        this.settings = workflowContext.getJobSettings();
        this.jobId = workflowContext.getJobId();
        Collection<Object> collection = null;
        if (email.getAttachments() != null) {
            collection = email.getAttachments() instanceof Binary || email.getAttachments() instanceof File ? Arrays.asList(email.getAttachments()) : (email.getAttachments() instanceof Collection ? (Collection)email.getAttachments() : WorkflowUtils.split(String.valueOf(email.getAttachments())));
        }
        String string = email.getFrom() == null || email.getFrom().length() == 0 ? workflowContext.getJobSettings().getSmtpSender() : email.getFrom();
        return this.send(string, email.getReplyTo(), list, WorkflowUtils.split(email.getCc()), WorkflowUtils.split(email.getBcc()), email.getSubject(), email.getBody(), collection, email.getHtml());
    }

    public String send(String string, String string2, List<String> list, List<String> list2, List<String> list3, String string3, String string4, Collection collection, boolean bl) throws EvFailureException {
        Object object;
        String string52;
        Iterator<String> iterator;
        Object object2;
        String string6;
        if (WorkflowRegistry.getInstance().isRelayEmail() || this.settings.isSmtpSSL()) {
            return this.relay(string, list, list2, list3, string3, string4, collection, bl);
        }
        if (this.mail == null) {
            this.mail = bl ? new HtmlEmail() : new MultiPartEmail();
        }
        this.mail.setCharset("utf-8");
        logger.debug("Smtp Server: [%s]", this.settings.getSmtpServer());
        logger.debug("Smtp Port: [%s]", this.settings.getSmtpPort());
        this.mail.setHostName(this.settings.getSmtpServer());
        this.mail.setSmtpPort(this.settings.getSmtpPort());
        logger.debug("Smtp Credentials Req: [%s]", this.settings.isSmtpCredentialsReq());
        if (this.settings.isSmtpCredentialsReq()) {
            logger.debug("Authentication Username: [%s]", this.settings.getSmtpUsername());
            this.mail.setAuthentication(this.settings.getSmtpUsername(), this.settings.getSmtpPassword());
        }
        logger.debug("Smtp SSL: [%s]", this.settings.isSmtpSSL());
        if (this.settings.isSmtpSSL()) {
            logger.debug("Ssl Smtp Port: [%s]", this.settings.getSmtpPort());
            this.mail.setSslSmtpPort(String.valueOf(this.settings.getSmtpPort()));
            this.mail.setSSLOnConnect(true);
            this.mail.setSSLCheckServerIdentity(false);
            this.mail.setStartTLSEnabled(true);
        }
        try {
            string6 = this.findFromAddress(string);
            logger.debug("From: [%s], Address: [%s]", string, string6);
            this.mail.setFrom(string6, string6, "UTF-8");
        }
        catch (Exception exception) {
            logger.error(this.jobId, "failed to set the from address [" + string + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        if (string2 != null && string2.length() > 0) {
            try {
                logger.debug("Reply To: [%s]", string2);
                this.mail.addReplyTo(string2, string2, "UTF-8");
            }
            catch (EmailException emailException) {
                logger.error(this.jobId, "failed to set reply to address [" + string2 + "]", emailException);
                throw new EvFailureException(new EvMessageContainer(emailException.getMessage()));
            }
        }
        if (list != null) {
            object2 = list.iterator();
            while (object2.hasNext()) {
                iterator = (String)object2.next();
                try {
                    string52 = this.findEmailUser((String)((Object)iterator));
                    if (string52 == null) continue;
                    logger.debug("To: [%s], Address: [%s]", iterator, string52);
                    this.mail.addTo(string52, string52, "UTF-8");
                }
                catch (Exception exception) {
                    logger.error(this.jobId, "failed to add to address [" + iterator + "]", exception);
                    throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
                }
            }
        }
        if (list2 != null) {
            object2 = list2.iterator();
            while (object2.hasNext()) {
                iterator = (String)object2.next();
                try {
                    string52 = this.findEmailUser((String)((Object)iterator));
                    if (string52 == null) continue;
                    logger.debug("Cc: [%s], Address: [%s]", iterator, string52);
                    this.mail.addCc(string52, string52, "UTF-8");
                }
                catch (Exception exception) {
                    logger.error(this.jobId, "failed to add cc address [" + iterator + "]", exception);
                    throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
                }
            }
        }
        if ((object2 = WorkflowMail.split(WorkflowRegistry.getInstance().getGlobalEmailRecipients())) != null) {
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                string52 = iterator.next();
                try {
                    object = this.findEmailUser(string52);
                    if (object == null) continue;
                    logger.debug("Global Cc: [%s], Address: [%s]", string52, object);
                    this.mail.addCc((String)object, (String)object, "UTF-8");
                }
                catch (Exception exception) {
                    logger.error(this.jobId, "failed to add cc address [" + string52 + "]", exception);
                    throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
                }
            }
        }
        if (list3 != null) {
            for (String string52 : list3) {
                try {
                    object = this.findEmailUser(string52);
                    if (object == null) continue;
                    logger.debug("Bcc: [%s], Address: [%s]", string52, object);
                    this.mail.addBcc((String)object, (String)object, "UTF-8");
                }
                catch (Exception exception) {
                    logger.error(this.jobId, "failed to add bcc address [" + string52 + "]", exception);
                    throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
                }
            }
        }
        logger.debug("Subject: [%s]", string3);
        this.mail.setSubject(string3);
        if (collection != null && collection.size() > 0) {
            for (String string52 : collection) {
                String string7;
                Object object3;
                if (string52 instanceof Binary) {
                    object3 = (Binary)string52;
                    logger.debug(this.jobId, "adding binary attachment [%s]", ((Binary)string52).getName());
                    object = new ByteArrayDataSource(object3.getBytes(), "application/octet-stream");
                    string7 = object3.getName();
                }
                if (string52 instanceof File) {
                    object3 = (File)((Object)string52);
                    logger.debug(this.jobId, "adding file attachment [%s]", ((File)object3).getAbsolutePath());
                    object = new FileDataSource((File)object3);
                    string7 = ((File)object3).getName();
                } else {
                    object3 = new File(String.valueOf(string52));
                    logger.debug(this.jobId, "adding file attachment [%s]", ((File)object3).toString());
                    object = new FileDataSource((File)object3);
                    string7 = ((File)object3).getName();
                }
                try {
                    this.mail.attach((DataSource)object, this.getAttachmentName(string7), "");
                }
                catch (Exception exception) {
                    logger.error(this.jobId, "failed to attach [" + object.getName() + "]", exception);
                }
            }
        }
        try {
            if (string4.trim().length() > 0) {
                if (this.mail instanceof HtmlEmail) {
                    ((HtmlEmail)this.mail).setHtmlMsg(string4);
                } else {
                    this.mail.setMsg(string4);
                }
            } else {
                this.mail.setMsg(" ");
            }
        }
        catch (EmailException emailException) {
            logger.error(this.jobId, "failed to set body message", emailException);
            throw new EvFailureException(new EvMessageContainer(emailException.getMessage()));
        }
        try {
            this.mail.send();
        }
        catch (EmailException emailException) {
            logger.error(this.jobId, "failed to send message, host [" + this.settings.getSmtpServer() + "], port [" + this.settings.getSmtpPort() + "]", emailException);
            throw new EvFailureException(new EvMessageContainer(emailException.getMessage()));
        }
        return string6;
    }

    private String findFromAddress(String string) throws Exception {
        String string2 = this.findEmailUser(string);
        if (string2 == null) {
            logger.warn("did not get a from email from address [" + string + "], will configure default from address");
            return this.settings.getSmtpSender();
        }
        return string2;
    }

    private String findEmailUser(String string) throws Exception {
        UMUsers_t uMUsers_t = new UMUsers_t();
        String string2 = String.format("login = '%s'", string);
        if (uMUsers_t.fill(string2)) {
            if (uMUsers_t.email.isNull() || uMUsers_t.email.get().length() == 0) {
                throw new Exception("email address for user [" + string + "] is empty");
            }
            String string3 = uMUsers_t.email.get();
            if (!string3.equals("Email Disabled")) {
                return string3;
            }
            logger.warn("recipient [" + string + "] has a disabled email address, skipping");
            return null;
        }
        return string;
    }

    public static boolean isValidEmailAddress(String string) {
        boolean bl = true;
        try {
            InternetAddress internetAddress = new InternetAddress(string);
            internetAddress.validate();
        }
        catch (AddressException addressException) {
            bl = false;
        }
        return bl;
    }

    private Email buildEmailObj(String string) {
        Email email = new Email();
        email.setEmailAddress(string);
        email.setDisplayName(string);
        return email;
    }

    private String relay(String string, List<String> list, List<String> list2, List<String> list3, String string2, String string3, Collection collection, boolean bl) throws EvFailureException {
        String string4;
        String string52;
        Iterator iterator;
        Object object;
        logger.info(this.jobId, "relaying email through CommServ");
        SendEmailReq sendEmailReq = new SendEmailReq();
        String string6 = null;
        try {
            string6 = this.findFromAddress(string);
            sendEmailReq.getEmailInfo().getFromEmail().setEmailAddress(string6);
        }
        catch (Exception exception) {
            logger.error("failed to set from address [" + string + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        sendEmailReq.getEmailInfo().getFromEmail().setDisplayName(string);
        logger.debug(this.jobId, "TO Address: [%s]", list.size());
        if (list != null) {
            object = list.iterator();
            while (object.hasNext()) {
                iterator = (String)object.next();
                logger.debug(this.jobId, "TO Address: [%s]", iterator);
                try {
                    string52 = this.findEmailUser((String)((Object)iterator));
                    if (string52 == null) continue;
                    sendEmailReq.getEmailInfo().getToEmail().add(this.buildEmailObj(string52));
                }
                catch (Exception exception) {
                    logger.error("failed to add TO address [" + iterator + "]", exception);
                }
            }
        }
        if (list2 != null) {
            object = list2.iterator();
            while (object.hasNext()) {
                iterator = (String)object.next();
                logger.debug(this.jobId, "TO Address: [%s]", iterator);
                try {
                    string52 = this.findEmailUser((String)((Object)iterator));
                    if (string52 == null) continue;
                    sendEmailReq.getEmailInfo().getCcEmail().add(this.buildEmailObj(string52));
                }
                catch (Exception exception) {
                    logger.error("failed to add CC address [" + iterator + "]", exception);
                }
            }
        }
        if ((object = WorkflowMail.split(WorkflowRegistry.getInstance().getGlobalEmailRecipients())) != null) {
            iterator = object.iterator();
            while (iterator.hasNext()) {
                string52 = iterator.next();
                try {
                    string4 = this.findEmailUser(string52);
                    if (string4 == null) continue;
                    logger.debug("Global Cc: [" + string52 + "], Address: [" + string4 + "]");
                    sendEmailReq.getEmailInfo().getCcEmail().add(this.buildEmailObj(string4));
                }
                catch (Exception exception) {
                    logger.error(this.jobId, "failed to add cc address [" + string52 + "]", exception);
                    throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
                }
            }
        }
        if (list3 != null) {
            for (String string52 : list3) {
                logger.debug(this.jobId, "TO Address: [%s]", string52);
                try {
                    string4 = this.findEmailUser(string52);
                    if (string4 == null) continue;
                    sendEmailReq.getEmailInfo().getBccEmail().add(this.buildEmailObj(string4));
                }
                catch (Exception exception) {
                    logger.error("failed to add CC address [" + string52 + "]", exception);
                }
            }
        }
        sendEmailReq.getEmailInfo().setSubject(string2);
        sendEmailReq.getEmailInfo().setBody(string3);
        if (collection != null && collection.size() > 0) {
            for (String string52 : collection) {
                string4 = new EmailAttachment();
                if (string52 instanceof Binary) {
                    if (((Binary)string52).getBytes() != null) {
                        logger.debug(this.jobId, "adding binary attachment [%s]", ((Binary)string52).getName());
                        string4.setAttachmentName(((Binary)string52).getName());
                        string4.setData(((Binary)string52).getBytes());
                    } else {
                        logger.warn(this.jobId, "cannot attach file [%s] as there is no data", ((Binary)string52).getName());
                    }
                } else {
                    Object object2;
                    if (string52 instanceof File) {
                        object2 = (File)((Object)string52);
                        string4.setAttachmentName(((File)object2).getName());
                        try {
                            string4.setData(WorkflowUtils.getBytes(new FileInputStream((File)object2)));
                        }
                        catch (Exception exception) {
                            logger.debug("failed to read attachment file [%s]", ((File)object2).getAbsolutePath(), exception);
                            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
                        }
                    }
                    object2 = String.valueOf(string52);
                    if (((String)object2).length() > 0) {
                        logger.debug(this.jobId, "adding local attachment [%s]", object2);
                        File file = new File((String)object2);
                        string4.setAttachmentName(file.getName());
                        try {
                            string4.setData(WorkflowUtils.getBytes(new FileInputStream(file)));
                        }
                        catch (Exception exception) {
                            logger.error("failed to read attachment file [" + (String)object2 + "]", exception);
                            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
                        }
                    }
                }
                sendEmailReq.getEmailInfo().getAttachments().add(string4);
            }
        }
        try {
            iterator = XMLEncoder.encode((Object)sendEmailReq);
        }
        catch (Exception exception) {
            logger.error("failed to encode [App::SendEmailReq]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        try {
            if (this.context == null || !this.context.getContext().isLoggedIn()) {
                logger.error("user is not logged in");
                throw new EvFailureException(new EvMessageContainer("user is not logged in"));
            }
            string52 = this.context.sendMessage((String)((Object)iterator));
        }
        catch (Exception exception) {
            logger.error("failed to execute xml [xml]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        try {
            string4 = (GenericResp)XMLDecoder.decode((String)string52, (Object)new GenericResp());
        }
        catch (Exception exception) {
            logger.error("failed to decode [App::GenericResp], xml [" + string52 + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        if (string4.getErrorCode() != 0) {
            logger.error("failed to relay email, errorCode [" + string4.getErrorCode() + "], errorMessage [" + string4.getErrorMessage() + "]");
            throw new EvFailureException(new EvMessageContainer(string4.getErrorMessage()));
        }
        return string6;
    }

    private String getAttachmentName(String string) throws Exception {
        if (this.isAscii(string)) {
            return string;
        }
        return MimeUtility.encodeText((String)string, (String)"UTF-8", null);
    }

    private boolean isAscii(String string) {
        for (char c : string.toCharArray()) {
            if (c <= '\u007f') continue;
            return false;
        }
        return true;
    }

    private HtmlEmail getMail() {
        if (this.mail == null) {
            this.mail = new HtmlEmail();
        }
        return (HtmlEmail)this.mail;
    }

    public String embed(String string) throws Exception {
        String string2 = this.getMail().embed(new URL(string), string);
        return String.format(CID_IMAGE_TAG, string2);
    }

    public String embed(File file) throws Exception {
        String string = this.getMail().embed(file);
        return String.format(CID_IMAGE_TAG, string);
    }

    public String embed(Binary binary) throws Exception {
        ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(binary.getBytes(), "application/octet-stream");
        String string = this.getMail().embed((DataSource)byteArrayDataSource, binary.getName());
        return String.format(CID_IMAGE_TAG, string);
    }
}

