/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.workflow.CommCellToken;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.logger.CTELogger;
import commvault.qnet.sys.CVPassword;

public class TokenInfo
implements CommCellToken {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(TokenInfo.class);
    public static final String TOKEN_COMMSERVHOST = "string(/QSDKLogin_QAllTokenInfo/tokenInfo/@commServer)";
    public static final String TOKEN_COMMSERVCLIENT = "string(/QSDKLogin_QAllTokenInfo/tokenInfo/@csClientName)";
    public static final String TOKEN_USERNAME = "string(/QSDKLogin_QAllTokenInfo/tokenInfo/@user)";
    private String token;
    private String commServHost;
    private String commServClient;
    private String userName;

    public static TokenInfo decrypt(String string) throws EvFailureException {
        CVPassword cVPassword = new CVPassword();
        String string2 = cVPassword.decrypt(string);
        logger.debug("parsing token xml [%s]", string2);
        WorkflowElement workflowElement = WorkflowElement.parse(string2);
        if (workflowElement == null) {
            logger.error("failed to decrypt token");
            throw new EvFailureException(new EvMessageContainer("failed to decrypt token"));
        }
        TokenInfo tokenInfo = new TokenInfo();
        tokenInfo.token = string;
        try {
            tokenInfo.commServHost = (String)workflowElement.selectSingleNode(TOKEN_COMMSERVHOST);
        }
        catch (Exception exception) {
            logger.error("failed to retrieve elements path [string(/QSDKLogin_QAllTokenInfo/tokenInfo/@commServer)]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        try {
            tokenInfo.commServClient = (String)workflowElement.selectSingleNode(TOKEN_COMMSERVCLIENT);
        }
        catch (Exception exception) {
            logger.error("failed to retrieve elements path [string(/QSDKLogin_QAllTokenInfo/tokenInfo/@csClientName)]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        try {
            tokenInfo.userName = (String)workflowElement.selectSingleNode(TOKEN_USERNAME);
        }
        catch (Exception exception) {
            logger.error("failed to retrieve elements path [string(/QSDKLogin_QAllTokenInfo/tokenInfo/@user)]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        return tokenInfo;
    }

    private TokenInfo() {
    }

    @Override
    public String getCommServHost() {
        return this.commServHost;
    }

    @Override
    public String getCommServClient() {
        return this.commServClient;
    }

    public String getUserName() {
        return this.userName;
    }

    @Override
    public String getToken() {
        return this.token;
    }
}

