/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.db.CTEDBException;
import commvault.cte.util.DateUtilities;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.CVInitiatedFrom;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvFailureReason;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.ExecutionState;
import commvault.cte.workflow.JobManagerContext;
import commvault.cte.workflow.JobSettings;
import commvault.cte.workflow.ProcessContext;
import commvault.cte.workflow.ScheduleView;
import commvault.cte.workflow.SessionContext;
import commvault.cte.workflow.WorkflowImport;
import commvault.cte.workflow.db.DataAccessLayer;
import commvault.cte.workflow.db.engine.WF_ProcessSteps_t;
import commvault.cte.workflow.db.engine.WF_Steps_t;
import commvault.cte.workflow.db.engine.WF_SuperProcess_t;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.dom.WorkflowExecution;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.stream.Marshaller;
import commvault.cte.workflow.utils.WorkflowUtils;
import commvault.msgs.App.XMLSchema;
import commvault.msgs.Workflow.OutputFormat;
import commvault.msgs.Workflow.ScriptDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class SuperProcess
implements ProcessContext {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(SuperProcess.class);
    protected ActivityContext activity;
    protected WorkflowElement parellelElement;
    protected WF_SuperProcess_t superProcessRecord;
    protected SessionContext context;
    protected WorkflowElement process = null;
    protected WorkflowElement variables = null;

    public SuperProcess(ActivityContext activityContext, WF_SuperProcess_t wF_SuperProcess_t) throws EvFailureException {
        this.activity = activityContext;
        this.superProcessRecord = wF_SuperProcess_t;
        this.initProcessElements();
        if (wF_SuperProcess_t.ContextId.isNull()) {
            this.context = activityContext.getContext().newInstance();
            wF_SuperProcess_t.ContextId.set(Integer.valueOf(this.context.getId()));
        } else {
            this.context = activityContext.getContext().getInstance(this.superProcessRecord.ContextId.get());
        }
    }

    protected void initProcessElements() {
        WorkflowElement workflowElement;
        WorkflowElement workflowElement2 = WorkflowElement.parseQuite(this.superProcessRecord.Execution.get());
        if (workflowElement2 != null && workflowElement2.getName().equals("workflow")) {
            this.process = workflowElement2;
        }
        this.variables = (workflowElement = WorkflowElement.parseQuite(this.superProcessRecord.Variables.get())) != null && workflowElement.getName().equals("variables") ? workflowElement : new WorkflowElement("variables");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() {
        Object object = this.activity.getLock();
        synchronized (object) {
            logger.debug(this.getJobId(), "completing process block");
            this.superProcessRecord.Completed.set(Integer.valueOf(DateUtilities.getNow()));
            this.superProcessRecord.State.set(Integer.valueOf(ExecutionState.COMPLETED.toInt()));
            if (this.variables != null) {
                this.superProcessRecord.Variables.set(this.variables.toString());
            }
            try {
                this.superProcessRecord.save();
            }
            catch (CTEDBException cTEDBException) {
                logger.error(this.getJobId(), "failed to save super process entry for process step id [" + this.activity.getProcessStepId() + "]", cTEDBException);
                this.setStatus(ProcessStatus.PENDING);
                this.setFailureReason(new EvMessageContainer(cTEDBException.getMessage()));
                return;
            }
        }
    }

    public Object selectSingleNode(String string) throws Exception {
        return this.getWorkflowExecution().selectSingleNode(string, this.process);
    }

    public List select(String string) throws Exception {
        return this.getWorkflowExecution().select(string, this.process);
    }

    @Override
    public Object getInput(String string) throws EvFailureException {
        try {
            return this.getMarshaller().decode(this.getWorkflowExecution().select("/workflow/inputs/" + string, this.process));
        }
        catch (Exception exception) {
            logger.error("failed to retrieve elements path [/workflow/inputs/" + string + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
    }

    @Override
    public Object getInput(String string, Class<?> clazz) throws EvFailureException {
        if (clazz == null) {
            return this.getInput(string);
        }
        try {
            return this.getMarshaller().decode(this.getWorkflowExecution().select("/workflow/inputs/" + string, this.process), clazz);
        }
        catch (Exception exception) {
            logger.error("failed to retrieve elements path [/workflow/inputs/" + string + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
    }

    @Override
    public Object getObject(String string) throws EvFailureException {
        try {
            return this.getMarshaller().decode(this.getWorkflowExecution().select(string, this.process));
        }
        catch (Exception exception) {
            logger.error("failed to retrieve elements path [" + string + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
    }

    @Override
    public Object getObject(String string, Class<?> clazz) throws EvFailureException {
        if (clazz == null) {
            return this.getObject(string);
        }
        try {
            return this.getMarshaller().decode(this.getWorkflowExecution().select(string, this.process), clazz);
        }
        catch (Exception exception) {
            logger.error("failed to retrieve elements path [" + string + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
    }

    @Override
    public Object getVariable(String string) throws EvFailureException {
        try {
            return this.getMarshaller().decode(this.getWorkflowExecution().select("/workflow/variables/" + string, this.process));
        }
        catch (Exception exception) {
            logger.error("failed to retrieve elements path [/workflow/variables/" + string + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
    }

    @Override
    public Object getVariable(String string, Class<?> clazz) throws EvFailureException {
        if (clazz == null) {
            return this.getVariable(string);
        }
        try {
            return this.getMarshaller().decode(this.getWorkflowExecution().select("/workflow/variables/" + string, this.process), clazz);
        }
        catch (Exception exception) {
            logger.error("failed to retrieve elements path [/workflow/variables/" + string + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
    }

    @Override
    public Object getParentVariable(String string) throws EvFailureException {
        return this.activity.getParentVariable(string);
    }

    @Override
    public Object getParentVariable(String string, Class<?> clazz) throws EvFailureException {
        return this.activity.getParentVariable(string, clazz);
    }

    @Override
    public Object getConfiguration(String string) throws EvFailureException {
        try {
            return this.getMarshaller().decode(this.getWorkflowExecution().select("/workflow/configuration/" + string));
        }
        catch (Exception exception) {
            logger.error("failed to retrieve elements path [/workflow/configuration/" + string + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
    }

    @Override
    public Object getConfiguration(String string, Class<?> clazz) throws EvFailureException {
        if (clazz == null) {
            return this.getConfiguration(string);
        }
        try {
            return this.getMarshaller().decode(this.getWorkflowExecution().select("/workflow/configuration/" + string), clazz);
        }
        catch (Exception exception) {
            logger.error("failed to retrieve elements path [/workflow/configuration/" + string + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
    }

    @Override
    public Object getOutput(String string) throws EvFailureException {
        try {
            return this.getMarshaller().decode(this.getWorkflowExecution().select("/workflow/outputs/" + string, this.process));
        }
        catch (Exception exception) {
            logger.error("failed to retrieve elements path [/workflow/outputs/" + string + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
    }

    @Override
    public Object getOutput(String string, Class<?> clazz) throws EvFailureException {
        if (clazz == null) {
            return this.getOutput(string);
        }
        try {
            return this.getMarshaller().decode(this.getWorkflowExecution().select("/workflow/outputs/" + string, this.process), clazz);
        }
        catch (Exception exception) {
            logger.error("failed to retrieve elements path [/workflow/outputs/" + string + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
    }

    @Override
    public ExecutionState getExecutionState() {
        return ExecutionState.fromInt(this.superProcessRecord.State.get());
    }

    @Override
    public void setExecutionState(ExecutionState executionState) {
        this.superProcessRecord.State.set(Integer.valueOf(executionState.toInt()));
    }

    @Override
    public Integer getSuperProcessId() {
        return this.superProcessRecord.SuperProcessId.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        Object object = this.activity.getLock();
        synchronized (object) {
            this.activity.save();
        }
        if (this.variables != null) {
            this.superProcessRecord.Variables.set(this.variables.toString());
        }
        try {
            this.superProcessRecord.save();
        }
        catch (CTEDBException cTEDBException) {
            logger.error(this.getJobId(), "error saving super process row [" + this.getSuperProcessId() + "]", cTEDBException);
        }
        this.setSaveExecution(true);
    }

    public Integer getLoopIndex() {
        return this.superProcessRecord.LoopIndex.get();
    }

    @Override
    public SessionContext getContext() {
        return this.context;
    }

    @Override
    public void clearFailures() {
        this.activity.clearFailures();
    }

    @Override
    public String getCreator() {
        return this.activity.getCreator();
    }

    @Override
    public String getDescription() {
        return this.activity.getDescription();
    }

    @Override
    public Set<EvFailureReason> getFailures() {
        return this.activity.getFailures();
    }

    @Override
    public CVInitiatedFrom getInitFrom() {
        return this.activity.getInitFrom();
    }

    @Override
    public List<WorkflowImport> getImports() {
        return this.activity.getImports();
    }

    @Override
    public Marshaller getMarshaller() {
        return this.activity.getMarshaller();
    }

    @Override
    public ProcessContext getParent() {
        return this.activity.getParent();
    }

    @Override
    public Integer getProcessStepId() {
        return this.activity.getProcessStepId();
    }

    @Override
    public Date getStartTime() {
        return this.activity.getStartTime();
    }

    @Override
    public Integer getStartTimeUnix() {
        return this.activity.getStartTimeUnix();
    }

    @Override
    public Date getEndTime() {
        return this.activity.getEndTime();
    }

    @Override
    public ProcessStatus getStatus() {
        return this.activity.getStatus();
    }

    @Override
    public int getSubTaskId() {
        return this.activity.getSubTaskId();
    }

    @Override
    public int getTaskId() {
        return this.activity.getTaskId();
    }

    @Override
    public String getUniqueName() {
        return this.activity.getUniqueName();
    }

    @Override
    public String getFriendlyName() {
        return this.activity.getFriendlyName();
    }

    @Override
    public String getExecutor() {
        return this.activity.getExecutor();
    }

    @Override
    public int getExecutorId() {
        return this.activity.getExecutorId();
    }

    @Override
    public int getCreatorId() {
        return this.activity.getCreatorId();
    }

    @Override
    public int getLocaleId() {
        return this.activity.getLocaleId();
    }

    @Override
    public void setOutput(String string, Object object) throws EvFailureException {
        this.activity.setOutput(string, object);
    }

    @Override
    public WorkflowExecution getWorkflowExecution() {
        return this.activity.getWorkflowExecution();
    }

    @Override
    public String getWorkflowName() {
        return this.activity.getWorkflowName();
    }

    @Override
    public void removeFailure(EvFailureReason evFailureReason) {
        this.activity.removeFailure(evFailureReason);
    }

    @Override
    public void removeFailures(Set<EvFailureReason> set) {
        this.activity.removeFailures(set);
    }

    @Override
    public void setFailed(String string) {
        this.activity.setFailed(string);
    }

    @Override
    public void setCompletedWithErrors(boolean bl) {
        this.activity.setCompletedWithErrors(bl);
    }

    @Override
    public boolean isCompletedWithErrors() {
        return this.activity.isCompletedWithErrors();
    }

    @Override
    public void setFailureReason(EvFailureReason evFailureReason) {
        this.activity.setFailureReason(evFailureReason);
    }

    @Override
    public void setFailureReason(EvMessageContainer evMessageContainer) {
        this.activity.setFailureReason(evMessageContainer);
    }

    @Override
    public void setInput(String string, Object object) throws EvFailureException {
        this.activity.setInput(string, object);
    }

    @Override
    public void setVariable(String string, Object object) throws EvFailureException {
        this.activity.setVariable(string, object);
    }

    @Override
    public int getAutoResumeInterval() {
        return this.activity.getAutoResumeInterval();
    }

    @Override
    public void setAutoResumeInterval(int n) {
        this.activity.setAutoResumeInterval(n);
    }

    @Override
    public void suspend(String string) {
        this.activity.setFailureReason(new EvMessageContainer(string));
        this.activity.setStatus(ProcessStatus.SUSPEND_PENDING);
    }

    @Override
    public String impersonateLogin(String string, String string2, String string3) throws EvFailureException {
        return this.getContext().impersonateLogin(string, string2, string3);
    }

    @Override
    public String impersonateLogin(String string, String string2) throws EvFailureException {
        return this.getContext().impersonateLogin(string, string2);
    }

    @Override
    public String impersonateCommCell(String string) throws EvFailureException {
        return this.getContext().impersonateCommCell(string);
    }

    @Override
    public String impersonateCreator() throws EvFailureException {
        return this.getContext().impersonateCreator();
    }

    @Override
    public String impersonateExecutor() throws EvFailureException {
        return this.getContext().impersonateExecutor();
    }

    @Override
    public String getCurrentUserToken() {
        return this.getContext().getCurrentUserToken();
    }

    @Override
    public void logoutImpersonatedUser() {
        this.getContext().logoutImpersonatedUser();
    }

    @Override
    public String getName() {
        return this.activity.getUniqueName();
    }

    @Override
    public long getJobId() {
        return this.activity.getJobId();
    }

    @Override
    public String getProcessId() {
        return this.activity.getProcessId();
    }

    @Override
    public int getCommCellId() {
        return this.activity.getCommCellId();
    }

    @Override
    public EvFailureReason getLastFailure() {
        return this.activity.getLastFailure();
    }

    @Override
    public Object getLock() {
        return this.activity.getLock();
    }

    @Override
    public String getJobInputs() {
        return null;
    }

    @Override
    public String getConfigurationXml() {
        return null;
    }

    @Override
    public WF_Steps_t getStartStep() throws EvFailureException {
        WF_Steps_t wF_Steps_t;
        try {
            wF_Steps_t = this.getDataAccess().getStartStep(this.getDeploymentId(), this.activity.getStepId());
        }
        catch (CTEDBException cTEDBException) {
            logger.error(this.getJobId(), "error retrieving process start activity", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        if (wF_Steps_t == null) {
            logger.error(this.getJobId(), "could not find process start activity for super process [" + this.getName() + "], step id [" + this.activity.getStepId() + "]");
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_RETRIEVE_START", new Object[0]);
            throw new EvFailureException(evMessageContainer);
        }
        return wF_Steps_t;
    }

    @Override
    public void setStatus(ProcessStatus processStatus) {
        this.activity.setStatus(processStatus);
        if (processStatus == ProcessStatus.FAILED || processStatus == ProcessStatus.PENDING) {
            logger.warn(this.getJobId(), "failing super process [%s]", this.getDisplayName());
        }
    }

    @Override
    public List<WF_ProcessSteps_t> getExecutingSteps() throws EvFailureException {
        try {
            logger.debug("getting executing steps for super process id [%s], data access [%s]", this.getSuperProcessId(), this.getDataAccess().getClass());
            return this.getDataAccess().getProcessSteps(this.getJobId(), this.getSuperProcessId(), ExecutionState.RUNNING);
        }
        catch (CTEDBException cTEDBException) {
            logger.error(this.getJobId(), "error retrieving current activities for process block", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
    }

    @Override
    public String getCommCell() {
        return this.activity.getCommCell();
    }

    @Override
    public JobManagerContext getJobManager() {
        return this.activity.getJobManager();
    }

    @Override
    public boolean isRunning() {
        return this.activity.isRunning();
    }

    @Override
    public int getVersion() {
        return this.activity.getVersion();
    }

    @Override
    public int getWorkflowId() {
        return this.activity.getWorkflowId();
    }

    @Override
    public String getJobDescription() {
        return this.activity.getJobDescription();
    }

    @Override
    public void setJobDescription(String string) {
        this.activity.setJobDescription(string);
    }

    @Override
    public JobSettings getJobSettings() {
        return this.activity.getJobSettings();
    }

    @Override
    public void interrupt() {
        this.activity.interrupt();
    }

    @Override
    public boolean isAutoEnableLogging() {
        return this.getParent().isAutoEnableLogging();
    }

    @Override
    public void setLoggingDisabled(boolean bl) {
        this.activity.setLoggingDisabled(bl);
    }

    @Override
    public void setLoggingDisabled(boolean bl, boolean bl2) {
        this.activity.setLoggingDisabled(bl, bl2);
    }

    @Override
    public boolean isLoggingDisabled() {
        return this.activity.isLoggingDisabled();
    }

    @Override
    public boolean isLogRedirected() {
        return this.activity.isLogRedirected();
    }

    @Override
    public void setLogFile(String string) throws Exception {
        this.activity.setLogFile(string);
    }

    @Override
    public void resetLogFile() {
        this.activity.resetLogFile();
    }

    @Override
    public List<WF_Steps_t> getEventSteps(String string) throws EvFailureException {
        return new ArrayList<WF_Steps_t>();
    }

    @Override
    public ScheduleView getScheduleView() {
        return this.activity.getScheduleView();
    }

    @Override
    public String getFailureReason() {
        return this.activity.getFailureReason();
    }

    @Override
    public ProcessContext getRoot() {
        return this.activity.getRoot();
    }

    @Override
    public Integer getDeploymentId() {
        return this.activity.getDeploymentId();
    }

    @Override
    public Integer getCalculatedMaxRestarts() {
        return this.activity.getCalculatedMaxRestarts();
    }

    @Override
    public String sendMessage(String string) throws Exception {
        return WorkflowUtils.executeXml(string, this.getContext(), this.getJobId());
    }

    public void setProcessXml(WorkflowElement workflowElement) {
        this.parellelElement = workflowElement;
    }

    @Override
    public List<WorkflowElement> getProcessXml() {
        List<WorkflowElement> list = this.activity.getParent().getProcessXml();
        if (this.parellelElement != null) {
            list.add(this.parellelElement);
        }
        return list;
    }

    @Override
    public void setSaveExecution(boolean bl) {
        this.getParent().setSaveExecution(true);
    }

    @Override
    public boolean isSaveExecution() {
        return false;
    }

    @Override
    public String getProcessName() {
        return null;
    }

    @Override
    public String getDisplayName() {
        return this.activity.getDisplayName();
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public void addFailedActivity(ActivityContext activityContext) {
        this.activity.getParent().addFailedActivity(activityContext);
    }

    @Override
    public DataAccessLayer getDataAccess() {
        return this.activity.getDataAccess();
    }

    @Override
    public boolean isOnDemand() {
        return this.activity.isOnDemand();
    }

    @Override
    public boolean isDebug() {
        return this.activity.isDebug();
    }

    @Override
    public void setDebug(boolean bl) {
        this.activity.setDebug(bl);
    }

    @Override
    public ProcessStatus getWorkflowStatus() {
        return this.activity.getWorkflowStatus();
    }

    @Override
    public void addCache(String string, Object object) {
        this.activity.addCache(string, object);
    }

    @Override
    public Object getCache(String string) {
        return this.activity.getCache(string);
    }

    @Override
    public int getCacheSize() {
        return this.activity.getCacheSize();
    }

    @Override
    public String getMaskedStep() {
        return null;
    }

    @Override
    public void addDebugMessage(String string) {
        this.activity.addDebugMessage(string);
    }

    @Override
    public List<String> getDebugLog() {
        return this.activity.getDebugLog();
    }

    @Override
    public String getExecutionXml() {
        return this.superProcessRecord.Execution.get();
    }

    @Override
    public XMLSchema getInputSchema() {
        return this.activity.getParent().getInputSchema();
    }

    @Override
    public XMLSchema getVariableSchema() {
        return this.activity.getParent().getVariableSchema();
    }

    @Override
    public XMLSchema getConfigurationSchema() {
        return this.activity.getParent().getConfigurationSchema();
    }

    @Override
    public String getOutputXml() {
        return this.activity.getParent().getOutputXml();
    }

    @Override
    public String getDefinitionInputs() {
        return this.activity.getParent().getDefinitionInputs();
    }

    @Override
    public String getDefinitionVariables() {
        return this.activity.getParent().getDefinitionVariables();
    }

    @Override
    public String getDefinitionConfiguration() {
        return this.activity.getParent().getDefinitionConfiguration();
    }

    @Override
    public XMLSchema getOutputSchema() {
        return this.activity.getParent().getOutputSchema();
    }

    @Override
    public ScriptDefinition getOnComplete() {
        return this.activity.getParent().getOnComplete();
    }

    @Override
    public ScriptDefinition getOnStart() {
        return this.activity.getParent().getOnStart();
    }

    @Override
    public String getOutputs() {
        return this.activity.getParent().getOutputs();
    }

    @Override
    public void setOutputs(String string) {
        this.activity.getParent().setOutputs(string);
    }

    @Override
    public OutputFormat getOutputFormat() {
        return OutputFormat.XML;
    }

    @Override
    public String getSessionId() {
        return this.activity.getSessionId();
    }

    @Override
    public void setSessionId(String string) {
        this.activity.setSessionId(string);
    }

    @Override
    public String getInstanceId() {
        return this.activity.getInstanceId();
    }

    @Override
    public boolean isApiWorkflow() {
        return this.activity.getParent().isApiWorkflow();
    }

    @Override
    public boolean isTransitionCancelled() {
        return this.activity.isTransitionCancelled();
    }

    @Override
    public void setTransitionCancelled(boolean bl) {
        this.activity.setTransitionCancelled(bl);
    }

    @Override
    public ProcessContext getParentWorkflow() {
        return this.activity.getParentWorkflow();
    }

    @Override
    public long getWorkflowJobId() {
        return this.activity.getWorkflowJobId();
    }

    @Override
    public void registerChild(ProcessContext processContext) {
        this.getParent().registerChild(processContext);
    }

    @Override
    public void removeChild(ProcessContext processContext) {
        this.getParent().removeChild(processContext);
    }

    @Override
    public void setSwitchToJob() {
        this.getParent().setSwitchToJob();
    }

    @Override
    public void setAttemptCreation(int n) {
        this.activity.setAttemptCreation(n);
    }

    @Override
    public boolean isTimedOut() {
        return this.activity.isTimedOut();
    }

    @Override
    public String getCallerIP() {
        return this.getParent().getCallerIP();
    }

    @Override
    public boolean isGlobalLock() {
        return this.activity.isGlobalLock();
    }

    @Override
    public boolean isSessionActive() {
        return this.activity.isSessionActive();
    }

    @Override
    public Object getLocalVariable(String string) throws EvFailureException {
        try {
            return this.getMarshaller().decode(this.variables.select("variables/" + string));
        }
        catch (Exception exception) {
            logger.error("failed to retrieve elements path [variables/" + string + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
    }

    @Override
    public Object getLocalVariable(String string, Class<?> clazz) throws EvFailureException {
        if (clazz == null) {
            return this.getLocalVariable(string);
        }
        try {
            return this.getMarshaller().decode(this.variables.select("variables/" + string), clazz);
        }
        catch (Exception exception) {
            logger.error("failed to retrieve elements path [variables/" + string + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
    }

    @Override
    public void setLocalVariable(String string, Object object) throws EvFailureException {
        WorkflowElement workflowElement = this.variables.getChild(string);
        List<WorkflowElement> list = this.getMarshaller().encode(string, object);
        this.variables.removeChildren(string);
        if (list != null) {
            for (WorkflowElement workflowElement2 : list) {
                if (workflowElement != null) {
                    workflowElement2.copyAttributesFrom(workflowElement);
                }
                this.variables.addContent(workflowElement2.clone());
            }
        }
    }

    @Override
    public void setCompletionPercentage(int n) {
        this.activity.setCompletionPercentage(n);
    }

    @Override
    public int getCompletionPercentage() {
        return this.activity.getCompletionPercentage();
    }
}

