/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.db.CTEDBException;
import commvault.cte.util.DateUtilities;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.ExecutionState;
import commvault.cte.workflow.ProcessContext;
import commvault.cte.workflow.SessionContext;
import commvault.cte.workflow.WorkflowContext;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.WorkflowStep;
import commvault.cte.workflow.WorkflowTransition;
import commvault.cte.workflow.activities.WizardBlock;
import commvault.cte.workflow.db.engine.WF_ProcessSteps_t;
import commvault.cte.workflow.db.engine.WF_ProcessTransitions_t;
import commvault.cte.workflow.db.engine.WF_StepTransitions_t;
import commvault.cte.workflow.db.engine.WF_Steps_t;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.Workflow.StepFlags;
import java.util.UUID;

public class StepBuilder {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(StepBuilder.class);

    protected static ActivityContext create(ProcessContext processContext, ActivityContext activityContext, WorkflowTransition workflowTransition, SessionContext sessionContext) throws EvFailureException {
        WF_Steps_t wF_Steps_t;
        try {
            wF_Steps_t = processContext.getDataAccess().getStep(workflowTransition.getTargetStepId());
        }
        catch (CTEDBException cTEDBException) {
            logger.error(processContext.getJobId(), "error retrieving WF_Step record for [" + workflowTransition.getTargetActivity() + "], id [" + workflowTransition.getTargetStepId() + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        if (wF_Steps_t == null) {
            logger.error(processContext.getJobId(), "could not find WF_Step record for [" + workflowTransition.getTargetActivity() + "], id [" + workflowTransition.getTargetStepId() + "]");
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_LOAD_ACTIVITY", workflowTransition.getTargetActivity());
            throw new EvFailureException(evMessageContainer);
        }
        return StepBuilder.create(processContext, activityContext, wF_Steps_t, workflowTransition, sessionContext);
    }

    protected static ActivityContext create(ProcessContext processContext, ActivityContext activityContext, WF_Steps_t wF_Steps_t, WorkflowTransition workflowTransition, SessionContext sessionContext) throws EvFailureException {
        String string = activityContext != null ? activityContext.getSessionId() : processContext.getSessionId();
        if (!processContext.isDebug() && (wF_Steps_t.flags.get() & StepFlags.INTERACTIVE.getEnumValue()) > 0) {
            string = UUID.randomUUID().toString();
        }
        if (workflowTransition != null && workflowTransition.getVirtualProcessStepId() != null) {
            return StepBuilder.loadVirtualStep(processContext, workflowTransition.getVirtualProcessStepId(), sessionContext, string);
        }
        WF_ProcessSteps_t wF_ProcessSteps_t = StepBuilder.buildStep(processContext, wF_Steps_t, workflowTransition, sessionContext, string);
        WF_ProcessTransitions_t wF_ProcessTransitions_t = null;
        if (workflowTransition != null) {
            wF_ProcessTransitions_t = StepBuilder.createTransition(activityContext, wF_Steps_t, wF_ProcessSteps_t, workflowTransition.stepTransition);
        }
        WorkflowStep workflowStep = new WorkflowStep(processContext, wF_Steps_t, wF_ProcessSteps_t, wF_ProcessTransitions_t, sessionContext);
        return workflowStep;
    }

    protected static ActivityContext loadVirtualStep(ProcessContext processContext, int n, SessionContext sessionContext, String string) throws EvFailureException {
        WF_Steps_t wF_Steps_t;
        WF_ProcessSteps_t wF_ProcessSteps_t;
        try {
            wF_ProcessSteps_t = processContext.getDataAccess().getProcessStep(n);
        }
        catch (CTEDBException cTEDBException) {
            logger.error(processContext.getJobId(), "error retrieving process step [" + n + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        wF_ProcessSteps_t.StartTime.set(Integer.valueOf(DateUtilities.getNow()));
        wF_ProcessSteps_t.Modified.set(Integer.valueOf(DateUtilities.getNow()));
        wF_ProcessSteps_t.Status.set(Integer.valueOf(ProcessStatus.QUEUED.toInt()));
        wF_ProcessSteps_t.State.set(Integer.valueOf(ExecutionState.RUNNING.toInt()));
        wF_ProcessSteps_t.PathId.set(Integer.valueOf(0));
        wF_ProcessSteps_t.Attempts.set(Integer.valueOf(0));
        wF_ProcessSteps_t.Executions.set(Integer.valueOf(0));
        wF_ProcessSteps_t.Restarts.set(Integer.valueOf(0));
        wF_ProcessSteps_t.sessionId.set(string);
        try {
            wF_Steps_t = processContext.getDataAccess().getStep(wF_ProcessSteps_t.StepId.get());
        }
        catch (CTEDBException cTEDBException) {
            logger.error(processContext.getJobId(), "error retrieving workflow step [" + wF_ProcessSteps_t.Name.get() + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        WF_ProcessTransitions_t wF_ProcessTransitions_t = null;
        if (!wF_ProcessSteps_t.fromTransitionId.isNull()) {
            try {
                wF_ProcessTransitions_t = processContext.getDataAccess().getTransition(wF_ProcessSteps_t.fromTransitionId.get());
            }
            catch (CTEDBException cTEDBException) {
                logger.error(processContext.getJobId(), "error retrieving source transitions for process step [" + wF_ProcessSteps_t.Name.get() + "]", cTEDBException);
                throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
            }
        }
        return new WorkflowStep(processContext, wF_Steps_t, wF_ProcessSteps_t, wF_ProcessTransitions_t, sessionContext);
    }

    protected static ActivityContext create(ProcessContext processContext, String string, int n) throws EvFailureException {
        WF_ProcessSteps_t wF_ProcessSteps_t;
        try {
            wF_ProcessSteps_t = processContext.getDataAccess().getProcessStep(string, n);
        }
        catch (CTEDBException cTEDBException) {
            logger.error(processContext.getJobId(), "error retrieving process step for activity [" + string + "], context id [" + n + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        if (wF_ProcessSteps_t == null) {
            logger.error(processContext.getJobId(), "could not find process step for activity [" + string + "], context id [" + n + "]");
            EvMessageContainer evMessageContainer = new EvMessageContainer("could not find process step for activity [%s]", string);
            throw new EvFailureException(evMessageContainer);
        }
        return StepBuilder.create(processContext, wF_ProcessSteps_t);
    }

    protected static ActivityContext create(ProcessContext processContext, int n) throws EvFailureException {
        WF_ProcessSteps_t wF_ProcessSteps_t;
        try {
            wF_ProcessSteps_t = processContext.getDataAccess().getProcessStep(n);
        }
        catch (CTEDBException cTEDBException) {
            logger.error(processContext.getJobId(), "error retrieving process step [" + n + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        if (wF_ProcessSteps_t == null) {
            logger.error(processContext.getJobId(), "could not find process step for [" + n + "]");
            EvMessageContainer evMessageContainer = new EvMessageContainer("could not find process step for [%s]", n);
            throw new EvFailureException(evMessageContainer);
        }
        return StepBuilder.create(processContext, wF_ProcessSteps_t);
    }

    protected static ActivityContext create(ProcessContext processContext, WF_ProcessSteps_t wF_ProcessSteps_t) throws EvFailureException {
        WF_Steps_t wF_Steps_t;
        try {
            wF_Steps_t = processContext.getDataAccess().getStep(wF_ProcessSteps_t.StepId.get());
        }
        catch (CTEDBException cTEDBException) {
            logger.error(processContext.getJobId(), "error retrieving workflow step [" + wF_ProcessSteps_t.Name.get() + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        if (wF_Steps_t == null) {
            logger.error(processContext.getJobId(), "could not find process step for [" + wF_ProcessSteps_t.Name.get() + "]");
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_LOAD_ACTIVITY", wF_ProcessSteps_t.Name.get());
            throw new EvFailureException(evMessageContainer);
        }
        WF_ProcessTransitions_t wF_ProcessTransitions_t = null;
        if (!wF_ProcessSteps_t.fromTransitionId.isNull()) {
            try {
                wF_ProcessTransitions_t = processContext.getDataAccess().getTransition(wF_ProcessSteps_t.fromTransitionId.get());
            }
            catch (CTEDBException cTEDBException) {
                logger.error(processContext.getJobId(), "error retrieving source transitions for process step [" + wF_ProcessSteps_t.Name.get() + "]", cTEDBException);
                throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
            }
        }
        SessionContext sessionContext = processContext.getContext().getInstance(wF_ProcessSteps_t.ContextId.get());
        return new WorkflowStep(processContext, wF_Steps_t, wF_ProcessSteps_t, wF_ProcessTransitions_t, sessionContext);
    }

    private static WF_ProcessSteps_t buildStep(ProcessContext processContext, WF_Steps_t wF_Steps_t, WorkflowTransition workflowTransition, SessionContext sessionContext, String string) throws EvFailureException {
        WorkflowElement workflowElement;
        if (sessionContext != null && WorkflowRegistry.getInstance().isRemovePreviousSteps()) {
            processContext.getDataAccess().removePreviousActivityInstance(sessionContext.getId(), wF_Steps_t.StepId.get());
        }
        logger.debug(processContext.getJobId(), "creating process step record for step [%s]", wF_Steps_t.UniqueName.get());
        WF_ProcessSteps_t wF_ProcessSteps_t = processContext.getDataAccess().newProcessStep();
        String.format("jobId = %s AND commCellId = %s AND StepId = %s", processContext.getJobId(), processContext.getCommCellId(), wF_Steps_t.StepId.get());
        wF_ProcessSteps_t.ParentId.set(processContext.getProcessStepId());
        wF_ProcessSteps_t.jobId.set(Long.valueOf(processContext.getJobId()));
        wF_ProcessSteps_t.commCellId.set(Integer.valueOf(processContext.getCommCellId()));
        wF_ProcessSteps_t.StepId.set(wF_Steps_t.StepId.get());
        wF_ProcessSteps_t.Name.set(wF_Steps_t.UniqueName.get());
        wF_ProcessSteps_t.StartTime.set(Integer.valueOf(DateUtilities.getNow()));
        wF_ProcessSteps_t.Modified.set(Integer.valueOf(DateUtilities.getNow()));
        wF_ProcessSteps_t.Status.set(Integer.valueOf(ProcessStatus.QUEUED.toInt()));
        wF_ProcessSteps_t.State.set(Integer.valueOf(ExecutionState.RUNNING.toInt()));
        wF_ProcessSteps_t.WorkflowStart.set(wF_Steps_t.WorkflowStart.get());
        wF_ProcessSteps_t.PathId.set(Integer.valueOf(0));
        wF_ProcessSteps_t.Attempts.set(Integer.valueOf(0));
        wF_ProcessSteps_t.Executions.set(Integer.valueOf(0));
        wF_ProcessSteps_t.Restarts.set(Integer.valueOf(0));
        wF_ProcessSteps_t.superProcessId.set(processContext.getSuperProcessId());
        wF_ProcessSteps_t.flags.set(wF_Steps_t.flags.get());
        wF_ProcessSteps_t.sessionId.set(string);
        wF_ProcessSteps_t.wfJobId.set(Long.valueOf(processContext.getWorkflowJobId()));
        if (processContext instanceof WizardBlock.WizardProcess && (workflowElement = processContext.getWorkflowExecution().getOutput(wF_Steps_t.UniqueName.get())) != null) {
            wF_ProcessSteps_t.Outputs.set(workflowElement.toString());
        }
        if (sessionContext != null) {
            wF_ProcessSteps_t.ContextId.set(Integer.valueOf(sessionContext.getId()));
        } else {
            logger.warn(processContext.getJobId(), "no context available for creating step [%s]", wF_Steps_t.UniqueName.get());
        }
        if (workflowTransition != null) {
            wF_ProcessSteps_t.fromTransitionId.set(workflowTransition.stepTransition.TransitionId.get());
        }
        try {
            wF_ProcessSteps_t.save();
        }
        catch (CTEDBException cTEDBException) {
            logger.error(processContext.getJobId(), "error saving process step for activity [" + wF_Steps_t.UniqueName.get() + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        return wF_ProcessSteps_t;
    }

    private static WF_ProcessTransitions_t createTransition(WorkflowContext workflowContext, WF_Steps_t wF_Steps_t, WF_ProcessSteps_t wF_ProcessSteps_t, WF_StepTransitions_t wF_StepTransitions_t) throws EvFailureException {
        logger.debug(workflowContext.getJobId(), "creating transition record for process step [%s], transition id [%s], target process step [%s]", workflowContext.getProcessStepId(), wF_StepTransitions_t.TransitionId.get(), wF_ProcessSteps_t.ProcessStepId.get());
        WF_ProcessTransitions_t wF_ProcessTransitions_t = workflowContext.getDataAccess().newProcessTransition();
        wF_ProcessTransitions_t.jobId.set(Long.valueOf(workflowContext.getJobId()));
        wF_ProcessTransitions_t.commCellId.set(Integer.valueOf(workflowContext.getCommCellId()));
        wF_ProcessTransitions_t.TransitionId.set(wF_StepTransitions_t.TransitionId.get());
        wF_ProcessTransitions_t.SourceProcessStepId.set(workflowContext.getProcessStepId());
        wF_ProcessTransitions_t.SourceActivity.set(workflowContext.getUniqueName());
        wF_ProcessTransitions_t.TargetProcessStepId.set(wF_ProcessSteps_t.ProcessStepId.get());
        wF_ProcessTransitions_t.TargetStepId.set(wF_Steps_t.StepId.get());
        wF_ProcessTransitions_t.Created.set(Integer.valueOf(DateUtilities.getNow()));
        wF_ProcessTransitions_t.ContextId.set(Integer.valueOf(workflowContext.getParent().getContext().getId()));
        try {
            wF_ProcessTransitions_t.save();
        }
        catch (CTEDBException cTEDBException) {
            logger.error(workflowContext.getJobId(), "error saving source transitions for activity [" + wF_Steps_t.UniqueName.get() + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        return wF_ProcessTransitions_t;
    }
}

