/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.common.schema.SchemaProperty;
import commvault.cte.common.schema.SchemaType;
import commvault.cte.common.schema.util.SchemaEncoder;
import commvault.cte.common.schema.util.SchemaUtils;
import commvault.cte.common.wsdl.Binding;
import commvault.cte.common.wsdl.BindingOperation;
import commvault.cte.common.wsdl.BindingProtocol;
import commvault.cte.common.wsdl.Message;
import commvault.cte.common.wsdl.MessagePart;
import commvault.cte.common.wsdl.PortOperation;
import commvault.cte.common.wsdl.SOAPOperation;
import commvault.cte.common.wsdl.WSDLSystem;
import commvault.cte.db.CTEDBException;
import commvault.cte.db.CTEDBTimestamp;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.activities.WebServiceActivity;
import commvault.cte.workflow.db.cs.WF_ActivityGroup_t;
import commvault.cte.workflow.db.cs.WF_ActivitySet_t;
import commvault.cte.workflow.db.cs.WF_Activity_t;
import commvault.cte.workflow.db.cs.WF_SchemaLocation_t;
import commvault.cte.workflow.db.cs.WF_Schema_t;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.JDOMUtil;
import commvault.cte.workflow.utils.WorkflowUtils;
import commvault.msgs.App.XMLSchema;
import commvault.msgs.CvEntities.UserEntity;
import commvault.msgs.Workflow.ActivitySchema;
import commvault.msgs.Workflow.ImportSOAPService;
import commvault.msgs.Workflow.ImportSOAPServiceResp;
import commvault.msgs.Workflow.OperationModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.jdom2.Element;

public class SoapDeploymentManager {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(SoapDeploymentManager.class);
    private static final String WS_IMAGE_LOCATION = "/webservice.png";
    private WSDLSystem wsdlDocument;
    private final WF_SchemaLocation_t locationRow;
    private ImportSOAPService service;

    public static ImportSOAPServiceResp deploy(ImportSOAPService importSOAPService, UserEntity userEntity) throws EvFailureException {
        logger.info("deploying activities for web service [%s], requested by [%s]", importSOAPService.getSchemaLocation().getSchemaLocationUrl(), userEntity.getUserName());
        SoapDeploymentManager soapDeploymentManager = new SoapDeploymentManager(importSOAPService);
        return soapDeploymentManager.deploy();
    }

    public SoapDeploymentManager(ImportSOAPService importSOAPService) throws EvFailureException {
        this.service = importSOAPService;
        this.locationRow = new WF_SchemaLocation_t();
        try {
            String string = String.format("LocationUrl = '%s'", importSOAPService.getSchemaLocation().getSchemaLocationUrl());
            if (!this.locationRow.fill(string)) {
                logger.error("could not find schema location using where clause [" + string + "]");
                EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_LOAD_SCHEMA", importSOAPService.getSchemaLocation().getSchemaLocationUrl());
                throw new EvFailureException(evMessageContainer);
            }
        }
        catch (Exception exception) {
            logger.error("error retrieving schema location for id [" + importSOAPService.getSchemaLocation().getSchemaLocationId() + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        if (!this.locationRow.xmlInfo.isNull() && this.locationRow.xmlInfo.get().length() > 0) {
            logger.debug("parsing locally stored WSDL file");
            try {
                this.wsdlDocument = WSDLSystem.parse((Reader)new StringReader(this.locationRow.xmlInfo.get()));
            }
            catch (Exception exception) {
                logger.error("error parsing locally stored wsdl [" + this.locationRow.xmlInfo.get() + "]", exception);
                EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_LOAD_WSDL", new Object[0]);
                throw new EvFailureException(evMessageContainer);
            }
        }
        logger.debug("parsing WSDL from [%s]", this.locationRow.LocationUrl.get());
        try {
            this.wsdlDocument = WSDLSystem.parse((URL)new URL(this.locationRow.LocationUrl.get()));
        }
        catch (Exception exception) {
            logger.error("error parsing wsdl from URL [" + this.locationRow.LocationUrl.get() + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
    }

    private XMLSchema buildMessageSchema(PortOperation portOperation, Message message) {
        XMLSchema xMLSchema = null;
        if (message.getAllParts().length > 0) {
            if (message.getAllParts().length > 1) {
                logger.debug("wsdl message contains multiple parts [%s]", message.getAllParts().length);
                for (MessagePart messagePart : message.getAllParts()) {
                    logger.debug("adding message part [%s]", JDOMUtil.serialize(messagePart.getElement()));
                    if (messagePart.getSchemaElement() != null) {
                        logger.debug("adding schema element [%s]", messagePart.getType().toString());
                        xMLSchema = SchemaEncoder.encode((String)portOperation.getName().getLocalPart(), (SchemaType)messagePart.getSchemaElement().getType());
                        continue;
                    }
                    if (messagePart.getSchemaType() != null) {
                        logger.debug("creating schema element [%s] with type [%s]", messagePart.getName().getLocalPart(), messagePart.getType().toString());
                        xMLSchema = new XMLSchema();
                        xMLSchema.setName(portOperation.getName().getLocalPart());
                        XMLSchema xMLSchema2 = SchemaEncoder.encode((String)messagePart.getName().getLocalPart(), (SchemaType)messagePart.getSchemaType());
                        xMLSchema.getChildren().add(xMLSchema2);
                        continue;
                    }
                    logger.warn("could not find schema entry for message type name [%s]", messagePart.getType().toString());
                }
            } else {
                MessagePart messagePart = message.getAllParts()[0];
                logger.debug("wsdl message contains single part [%s]", JDOMUtil.serialize(messagePart.getElement()));
                if (messagePart.getSchemaElement() != null) {
                    logger.debug("building schema from element [%s]", JDOMUtil.serialize(messagePart.getSchemaElement().getElement()));
                    xMLSchema = SchemaEncoder.encode((SchemaProperty)messagePart.getSchemaElement());
                } else if (messagePart.getSchemaType() != null) {
                    logger.debug("creating schema element [%s] from type [%s]", messagePart.getName().getLocalPart(), JDOMUtil.serialize(messagePart.getSchemaType().getElement()));
                    xMLSchema = new XMLSchema();
                    xMLSchema.setName(portOperation.getName().getLocalPart());
                    XMLSchema xMLSchema3 = SchemaEncoder.encode((String)messagePart.getName().getLocalPart(), (SchemaType)messagePart.getSchemaType());
                    xMLSchema.getChildren().add(xMLSchema3);
                } else {
                    logger.warn("could not find schema entry for message type name [%s]", messagePart.getType().toString());
                }
            }
        } else {
            logger.debug("wsdl message does not contain any parts");
        }
        return xMLSchema;
    }

    public ImportSOAPServiceResp deploy() throws EvFailureException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        ImportSOAPServiceResp importSOAPServiceResp = new ImportSOAPServiceResp();
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator iterator = this.service.getOperations().iterator();
        while (iterator.hasNext()) {
            object5 = (OperationModel)iterator.next();
            object4 = null;
            try {
                object4 = QName.valueOf(object5.getPortOperation());
            }
            catch (Throwable throwable) {
                logger.error("invalid port operation for activity [" + object5.getOperationName() + "], removing entry");
                iterator.remove();
                continue;
            }
            object3 = this.getBinding((QName)object4);
            if (object3 == null) {
                logger.error("invalid port operation for activity [" + object5.getOperationName() + "], removing entry");
                iterator.remove();
                continue;
            }
            if (object5.getOperationName().trim().length() == 0) {
                logger.warn("invalid activity name [%s], changing it to [%s]", object5.getOperationName(), object4.getLocalPart());
                object5.setOperationName(object4.getLocalPart());
            }
            if (!SchemaUtils.isValidName((String)object5.getOperationName())) {
                logger.error("invalid activity name [" + object5.getOperationName() + "], removing entry");
                iterator.remove();
                continue;
            }
            arrayList.add(object5.getOperationName().toLowerCase());
            logger.debug("creating schema for web service activity [%s]", object5.getOperationName());
            object2 = new ActivitySchema();
            object2.getInputs().setName("inputs");
            object2.getOutputs().setName("outputs");
            if (object3.getPortOperation().getInput() != null) {
                logger.debug("building input schema from message [%s]", JDOMUtil.serialize(object3.getPortOperation().getInput().getElement()));
                object = this.buildMessageSchema(object3.getPortOperation(), object3.getPortOperation().getInput());
                object2.getInputs().getChildren().add(object);
            }
            if (object3.getPortOperation().getOutput() != null) {
                logger.debug("building output schema from message [%s]", JDOMUtil.serialize(object3.getPortOperation().getOutput().getElement()));
                object = this.buildMessageSchema(object3.getPortOperation(), object3.getPortOperation().getOutput());
                object2.getOutputs().getChildren().add(object);
            }
            if (object3.getHeader() != null) {
                logger.debug("building header schema from message [%s]", JDOMUtil.serialize(object3.getHeader().getElement()));
                object = SchemaEncoder.encode((SchemaProperty)object3.getHeader().getSchemaElement());
                if (object != null) {
                    object2.getInputs().getChildren().add(object);
                }
            }
            object = WorkflowUtils.encodeMessage(object2, "activitySchema");
            logger.debug("generated schema [%s] for activity [%s]", object, object5.getOperationName());
            hashMap.put(object5.getOperationName(), object);
        }
        object5 = this.wsdlDocument.getRoot().getTargetNamespace().getURI();
        if (!((String)object5).endsWith("/")) {
            object5 = (String)object5 + "/";
        }
        object5 = (String)object5 + "activities";
        object4 = null;
        try {
            object3 = WF_Schema_t.select(String.format("LocationId = %s", this.locationRow.LocationId.get()));
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to retrieve current WF_Schema rows for location id [" + this.locationRow.LocationId.get() + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        object2 = object3.iterator();
        while (object2.hasNext()) {
            object = (WF_Schema_t)((Object)object2.next());
            if (((WF_Schema_t)((Object)object)).Namespace.get().equalsIgnoreCase((String)object5)) {
                object4 = object;
                continue;
            }
            logger.info("removing old WF_Schema row namespace [%s]", ((WF_Schema_t)((Object)object)).Namespace.get());
            try {
                object.delete();
            }
            catch (CTEDBException cTEDBException) {
                logger.error("failed to delete WF_Schema row for namespace [" + ((WF_Schema_t)((Object)object)).Namespace.get() + "]", cTEDBException);
            }
        }
        if (object4 == null) {
            object4 = new WF_Schema_t();
            ((WF_Schema_t)((Object)object4)).LocationId.set(this.locationRow.LocationId.get());
            ((WF_Schema_t)((Object)object4)).Namespace.set((String)object5);
            ((WF_Schema_t)((Object)object4)).XsdSchema.set("");
            ((WF_Schema_t)((Object)object4)).Modified.set(CTEDBTimestamp.getNow());
        } else {
            ((WF_Schema_t)((Object)object4)).XsdSchema.set("");
            ((WF_Schema_t)((Object)object4)).Modified.set(CTEDBTimestamp.getNow());
        }
        try {
            object4.save();
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to save WF_Schema row for namespace [" + ((WF_Schema_t)((Object)object4)).Namespace.get() + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        object2 = String.format("SchemaId = %s", ((WF_Schema_t)((Object)object4)).SchemaId.get());
        object = null;
        try {
            object = WF_Activity_t.select((String)object2);
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to retrieve existing activities for schema id [" + ((WF_Schema_t)((Object)object4)).SchemaId.get() + "]", cTEDBException);
        }
        if (object != null) {
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                WF_Activity_t wF_Activity_t = (WF_Activity_t)((Object)iterator2.next());
                if (arrayList.contains(wF_Activity_t.Name.get().toLowerCase())) continue;
                logger.info("removing web service activity [%s] since it wasn't in new request", wF_Activity_t.Name.get());
                try {
                    wF_Activity_t.delete();
                }
                catch (CTEDBException cTEDBException) {
                    logger.error("failed to delete existing activity id [" + wF_Activity_t.ActivityId.get() + "]", cTEDBException);
                }
            }
        }
        int n = 0;
        for (OperationModel operationModel : this.service.getOperations()) {
            if (!this.createActivity(operationModel.getOperationName(), (Element)hashMap.get(operationModel.getOperationName()), ((WF_Schema_t)((Object)object4)).SchemaId.get(), "", operationModel.getPortOperation(), operationModel.getGroup())) continue;
            ++n;
        }
        logger.info("deployment of web service [%s] completed", this.locationRow.LocationUrl.get());
        importSOAPServiceResp.setActivitiesImported(n);
        return importSOAPServiceResp;
    }

    private boolean createActivity(String string, Element element, int n, String string2, String string3, String string4) {
        WF_ActivitySet_t wF_ActivitySet_t;
        WF_Activity_t wF_Activity_t;
        block18: {
            Object object2;
            logger.info("deploying web service activity [%s], operation [%s], group [%s]", string, string3, string4);
            wF_Activity_t = new WF_Activity_t();
            String string5 = String.format("Name = '%s' AND schemaId = %s", string, n);
            try {
                if (!wF_Activity_t.fill(string5)) {
                    wF_Activity_t.Created.set(CTEDBTimestamp.getNow());
                } else {
                    logger.debug("found existing activity with name [%s], schema id [%s]", string, n);
                }
            }
            catch (CTEDBException cTEDBException) {
                logger.error("failed to retrieve current activity, name [" + string + "], schema id [" + n + "]", cTEDBException);
                return false;
            }
            wF_Activity_t.Name.set(string);
            wF_Activity_t.Description.set(string2);
            wF_Activity_t.Class.set(WebServiceActivity.class.getName());
            wF_Activity_t.SchemaId.set(Integer.valueOf(n));
            wF_Activity_t.Icon.set(this.getWebServiceImage());
            wF_Activity_t.Operation.set(string3);
            wF_Activity_t.CellClass.set("commvault.workflow.cell.WebServiceCell");
            wF_Activity_t.Inbound.set(Integer.valueOf(1));
            wF_Activity_t.Outbound.set(Integer.valueOf(1));
            wF_Activity_t.Modified.set(CTEDBTimestamp.getNow());
            wF_Activity_t.SchemaFile.set("");
            wF_Activity_t.ActivitySchema.set(element);
            try {
                wF_Activity_t.save();
            }
            catch (CTEDBException cTEDBException) {
                logger.error("failed to save activity record", cTEDBException);
                return false;
            }
            String string6 = String.format("ActivityId = %s", wF_Activity_t.ActivityId.get());
            List<WF_ActivityGroup_t> list = null;
            try {
                list = WF_ActivityGroup_t.select(string6);
            }
            catch (CTEDBException cTEDBException) {
                logger.error("failed to retrieve currnet groups for activity", cTEDBException);
            }
            if (list != null) {
                for (Object object2 : list) {
                    logger.debug("removing activity [%s] from existing group [%s]", wF_Activity_t.Name.get(), object2.ActivitySetId.get());
                    try {
                        object2.delete();
                    }
                    catch (CTEDBException cTEDBException) {
                        logger.error("failed to delete activity group, activity id [" + wF_Activity_t.ActivityId.get() + "], set id [" + object2.ActivitySetId.get() + "]", cTEDBException);
                    }
                }
            }
            wF_ActivitySet_t = new WF_ActivitySet_t();
            object2 = String.format("Name = '%s'", string4);
            try {
                if (wF_ActivitySet_t.fill((String)object2)) break block18;
                logger.debug("creating activity set record for [%s]", string4);
                wF_ActivitySet_t.Name.set(string4);
                wF_ActivitySet_t.Modified.set(CTEDBTimestamp.getNow());
                wF_ActivitySet_t.Created.set(CTEDBTimestamp.getNow());
                try {
                    wF_ActivitySet_t.save();
                }
                catch (Exception exception) {
                    logger.error("failed to save activity set entry [" + string4 + "]", exception);
                    return false;
                }
            }
            catch (CTEDBException cTEDBException) {
                logger.error("failed to retrieve existing activity set entry for [" + string4 + "]", cTEDBException);
                return false;
            }
        }
        WF_ActivityGroup_t wF_ActivityGroup_t = new WF_ActivityGroup_t();
        wF_ActivityGroup_t.ActivityId.set(wF_Activity_t.ActivityId.get());
        wF_ActivityGroup_t.ActivitySetId.set(wF_ActivitySet_t.ActivitySetId.get());
        try {
            wF_ActivityGroup_t.save();
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to save activity group, activity id [" + wF_Activity_t.ActivityId.get() + "], set id [" + wF_ActivitySet_t.ActivitySetId.get() + "]", cTEDBException);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getWebServiceImage() {
        InputStream inputStream = this.getClass().getResourceAsStream(WS_IMAGE_LOCATION);
        if (inputStream == null) {
            logger.warn("could not retrieve web service image [%s] from internal jar", WS_IMAGE_LOCATION);
            return null;
        }
        try {
            String string = WorkflowUtils.encodeImage(inputStream);
            return string;
        }
        catch (Exception exception) {
            logger.warn("error encoding web service image [%s] from internal jar", WS_IMAGE_LOCATION, exception);
            String string = null;
            return string;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private SOAPOperation getBinding(QName qName) {
        BindingOperation bindingOperation;
        new ArrayList();
        List list = null;
        list = this.wsdlDocument.getBindings(BindingProtocol.SOAP12);
        if (list != null) {
            for (Binding binding : list) {
                bindingOperation = binding.getBindingOperation(qName);
                if (bindingOperation == null) continue;
                return (SOAPOperation)bindingOperation;
            }
        }
        if ((list = this.wsdlDocument.getBindings(BindingProtocol.SOAP)) != null) {
            for (Binding binding : list) {
                bindingOperation = binding.getBindingOperation(qName);
                if (bindingOperation == null) continue;
                return (SOAPOperation)bindingOperation;
            }
        }
        return null;
    }
}

