/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.common.xml.CTEProcessingModel;
import commvault.cte.common.xml.XMLEncoder;
import commvault.cte.util.DateUtilities;
import commvault.cte.workflow.AsyncWorkflowResponse;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.InteractiveAction;
import commvault.cte.workflow.Repeatable;
import commvault.cte.workflow.WorkflowContext;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.message.RequestManager;
import commvault.msgs.Workflow.InteractiveRequest;
import commvault.msgs.Workflow.SessionRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class SessionManager
implements Repeatable {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(SessionManager.class);
    private static final SessionManager instance = new SessionManager();
    private static int CLOSE_MESSAGE_TIMEOUT = 1800;
    private Map<String, Set<String>> workflowSessions = new HashMap<String, Set<String>>();
    private Map<String, Long> sessions = new HashMap<String, Long>();
    private Map<String, List<AsyncWorkflowResponse>> responseHandlers = new HashMap<String, List<AsyncWorkflowResponse>>();
    private Map<String, LinkedList<ResponseQueue>> responseQueue = new HashMap<String, LinkedList<ResponseQueue>>();
    private Map<String, ClosedResponse> closeMessages = new HashMap<String, ClosedResponse>();

    public static SessionManager getInstance() {
        return instance;
    }

    private SessionManager() {
    }

    public synchronized void createSession(WorkflowContext workflowContext, AsyncWorkflowResponse asyncWorkflowResponse) {
        String string = this.initializeSession(workflowContext);
        logger.info(workflowContext.getJobId(), "created interactive session with id [%s]", string);
        this.addResponseHandler(string, asyncWorkflowResponse);
    }

    private void addResponseHandler(String string, AsyncWorkflowResponse asyncWorkflowResponse) {
        if (asyncWorkflowResponse != null) {
            List<AsyncWorkflowResponse> list = this.responseHandlers.get(string);
            if (list == null) {
                list = new ArrayList<AsyncWorkflowResponse>();
                this.responseHandlers.put(string, list);
            }
            list.add(asyncWorkflowResponse);
        }
    }

    public synchronized void createSession(WorkflowContext workflowContext, InteractiveAction interactiveAction) {
        String string = this.initializeSession(workflowContext);
        logger.info(workflowContext.getJobId(), "created interactive session with id [%s]", string);
        this.responseQueue.get(string).add(new ResponseQueue(workflowContext, interactiveAction, null));
    }

    private String initializeSession(WorkflowContext workflowContext) {
        String string;
        if (workflowContext.getSessionId() == null) {
            string = UUID.randomUUID().toString();
            workflowContext.setSessionId(string);
        } else {
            string = workflowContext.getSessionId();
        }
        this.sessions.put(string, workflowContext.getJobId());
        Set<String> set = this.workflowSessions.get(workflowContext.getInstanceId());
        if (set == null) {
            set = new HashSet<String>();
            this.workflowSessions.put(workflowContext.getInstanceId(), set);
        }
        set.add(string);
        if (!this.responseQueue.containsKey(string)) {
            this.responseQueue.put(string, new LinkedList());
        }
        return string;
    }

    public synchronized boolean contains(WorkflowContext workflowContext) {
        return this.workflowSessions.containsKey(workflowContext.getInstanceId());
    }

    public synchronized boolean contains(long l) {
        return this.sessions.containsValue(l);
    }

    public synchronized void close(WorkflowContext workflowContext, CTEProcessingModel cTEProcessingModel) {
        Set<String> set = this.workflowSessions.get(workflowContext.getInstanceId());
        if (set != null) {
            for (String string : set) {
                this.close(string, cTEProcessingModel);
            }
            this.workflowSessions.remove(workflowContext.getInstanceId());
        }
    }

    public synchronized void close(String string) {
        this.close(string, (CTEProcessingModel)RequestManager.getGenericResponse(1, "session closed"));
    }

    public synchronized void close(String string, CTEProcessingModel cTEProcessingModel) {
        if (string == null) {
            return;
        }
        if (!this.sessions.containsKey(string)) {
            logger.debug("session id [%s] doesn't exist to close", string);
            return;
        }
        logger.debug("closing session [%s] with message type [%s]", string, cTEProcessingModel.getClass());
        List<AsyncWorkflowResponse> list = this.responseHandlers.remove(string);
        if (list != null) {
            for (AsyncWorkflowResponse object : list) {
                if (object == null) continue;
                object.setResponse(cTEProcessingModel);
            }
        } else {
            this.closeMessages.put(string, new ClosedResponse(cTEProcessingModel));
        }
        List list2 = this.responseQueue.remove(string);
        if (list2 != null) {
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                ResponseQueue responseQueue = (ResponseQueue)iterator.next();
                responseQueue.getAction().onInteractiveSessionClosed();
            }
        }
        this.sessions.remove(string);
    }

    public synchronized void reset(SessionRequest sessionRequest, AsyncWorkflowResponse asyncWorkflowResponse) {
        if (!this.sessions.containsKey(sessionRequest.getSessionId())) {
            ClosedResponse closedResponse = this.closeMessages.remove(sessionRequest.getSessionId());
            if (closedResponse != null) {
                logger.debug("responding to request with session id [%s] with closing message [%s]", sessionRequest.getSessionId(), closedResponse.getMessage().getClass());
                asyncWorkflowResponse.setResponse(closedResponse.getMessage());
            } else {
                logger.error("session [" + sessionRequest.getSessionId() + "] does not exist");
                asyncWorkflowResponse.setResponse((CTEProcessingModel)RequestManager.getGenericResponse(1, "session does not exist"));
            }
            return;
        }
        this.addResponseHandler(sessionRequest.getSessionId(), asyncWorkflowResponse);
        this.responseQueue.get(sessionRequest.getSessionId()).clear();
    }

    public synchronized void setRequest(SessionRequest sessionRequest, AsyncWorkflowResponse asyncWorkflowResponse) {
        if (!this.sessions.containsKey(sessionRequest.getSessionId())) {
            ClosedResponse closedResponse = this.closeMessages.remove(sessionRequest.getSessionId());
            if (closedResponse != null) {
                logger.debug("responding to request with session id [%s] with closing message [%s]", sessionRequest.getSessionId(), closedResponse.getMessage().getClass());
                asyncWorkflowResponse.setResponse(closedResponse.getMessage());
            } else {
                logger.error("session [" + sessionRequest.getSessionId() + "] does not exist");
                asyncWorkflowResponse.setResponse((CTEProcessingModel)RequestManager.getGenericResponse(1, "session does not exist"));
            }
            return;
        }
        this.addResponseHandler(sessionRequest.getSessionId(), asyncWorkflowResponse);
        if (sessionRequest instanceof InteractiveRequest) {
            LinkedList<ResponseQueue> linkedList = this.responseQueue.get(sessionRequest.getSessionId());
            if (linkedList.size() == 0) {
                logger.error("handler for session [" + sessionRequest.getSessionId() + "] does not exist");
                this.close(sessionRequest.getSessionId(), (CTEProcessingModel)RequestManager.getGenericResponse(1, "interactive handler does not exist"));
                return;
            }
            try {
                ResponseQueue responseQueue = linkedList.removeFirst();
                responseQueue.getAction().actionPerformed((InteractiveRequest)sessionRequest, responseQueue.getContext());
            }
            catch (EvFailureException evFailureException) {
                logger.error("failed to perform action on session id [" + sessionRequest.getSessionId() + "]");
                evFailureException.setLocaleId(sessionRequest.getProcessingInstructionInfo().getLocale().getLocaleId());
                this.close(sessionRequest.getSessionId(), (CTEProcessingModel)RequestManager.getGenericResponse(evFailureException.getMessageContainer().getErrorCode(), evFailureException.getMessage()));
                return;
            }
            if (((InteractiveRequest)sessionRequest).getDisconnect()) {
                logger.debug("closing session [%s] since message contained disconnect parameter", sessionRequest.getSessionId());
                this.close(sessionRequest.getSessionId(), (CTEProcessingModel)RequestManager.getGenericResponse());
                return;
            }
        }
        this.popResponse(sessionRequest.getSessionId());
    }

    public synchronized void sendResponse(WorkflowContext workflowContext, CTEProcessingModel cTEProcessingModel, InteractiveAction interactiveAction) throws EvFailureException {
        try {
            logger.debug("add message to session queue, session id [%s], message: [%s]", workflowContext.getSessionId(), XMLEncoder.encode((Object)cTEProcessingModel));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (workflowContext.getSessionId() == null) {
            logger.error("no interactive session available");
            throw new EvFailureException(new EvMessageContainer("no interactive session available"));
        }
        if (!this.sessions.containsKey(workflowContext.getSessionId())) {
            logger.error("session [" + workflowContext.getSessionId() + "] does not exist");
            throw new EvFailureException(new EvMessageContainer("session does not exist"));
        }
        this.responseQueue.get(workflowContext.getSessionId()).add(new ResponseQueue(workflowContext, interactiveAction, cTEProcessingModel));
        this.popResponse(workflowContext.getSessionId());
    }

    private void popResponse(String string) {
        logger.debug("popping next message for session [" + string + "]");
        LinkedList<ResponseQueue> linkedList = this.responseQueue.get(string);
        if (linkedList.size() > 0) {
            List<AsyncWorkflowResponse> list = this.responseHandlers.remove(string);
            if (list != null) {
                ResponseQueue responseQueue = linkedList.getFirst();
                for (AsyncWorkflowResponse asyncWorkflowResponse : list) {
                    asyncWorkflowResponse.setResponse(responseQueue.getMessage());
                }
            } else {
                logger.debug("cannot send next message as no response handler available for [" + string + "]");
            }
        } else {
            logger.debug("no messages available for session [" + string + "]");
        }
    }

    @Override
    public synchronized void run() {
        if (this.closeMessages.size() > 0) {
            Iterator<ClosedResponse> iterator = this.closeMessages.values().iterator();
            int n = DateUtilities.getNow();
            while (iterator.hasNext()) {
                ClosedResponse closedResponse = iterator.next();
                int n2 = n - closedResponse.queueTime;
                if (n2 < CLOSE_MESSAGE_TIMEOUT) continue;
                iterator.remove();
            }
        }
    }

    @Override
    public int getInterval() {
        return 300;
    }

    private static class ClosedResponse {
        private final CTEProcessingModel message;
        private final int queueTime = DateUtilities.getNow();

        public ClosedResponse(CTEProcessingModel cTEProcessingModel) {
            this.message = cTEProcessingModel;
        }

        public CTEProcessingModel getMessage() {
            return this.message;
        }
    }

    private static class ResponseQueue {
        private final WorkflowContext context;
        private final InteractiveAction action;
        private final CTEProcessingModel message;

        public ResponseQueue(WorkflowContext workflowContext, InteractiveAction interactiveAction, CTEProcessingModel cTEProcessingModel) {
            this.context = workflowContext;
            this.action = interactiveAction;
            this.message = cTEProcessingModel;
        }

        public WorkflowContext getContext() {
            return this.context;
        }

        public InteractiveAction getAction() {
            return this.action;
        }

        public CTEProcessingModel getMessage() {
            return this.message;
        }
    }
}

