/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.db.CTEDBConnInfo;
import commvault.cte.db.CTEDBConnection;
import commvault.cte.db.CTEDBException;
import commvault.cte.workflow.Capability;
import commvault.cte.workflow.CommCellContext;
import commvault.cte.workflow.CommCellProperties;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EvSecurity;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.ImpersonateContext;
import commvault.cte.workflow.ImpersonateUtil;
import commvault.cte.workflow.ProcessContext;
import commvault.cte.workflow.SecurityContext;
import commvault.cte.workflow.SecurityToken;
import commvault.cte.workflow.SessionImpersonation;
import commvault.cte.workflow.TokenInfo;
import commvault.cte.workflow.UserModel;
import commvault.cte.workflow.WorkflowProcess;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.db.cs.UMUsers_t;
import commvault.cte.workflow.db.engine.WF_Context_t;
import commvault.cte.workflow.db.engine.WF_Token_t;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.CommServUtils;
import commvault.msgs.CvEntities.CommCellEntity;
import commvault.msgs.CvEntities.UserEntity;
import java.util.HashSet;
import javax.security.auth.Subject;

public class SessionContext
implements ImpersonateContext,
SecurityContext {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(SessionContext.class);
    private WorkflowProcess workflow;
    private WF_Context_t context;
    private SessionContext parent;
    private SecurityToken securityToken;
    private SecurityContext masterSession;
    private CommCellContext properties;
    private boolean debugNext = false;

    public static SessionContext getInstance(WorkflowProcess workflowProcess) throws EvFailureException {
        WF_Context_t wF_Context_t = null;
        try {
            wF_Context_t = workflowProcess.getDataAccess().getRootContext(workflowProcess.getJobId(), workflowProcess.getCommCellId());
        }
        catch (CTEDBException cTEDBException) {
            logger.error(workflowProcess.getJobId(), "failed to retrieve context for job", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        if (wF_Context_t == null) {
            wF_Context_t = workflowProcess.getDataAccess().newContext();
            wF_Context_t.jobId.set(Long.valueOf(workflowProcess.getJobId()));
            wF_Context_t.commCellId.set(Integer.valueOf(workflowProcess.getCommCellId()));
            wF_Context_t.ParentId.setNull();
            wF_Context_t.TokenId.setNull();
            try {
                wF_Context_t.save();
            }
            catch (CTEDBException cTEDBException) {
                logger.error(workflowProcess.getJobId(), "failed to create workflow context record", cTEDBException);
                throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
            }
        }
        return new SessionContext(wF_Context_t, workflowProcess);
    }

    private SessionContext(WF_Context_t wF_Context_t, WorkflowProcess workflowProcess) throws EvFailureException {
        this(wF_Context_t, workflowProcess, null);
    }

    private SessionContext(WF_Context_t wF_Context_t, WorkflowProcess workflowProcess, SessionContext sessionContext) throws EvFailureException {
        Object object;
        this.context = wF_Context_t;
        this.parent = sessionContext;
        this.workflow = workflowProcess;
        if (!wF_Context_t.TokenId.isNull()) {
            try {
                object = workflowProcess.getDataAccess().getToken(wF_Context_t.TokenId.get());
            }
            catch (CTEDBException cTEDBException) {
                logger.error(workflowProcess.getJobId(), "failed to load WF_Token row for token id [" + wF_Context_t.TokenId.get() + "]", cTEDBException);
                throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
            }
            if (object != null) {
                this.securityToken = new SecurityToken((WF_Token_t)((Object)object));
            } else {
                logger.error(workflowProcess.getJobId(), "no token row exists for token id [" + wF_Context_t.TokenId.get() + "] in context id [" + wF_Context_t.ContextId.get() + "]");
            }
        } else {
            logger.debug(workflowProcess.getJobId(), "no token id is associated with context id [%s]", wF_Context_t.ContextId.get());
        }
        if (this.isLoggedIn()) {
            object = TokenInfo.decrypt(this.securityToken.getToken());
            try {
                this.properties = CommCellProperties.load(((TokenInfo)object).getCommServClient());
            }
            catch (Exception exception) {
                logger.error(workflowProcess.getJobId(), "failed to load properties for commcell [" + ((TokenInfo)object).getCommServClient() + "]", exception);
                throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
            }
        }
        if (sessionContext != null) {
            this.debugNext = sessionContext.debugNext;
        }
    }

    public SecurityContext getMasterImpersonation() throws EvFailureException {
        if (!this.isLoggedIn()) {
            logger.error(this.getWorkflow().getJobId(), "user is not logged in");
            throw new EvFailureException(new EvMessageContainer("user is not logged in"));
        }
        if (this.properties.getCommCell().getCommCellId() == WorkflowProperties.getInstance().getCommCell().getCommCellId()) {
            return this;
        }
        if (this.masterSession == null) {
            logger.info(this.getWorkflow().getJobId(), "impersonating with master commcell [%s] for user [%s]", WorkflowProperties.getInstance().getCommCell().getCommCellName(), this.getUser().getUserName());
            try {
                this.masterSession = SessionImpersonation.impersonate((SecurityContext)this, WorkflowProperties.getInstance().getCommCell().getCommCellId());
            }
            catch (Exception exception) {
                logger.error(this.getWorkflow().getJobId(), "failed to impersonate user [" + this.getUser().getUserName() + "] to master commcell [" + WorkflowProperties.getInstance().getCommCell().getCommCellName() + "]", exception);
                throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
            }
        }
        return this.masterSession;
    }

    public SessionContext getInstance(int n) throws EvFailureException {
        WF_Context_t wF_Context_t;
        try {
            wF_Context_t = this.workflow.getDataAccess().getContext(n);
        }
        catch (CTEDBException cTEDBException) {
            logger.error(this.workflow.getJobId(), "failed to retrieve context id [" + n + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        if (wF_Context_t == null) {
            logger.error(this.workflow.getJobId(), "failed to find WF_Context row for context id [" + n + "]");
            throw new EvFailureException(new EvMessageContainer("missing context for id [%s]", n));
        }
        return new SessionContext(wF_Context_t, this.workflow);
    }

    public SessionContext newInstance() throws EvFailureException {
        WF_Context_t wF_Context_t = this.workflow.getDataAccess().newContext();
        wF_Context_t.jobId.set(this.context.jobId.get());
        wF_Context_t.commCellId.set(this.context.commCellId.get());
        wF_Context_t.ParentId.set(this.context.ContextId.get());
        wF_Context_t.TokenId.set(this.context.TokenId.get());
        try {
            wF_Context_t.save();
        }
        catch (CTEDBException cTEDBException) {
            logger.error(this.workflow.getJobId(), "failed to create workflow context record", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        return new SessionContext(wF_Context_t, this.workflow, this);
    }

    public SessionContext getParent() throws EvFailureException {
        if (this.parent != null) {
            return this.parent;
        }
        if (!this.context.ParentId.isNull()) {
            return this.getInstance(this.context.ParentId.get());
        }
        return this;
    }

    public int getId() {
        return this.context.ContextId.get();
    }

    @Override
    public UserEntity getUser() {
        if (this.securityToken != null) {
            UserEntity userEntity = new UserEntity();
            userEntity.setUserName(this.securityToken.getUserName());
            userEntity.setUserId(this.securityToken.getUserId());
            return userEntity;
        }
        return null;
    }

    public String getUserName() {
        if (this.securityToken != null) {
            return this.securityToken.getUserName();
        }
        return null;
    }

    public Integer getUserId() {
        if (this.securityToken != null) {
            return this.securityToken.getUserId();
        }
        return null;
    }

    public SecurityToken getSecurityToken() {
        if (this.securityToken != null) {
            return this.securityToken;
        }
        return null;
    }

    @Override
    public boolean isLoggedIn() {
        return this.securityToken != null && this.securityToken.isLoggedIn();
    }

    @Override
    public boolean isClientAdmin() {
        if (this.properties.getCommCell().getCommCellId() == WorkflowProperties.getInstance().getCommCell().getCommCellId() && this.isLoggedIn()) {
            try {
                return EvSecurity.isNodeCapability(WorkflowProperties.getInstance().getClient().getClientId(), Capability.ADMINISTRATIVE_MANAGEMENT, this);
            }
            catch (CTEDBException cTEDBException) {
                logger.error("failed to check capabilties for user [" + this.getUserName() + "]", cTEDBException);
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isCommCellAdmin() {
        if (this.isLoggedIn()) {
            try {
                return EvSecurity.isAdministrativeCapability(2, this);
            }
            catch (CTEDBException cTEDBException) {
                logger.error("failed to check capabilties for user [" + this.getUserName() + "]", cTEDBException);
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isEngineAdmin() {
        if (this.properties.getCommCell().getCommCellId() == WorkflowProperties.getInstance().getCommCell().getCommCellId() && this.isLoggedIn()) {
            try {
                return EvSecurity.isNodeCapability(WorkflowProperties.getInstance().getClient().getClientId(), Capability.AGENT_MANAGEMENT, this);
            }
            catch (CTEDBException cTEDBException) {
                logger.error("failed to check capabilties for user [" + this.getUserName() + "]", cTEDBException);
                return false;
            }
        }
        return false;
    }

    @Override
    public String impersonateLogin(String string, String string2) throws EvFailureException {
        return this.impersonateLogin(WorkflowProperties.getInstance().getCommCell().getCommCellName(), string, string2);
    }

    @Override
    public String impersonateLogin(String string, String string2, String string3) throws EvFailureException {
        String string4;
        CommCellContext commCellContext = null;
        try {
            commCellContext = CommCellProperties.load(string);
        }
        catch (Exception exception) {
            logger.error(this.workflow.getJobId(), "failed to load registered commcell [" + string + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        try {
            string4 = ImpersonateUtil.getInstance().loginUser(commCellContext.getCommServHost(), commCellContext.getCommServClient(), string2, string3);
        }
        catch (Exception exception) {
            logger.error(this.workflow.getJobId(), "login failed for user [" + string2 + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        UMUsers_t uMUsers_t = new UMUsers_t(commCellContext.getCommCellConnection());
        String string5 = String.format("login = '%s'", string2);
        try {
            if (!uMUsers_t.fill(string5)) {
                logger.error("could not find user information for [" + string2 + "]");
                throw new EvFailureException(EventMessage.getContainer("JM_WORKFLOW_FAILED_RETRIEVE_USER", new Object[0]));
            }
        }
        catch (CTEDBException cTEDBException) {
            logger.error(this.workflow.getJobId(), "failed to retrieve user information for [" + string2 + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        return this.impersonate(new UserModel(uMUsers_t), null, string4, commCellContext);
    }

    @Override
    public String impersonateCommCell(String string) throws EvFailureException {
        CommCellContext commCellContext;
        if (!this.isLoggedIn()) {
            throw new EvFailureException(new EvMessageContainer("user not logged in"));
        }
        try {
            commCellContext = CommCellProperties.load(string);
        }
        catch (Exception exception) {
            logger.error(this.workflow.getJobId(), "failed to lookup registered commcell [" + string + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        UMUsers_t uMUsers_t = new UMUsers_t(this.getCommCellConnection());
        UMUsers_t uMUsers_t2 = new UMUsers_t(commCellContext.getCommCellConnection());
        try {
            if (!uMUsers_t.fill(String.format("login = '%s'", this.getUserName()))) {
                logger.error(this.workflow.getJobId(), "failed to find user with login [" + this.getUserName() + "] on commCell [" + WorkflowProperties.getInstance().getCommCell().getCommCellName() + "]");
                throw new EvFailureException(new EvMessageContainer("failed to find user with login [%s] on commCell [%s]", this.getUserName(), WorkflowProperties.getInstance().getCommCell().getCommCellName()));
            }
        }
        catch (Exception exception) {
            logger.error(this.workflow.getJobId(), "failed to lookup user with login [" + this.getUserName() + "] on commCell [" + WorkflowProperties.getInstance().getCommCell().getCommCellName() + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        try {
            if (!uMUsers_t2.fill(String.format("login = '%s'", this.getUserName()))) {
                logger.error(this.workflow.getJobId(), "failed to find user with login [" + this.getUserName() + "] on commCell [" + commCellContext.getCommCell().getCommCellName() + "]");
                throw new EvFailureException(new EvMessageContainer("failed to find user with login [" + this.getUserName() + "] on commCell [" + commCellContext.getCommCell().getCommCellName() + "]"));
            }
        }
        catch (CTEDBException cTEDBException) {
            logger.error(this.workflow.getJobId(), "failed to lookup user with login [" + this.getUserName() + "] on commCell [" + commCellContext.getCommCell().getCommCellName() + "]", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        return this.impersonate(commCellContext, new UserModel(uMUsers_t2));
    }

    @Override
    public String impersonateCreator() throws EvFailureException {
        return this.impersonate(WorkflowProperties.getInstance(), this.workflow.getCreatorModel());
    }

    @Override
    public String impersonateExecutor() throws EvFailureException {
        return this.impersonate(WorkflowProperties.getInstance(), this.workflow.getExecutorModel());
    }

    private String impersonate(CommCellContext commCellContext, UserEntity userEntity) throws EvFailureException {
        String string;
        String string2;
        logger.debug(this.workflow.getJobId(), "logging in user [%s] on commcell [%s]", userEntity.getUserName(), commCellContext.getCommCell());
        try {
            string2 = CommServUtils.generateQSDKToken(userEntity, commCellContext.getCommCellConnection());
        }
        catch (Exception exception) {
            logger.error(this.workflow.getJobId(), "failed to impersonate user [" + userEntity.getUserName() + "]", exception);
            throw new EvFailureException(new EvMessageContainer("login failed for user [%s]", userEntity.getUserName()));
        }
        try {
            logger.trace(this.workflow.getJobId(), "encrypting guid [%s] for user [%s], commserv host [%s], commserv client [%s]", string2, userEntity.getUserName(), commCellContext.getCommServHost(), commCellContext.getCommServClient());
            string = ImpersonateUtil.getInstance().generateToken(commCellContext.getCommServHost(), commCellContext.getCommServClient(), userEntity.getUserName(), string2);
        }
        catch (Exception exception) {
            logger.error(this.workflow.getJobId(), "failed to encrypt session for user [" + userEntity.getUserName() + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        logger.trace("created session token [%s] for user [%s]", string, userEntity.getUserName());
        return this.impersonate(userEntity, string2, string, commCellContext);
    }

    private String impersonate(UserEntity userEntity, String string, String string2, CommCellContext commCellContext) throws EvFailureException {
        try {
            this.securityToken = SecurityToken.newInstance(userEntity, string, string2, this.workflow);
        }
        catch (Exception exception) {
            logger.error(this.workflow.getJobId(), "error creating token for user [" + userEntity.getUserName() + "]", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        this.context.TokenId.set(Integer.valueOf(this.securityToken.getTokenId()));
        try {
            this.context.save();
        }
        catch (CTEDBException cTEDBException) {
            logger.error(this.workflow.getJobId(), "failed to save context", cTEDBException);
        }
        this.properties = commCellContext;
        return this.securityToken.getToken();
    }

    @Override
    public String getToken() {
        if (this.securityToken != null) {
            return this.securityToken.getToken();
        }
        return null;
    }

    @Override
    public String getCurrentUserToken() {
        return this.getToken();
    }

    @Override
    public void logout() {
        this.logoutImpersonatedUser();
    }

    @Override
    public void logoutImpersonatedUser() {
        if (this.securityToken != null) {
            this.securityToken.logout();
        }
    }

    @Override
    public Subject getSubject() {
        HashSet<SessionContext> hashSet = new HashSet<SessionContext>();
        hashSet.add(this);
        return new Subject(false, hashSet, new HashSet(), new HashSet());
    }

    @Override
    public String getName() {
        return this.getUser().getUserName();
    }

    @Override
    public CommCellEntity getCommCell() {
        if (this.properties != null) {
            return this.properties.getCommCell();
        }
        return new CommCellEntity();
    }

    @Override
    public String getCommServHost() {
        if (this.properties != null) {
            return this.properties.getCommServHost();
        }
        return null;
    }

    @Override
    public String getCommServClient() {
        if (this.properties != null) {
            return this.properties.getCommServClient();
        }
        return null;
    }

    @Override
    public CTEDBConnInfo getConnInfo() {
        if (this.properties != null) {
            return this.properties.getConnInfo();
        }
        return null;
    }

    @Override
    public CTEDBConnection getCommCellConnection() {
        if (this.properties != null) {
            return this.properties.getCommCellConnection();
        }
        return null;
    }

    @Override
    public WorkflowProperties.WebServiceParameters getDefaultWebService() {
        if (this.properties != null) {
            return this.properties.getDefaultWebService();
        }
        return null;
    }

    @Override
    public ProcessContext getWorkflow() {
        return this.workflow;
    }

    public void setDebugNext(boolean bl) {
        this.debugNext = bl;
    }

    public boolean isDebugNext() {
        return this.debugNext;
    }
}

