/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import com.sun.management.HotSpotDiagnosticMXBean;
import commvault.cte.util.Application;
import commvault.cte.util.PasswordEncoder;
import commvault.cte.workflow.EventManager;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.JobManager;
import commvault.cte.workflow.MessageServer;
import commvault.cte.workflow.WorkflowEngine;
import commvault.cte.workflow.WorkflowLogger;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.WorkflowSecurityManager;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.App.AppSubSystemReferenceClass;
import commvault.msgs.CM.CMSubSystemReferenceClass;
import commvault.msgs.CNSession.CNSessionSubSystemReferenceClass;
import commvault.msgs.Common.CommonSubSystemReferenceClass;
import commvault.msgs.CvEntities.CvEntitiesSubSystemReferenceClass;
import commvault.msgs.GalaxyUtilities.GalaxyUtilitiesSubSystemReferenceClass;
import commvault.msgs.VirtualServer.VirtualServerSubSystemReferenceClass;
import commvault.msgs.Workflow.WorkflowSubSystemReferenceClass;
import commvault.qnet.sys.CVPassword;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;

public class Server {
    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println("arg[" + i + "]: " + stringArray[i]);
        }
        System.out.println("parsing arguments");
        String string = null;
        if (stringArray.length > 0) {
            string = stringArray[0];
            System.out.println("setting instance focus to " + string);
        }
        if (string == null) {
            System.out.println("error retrieving vm from command line arguments, defaulting to Instance001");
            string = "Instance001";
        }
        if (!EventMessage.getInstance().initialize(string)) {
            System.out.println("error initializing EvEvent for instance " + string + ", check Workflow.log for additional information.");
        }
        WorkflowRegistry.newInstance(string);
        EventMessage.getInstance().loadEventHeaders();
        System.out.println("initializing logger");
        CTELogger.createInstance(WorkflowLogger.buildConfig("WorkflowEngine", "Workflow", true));
        CTELogger.LoggerInstance loggerInstance = CTELogger.getLogger(Server.class);
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            HotSpotDiagnosticMXBean hotSpotDiagnosticMXBean = ManagementFactory.newPlatformMXBeanProxy(mBeanServer, "com.sun.management:type=HotSpotDiagnostic", HotSpotDiagnosticMXBean.class);
            hotSpotDiagnosticMXBean.setVMOption("HeapDumpOnOutOfMemoryError", "true");
        }
        catch (Throwable throwable) {
            loggerInstance.error("failed to configure JVM hotspot", throwable);
        }
        System.setSecurityManager(new WorkflowSecurityManager());
        AppSubSystemReferenceClass.registerSubSystem();
        CMSubSystemReferenceClass.registerSubSystem();
        CNSessionSubSystemReferenceClass.registerSubSystem();
        CommonSubSystemReferenceClass.registerSubSystem();
        CvEntitiesSubSystemReferenceClass.registerSubSystem();
        GalaxyUtilitiesSubSystemReferenceClass.registerSubSystem();
        VirtualServerSubSystemReferenceClass.registerSubSystem();
        WorkflowSubSystemReferenceClass.registerSubSystem();
        Application.instance().setPasswordEncoder(new PasswordEncoder(){

            public byte[] encode(byte[] byArray) {
                CVPassword cVPassword = new CVPassword();
                return cVPassword.encrypt(new String(byArray)).getBytes();
            }
        });
        boolean bl = false;
        while (true) {
            try {
                while (WorkflowRegistry.getInstance().getInstalledClients().size() <= 0) {
                    if (!bl) {
                        loggerInstance.info("no client registration found, pausing service startup");
                        bl = true;
                    }
                    Thread.sleep(10000L);
                }
            }
            catch (Throwable throwable) {
                loggerInstance.errorNow("failed to get installed clients", throwable);
                System.exit(1);
                continue;
            }
            break;
        }
        try {
            WorkflowEngine.instance().initialize();
        }
        catch (Throwable throwable) {
            loggerInstance.errorNow("error initializing workflow engine", throwable);
            System.exit(1);
        }
        loggerInstance.debug("workflow server initialization complete, starting message handler");
        try {
            MessageServer.getInstance().start();
        }
        catch (Throwable throwable) {
            loggerInstance.error("failed to start message server", throwable);
            System.exit(1);
        }
    }

    public static void stop(String[] stringArray) {
        CTELogger.LoggerInstance loggerInstance = CTELogger.getLogger(Server.class);
        loggerInstance.info("workflow engine shutting down");
        WorkflowEngine.getInstance().shutdown();
        EventManager.getInstance().fireEngineStopEvent();
        MessageServer.getInstance().stop();
        JobManager.DB_EXEC.shutdown();
        loggerInstance.info("******** workflow engine shutdown ********");
        WorkflowLogger.getInstance().close();
        System.exit(0);
    }
}

