/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.common.xml.CTEProcessingModel;
import commvault.cte.common.xml.XMLEncoder;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.App.GenericResp;

public class ResponseMessage {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ResponseMessage.class);
    protected int errorCode;
    protected String errorMessage;
    private String message = "";

    public ResponseMessage() {
        this(0, "Success");
    }

    public ResponseMessage(CTEProcessingModel cTEProcessingModel) throws EvFailureException {
        try {
            this.message = XMLEncoder.encode((Object)cTEProcessingModel);
        }
        catch (Exception exception) {
            logger.error("error encoding response [" + cTEProcessingModel.getClass().getName() + "]", exception);
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_BUILD_RESPONSE", new Object[0]);
            throw new EvFailureException(evMessageContainer);
        }
    }

    public ResponseMessage(int n, String string) {
        GenericResp genericResp = new GenericResp();
        genericResp.setErrorCode(n);
        genericResp.setErrorMessage(string);
        try {
            this.message = XMLEncoder.encode((Object)genericResp);
        }
        catch (Exception exception) {
            logger.error("failed to encode App:GenericResp", exception);
        }
    }

    public ResponseMessage(EvMessageContainer evMessageContainer, int n) {
        this(evMessageContainer.getErrorCode(), EventMessage.getInstance().formatMessage(evMessageContainer, n));
    }

    public String toString() {
        return this.message;
    }
}

