/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.db.CTEDBException;
import commvault.cte.db.CTEDBTimestamp;
import commvault.cte.util.DateUtilities;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.PackageActivity;
import commvault.cte.workflow.PackageImporter;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.activity.XMLActivity;
import commvault.cte.workflow.db.cs.WF_ActivitySet_t;
import commvault.cte.workflow.db.cs.WF_Activity_t;
import commvault.cte.workflow.db.cs.WF_SchemaLocation_t;
import commvault.cte.workflow.db.cs.WF_Schema_t;
import commvault.cte.workflow.db.engine.WF_ActivityPackages_t;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.stream.XMLStream;
import commvault.cte.workflow.utils.ReflectionUtils;
import commvault.cte.workflow.utils.WorkflowUtils;
import commvault.msgs.Workflow.ActivityFlags;
import commvault.msgs.Workflow.ActivityPackage;
import commvault.msgs.Workflow.ActivitySchema;
import commvault.msgs.Workflow.SchemaLocationType;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PackageManager {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(PackageManager.class);
    private XMLStream stream = new XMLStream();
    private WF_ActivityPackages_t packageRow;
    private final WF_SchemaLocation_t schemaLocationRow;
    private final List<PackageActivity> activities = new ArrayList<PackageActivity>();
    private final Map<String, WF_ActivitySet_t> activitySets = new HashMap<String, WF_ActivitySet_t>();

    public static int buildFlags(ActivityPackage activityPackage) {
        int n = 0;
        if (activityPackage.getDepreciated()) {
            n |= ActivityFlags.DEPRECIATED.getEnumValue();
        }
        return n;
    }

    public PackageManager(File file) throws EvFailureException {
        String string;
        this.schemaLocationRow = new WF_SchemaLocation_t();
        try {
            if (!this.schemaLocationRow.fill(String.format("LocationUrl='%s'", file.getName()))) {
                this.schemaLocationRow.LocationType.set(Integer.valueOf(SchemaLocationType.JAR.getEnumValue()));
            }
        }
        catch (CTEDBException cTEDBException) {
            logger.error("error looking up existing package location", cTEDBException);
            EvMessageContainer evMessageContainer = new EvMessageContainer(cTEDBException.getMessage());
            throw new EvFailureException(evMessageContainer);
        }
        try {
            string = WorkflowUtils.getMD5Checksum(file);
        }
        catch (Exception exception) {
            logger.error("failed to generate md5 checksum for file [" + file.getAbsolutePath() + "]", exception);
            EvMessageContainer evMessageContainer = new EvMessageContainer(exception.getMessage());
            throw new EvFailureException(evMessageContainer);
        }
        this.schemaLocationRow.LocationUrl.set(file.getName());
        this.schemaLocationRow.MD5CheckSum.set(string);
        this.schemaLocationRow.FileTime.set(Long.valueOf(file.lastModified()));
        this.schemaLocationRow.Version.set(Double.valueOf(WorkflowUtils.getManifestVersion(file)));
        this.schemaLocationRow.Modified.set(Integer.valueOf(DateUtilities.getNow()));
        try {
            this.schemaLocationRow.save();
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to save schema location for [" + this.schemaLocationRow.LocationUrl.get() + "]", cTEDBException);
            EvMessageContainer evMessageContainer = new EvMessageContainer(cTEDBException.getMessage());
            throw new EvFailureException(evMessageContainer);
        }
        this.packageRow = new WF_ActivityPackages_t();
        try {
            this.packageRow.fill(String.format("PackageName = '%s'", file.getName()));
        }
        catch (CTEDBException cTEDBException) {
            logger.error("error looking up existing package", cTEDBException);
            EvMessageContainer evMessageContainer = new EvMessageContainer(cTEDBException.getMessage());
            throw new EvFailureException(evMessageContainer);
        }
        this.packageRow.PackageName.set(file.getName());
    }

    public void addActivity(ActivityPackage activityPackage, String string) {
        Serializable serializable;
        Class<?> clazz;
        try {
            logger.debug("loading activity class [%s]", activityPackage.getClassName());
            clazz = PackageImporter.class.getClassLoader().loadClass(activityPackage.getClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.error("could not instantiate class for activity [" + activityPackage.getName() + "]", classNotFoundException);
            return;
        }
        if (!Activity.class.isAssignableFrom(clazz)) {
            logger.error("class [" + clazz.getName() + "] for activity [" + activityPackage.getName() + "] is not valid activity");
            return;
        }
        WF_Activity_t wF_Activity_t = new WF_Activity_t();
        String string2 = clazz.getPackage().getName();
        try {
            serializable = this.getSchemaId(string2);
            if (serializable != null && wF_Activity_t.fill(String.format("Name = '%s' AND SchemaId = %s", activityPackage.getName(), serializable))) {
                logger.debug("found existing activity for [%s], namespace [%s]", activityPackage.getName(), string2);
            }
        }
        catch (CTEDBException cTEDBException) {
            logger.error("error looking up existing activity [" + activityPackage.getName() + "]", cTEDBException);
            return;
        }
        wF_Activity_t.Name.set(activityPackage.getName());
        wF_Activity_t.DisplayName.set(activityPackage.getDisplayName(false));
        wF_Activity_t.Description.set(activityPackage.getDescription());
        wF_Activity_t.Class.set(clazz.getName());
        wF_Activity_t.InputEditor.set(activityPackage.getInputEditor(false));
        wF_Activity_t.CellClass.set(activityPackage.getCellClass(false));
        wF_Activity_t.Icon.set(string);
        wF_Activity_t.Outbound.set(Integer.valueOf(this.trueValue(activityPackage.getOutbound(false))));
        wF_Activity_t.Inbound.set(Integer.valueOf(this.trueValue(activityPackage.getInbound(false))));
        wF_Activity_t.Flags.set(Integer.valueOf(PackageManager.buildFlags(activityPackage)));
        wF_Activity_t.Definition.set(activityPackage.getDefinition());
        try {
            logger.debug("instantiating activity class [%s]", clazz.getName());
            serializable = (Activity)ReflectionUtils.newInstance(clazz);
        }
        catch (Exception exception) {
            logger.error("error instantiating activity class [" + clazz.getName() + "]", exception);
            return;
        }
        ActivitySchema activitySchema = activityPackage.getActivitySchema(false);
        if (activitySchema == null && serializable instanceof XMLActivity) {
            logger.debug("retrieving schema from XMLActivity [%s]", activityPackage.getName());
            activitySchema = ((XMLActivity)serializable).getSchema(activityPackage.getName());
        }
        if (activitySchema == null) {
            logger.debug("generating schema for activity [%s]", activityPackage.getName());
            activitySchema = this.stream.generateActivitySchema(clazz);
        }
        try {
            wF_Activity_t.ActivitySchema.set(WorkflowUtils.encodeMessage(activitySchema, "activitySchema"));
        }
        catch (Exception exception) {
            logger.error("failed to encode schema for activity [" + clazz.getName() + "]", exception);
            return;
        }
        logger.trace("generated schema [%s]", wF_Activity_t.ActivitySchema.get());
        WF_ActivitySet_t wF_ActivitySet_t = this.activitySets.get(activityPackage.getGroup());
        if (wF_ActivitySet_t == null) {
            wF_ActivitySet_t = new WF_ActivitySet_t();
            try {
                wF_ActivitySet_t.fill(String.format("Name='%s'", activityPackage.getGroup()));
            }
            catch (CTEDBException cTEDBException) {
                logger.error("error looking up existing activity set [" + activityPackage.getGroup() + "]", cTEDBException);
                return;
            }
            wF_ActivitySet_t.Name.set(activityPackage.getGroup());
            this.activitySets.put(activityPackage.getGroup(), wF_ActivitySet_t);
        }
        this.activities.add(new PackageActivity(wF_Activity_t, wF_ActivitySet_t, string2, WorkflowProperties.getInstance().getCommCellConnection()));
    }

    private int trueValue(Boolean bl) {
        if (bl == null || bl.booleanValue()) {
            return 1;
        }
        return 0;
    }

    private Integer getSchemaId(String string) throws CTEDBException {
        WF_Schema_t wF_Schema_t = new WF_Schema_t();
        if (wF_Schema_t.fill("Namespace = '" + string + "'")) {
            return wF_Schema_t.SchemaId.get();
        }
        return null;
    }

    private Integer createSchemaId(String string, int n) throws CTEDBException {
        WF_Schema_t wF_Schema_t = new WF_Schema_t();
        wF_Schema_t.Namespace.set(string);
        wF_Schema_t.XsdSchema.set("");
        wF_Schema_t.LocationId.set(Integer.valueOf(n));
        wF_Schema_t.Modified.set(CTEDBTimestamp.getNow());
        wF_Schema_t.save();
        return wF_Schema_t.SchemaId.get();
    }

    public void save() throws EvFailureException {
        logger.info("saving import");
        this.schemaLocationRow.Modified.set(Integer.valueOf(DateUtilities.getNow()));
        try {
            this.schemaLocationRow.save();
        }
        catch (CTEDBException cTEDBException) {
            logger.error("error saving schema location", cTEDBException);
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_CREATE_IMPORT", new Object[0]);
            throw new EvFailureException(evMessageContainer);
        }
        this.packageRow.PackageId.set(this.schemaLocationRow.LocationId.get());
        this.packageRow.Imported.set(Integer.valueOf(DateUtilities.getNow()));
        try {
            this.packageRow.save();
        }
        catch (CTEDBException cTEDBException) {
            logger.error("error saving activity package", cTEDBException);
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_CREATE_IMPORT", new Object[0]);
            throw new EvFailureException(evMessageContainer);
        }
        for (WF_ActivitySet_t object : this.activitySets.values()) {
            object.Modified.set(CTEDBTimestamp.getNow());
            try {
                logger.debug("saving activity set [" + object.Name.get() + "]");
                object.save();
            }
            catch (CTEDBException packageActivity) {
                logger.error("error saving activity set [" + object.Name.get() + "]", packageActivity);
            }
        }
        ArrayList arrayList = new ArrayList();
        for (PackageActivity packageActivity : this.activities) {
            Object cTEDBException;
            logger.debug("saving activity [" + packageActivity.activityRow.Name.get() + "]");
            try {
                cTEDBException = this.getSchemaId(packageActivity.getNamespace());
                if (cTEDBException == null) {
                    cTEDBException = this.createSchemaId(packageActivity.getNamespace(), this.schemaLocationRow.LocationId.get());
                }
                packageActivity.activityRow.SchemaId.set((Integer)cTEDBException);
                packageActivity.activityRow.Modified.set(CTEDBTimestamp.getNow());
                packageActivity.activityRow.save();
            }
            catch (CTEDBException cTEDBException2) {
                logger.error("error saving WF_Activity row for activity [" + packageActivity.getActivityName() + "]", cTEDBException2);
                continue;
            }
            arrayList.add(packageActivity.activityRow);
            cTEDBException = String.format("ActivitySetId=%s AND ActivityId=%s", packageActivity.activitySet.ActivitySetId.get(), packageActivity.activityRow.ActivityId.get());
            try {
                if (packageActivity.activityGroupRow.fill((String)cTEDBException)) continue;
                packageActivity.activityGroupRow.ActivityId.set(packageActivity.activityRow.ActivityId.get());
                packageActivity.activityGroupRow.ActivitySetId.set(packageActivity.activitySet.ActivitySetId.get());
                try {
                    packageActivity.activityGroupRow.save();
                }
                catch (CTEDBException cTEDBException3) {
                    logger.error("error saving activity group", cTEDBException3);
                }
            }
            catch (CTEDBException cTEDBException4) {
                logger.error("error looking up current activity group for where clause [" + (String)cTEDBException + "]", cTEDBException4);
            }
        }
    }
}

