/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.common.schema.util.SchemaUtils;
import commvault.cte.common.xml.XMLDecoder;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.InternalClassPath;
import commvault.cte.workflow.PackageManager;
import commvault.cte.workflow.db.cs.WF_SchemaLocation_t;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.WorkflowUtils;
import commvault.msgs.CvEntities.UserEntity;
import commvault.msgs.Workflow.ActivityPackage;
import commvault.msgs.Workflow.ImportActivities;
import commvault.msgs.Workflow.SchemaLocationType;
import commvault.msgs.Workflow.WorkflowPackage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PackageImporter {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(PackageImporter.class);
    public static final String ACTIVITY_XML = "activities.xml";

    public static void refresh(WF_SchemaLocation_t wF_SchemaLocation_t, UserEntity userEntity) throws EvFailureException {
        logger.info("refreshing package [%s], requested by [%s]", wF_SchemaLocation_t.LocationUrl.get(), userEntity.getUserName());
        File file = wF_SchemaLocation_t.LocationType.get().intValue() == SchemaLocationType.INTERNAL.getEnumValue() ? InternalClassPath.getInstance().getSystemPackage(wF_SchemaLocation_t.LocationUrl.get()) : InternalClassPath.getInstance().getPackage(wF_SchemaLocation_t.LocationUrl.get());
        if (file == null) {
            logger.error("workflow engine does not contain local package [" + wF_SchemaLocation_t.LocationUrl.get() + "]");
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_PACKAGE_DOESNT_EXIST", wF_SchemaLocation_t.LocationUrl.get());
            throw new EvFailureException(evMessageContainer);
        }
        PackageImporter.importPackage(file);
        logger.info("successfully completed refresh for package [%s]", file.getAbsolutePath());
    }

    public static void importPackage(ImportActivities importActivities, UserEntity userEntity) throws EvFailureException {
        logger.info("importing package from file [%s], requested by [%s]", importActivities.getLocation(), userEntity.getUserName());
        File file = new File(importActivities.getLocation());
        if (!file.exists()) {
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_LOAD_PACKAGE", file.getAbsolutePath());
            throw new EvFailureException(evMessageContainer);
        }
        PackageImporter.importPackage(file);
        logger.info("successfully completed import for package [%s]", file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importPackage(File file) throws EvFailureException {
        JarFile jarFile;
        try {
            jarFile = new JarFile(file);
        }
        catch (IOException iOException) {
            logger.error("error loading jar package [" + file.getAbsolutePath() + "]", iOException);
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_LOAD_PACKAGE", file.getAbsolutePath());
            throw new EvFailureException(evMessageContainer);
        }
        try {
            WorkflowPackage workflowPackage;
            Object object;
            logger.debug("retrieving xml file [%s] from package", ACTIVITY_XML);
            JarEntry jarEntry = jarFile.getJarEntry(ACTIVITY_XML);
            try {
                object = jarFile.getInputStream(jarEntry);
                String string = WorkflowUtils.readStream((InputStream)object);
                workflowPackage = (WorkflowPackage)XMLDecoder.decode((String)string, (Object)new WorkflowPackage());
            }
            catch (Exception exception) {
                logger.error("error loading activities xml file", exception);
                EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_LOAD_PACKAGE", file.getAbsolutePath());
                throw new EvFailureException(evMessageContainer);
            }
            object = new PackageManager(file);
            for (ActivityPackage activityPackage : workflowPackage.getActivity()) {
                PackageImporter.processActivity((PackageManager)object, jarFile, activityPackage);
            }
            ((PackageManager)object).save();
        }
        finally {
            try {
                jarFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void processActivity(PackageManager packageManager, JarFile jarFile, ActivityPackage activityPackage) {
        if (activityPackage.getName().length() == 0) {
            logger.error("activity xml contains an empty activity name");
            return;
        }
        if (!SchemaUtils.isValidName((String)activityPackage.getName())) {
            logger.error("activity xml contains an illegal activity name [" + activityPackage.getName() + "]");
            return;
        }
        if (activityPackage.getClassName().length() == 0) {
            logger.error("class name is null for activity [" + activityPackage.getName() + "]");
            return;
        }
        logger.info("importing activity [%s], class [%s]", activityPackage.getName(), activityPackage.getClassName());
        packageManager.addActivity(activityPackage, PackageImporter.retrieveImage(jarFile, activityPackage.getIcon()));
    }

    private static String retrieveImage(JarFile jarFile, String string) {
        if (string != null && string.trim().length() > 0) {
            logger.debug("retrieving activity icon [%s]", string);
            try {
                JarEntry jarEntry = jarFile.getJarEntry(string);
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                return WorkflowUtils.encodeImage(inputStream);
            }
            catch (Exception exception) {
                logger.error("could not load image from [" + string + "]", exception);
                return null;
            }
        }
        return null;
    }
}

