/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.db.CTEDBException;
import commvault.cte.util.Base64;
import commvault.cte.workflow.CommCellSettings;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.Repeatable;
import commvault.cte.workflow.UserModel;
import commvault.cte.workflow.WorkflowMail;
import commvault.cte.workflow.WorkflowMessage;
import commvault.cte.workflow.WorkflowMessageListener;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.db.cs.GXGlobalParam_t;
import commvault.cte.workflow.db.cs.WF_Interaction_t;
import commvault.cte.workflow.logger.CTELogger;
import commvault.qnet.sys.CVPassword;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchTerm;
import org.bouncycastle.mail.smime.SMIMESigned;

public class Mailbox
implements Repeatable {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(Mailbox.class);
    public static boolean KEEP_MAILBOX_OPEN = WorkflowRegistry.getInstance().isEnableMailbox();
    public static boolean REPLY_CLOSED_ACTIONS = WorkflowRegistry.getInstance().isReplyClosedActions();
    public static boolean DELETE_EMAILS = WorkflowRegistry.getInstance().isDeleteApprovalEmails();
    private static Pattern ID_PATTERN = Pattern.compile("\\[id:.*]");
    private String emailHost;
    private String emailAddress;
    private String emailPassword;
    private String emailFolder;
    private String emailCopyFolder;
    private int emailPort;
    private boolean emailSSL;
    private boolean enabled;
    private Thread thread = null;
    private CommCellSettings settings;
    private static Mailbox instance;
    private Session session;
    private int interval;
    private Store store;
    private Folder inbox;
    private Folder copyFolder;
    private Set<WorkflowMessageListener> listeners = new HashSet<WorkflowMessageListener>();

    public static Mailbox getInstance() {
        if (instance == null) {
            instance = new Mailbox();
        }
        return instance;
    }

    public Mailbox() {
        String string;
        this.interval = WorkflowRegistry.getInstance().getApprovalEmailPullingInterval();
        boolean bl = this.getBooleanValue("WorkflowEmailApprovalEnabled");
        boolean bl2 = this.getBooleanValue("WorkflowEmailApprovalSSL");
        this.enabled = WorkflowRegistry.getInstance().getRegistryNumber("WFEngine", "WorkflowEmailApprovalEnabled", bl ? 1 : 0) == 1;
        this.emailSSL = WorkflowRegistry.getInstance().getRegistryNumber("WFEngine", "WorkflowEmailApprovalSSL", bl2 ? 1 : 0) == 1;
        this.emailAddress = WorkflowRegistry.getInstance().getRegistryString("WFEngine", "WorkflowEmailApprovalMailbox", this.getGlobalParameterValue("WorkflowEmailApprovalMailbox"));
        this.emailHost = WorkflowRegistry.getInstance().getRegistryString("WFEngine", "WorkflowEmailApprovalHost", this.getGlobalParameterValue("WorkflowEmailApprovalHost", ""));
        this.emailPort = WorkflowRegistry.getInstance().getRegistryNumber("WFEngine", "WorkflowEmailApprovalPort", 0);
        Properties properties = new Properties();
        properties.setProperty("mail.store.protocol", "imaps");
        properties.put("mail.imaps.host", this.emailHost);
        String string2 = WorkflowRegistry.getInstance().getRegistryString("WFEngine", "WorkflowEmailApprovalFallback", "");
        if (string2.length() > 0) {
            properties.setProperty("mail.imaps.socketFactory.fallback", string2);
        }
        if (this.emailSSL) {
            properties.setProperty("mail.imaps.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            properties.setProperty("mail.imap.ssl.enable", "true");
        }
        if (this.emailPort > 0) {
            properties.setProperty("mail.imaps.port", String.valueOf(this.emailPort));
            properties.setProperty("mail.imaps.socketFactory.port", String.valueOf(this.emailPort));
        }
        this.session = Session.getInstance((Properties)properties, null);
        String string3 = WorkflowRegistry.getInstance().getRegistryString("WFEngine", "WorkflowEmailApprovalPassword", this.getGlobalParameterValue("WorkflowEmailApprovalPassword"));
        if (string3 != null && string3.length() > 0) {
            if (string3.startsWith("||")) {
                string3 = Base64.decode((String)string3.substring(5));
            }
            string = new CVPassword();
            try {
                this.emailPassword = string.decrypt(string3);
                if (this.emailPassword == null || this.emailPassword.length() == 0) {
                    logger.details("decrypted password from GxGlobalParam entry [%s] was empty using plain text password", "WorkflowEmailApprovalPassword");
                    this.emailPassword = string3;
                }
            }
            catch (Throwable throwable) {
                logger.details("failed to decrypt password from GxGlobalParam entry [%s]", "WorkflowEmailApprovalPassword");
                this.emailPassword = string3;
            }
        } else {
            this.emailPassword = "";
        }
        this.emailFolder = (string = this.getGlobalParameterValue("WorkflowEmailApprovalFolder")) == null || string.length() == 0 ? "Inbox" : string;
        this.emailFolder = WorkflowRegistry.getInstance().getRegistryString("WFEngine", "WorkflowEmailApprovalFolder", this.emailFolder);
        this.emailCopyFolder = WorkflowRegistry.getInstance().getMailCopyFolder();
        if (REPLY_CLOSED_ACTIONS) {
            this.settings = new CommCellSettings();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getReplyTo() {
        return this.emailAddress;
    }

    public synchronized void addListener(WorkflowMessageListener workflowMessageListener) {
        if (this.enabled) {
            this.listeners.add(workflowMessageListener);
        }
    }

    public synchronized void removeListener(WorkflowMessageListener workflowMessageListener) {
        this.listeners.remove(workflowMessageListener);
    }

    private void connect() throws Exception {
        logger.info("connecting to mailbox [%s] on server [%s]", this.emailAddress, this.emailHost);
        if (this.store == null) {
            this.store = this.session.getStore("imaps");
        }
        if (this.emailPort > 0) {
            this.store.connect(this.emailHost, this.emailPort, this.emailAddress, this.emailPassword);
        } else {
            this.store.connect(this.emailHost, this.emailAddress, this.emailPassword);
        }
        this.inbox = this.store.getFolder(this.emailFolder);
        if (this.emailCopyFolder != null && this.emailCopyFolder.length() > 0) {
            this.copyFolder = this.store.getFolder(this.emailCopyFolder);
        }
    }

    private void checkMessages() throws Exception {
        logger.debug("begin retrieving messages from mailbox [" + this.emailAddress + "], folder [" + this.emailFolder + "]");
        if (this.inbox.getUnreadMessageCount() == 0) {
            logger.debug("no unread messages found in mailbox [" + this.emailAddress + "], folder [" + this.emailFolder + "]");
            return;
        }
        FlagTerm flagTerm = new FlagTerm(new Flags(Flags.Flag.SEEN), false);
        Message[] messageArray = this.inbox.search((SearchTerm)flagTerm);
        if (messageArray == null || messageArray.length == 0) {
            logger.debug("search term for Flags.Flag.SEEN [false], returned no message in mailbox [" + this.emailAddress + "]");
            return;
        }
        for (Message message : messageArray) {
            WorkflowMessage workflowMessage;
            if (message == null || message.isExpunged()) continue;
            try {
                workflowMessage = this.buildMessage(message);
            }
            catch (IOException iOException) {
                logger.error("IO error trying to build message for subject [" + message.getSubject() + "], error [" + iOException.getMessage() + "]");
                continue;
            }
            message.setFlag(Flags.Flag.SEEN, false);
            logger.debug("processing email from [" + workflowMessage.getFrom() + "] with subject [" + workflowMessage.getSubject() + "]");
            boolean bl = false;
            for (WorkflowMessageListener workflowMessageListener : this.listeners.toArray(new WorkflowMessageListener[0])) {
                if (workflowMessageListener.isClosed()) {
                    this.removeListener(workflowMessageListener);
                    continue;
                }
                if (workflowMessageListener.getStatus() == ProcessStatus.RUNNING || workflowMessageListener.getStatus() == ProcessStatus.WAITING) {
                    if (!workflowMessageListener.onReceive(workflowMessage)) continue;
                    bl = true;
                    if (this.copyFolder != null) {
                        this.inbox.copyMessages(new Message[]{message}, this.copyFolder);
                    }
                    if (DELETE_EMAILS) {
                        message.setFlag(Flags.Flag.DELETED, true);
                        break;
                    }
                    message.setFlag(Flags.Flag.SEEN, true);
                    break;
                }
                logger.debug("removing message listener [" + workflowMessageListener.getClass() + "] since it has a status of [" + workflowMessageListener.getStatus() + "]");
                this.removeListener(workflowMessageListener);
            }
            if (bl) continue;
            if (REPLY_CLOSED_ACTIONS) {
                if (this.checkClosedAction(workflowMessage)) {
                    if (this.copyFolder != null) {
                        this.inbox.copyMessages(new Message[]{message}, this.copyFolder);
                    }
                    if (DELETE_EMAILS) {
                        message.setFlag(Flags.Flag.DELETED, true);
                        continue;
                    }
                    message.setFlag(Flags.Flag.SEEN, true);
                    continue;
                }
                logger.debug("email from [" + workflowMessage.getFrom() + "] with subject [" + workflowMessage.getSubject() + "] does not have a handler associated with it");
                continue;
            }
            logger.debug("email from [" + workflowMessage.getFrom() + "] with subject [" + workflowMessage.getSubject() + "] does not have a handler associated with it");
        }
        logger.debug("completed retrieving messages from mailbox [" + this.emailAddress + "], folder [" + this.emailFolder + "]");
    }

    private boolean checkClosedAction(WorkflowMessage workflowMessage) {
        String string = this.getInteractionId(workflowMessage.getSubject());
        if (string != null && string.length() > 0) {
            Object object;
            String string2 = null;
            WF_Interaction_t wF_Interaction_t = this.getInteraction(string);
            if (wF_Interaction_t != null && wF_Interaction_t.status.get() > 0 && !wF_Interaction_t.completedBy.isNull() && wF_Interaction_t.completedBy.get() > 0) {
                try {
                    object = UserModel.load(wF_Interaction_t.completedBy.get());
                    string2 = object.getUserName();
                }
                catch (EvFailureException evFailureException) {
                    logger.error(null, "failed to load user for interaction guid [" + string + "], user id [" + wF_Interaction_t.completedBy.get() + "] for email address from [" + workflowMessage.getFrom() + "], subject [" + workflowMessage.getSubject() + "]");
                    return false;
                }
            }
            if (string2 != null && string2.length() > 0) {
                logger.info("auto replying to user [" + workflowMessage.getFrom() + "] for subject [" + workflowMessage.getSubject() + "] since action has already been completed by [" + string2 + "]");
                object = new WorkflowMail(this.settings, null);
                String string3 = "This action has already been completed by [" + string2 + "]";
                try {
                    ((WorkflowMail)object).send(Mailbox.getInstance().getReplyTo(), workflowMessage.getFrom(), workflowMessage.getSubject(), string3.toString());
                }
                catch (EvFailureException evFailureException) {
                    logger.error(null, "failed to reply to recipient [" + workflowMessage.getFrom() + "] with message [" + string3.toString() + "]");
                }
                return true;
            }
        }
        return false;
    }

    private String getInteractionId(String string) {
        Matcher matcher = ID_PATTERN.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group();
            return matcher.group().substring(4, string2.length() - 1);
        }
        return null;
    }

    private WF_Interaction_t getInteraction(String string) {
        String string2 = String.format("interactionGuid = '%s' And clientId = %s", string, WorkflowProperties.getInstance().getClient().getClientId());
        WF_Interaction_t wF_Interaction_t = new WF_Interaction_t();
        try {
            if (wF_Interaction_t.fill(string2)) {
                return wF_Interaction_t;
            }
            return null;
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to retrieve WF_Interaction record for interactionGuid [" + string + "]", cTEDBException);
            return null;
        }
    }

    private WorkflowMessage buildMessage(Message message) throws Exception {
        WorkflowMessage workflowMessage = new WorkflowMessage();
        Address[] addressArray = message.getFrom();
        if (addressArray[0] instanceof InternetAddress) {
            workflowMessage.setFrom(((InternetAddress)addressArray[0]).getAddress());
        } else {
            workflowMessage.setFrom(addressArray[0].toString());
        }
        workflowMessage.setSubject(message.getSubject());
        logger.debug("found email message from [%s] with subject [%s]", workflowMessage.getFrom(), workflowMessage.getSubject());
        String string = "";
        String string2 = "";
        if (message.isMimeType("multipart/signed")) {
            SMIMESigned sMIMESigned = new SMIMESigned((MimeMultipart)message.getContent());
            MimeBodyPart mimeBodyPart = sMIMESigned.getContent();
            Object object = mimeBodyPart.getContent();
            if (object instanceof String) {
                string = String.valueOf(message.getContent());
                string2 = message.getContentType();
            } else if (object instanceof Multipart) {
                MimeMultipart mimeMultipart = (MimeMultipart)message.getContent();
                BodyPart bodyPart = this.getMimeBody(message.getSubject(), mimeMultipart);
                string = String.valueOf(String.valueOf(bodyPart.getContent()));
                string2 = bodyPart.getContentType();
            }
        } else if (message.isMimeType("application/pkcs7-mime") || message.isMimeType("application/x-pkcs7-mime")) {
            SMIMESigned sMIMESigned = new SMIMESigned((Part)message);
            MimeBodyPart mimeBodyPart = sMIMESigned.getContent();
            Object object = mimeBodyPart.getContent();
            if (object instanceof String) {
                string = String.valueOf(message.getContent());
                string2 = message.getContentType();
            } else {
                logger.error("unknown smime content type [" + object.getClass() + "]");
                string = "";
                string2 = message.getContentType();
            }
        } else if (message.getContent() instanceof String) {
            string = String.valueOf(message.getContent());
            string2 = message.getContentType();
        } else if (message.getContent() instanceof MimeMultipart) {
            MimeMultipart mimeMultipart = (MimeMultipart)message.getContent();
            BodyPart bodyPart = this.getMimeBody(message.getSubject(), mimeMultipart);
            string = String.valueOf(String.valueOf(bodyPart.getContent()));
            string2 = bodyPart.getContentType();
        } else {
            logger.warn("unknown content type [%s], class [%s] for message with subject [%s]", message.getContentType(), message.getContent().getClass(), message.getSubject());
            string = String.valueOf(message.getContent());
            string2 = message.getContentType();
        }
        workflowMessage.setContentType(string2);
        workflowMessage.setBody(string);
        return workflowMessage;
    }

    private BodyPart getMimeBody(String string, MimeMultipart mimeMultipart) throws Exception {
        int n = mimeMultipart.getCount();
        for (int i = 0; i < n; ++i) {
            BodyPart bodyPart = mimeMultipart.getBodyPart(i);
            logger.trace("multi-part message recieved for subject [%s], part [%s], content type [%s], content [%s]", string, i, bodyPart.getContentType(), String.valueOf(bodyPart.getContent()));
            if (bodyPart.getContent() instanceof String) {
                return bodyPart;
            }
            if (!(bodyPart.getContent() instanceof MimeMultipart)) continue;
            return this.getMimeBody(string, (MimeMultipart)bodyPart.getContent());
        }
        return null;
    }

    private synchronized void worker() {
        this.interval = WorkflowRegistry.getInstance().getApprovalEmailPullingInterval();
        if (this.listeners.size() > 0 || KEEP_MAILBOX_OPEN) {
            logger.trace("initiating mailbox retrieval for [%s] listener(s)", this.listeners.size());
            if (this.store == null || !this.store.isConnected()) {
                try {
                    this.connect();
                }
                catch (Exception exception) {
                    logger.error("failed to connect to mailbox [" + this.emailAddress + "] on host [" + this.emailHost + "]", exception);
                    this.interval = 3600;
                    return;
                }
            }
            this.reopenFolder(this.inbox, this.emailFolder);
            this.reopenFolder(this.copyFolder, this.emailCopyFolder);
            try {
                this.checkMessages();
            }
            catch (Throwable throwable) {
                logger.error("failed to check messages in mailbox [" + this.emailAddress + "] on host [" + this.emailHost + "]", throwable);
            }
            this.closeFolder(this.inbox, this.emailFolder);
            this.closeFolder(this.copyFolder, this.emailCopyFolder);
        } else {
            this.closeFolder(this.inbox, this.emailFolder);
            this.closeFolder(this.copyFolder, this.emailCopyFolder);
            if (this.store != null && this.store.isConnected()) {
                logger.info("closing connection to mailbox [%s] on host [%s] since there are no more listeners", this.emailAddress, this.emailHost);
                try {
                    this.store.close();
                }
                catch (MessagingException messagingException) {
                    logger.error("failed to close mailbox [" + this.emailAddress + "] on host [" + this.emailHost + "]", messagingException);
                }
            }
        }
    }

    private void reopenFolder(Folder folder, String string) {
        if (folder != null) {
            if (folder.isOpen()) {
                try {
                    folder.close(true);
                    folder.open(2);
                }
                catch (MessagingException messagingException) {
                    logger.error("failed to re-open folder [" + string + "] on host [" + this.emailHost + "]", messagingException);
                    return;
                }
            }
            try {
                folder.open(2);
            }
            catch (MessagingException messagingException) {
                logger.error("failed to open folder [" + string + "] on host [" + this.emailHost + "]", messagingException);
                return;
            }
        }
    }

    private void closeFolder(Folder folder, String string) {
        if (folder != null && folder.isOpen()) {
            try {
                folder.close(true);
            }
            catch (MessagingException messagingException) {
                logger.error("failed to close folder [" + string + "] on host [" + this.emailHost + "]", messagingException);
            }
        }
    }

    @Override
    public synchronized void run() {
        if (this.thread != null) {
            logger.debug("mailbox thread is already running");
            return;
        }
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Mailbox.this.worker();
                }
                catch (Throwable throwable) {
                    logger.error("uncaught exception executing mailbox thread", throwable);
                }
                finally {
                    Mailbox.this.thread = null;
                }
            }
        });
        this.thread.start();
    }

    @Override
    public int getInterval() {
        return this.interval;
    }

    public boolean getBooleanValue(String string) {
        String string2 = this.getGlobalParameterValue(string);
        if (string2 == null) {
            return false;
        }
        return string2.equals(String.valueOf(1)) || string2.equals(String.valueOf(Boolean.TRUE.toString()));
    }

    private String getGlobalParameterValue(String string) {
        return this.getGlobalParameterValue(string, null);
    }

    private String getGlobalParameterValue(String string, String string2) {
        GXGlobalParam_t gXGlobalParam_t = new GXGlobalParam_t();
        String string3 = String.format("name = '%s'", string);
        try {
            if (gXGlobalParam_t.fill(string3)) {
                return gXGlobalParam_t.value.get();
            }
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to retrieve GxGlobal Parameter [" + string + "]", cTEDBException);
        }
        return string2;
    }

    private static class LRUCache
    extends LinkedHashMap<String, String> {
        private int cacheSize;

        private LRUCache(int n) {
            super(16, 0.75f, true);
            this.cacheSize = n;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> entry) {
            return this.size() >= this.cacheSize;
        }
    }
}

