/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.db.CTEDBException;
import commvault.cte.util.DateUtilities;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.ExecutionState;
import commvault.cte.workflow.ForEachParallelProcess;
import commvault.cte.workflow.JobContext;
import commvault.cte.workflow.ParellelProcess;
import commvault.cte.workflow.ParellelProcessManager;
import commvault.cte.workflow.ProcessManager;
import commvault.cte.workflow.SuperProcess;
import commvault.cte.workflow.db.engine.WF_SuperProcess_t;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.logger.CTELogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ForEachProcessManager {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ForEachProcessManager.class);
    private List<ParellelProcessManager> threads = new ArrayList<ParellelProcessManager>();
    private int uncompletedThreads = 0;
    private final ActivityContext context;
    private String name;
    private List list;
    private boolean continueOnFailure;
    private int numberOfParallelExecutions;
    private Object lock = new Object[0];

    public ForEachProcessManager(ActivityContext activityContext, String string, List list, boolean bl, int n) {
        this.context = activityContext;
        this.name = string;
        this.list = list;
        this.continueOnFailure = bl;
        this.numberOfParallelExecutions = n;
    }

    public void addProcess(ParellelProcess parellelProcess) {
        this.threads.add(new ParellelProcessManager(parellelProcess));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void worker() {
        for (ParellelProcessManager parellelProcessManager : this.threads) {
            parellelProcessManager.start(this);
        }
        while (true) {
            Object object = this.lock;
            synchronized (object) {
                JobContext jobContext;
                int n = 0;
                Iterator<ParellelProcessManager> iterator = this.threads.iterator();
                while (iterator.hasNext()) {
                    jobContext = iterator.next();
                    if (((ParellelProcessManager)jobContext).isAlive()) {
                        if (((ParellelProcessManager)jobContext).getSuperProcess().getStatus() != ProcessStatus.WAITING) continue;
                        ++n;
                        continue;
                    }
                    if (this.context.getStatus() == ProcessStatus.RUNNING || this.context.getStatus() == ProcessStatus.WAITING) {
                        if (((ProcessManager)jobContext).getSize() == 0) {
                            ((ParellelProcessManager)jobContext).getSuperProcess().complete();
                        } else {
                            logger.info(this.context.getJobId(), "process block for super process id [%s] exited with status [%s], step size [%s]", ((ParellelProcessManager)jobContext).getSuperProcess().getSuperProcessId(), ((ParellelProcessManager)jobContext).getSuperProcess().getStatus().toString(), ((ProcessManager)jobContext).getSize());
                            ++this.uncompletedThreads;
                        }
                    }
                    iterator.remove();
                }
                if (this.threads.size() == 0) {
                    if (this.context.getStatus() == ProcessStatus.WAITING) {
                        logger.debug(this.context.getJobId(), "switching foreach block back to running state since there are no more waiting threads");
                        this.context.setStatus(ProcessStatus.RUNNING);
                    }
                } else if (this.threads.size() == n) {
                    if (this.context.getStatus() == ProcessStatus.RUNNING) {
                        logger.debug(this.context.getJobId(), "switching foreach block to waiting status since all executing threads are in a waiting state");
                        this.context.setStatus(ProcessStatus.WAITING);
                    }
                } else if (this.context.getStatus() == ProcessStatus.WAITING) {
                    logger.debug(this.context.getJobId(), "switching foreach block back to running state since there is at least one non-waiting thread");
                    this.context.setStatus(ProcessStatus.RUNNING);
                }
                if (this.getNextIndex() < this.list.size() && this.threads.size() < this.numberOfParallelExecutions) {
                    if (this.context.interrupted()) {
                        logger.debug("unable to process next foreach item due to the context being interrupted");
                    } else if (this.context.getStatus() != ProcessStatus.RUNNING && this.context.getStatus() != ProcessStatus.WAITING) {
                        logger.debug("unable to process next foreach item due to status of workflow being [%s]", this.context.getStatus().toString());
                    } else if (!this.context.isRunning()) {
                        logger.debug("unable to process next foreach item due to workflow being shutdown");
                    } else {
                        if (this.context.getStatus() == ProcessStatus.WAITING) {
                            logger.debug(this.context.getJobId(), "switching foreach block to running state since we are adding another thread");
                            this.context.setStatus(ProcessStatus.RUNNING);
                        }
                        while (this.getNextIndex() < this.list.size() && this.threads.size() < this.numberOfParallelExecutions) {
                            try {
                                jobContext = this.getParallelProcess(this.getNextIndex());
                            }
                            catch (EvFailureException evFailureException) {
                                logger.error("unable to process next foreach item");
                                this.context.setFailureReason(evFailureException.getMessageContainer());
                                this.context.setStatus(ProcessStatus.PENDING);
                                break;
                            }
                            this.setIndex(this.getNextIndex() + 1);
                            this.context.save();
                            ParellelProcessManager parellelProcessManager = new ParellelProcessManager((SuperProcess)jobContext);
                            this.threads.add(parellelProcessManager);
                            logger.info(this.context.getJobId(), "starting for-each process for item index [%s] value [%s]", ((SuperProcess)jobContext).getLoopIndex(), ((SuperProcess)jobContext).getExecutionXml());
                            parellelProcessManager.start(this);
                        }
                    }
                }
                if (this.threads.size() == 0) {
                    break;
                }
                try {
                    this.lock.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signal() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    public boolean isRunning() {
        return this.uncompletedThreads > 0;
    }

    private int getNextIndex() {
        if (this.context.getSubJobId() == null) {
            return 0;
        }
        return this.context.getSubJobId().intValue();
    }

    private void setIndex(int n) {
        this.context.setSubJobId(n);
    }

    private ParellelProcess getParallelProcess(int n) throws EvFailureException {
        ForEachParallelProcess forEachParallelProcess;
        List<WorkflowElement> list;
        try {
            list = this.context.getMarshaller().encode(this.name, this.list.get(n));
        }
        catch (EvFailureException evFailureException) {
            logger.error(this.context.getJobId(), "failed to encode foreach input");
            throw evFailureException;
        }
        if (list == null || list.size() == 0) {
            logger.warn(this.context.getJobId(), "did not retrieve any xml from encoding for-each input [%s]", String.valueOf(this.list.get(n)));
            return null;
        }
        WorkflowElement workflowElement = list.get(0).clone();
        workflowElement.setName(this.name);
        WorkflowElement workflowElement2 = new WorkflowElement(this.context.getUniqueName());
        workflowElement2.addContent(workflowElement);
        WF_SuperProcess_t wF_SuperProcess_t = this.context.getDataAccess().newSuperProcess();
        wF_SuperProcess_t.ProcessStepId.set(this.context.getProcessStepId());
        wF_SuperProcess_t.State.set(Integer.valueOf(ExecutionState.STARTING.toInt()));
        wF_SuperProcess_t.Started.set(Integer.valueOf(DateUtilities.getNow()));
        wF_SuperProcess_t.Execution.set(workflowElement2.toString());
        wF_SuperProcess_t.LoopIndex.set(Integer.valueOf(n));
        try {
            forEachParallelProcess = new ForEachParallelProcess(this.context, wF_SuperProcess_t, this.continueOnFailure);
        }
        catch (EvFailureException evFailureException) {
            logger.error(this.context.getJobId(), "failed to load super process entry for process step id [" + this.context.getProcessStepId() + "]");
            throw evFailureException;
        }
        try {
            wF_SuperProcess_t.save();
        }
        catch (CTEDBException cTEDBException) {
            logger.error(this.context.getJobId(), "error saving super process", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        forEachParallelProcess.setProcessXml(workflowElement2);
        return forEachParallelProcess;
    }
}

