/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.WorkflowContext;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.WorkflowUtils;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import workflow.types.Binary;

public class FileUploadMonitor {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(FileUploadMonitor.class);
    private Set<FileContainer> files = new HashSet<FileContainer>();
    private WorkflowContext context;
    private WorkflowElement inputs;

    public FileUploadMonitor(WorkflowElement workflowElement, WorkflowContext workflowContext) throws EvFailureException {
        this.context = workflowContext;
        this.inputs = workflowElement;
        for (WorkflowElement workflowElement2 : workflowElement.getChildren()) {
            Binary binary;
            String string = workflowElement2.getAttributeValue("class");
            if (string == null || string.length() == 0) continue;
            FileContainer fileContainer = null;
            if (string.equals(Binary.class.getName())) {
                logger.debug("checking binary input [%s], xml [%s]", workflowElement2.getName(), workflowElement2);
                try {
                    binary = (Binary)workflowContext.getMarshaller().decode(workflowElement2);
                }
                catch (EvFailureException evFailureException) {
                    logger.error(workflowContext.getJobId(), "failed to decode binary input [" + workflowElement2.getName() + "]");
                    throw evFailureException;
                }
                if (binary != null) {
                    fileContainer = new BinaryContainer(workflowElement2, binary);
                }
            }
            if (string.equals(workflow.types.File.class.getName())) {
                logger.debug("checking file input [%s], xml [%s]", workflowElement2.getName(), workflowElement2);
                try {
                    binary = (workflow.types.File)workflowContext.getMarshaller().decode(workflowElement2);
                }
                catch (EvFailureException evFailureException) {
                    logger.error(workflowContext.getJobId(), "failed to decode binary input [" + workflowElement2.getName() + "]");
                    throw evFailureException;
                }
                if (binary != null) {
                    File file;
                    if (!WorkflowUtils.isWindows()) {
                        binary.setDestPath(binary.getDestPath().replace('\\', '/'));
                    }
                    if (!(file = new File(binary.getDestPath())).isAbsolute()) {
                        File file2 = new File(WorkflowProperties.getInstance().getJobResultsDir(), binary.getDestPath());
                        binary.setDestPath(file2.getAbsolutePath());
                    }
                    fileContainer = new FileContainer(workflowElement2, (workflow.types.File)binary);
                }
            }
            if (fileContainer == null || fileContainer.getFile() == null || fileContainer.getFile().getDestPath() == null || fileContainer.getFile().getDestPath().length() <= 0) continue;
            if (this.files.add(fileContainer)) {
                logger.debug("added input [%s] to upload monitor, file name [%s], upload path [%s], size [%s]", workflowElement2.getName(), fileContainer.getFile().getName(), fileContainer.getFile().getDestPath(), fileContainer.getFile().getFileSize());
                continue;
            }
            logger.warn(workflowContext.getJobId(), "duplicate uploaded file [%s]", fileContainer.getFile().getDestPath());
        }
    }

    public void upload() throws EvFailureException, InterruptedException {
        if (this.files.size() == 0) {
            return;
        }
        for (FileContainer fileContainer : this.files) {
            File file = new File(fileContainer.getFile().getDestPath());
            if (file.exists()) {
                this.context.getRoot().getWorkflowExecution().addUploadedFile(file.getAbsolutePath());
                try {
                    fileContainer.setFile(file);
                }
                catch (Exception exception) {
                    logger.error(this.context.getJobId(), "failed to read uploaded file [" + fileContainer.getFile().getDestPath() + "]", exception);
                    throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
                }
                this.inputs.removeContent(fileContainer.getElement());
                List<WorkflowElement> list = this.context.getMarshaller().encode(fileContainer.element.getName(), fileContainer.getFile());
                if (fileContainer.isList()) {
                    for (WorkflowElement workflowElement : list) {
                        workflowElement.setAttribute("_list_", String.valueOf(Boolean.TRUE));
                    }
                }
                this.inputs.addContent(list);
                continue;
            }
            throw new EvFailureException(new EvMessageContainer("failed to find uploaded file [" + fileContainer.getFile().getDestPath() + "]"));
        }
    }

    private static class BinaryContainer
    extends FileContainer {
        private BinaryContainer(WorkflowElement workflowElement, Binary binary) {
            super(workflowElement, (workflow.types.File)binary);
        }

        @Override
        public void setFile(File file) throws Exception {
            ((Binary)this.getFile()).setBytes(WorkflowUtils.getBytes(new FileInputStream(file)));
        }
    }

    private static class FileContainer {
        private WorkflowElement element;
        private workflow.types.File workflowFile;

        private FileContainer(WorkflowElement workflowElement, workflow.types.File file) {
            this.element = workflowElement;
            this.workflowFile = file;
        }

        public WorkflowElement getElement() {
            return this.element;
        }

        public boolean isList() {
            return Boolean.parseBoolean(this.element.getAttributeValue("_list_"));
        }

        public workflow.types.File getFile() {
            return this.workflowFile;
        }

        public int hashCode() {
            return this.workflowFile.hashCode();
        }

        public String toString() {
            return this.workflowFile.getName();
        }

        public void setFile(File file) throws Exception {
        }
    }
}

