/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.db.CTEDBException;
import commvault.cte.workflow.WorkflowProcess;
import commvault.cte.workflow.db.engine.WF_ActivityPackages_t;
import commvault.cte.workflow.db.engine.WF_Handlers_t;
import commvault.cte.workflow.events.EngineStartHandler;
import commvault.cte.workflow.events.EngineStopHandler;
import commvault.cte.workflow.events.EventRegistry;
import commvault.cte.workflow.events.WorkflowAction;
import commvault.cte.workflow.events.WorkflowEndHandler;
import commvault.cte.workflow.events.WorkflowStartHandler;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.ReflectionUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EventManager {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(EventManager.class);
    private static EventManager instance;
    private Set<WorkflowAction> registeredHandlers = new HashSet<WorkflowAction>();

    public static EventManager getInstance() {
        if (instance == null) {
            instance = new EventManager();
        }
        return instance;
    }

    public EventManager() {
        this.registerHandlers(null);
    }

    public void registerPackage(WF_ActivityPackages_t wF_ActivityPackages_t) {
        String string = String.format("PackageId = %s", wF_ActivityPackages_t.PackageId.get());
        this.registerHandlers(string);
    }

    private void registerHandlers(String string) {
        List<WF_Handlers_t> list;
        try {
            list = WF_Handlers_t.select(string);
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to retrieve installed action handlers", cTEDBException);
            return;
        }
        for (WF_Handlers_t wF_Handlers_t : list) {
            try {
                WorkflowAction workflowAction;
                Class<?> clazz = this.getClass().getClassLoader().loadClass(wF_Handlers_t.ClassName.get());
                if (!WorkflowAction.class.isAssignableFrom(clazz)) {
                    logger.error("handler class [" + clazz.getName() + "] is not valid WorkflowAction");
                    continue;
                }
                try {
                    workflowAction = (WorkflowAction)ReflectionUtils.newInstance(clazz);
                }
                catch (Exception exception) {
                    logger.error("failed to load handler class [" + clazz.getName() + "]", exception);
                    continue;
                }
                logger.debug("successfully registered workflow action handler [%s]", clazz.getName());
                this.registeredHandlers.add(workflowAction);
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.error("failed to load handler class [" + wF_Handlers_t.ClassName.get() + "]", classNotFoundException);
            }
        }
    }

    public void fireEngineStartEvent() {
        for (EngineStartHandler engineStartHandler : EventRegistry.ENGINE_START_HANDLERS) {
            logger.debug("firing engine start event on handler [%s]", engineStartHandler.getClass().getName());
            engineStartHandler.onEngineStart();
        }
        for (WorkflowAction workflowAction : this.registeredHandlers) {
            logger.debug("firing engine start event on handler [%s]", workflowAction.getClass().getName());
            workflowAction.onEngineStart();
        }
    }

    public void fireEngineStopEvent() {
        for (EngineStopHandler engineStopHandler : EventRegistry.ENGINE_STOP_HANDLERS) {
            logger.debug("firing engine stop event on handler [%s]", engineStopHandler.getClass().getName());
            engineStopHandler.onEngineStop();
        }
        for (WorkflowAction workflowAction : this.registeredHandlers) {
            logger.debug("firing engine stop event on handler [%s]", workflowAction.getClass().getName());
            workflowAction.onEngineStop();
        }
    }

    public void fireWorkflowStartEvent(WorkflowProcess workflowProcess) {
        for (WorkflowStartHandler workflowStartHandler : EventRegistry.WORKFLOW_START_HANDLERS) {
            logger.debug("firing workflow start event on handler [%s]", workflowStartHandler.getClass().getName());
            workflowStartHandler.onWorkflowStart(workflowProcess);
        }
        for (WorkflowAction workflowAction : this.registeredHandlers) {
            logger.debug("firing workflow start event on handler [%s]", workflowAction.getClass().getName());
            workflowAction.onWorkflowStart(workflowProcess);
        }
    }

    public void fireWorkflowEndEvent(WorkflowProcess workflowProcess) {
        for (WorkflowEndHandler workflowEndHandler : EventRegistry.WORKFLOW_END_HANDLERS) {
            logger.debug("firing workflow end event on handler [%s]", workflowEndHandler.getClass().getName());
            workflowEndHandler.onWorkflowEnd(workflowProcess);
        }
        for (WorkflowAction workflowAction : this.registeredHandlers) {
            logger.debug("firing workflow end event on handler [%s]", workflowAction.getClass().getName());
            workflowAction.onWorkflowEnd(workflowProcess);
        }
    }
}

