/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.db.CTEDBConnection;
import commvault.cte.db.CTEDBException;
import commvault.cte.db.CTEDBReservation;
import commvault.cte.util.DateUtilities;
import commvault.cte.workflow.Capability;
import commvault.cte.workflow.SecurityContext;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.EntityType;
import java.sql.CallableStatement;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;

public class EvSecurity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(EvSecurity.class);
    private static final boolean RETRY_SEC_PROC = WorkflowRegistry.getInstance().isRetrySecurityProcedure();
    private static final int SECURITY_CACHE_TIME = WorkflowRegistry.getInstance().getSecurityCacheTime();
    private static final ConcurrentHashMap<String, CachedValue> securityCache = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Boolean getCachedValue(String string, Callable<Boolean> callable, boolean bl) throws CTEDBException {
        if (SECURITY_CACHE_TIME > 0 && bl) {
            String string2 = string.intern();
            synchronized (string2) {
                Boolean bl2;
                CachedValue cachedValue = securityCache.get(string);
                if (cachedValue != null) {
                    int n = DateUtilities.getNow() - cachedValue.created;
                    if (n >= SECURITY_CACHE_TIME) {
                        securityCache.remove(string);
                    } else {
                        return cachedValue.value;
                    }
                }
                try {
                    bl2 = callable.call();
                }
                catch (Exception exception) {
                    if (exception instanceof CTEDBException) {
                        throw (CTEDBException)((Object)exception);
                    }
                    throw new CTEDBException((Throwable)exception);
                }
                if (bl2 == null) {
                    return bl2;
                }
                securityCache.put(string, new CachedValue(bl2));
                return (boolean)bl2;
            }
        }
        try {
            return callable.call();
        }
        catch (Exception exception) {
            if (exception instanceof CTEDBException) {
                throw (CTEDBException)((Object)exception);
            }
            throw new CTEDBException((Throwable)exception);
        }
    }

    public static boolean isNodeCapability(int n, Capability capability, SecurityContext securityContext) throws CTEDBException {
        return EvSecurity.checkPermissionOnEntity(EntityType.CLIENT_ENTITY.getEnumValue(), n, capability, securityContext);
    }

    public static boolean canExecuteWorkflow(int n, SecurityContext securityContext) throws CTEDBException {
        return EvSecurity.checkPermissionOnEntity(EntityType.WORKFLOW_ENTITY.getEnumValue(), n, Capability.EXECUTE_WORKFLOW, securityContext) || EvSecurity.checkPermissionOnEntity(EntityType.WORKFLOW_ENTITY.getEnumValue(), n, Capability.EXECUTE_WORKFLOW_OLD, securityContext);
    }

    public static boolean canExecuteWorkflow(int n, int n2) throws CTEDBException {
        return EvSecurity.checkPermissionOnEntity(EntityType.WORKFLOW_ENTITY.getEnumValue(), n, Capability.EXECUTE_WORKFLOW, n2) || EvSecurity.checkPermissionOnEntity(EntityType.WORKFLOW_ENTITY.getEnumValue(), n, Capability.EXECUTE_WORKFLOW_OLD, n2);
    }

    public static boolean checkPermissionOnEntity(int n, int n2, Capability capability, int n3) throws CTEDBException {
        return EvSecurity.checkPermissionOnEntity(n, n2, capability, n3, true, WorkflowProperties.getInstance().getCommCellConnection());
    }

    public static boolean checkPermissionOnEntity(int n, int n2, Capability capability, SecurityContext securityContext) throws CTEDBException {
        return EvSecurity.checkPermissionOnEntity(n, n2, capability, securityContext, true);
    }

    public static boolean checkPermissionOnEntity(int n, int n2, Capability capability, SecurityContext securityContext, boolean bl) throws CTEDBException {
        return EvSecurity.checkPermissionOnEntity(n, n2, capability, securityContext.getUser().getUserId(), bl, securityContext.getCommCellConnection());
    }

    private static boolean checkPermissionOnEntity(final int n, final int n2, final Capability capability, final int n3, boolean bl, final CTEDBConnection cTEDBConnection) throws CTEDBException {
        Callable<Boolean> callable = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try (CTEDBReservation cTEDBReservation = cTEDBConnection.createReservation();){
                    CallableStatement callableStatement = cTEDBReservation.createCallableStatement("{call sec_checkPermissionOnEntity(?,?,?,?,?)}");
                    callableStatement.setInt(1, n3);
                    callableStatement.setInt(2, capability.getBitIndex());
                    callableStatement.registerOutParameter(3, 4);
                    callableStatement.setInt(4, n);
                    callableStatement.setInt(5, n2);
                    callableStatement.execute();
                    Boolean bl = callableStatement.getInt(3) == 1;
                    return bl;
                }
            }
        };
        String string = "sec_checkPermissionOnEntity" + n + "_" + n2 + "_" + capability.toString() + "_" + n3 + "_" + cTEDBConnection.toString();
        Boolean bl2 = EvSecurity.getCachedValue(string, callable, bl);
        if (bl2 == null) {
            return false;
        }
        return bl2;
    }

    public static boolean isAdministrativeCapability(int n, SecurityContext securityContext) throws CTEDBException {
        return EvSecurity.isNonNodeCapability(2, 2018, n, Capability.ADMINISTRATIVE_MANAGEMENT, securityContext);
    }

    public static boolean isAdministrativeCapability(int n, SecurityContext securityContext, boolean bl) throws CTEDBException {
        return EvSecurity.isNonNodeCapability(2, 2018, n, Capability.ADMINISTRATIVE_MANAGEMENT, securityContext, bl);
    }

    public static boolean isAdministrativeCapabilityRetry(int n, SecurityContext securityContext) throws CTEDBException {
        if (RETRY_SEC_PROC) {
            for (int i = 0; i < 5; ++i) {
                if (EvSecurity.isAdministrativeCapability(n, securityContext, false)) {
                    return true;
                }
                logger.info("sec_NoNiDaNodeAccess(%s, %s, %s, %s) did not return that user id [%s] is an admin", securityContext.getUser().getUserId(), 2, 1, n, securityContext.getUser().getUserId());
                try {
                    Thread.sleep(3000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    throw new CTEDBException((Throwable)interruptedException);
                }
            }
            return false;
        }
        return EvSecurity.isAdministrativeCapability(n, securityContext);
    }

    private static boolean isNonNodeCapability(int n, int n2, int n3, Capability capability, SecurityContext securityContext) throws CTEDBException {
        return EvSecurity.isNonNodeCapability(n, n2, n3, capability, securityContext, true);
    }

    private static boolean isNonNodeCapability(int n, int n2, int n3, Capability capability, SecurityContext securityContext, boolean bl) throws CTEDBException {
        return EvSecurity.checkPermissionOnEntity(EntityType.COMMCELL_ENTITY.getEnumValue(), n3, capability, securityContext, bl);
    }

    private static class CachedValue {
        private int created = DateUtilities.getNow();
        private boolean value;

        public CachedValue(boolean bl) {
            this.value = bl;
        }
    }
}

