/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.workflow.EventArgumentType;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.App.ArgumentInfoGroupXML;
import commvault.msgs.App.ArgumentInfoXML;

public class EvMessageContainer {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(EvMessageContainer.class);
    private final int messageId;
    private int errorCode = 1;
    private final ArgumentInfoGroupXML argumentInfo = new ArgumentInfoGroupXML();

    public EvMessageContainer(String string) {
        this(EventMessage.getInstance().getMessageId("JM_PENDING_CAUSE_50"), string);
    }

    public EvMessageContainer(String string, Object ... objectArray) {
        this(String.format(string, objectArray));
    }

    public EvMessageContainer(int n, Object ... objectArray) {
        this.messageId = n;
        if (objectArray != null && objectArray.length > 0) {
            for (Object object : objectArray) {
                ArgumentInfoXML argumentInfoXML = new ArgumentInfoXML();
                if (object == null) {
                    argumentInfoXML.setArg("");
                    argumentInfoXML.setSize(0L);
                    argumentInfoXML.setType(EventArgumentType.EA_STRING.getEnumValue());
                } else {
                    String string = String.valueOf(object);
                    if (string.length() > 1023) {
                        string = string.substring(0, 1023);
                    }
                    argumentInfoXML.setArg(string);
                    argumentInfoXML.setSize((long)(string.length() + 1));
                    argumentInfoXML.setType(this.getArgumentType(object.getClass()).getEnumValue());
                }
                this.argumentInfo.getArguments().add(argumentInfoXML);
            }
        }
    }

    private EventArgumentType getArgumentType(Class clazz) {
        if (clazz.equals(Character.class) || clazz.equals(Character.TYPE)) {
            return EventArgumentType.EA_CHAR;
        }
        if (clazz.equals(Short.class) || clazz.equals(Short.TYPE)) {
            return EventArgumentType.EA_SHORT;
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return EventArgumentType.EA_INT;
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return EventArgumentType.EA_LONG;
        }
        return EventArgumentType.EA_STRING;
    }

    public int getMessageId() {
        return this.messageId;
    }

    public ArgumentInfoGroupXML getArgumentInfo() {
        return this.argumentInfo;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int n) {
        this.errorCode = n;
    }
}

