/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.db.CTEDBException;
import commvault.cte.util.DateUtilities;
import commvault.cte.workflow.db.engine.WF_Props_t;
import commvault.cte.workflow.logger.CTELogger;

public class EngineProperties {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(EngineProperties.class);
    private static EngineProperties instance = new EngineProperties();
    private static final String PROPERTY_DATA_AGING = "DataAging";
    private static final String PROPERTY_AUTO_DEPLOY = "AutoDeploy";
    private static final String PROPERTY_REDEPLOY = "ReDeploy";
    private static final String PROPERTY_LAST_START = "StartTime";
    private static final String PROPERTY_LAST_SHUTDOWN = "ShutdownTime";
    private static final String PROPERTY_BAD_SHUTDOWN = "BadShutdowns";
    private static final String PROPERTY_CLIENT_ID = "ClientId";

    public static EngineProperties getInstance() {
        return instance;
    }

    private EngineProperties() {
    }

    private WF_Props_t getPropertyRow(String string) {
        String string2 = String.format("Name='%s'", string);
        WF_Props_t wF_Props_t = new WF_Props_t();
        try {
            if (wF_Props_t.fill(string2)) {
                return wF_Props_t;
            }
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to retrieve engine properties", cTEDBException);
        }
        return null;
    }

    private synchronized String getPropertyString(String string) {
        WF_Props_t wF_Props_t = this.getPropertyRow(string);
        if (wF_Props_t != null) {
            return wF_Props_t.Value.get();
        }
        return null;
    }

    private synchronized Integer getPropertyInt(String string) {
        WF_Props_t wF_Props_t = this.getPropertyRow(string);
        if (wF_Props_t != null) {
            return Integer.parseInt(wF_Props_t.Value.get());
        }
        return null;
    }

    private synchronized void setPropertyValue(String string, Object object) {
        WF_Props_t wF_Props_t = this.getPropertyRow(string);
        if (wF_Props_t == null) {
            wF_Props_t = new WF_Props_t();
            wF_Props_t.Name.set(string);
        }
        if (object == null) {
            wF_Props_t.Value.setNull();
        } else {
            wF_Props_t.Value.set(String.valueOf(object));
        }
        wF_Props_t.Modified.set(Integer.valueOf(DateUtilities.getNow()));
        try {
            logger.trace("updating WF_Props property [%s] with value [%s]", string, String.valueOf(object));
            wF_Props_t.save();
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to save engine property [" + string + "]", cTEDBException);
        }
    }

    public Integer getAutoDeployment() {
        return this.getPropertyInt(PROPERTY_AUTO_DEPLOY);
    }

    public void setAutoDeployment(int n) {
        this.setPropertyValue(PROPERTY_AUTO_DEPLOY, n);
    }

    public Integer getReDeployment() {
        return this.getPropertyInt(PROPERTY_REDEPLOY);
    }

    public void setReDeployment(int n) {
        this.setPropertyValue(PROPERTY_REDEPLOY, n);
    }

    public Integer getLastDataAging() {
        return this.getPropertyInt(PROPERTY_DATA_AGING);
    }

    public Integer getClientId() {
        return this.getPropertyInt(PROPERTY_CLIENT_ID);
    }

    public void setClientId(int n) {
        this.setPropertyValue(PROPERTY_CLIENT_ID, n);
    }

    public void setLastDataAging(int n) {
        this.setPropertyValue(PROPERTY_DATA_AGING, n);
    }

    public Integer getLastStartTime() {
        return this.getPropertyInt(PROPERTY_LAST_START);
    }

    public void setLastStartTime(int n) {
        this.setPropertyValue(PROPERTY_LAST_START, n);
    }

    public int getLastShutdown() {
        Integer n = this.getPropertyInt(PROPERTY_LAST_SHUTDOWN);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public void setLastShutdown(int n) {
        this.setPropertyValue(PROPERTY_LAST_SHUTDOWN, n);
    }

    public int getBadShutdowns() {
        Integer n = this.getPropertyInt(PROPERTY_BAD_SHUTDOWN);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public void setBadShutdowns(int n) {
        this.setPropertyValue(PROPERTY_BAD_SHUTDOWN, n);
    }
}

