/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.common.xml.XMLDecoder;
import commvault.cte.db.CTEDBException;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.ExecutionState;
import commvault.cte.workflow.ProcessContext;
import commvault.cte.workflow.SuperProcess;
import commvault.cte.workflow.UserModel;
import commvault.cte.workflow.WorkflowImport;
import commvault.cte.workflow.db.DataAccessLayer;
import commvault.cte.workflow.db.engine.WF_Deployments_t;
import commvault.cte.workflow.db.engine.WF_ProcessSteps_t;
import commvault.cte.workflow.db.engine.WF_Steps_t;
import commvault.cte.workflow.db.engine.WF_SuperProcess_t;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.dom.WorkflowExecution;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.CommServUtils;
import commvault.cte.workflow.utils.WorkflowUtils;
import commvault.msgs.App.XMLSchema;
import commvault.msgs.CvEntities.UserEntity;
import commvault.msgs.Workflow.SchemaDefinition;
import commvault.msgs.Workflow.ScriptDefinition;
import java.util.ArrayList;
import java.util.List;

public class EmbeddedWorkflow
extends SuperProcess {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(EmbeddedWorkflow.class);
    private final ActivityContext parent;
    private final String jobInputs;
    private final WF_Deployments_t deployment;
    private String configurationXml;
    private WorkflowExecution workflowExecution;
    private SchemaDefinition schemaDefinition = null;
    private List<WorkflowImport> imports = null;
    private ScriptDefinition onStart;
    private ScriptDefinition onComplete;
    private UserEntity creator = null;
    private DataAccessLayer database;
    private String outputs;
    private boolean saveExecution = false;

    public EmbeddedWorkflow(ActivityContext activityContext, WF_Deployments_t wF_Deployments_t, WF_SuperProcess_t wF_SuperProcess_t, DataAccessLayer dataAccessLayer, String string) throws EvFailureException {
        super(activityContext, wF_SuperProcess_t);
        this.parent = activityContext;
        this.jobInputs = string;
        this.deployment = wF_Deployments_t;
        this.database = dataAccessLayer;
    }

    @Override
    protected void initProcessElements() {
    }

    public void initialize() throws EvFailureException {
        try {
            logger.trace("loading creator user id [%s]", this.deployment.Creator.get());
            this.creator = UserModel.load(this.deployment.Creator.get());
        }
        catch (EvFailureException evFailureException) {
            logger.error("failed to load creator user from id [" + this.deployment.Creator.get() + "]");
            throw evFailureException;
        }
        if (!this.deployment.SchemaDefinition.isNull()) {
            try {
                this.schemaDefinition = (SchemaDefinition)WorkflowUtils.decodeMessage(this.deployment.SchemaDefinition.get(), (Object)new SchemaDefinition());
            }
            catch (Exception exception) {
                logger.error("failed to decode Workflow::SchemaDefinition from xml [" + this.deployment.SchemaDefinition.get() + "]", exception);
                throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
            }
        } else {
            logger.warn(this.getJobId(), "no schema definition present for workflow [%s]", this.getName());
            this.schemaDefinition = new SchemaDefinition();
        }
        try {
            logger.trace("retrieving imports from workflow definition");
            this.imports = WorkflowImport.convert(this.database.getImports(this.deployment.DeploymentId.get()));
        }
        catch (CTEDBException cTEDBException) {
            logger.error(this.getJobId(), "error retrieving imports", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        if (!this.deployment.OnStart.isNull() && this.deployment.OnStart.get().length() > 0) {
            try {
                logger.trace("decoding workflow onStart script");
                this.onStart = (ScriptDefinition)XMLDecoder.decode((String)this.deployment.OnStart.get(), (Object)new ScriptDefinition());
            }
            catch (Exception exception) {
                logger.error(this.getJobId(), "error decoding workflow onStart [" + this.deployment.OnStart.get() + "]", exception);
                throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
            }
        }
        if (!this.deployment.OnComplete.isNull() && this.deployment.OnComplete.get().length() > 0) {
            try {
                logger.trace("decoding workflow onComplete script");
                this.onComplete = (ScriptDefinition)XMLDecoder.decode((String)this.deployment.OnComplete.get(), (Object)new ScriptDefinition());
            }
            catch (Exception exception) {
                logger.error(this.getJobId(), "error decoding workflow onComplete [" + this.deployment.OnComplete.get() + "]", exception);
                throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
            }
        }
        try {
            this.configurationXml = CommServUtils.getConfigurationSettings(this.getWorkflowId());
        }
        catch (Exception exception) {
            logger.error(this.getJobId(), "failed to retrieve configuration settings from APP_ComponentProp table for workflow id [" + this.getWorkflowId() + "]", exception);
        }
        logger.trace("loading execution document");
        this.workflowExecution = WorkflowExecution.createInstance(this);
    }

    @Override
    public WF_Steps_t getStartStep() throws EvFailureException {
        WF_Steps_t wF_Steps_t;
        try {
            wF_Steps_t = this.getDataAccess().getStartStep(this.getDeploymentId(), null);
        }
        catch (CTEDBException cTEDBException) {
            logger.error(this.getJobId(), "error retrieving workflow start activity", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        if (wF_Steps_t == null) {
            logger.error(this.getJobId(), "could not find workflow start for workflow [" + this.getName() + "]");
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_RETRIEVE_START", new Object[0]);
            throw new EvFailureException(evMessageContainer);
        }
        return wF_Steps_t;
    }

    @Override
    public List<WF_Steps_t> getEventSteps(String string) throws EvFailureException {
        try {
            return this.getDataAccess().getEventSteps(this.getDeploymentId(), string);
        }
        catch (CTEDBException cTEDBException) {
            logger.error(this.getJobId(), "error retrieving onComplete activities", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
    }

    @Override
    public List<WF_ProcessSteps_t> getExecutingSteps() throws EvFailureException {
        try {
            logger.debug("getting executing steps for super process id [%s], data access [%s]", this.getSuperProcessId(), this.getDataAccess().getClass());
            return this.getDataAccess().getProcessSteps(this.getJobId(), this.getSuperProcessId(), ExecutionState.RUNNING);
        }
        catch (CTEDBException cTEDBException) {
            logger.error(this.getJobId(), "error retrieving current activities for process block", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
    }

    @Override
    public List<WorkflowElement> getProcessXml() {
        return new ArrayList<WorkflowElement>();
    }

    @Override
    public void setTransitionCancelled(boolean bl) {
    }

    @Override
    public XMLSchema getInputSchema() {
        return this.schemaDefinition.getInputs();
    }

    @Override
    public XMLSchema getVariableSchema() {
        return this.schemaDefinition.getVariables();
    }

    @Override
    public XMLSchema getOutputSchema() {
        return this.schemaDefinition.getOutputs();
    }

    @Override
    public XMLSchema getConfigurationSchema() {
        return this.schemaDefinition.getConfig();
    }

    @Override
    public ScriptDefinition getOnComplete() {
        return this.onComplete;
    }

    @Override
    public ScriptDefinition getOnStart() {
        return this.onStart;
    }

    @Override
    public List<WorkflowImport> getImports() {
        return this.imports;
    }

    @Override
    public WorkflowExecution getWorkflowExecution() {
        return this.workflowExecution;
    }

    @Override
    public DataAccessLayer getDataAccess() {
        return this.database;
    }

    @Override
    public Integer getDeploymentId() {
        return this.deployment.DeploymentId.get();
    }

    @Override
    public boolean isDebug() {
        return false;
    }

    @Override
    public String getJobInputs() {
        return this.jobInputs;
    }

    @Override
    public String getConfigurationXml() {
        return this.configurationXml;
    }

    @Override
    public String getOutputs() {
        return this.outputs;
    }

    @Override
    public void setOutputs(String string) {
        this.outputs = string;
    }

    @Override
    public String getDescription() {
        if (this.deployment.Description.isNull()) {
            return "";
        }
        return this.deployment.Description.get();
    }

    @Override
    public String getWorkflowName() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.deployment.WorkflowName.get();
    }

    @Override
    public int getVersion() {
        return this.deployment.Version.get();
    }

    @Override
    public int getWorkflowId() {
        return this.deployment.WorkflowId.get();
    }

    @Override
    public String getOutputXml() {
        return this.deployment.Outputs.get();
    }

    @Override
    public String getDefinitionInputs() {
        return this.deployment.Inputs.get();
    }

    @Override
    public String getDefinitionVariables() {
        return this.deployment.Variables.get();
    }

    @Override
    public String getDefinitionConfiguration() {
        return this.deployment.Configuration.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        Object object = this.parent.getLock();
        synchronized (object) {
            String string = this.getWorkflowExecution().serialize();
            this.superProcessRecord.Execution.set(string);
            try {
                this.superProcessRecord.save();
            }
            catch (CTEDBException cTEDBException) {
                logger.error(this.getJobId(), "error saving super process [" + this.getFriendlyName() + "]", cTEDBException);
            }
        }
    }

    @Override
    public Object getParentVariable(String string) throws EvFailureException {
        if (this.getWorkflowExecution().isVariableExists(string)) {
            return this.getVariable(string);
        }
        return this.activity.getParentVariable(string);
    }

    @Override
    public Object getParentVariable(String string, Class<?> clazz) throws EvFailureException {
        if (this.getWorkflowExecution().isVariableExists(string)) {
            return this.getVariable(string, clazz);
        }
        return this.activity.getParentVariable(string, clazz);
    }

    @Override
    public void setVariable(String string, Object object) throws EvFailureException {
        this.workflowExecution.setVariable(string, object);
    }

    @Override
    public void setInput(String string, Object object) throws EvFailureException {
        this.workflowExecution.setInput(string, object);
    }

    @Override
    public void setOutput(String string, Object object) throws EvFailureException {
        this.workflowExecution.setOutput(string, object);
    }

    @Override
    public Object getLocalVariable(String string) throws EvFailureException {
        return this.getVariable(string);
    }

    @Override
    public Object getLocalVariable(String string, Class<?> clazz) throws EvFailureException {
        return this.getVariable(string, clazz);
    }

    @Override
    public void setLocalVariable(String string, Object object) throws EvFailureException {
        this.setVariable(string, object);
    }

    @Override
    public ProcessContext getParentWorkflow() {
        return this.parent.getParent();
    }

    @Override
    public long getWorkflowJobId() {
        return this.getSuperProcessId().intValue();
    }

    @Override
    public void setSaveExecution(boolean bl) {
        this.saveExecution = bl;
    }

    @Override
    public boolean isSaveExecution() {
        return this.saveExecution;
    }
}

