/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.common.schema.SchemaDocument;
import commvault.cte.common.schema.SchemaElement;
import commvault.cte.common.schema.SchemaProperty;
import commvault.cte.common.schema.SchemaType;
import commvault.cte.common.schema.SchemaTypeSystem;
import commvault.cte.common.schema.util.SchemaEncoder;
import commvault.cte.common.schema.util.SchemaUtils;
import commvault.cte.common.workflow.ActivitySystem;
import commvault.cte.common.workflow.WorkflowSystem;
import commvault.cte.common.xml.EncoderUtil;
import commvault.cte.common.xml.XMLEncoder;
import commvault.cte.db.CTEDBException;
import commvault.cte.db.CTEDBReservation;
import commvault.cte.db.CTEDBTimestamp;
import commvault.cte.util.DateUtilities;
import commvault.cte.workflow.Capability;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.EventMessage;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.activities.ExecuteWorkflow;
import commvault.cte.workflow.activities.WorkflowInputDesigner;
import commvault.cte.workflow.activity.ActivityValidator;
import commvault.cte.workflow.activity.StartActivity;
import commvault.cte.workflow.db.DataAccessLayer;
import commvault.cte.workflow.db.OnDemandDatabase;
import commvault.cte.workflow.db.WorkflowDatabase;
import commvault.cte.workflow.db.cs.WF_ActivityGroup_t;
import commvault.cte.workflow.db.cs.WF_ActivitySet_t;
import commvault.cte.workflow.db.cs.WF_Activity_t;
import commvault.cte.workflow.db.cs.WF_Definition_t;
import commvault.cte.workflow.db.cs.WF_Deploy_t;
import commvault.cte.workflow.db.cs.WF_SchemaLocation_t;
import commvault.cte.workflow.db.cs.WF_Schema_t;
import commvault.cte.workflow.db.engine.WF_Deployments_t;
import commvault.cte.workflow.db.engine.WF_Imports_t;
import commvault.cte.workflow.db.engine.WF_StepTransitions_t;
import commvault.cte.workflow.db.engine.WF_Steps_t;
import commvault.cte.workflow.eval.ExpressionUtils;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.schema.SchemaManager;
import commvault.cte.workflow.utils.CommServUtils;
import commvault.cte.workflow.utils.JDOMUtil;
import commvault.cte.workflow.utils.ReflectionUtils;
import commvault.cte.workflow.utils.WorkflowUtils;
import commvault.msgs.App.XMLSchema;
import commvault.msgs.CvEntities.EntityType;
import commvault.msgs.CvEntities.UserEntity;
import commvault.msgs.CvEntities.WorkflowEntity;
import commvault.msgs.Workflow.ActivityDefinition;
import commvault.msgs.Workflow.ActivitySchema;
import commvault.msgs.Workflow.DeployWorkflow;
import commvault.msgs.Workflow.DeploymentFlags;
import commvault.msgs.Workflow.ImportsDefinition;
import commvault.msgs.Workflow.InputForm;
import commvault.msgs.Workflow.SchemaDefinition;
import commvault.msgs.Workflow.SchemaWrapper;
import commvault.msgs.Workflow.StepFlags;
import commvault.msgs.Workflow.TransitionDefinition;
import commvault.msgs.Workflow.TransitionFlags;
import commvault.msgs.Workflow.TransitionStatus;
import commvault.msgs.Workflow.WorkflowDefinition;
import commvault.msgs.Workflow.WorkflowFlags;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.IllegalNameException;
import org.jdom2.JDOMException;
import org.jdom2.xpath.XPathFactory;

public class DeploymentManager {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(DeploymentManager.class);
    private static final String WF_IMAGE_LOCATION = "/workflow_process.png";
    private final UserEntity user;
    private SchemaManager schemaManager;
    private DataAccessLayer database;
    private final WFDefinition definition;
    private WF_Deploy_t commServeDeployment;
    private WF_Deployments_t engineDeployment;
    private WorkflowDefinition processDefinition;
    private final List<TransitionWrapper> deploymentTransitions = new ArrayList<TransitionWrapper>();
    private final Map<String, WF_Steps_t> deploymentSteps = new HashMap<String, WF_Steps_t>();
    private final Map<QName, WF_Activity_t> deploymentActivities = new HashMap<QName, WF_Activity_t>();
    private XMLSchema processInputSchema = null;
    private XMLSchema processVariableSchema = null;
    private XMLSchema processOutputSchema = null;
    private XMLSchema processConfigSchema = null;
    private XMLSchema executionSchema;
    private XMLSchema activitySystem;
    public boolean missingWorkflowActivity = false;
    private Document executionDocument;
    private boolean inputDesigner = false;
    private final Set<String> uniqueNames = new HashSet<String>();

    private static WF_Definition_t getDefinitionRow(WorkflowEntity workflowEntity) throws EvFailureException {
        String string;
        if (workflowEntity.getWorkflowId() > 0) {
            logger.trace("retrieving workflow definition for id [%s]", workflowEntity.getWorkflowId());
            string = String.format("WorkflowId=%s", workflowEntity.getWorkflowId());
        } else {
            logger.trace("retrieving workflow definition for [%s]", workflowEntity.getWorkflowName());
            string = String.format("Name='%s'", workflowEntity.getWorkflowName().replace("'", "''"));
        }
        WF_Definition_t wF_Definition_t = new WF_Definition_t();
        try {
            if (!wF_Definition_t.fill(string)) {
                logger.error("failed to load workflow definition using where clause [" + string + "]");
                EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_LOAD_DEFINITION", new Object[0]);
                throw new EvFailureException(evMessageContainer);
            }
        }
        catch (CTEDBException cTEDBException) {
            logger.error("error retrieving workflow definition [" + workflowEntity.getWorkflowName() + "] for deployment", cTEDBException);
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_LOAD_DEFINITION", new Object[0]);
            throw new EvFailureException(evMessageContainer);
        }
        return wF_Definition_t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deploy(DeployWorkflow deployWorkflow, UserEntity userEntity) throws EvFailureException {
        WF_Definition_t wF_Definition_t = DeploymentManager.getDefinitionRow(deployWorkflow.getWorkflow());
        try (SchemaManager schemaManager = SchemaManager.newInstance();){
            DeploymentManager deploymentManager = new DeploymentManager(schemaManager, new WFDefinition(wF_Definition_t), userEntity);
            logger.info("deploying workflow process [%s], requested by [%s]", wF_Definition_t.Name.get(), userEntity.getUserName());
            DeploymentManager.deploy(deploymentManager, wF_Definition_t, userEntity, schemaManager);
        }
    }

    public static void deploy(DeploymentManager deploymentManager, WF_Definition_t wF_Definition_t, UserEntity userEntity, SchemaManager schemaManager) throws EvFailureException {
        deploymentManager.deploy();
        if (deploymentManager.processDefinition != null && deploymentManager.processDefinition.getBusinessLogic()) {
            deploymentManager.updateBusinessLogic();
        }
        deploymentManager.createWorkflowActivity(wF_Definition_t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deploy(WorkflowDefinition workflowDefinition, UserEntity userEntity, OnDemandDatabase onDemandDatabase) throws EvFailureException {
        WFDefinition wFDefinition = new WFDefinition();
        wFDefinition.workflowId = workflowDefinition.getWorkflowId();
        wFDefinition.name = workflowDefinition.getName();
        try {
            wFDefinition.definition = WorkflowUtils.encodeMessage(workflowDefinition);
        }
        catch (Exception exception) {
            logger.error("failed to encode Workflow::WorkflowDefinition", exception);
            EvMessageContainer evMessageContainer = new EvMessageContainer(exception.getMessage());
            throw new EvFailureException(evMessageContainer);
        }
        wFDefinition.description = workflowDefinition.getDescription();
        wFDefinition.version = 1;
        wFDefinition.userId = userEntity.getUserId();
        logger.info("deploying workflow process [%s], requested by [%s]", wFDefinition.name, userEntity.getUserName());
        SchemaManager schemaManager = SchemaManager.newInstance();
        DeploymentManager deploymentManager = new DeploymentManager(schemaManager, wFDefinition, userEntity, onDemandDatabase);
        try {
            deploymentManager.deploy();
        }
        finally {
            schemaManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WF_Deployments_t redeploy(WF_Deployments_t wF_Deployments_t) throws EvFailureException {
        WorkflowEntity workflowEntity = new WorkflowEntity();
        workflowEntity.setWorkflowId(wF_Deployments_t.WorkflowId.get().intValue());
        workflowEntity.setWorkflowName(wF_Deployments_t.WorkflowName.get());
        UserEntity userEntity = new UserEntity();
        userEntity.setUserId(1);
        userEntity.setUserName("admin");
        WFDefinition wFDefinition = new WFDefinition();
        wFDefinition.workflowId = wF_Deployments_t.WorkflowId.get();
        wFDefinition.name = wF_Deployments_t.WorkflowName.get();
        wFDefinition.definition = wF_Deployments_t.Definition.get();
        wFDefinition.description = wF_Deployments_t.Description.get();
        wFDefinition.version = wF_Deployments_t.Version.get();
        wFDefinition.userId = wF_Deployments_t.userId.get();
        logger.info("deploying workflow process [%s], requested by [%s]", wFDefinition.name, userEntity.getUserName());
        SchemaManager schemaManager = SchemaManager.newInstance();
        DeploymentManager deploymentManager = new DeploymentManager(schemaManager, wFDefinition, userEntity);
        try {
            deploymentManager.deploy();
        }
        finally {
            schemaManager.close();
        }
        return deploymentManager.engineDeployment;
    }

    public DeploymentManager(SchemaManager schemaManager, WFDefinition wFDefinition, UserEntity userEntity) {
        this(schemaManager, wFDefinition, userEntity, new WorkflowDatabase());
    }

    public DeploymentManager(SchemaManager schemaManager, WFDefinition wFDefinition, UserEntity userEntity, DataAccessLayer dataAccessLayer) {
        this(schemaManager, wFDefinition, null, userEntity, dataAccessLayer);
    }

    public DeploymentManager(SchemaManager schemaManager, WFDefinition wFDefinition, WorkflowDefinition workflowDefinition, UserEntity userEntity) {
        this(schemaManager, wFDefinition, workflowDefinition, userEntity, new WorkflowDatabase());
    }

    public DeploymentManager(SchemaManager schemaManager, WFDefinition wFDefinition, WorkflowDefinition workflowDefinition, UserEntity userEntity, DataAccessLayer dataAccessLayer) {
        this.schemaManager = schemaManager;
        this.definition = wFDefinition;
        this.user = userEntity;
        this.database = dataAccessLayer;
        this.activitySystem = SchemaEncoder.encode((Element)new ActivitySystem().getElement());
    }

    protected void deploy() throws EvFailureException {
        Element element;
        Element element2;
        Element element3;
        Element element4;
        if (this.definition.definition == null) {
            logger.error("no definition exists for workflow [" + this.definition.name + "]");
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_LOAD_DEFINITION", new Object[0]);
            throw new EvFailureException(evMessageContainer);
        }
        try {
            logger.debug("deploying workflow definition [%s]", this.definition.definition);
            this.processDefinition = (WorkflowDefinition)WorkflowUtils.decodeMessage(this.definition.definition, (Object)new WorkflowDefinition());
        }
        catch (Exception exception) {
            logger.error("failed to decode workflow definition", exception);
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_LOAD_DEFINITION", new Object[0]);
            throw new EvFailureException(evMessageContainer);
        }
        if (this.processDefinition.getBusinessLogic()) {
            try {
                if (!CommServUtils.checkPermissionOnEntity(this.user.getUserId(), EntityType.COMMCELL_ENTITY.getEnumValue(), 2, Capability.ADMINISTRATIVE_MANAGEMENT)) {
                    logger.error("user [" + this.user.getUserName() + "] does not have Administrative Management capability which is required for Buisness Logic deployments");
                    EvMessageContainer evMessageContainer = EventMessage.getContainer("GUIMSG_SECURITY_USER_CAPABILITY", this.user.getUserName(), Capability.ADMINISTRATIVE_MANAGEMENT.getDisplayName(), this.processDefinition.getName());
                    throw new EvFailureException(evMessageContainer);
                }
            }
            catch (CTEDBException cTEDBException) {
                logger.error("failed to check if user has administrative capabilities", cTEDBException);
                throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
            }
        }
        if (this.processDefinition.getStart(false) == null) {
            logger.error("workflow definition is missing start activity");
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_RETRIEVE_START", new Object[0]);
            throw new EvFailureException(evMessageContainer);
        }
        if (this.processDefinition.getBusinessLogic()) {
            if (this.processDefinition.getBusinessLogicMessage().trim().length() == 0) {
                logger.error("missing business logic message");
                EvMessageContainer evMessageContainer = new EvMessageContainer("missing business logic message");
                throw new EvFailureException(evMessageContainer);
            }
            if (this.processDefinition.getBusinessLogicProcessing().trim().length() == 0) {
                logger.error("missing business logic execute when parameter");
                EvMessageContainer evMessageContainer = new EvMessageContainer("missing business logic execute when");
                throw new EvFailureException(evMessageContainer);
            }
            if (this.processDefinition.getBusinessLogicExecutedBy().trim().length() == 0) {
                logger.error("missing business logic module");
                EvMessageContainer evMessageContainer = new EvMessageContainer("missing business logic module");
                throw new EvFailureException(evMessageContainer);
            }
        }
        SchemaDefinition schemaDefinition = this.processDefinition.getSchema();
        try {
            element4 = JDOMUtil.parseXml(this.processDefinition.getInputs());
        }
        catch (JDOMException jDOMException) {
            logger.error("failed to create input element from definition", jDOMException);
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_INVALID_SCHEMA", new Object[0]);
            throw new EvFailureException(evMessageContainer);
        }
        if (element4 == null) {
            element4 = new Element("inputs");
        }
        if (this.processDefinition.getInputSchema().length() > 0) {
            try {
                this.processInputSchema = this.convertSchema(this.processDefinition.getInputSchema(), element4);
                this.applySchema(this.processInputSchema, element4);
                schemaDefinition.setInputs(this.processInputSchema);
            }
            catch (Exception exception) {
                logger.error("failed to build input schema from xml [" + this.processDefinition.getVariableSchema() + "]", exception);
                throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
            }
        } else {
            this.processInputSchema = this.processDefinition.getSchema().getInputs();
        }
        this.processInputSchema.setName("inputs");
        try {
            element3 = JDOMUtil.parseXml(this.processDefinition.getVariables());
        }
        catch (JDOMException jDOMException) {
            logger.error("failed to create variable element from definition");
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_INVALID_SCHEMA", new Object[0]);
            throw new EvFailureException(evMessageContainer);
        }
        if (element3 == null) {
            element3 = new Element("variables");
        }
        if (this.processDefinition.getVariableSchema().length() > 0) {
            try {
                this.processVariableSchema = this.convertSchema(this.processDefinition.getVariableSchema(), element3);
                this.applySchema(this.processVariableSchema, element3);
                schemaDefinition.setVariables(this.processVariableSchema);
            }
            catch (Exception exception) {
                logger.error("failed to build variable schema from xml [" + this.processDefinition.getVariableSchema() + "]", exception);
                throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
            }
        } else {
            this.processVariableSchema = this.processDefinition.getSchema().getVariables();
        }
        this.processVariableSchema.setName("variables");
        try {
            element2 = JDOMUtil.parseXml(this.processDefinition.getOutputs());
        }
        catch (JDOMException jDOMException) {
            logger.error("failed to create output element from definition", jDOMException);
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_INVALID_SCHEMA", new Object[0]);
            throw new EvFailureException(evMessageContainer);
        }
        if (element2 == null) {
            element2 = new Element("outputs");
        }
        if (this.processDefinition.getOutputSchema().length() > 0) {
            try {
                this.processOutputSchema = this.convertSchema(this.processDefinition.getOutputSchema(), element2);
                this.applySchema(this.processOutputSchema, element2);
                schemaDefinition.setOutputs(this.processOutputSchema);
            }
            catch (Exception exception) {
                logger.error("failed to build output schema from xml [" + this.processDefinition.getOutputSchema() + "]", exception);
                throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
            }
        } else {
            this.processOutputSchema = this.processDefinition.getSchema().getOutputs();
        }
        this.processOutputSchema.setName("outputs");
        try {
            element = JDOMUtil.parseXml(this.processDefinition.getConfig());
        }
        catch (JDOMException jDOMException) {
            logger.error("failed to create configuration element from definition", jDOMException);
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_INVALID_SCHEMA", new Object[0]);
            throw new EvFailureException(evMessageContainer);
        }
        if (element == null) {
            element = new Element("configuration");
        }
        this.processConfigSchema = this.processDefinition.getSchema().getConfig();
        this.processConfigSchema.setName("configuration");
        logger.trace("building workflow execution schema");
        this.executionSchema = new XMLSchema();
        this.executionSchema.setName("workflow");
        this.executionSchema.getChildren().add(this.processInputSchema);
        this.executionSchema.getChildren().add(this.processVariableSchema);
        this.executionSchema.getChildren().add(this.processConfigSchema);
        this.appendActivitySchema(this.processDefinition.getActivity());
        try {
            logger.debug("building execution document from execution schema [%s]", XMLEncoder.encode((Object)this.executionSchema));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Element element5 = SchemaEncoder.write((XMLSchema)this.executionSchema);
        this.executionDocument = new Document();
        this.executionDocument.setRootElement(element5);
        this.executionDocument.getRootElement().addContent((Content)new WorkflowSystem().getElement());
        logger.debug("built workflow execution xml [%s]", JDOMUtil.serialize(this.executionDocument.getRootElement()));
        this.validateXPath("Workflow Variables", this.processDefinition.getVariables(false));
        logger.debug("creating commserv deployment record");
        this.commServeDeployment = this.database.newCommServDeployment();
        this.commServeDeployment.clientId.set(Integer.valueOf(WorkflowProperties.getInstance().getClient().getClientId()));
        this.commServeDeployment.Deployed.set(Integer.valueOf(DateUtilities.getNow()));
        this.commServeDeployment.WorkflowId.set(Integer.valueOf(this.definition.workflowId));
        this.commServeDeployment.Version.set(Integer.valueOf(this.definition.version));
        this.commServeDeployment.InputsXml.set(EncoderUtil.encodeString((String)this.processDefinition.getInputs()));
        InputForm inputForm = SchemaEncoder.encodeForm((XMLSchema)this.processInputSchema, (Element)element4);
        inputForm.setDestPath(WorkflowProperties.getInstance().getJobResultsDir());
        inputForm.setProperties(this.processDefinition.getFormProperties());
        this.commServeDeployment.InputForm.set(WorkflowUtils.encodeMessage(inputForm, "inputForm"));
        SchemaWrapper schemaWrapper = new SchemaWrapper();
        schemaWrapper.setSchema(this.processConfigSchema);
        schemaWrapper.setXmlDefinition(this.processDefinition.getConfig());
        this.commServeDeployment.InputSchema.set(WorkflowUtils.encodeMessageAsString(schemaWrapper, "configuration"));
        try {
            InputForm inputForm2 = WorkflowUtils.buildConfigForm(schemaWrapper);
            if (inputForm2 != null) {
                this.commServeDeployment.ConfigForm.set(WorkflowUtils.encodeMessage(inputForm2, "configForm"));
            }
        }
        catch (Exception exception) {
            logger.error("error encoding config form", exception);
        }
        this.commServeDeployment.Status.set(Integer.valueOf(0));
        try {
            this.commServeDeployment.save();
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to save commserv deployment information", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        logger.debug("creating engine deployment record");
        this.engineDeployment = this.database.newEngineDeployment();
        if (this.processDefinition.getOnStart(false) != null) {
            this.validateXPath("Workflow onStart", this.processDefinition.getOnStart().getScript());
            try {
                this.engineDeployment.OnStart.set(XMLEncoder.encodeWithoutXmlHeader((Object)this.processDefinition.getOnStart()));
            }
            catch (Exception exception) {
                logger.error("error encoding workflow onStart", exception);
            }
        }
        if (this.processDefinition.getOnComplete(false) != null) {
            this.validateXPath("Workflow onComplete", this.processDefinition.getOnComplete().getScript());
            try {
                this.engineDeployment.OnComplete.set(XMLEncoder.encodeWithoutXmlHeader((Object)this.processDefinition.getOnComplete()));
            }
            catch (Exception exception) {
                logger.error("error encoding workflow onComplete", exception);
            }
        }
        this.engineDeployment.DeployId.set(this.commServeDeployment.DeployId.get());
        this.engineDeployment.WorkflowId.set(Integer.valueOf(this.definition.workflowId));
        this.engineDeployment.userId.set(Integer.valueOf(this.user.getUserId()));
        this.engineDeployment.Creator.set(Integer.valueOf(this.definition.userId));
        this.engineDeployment.Version.set(Integer.valueOf(this.definition.version));
        this.engineDeployment.WorkflowName.set(this.definition.name);
        this.engineDeployment.Description.set(this.definition.description);
        this.engineDeployment.Definition.set(this.definition.definition);
        this.engineDeployment.Inputs.set(JDOMUtil.serialize(element4));
        this.engineDeployment.Variables.set(JDOMUtil.serialize(element3));
        this.engineDeployment.Outputs.set(JDOMUtil.serialize(element2));
        this.engineDeployment.Configuration.set(JDOMUtil.serialize(element));
        this.engineDeployment.Deployed.set(Integer.valueOf(DateUtilities.getNow()));
        this.engineDeployment.Status.set(Boolean.valueOf(false));
        this.engineDeployment.DeployedRel.set(Integer.valueOf(WorkflowProperties.getInstance().getVersion()));
        this.engineDeployment.InputSchema.set("");
        this.engineDeployment.VariableSchema.set("");
        this.engineDeployment.OutputSchema.set("");
        try {
            this.engineDeployment.SchemaDefinition.set(WorkflowUtils.encodeMessage(schemaDefinition));
        }
        catch (Exception exception) {
            logger.error("failed to encode Workflow::SchemaDefinition", exception);
            throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
        }
        try {
            this.engineDeployment.save();
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to save engine deployment information", cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        logger.debug("deploying workflow imports");
        this.deployImports();
        logger.debug("deploying workflow activities");
        this.deploySteps();
        logger.debug("deploying workflow transitions");
        this.deployTransitions();
        int n = 0;
        if (this.processDefinition.getInteractive()) {
            n |= DeploymentFlags.INTERACTIVE.getEnumValue();
        }
        if (this.processDefinition.getApiMode()) {
            n |= DeploymentFlags.API_MODE.getEnumValue();
        }
        if (this.inputDesigner) {
            n |= DeploymentFlags.INPUT_DESIGNER.getEnumValue();
        }
        if (this.processDefinition.getWebHidden()) {
            n |= DeploymentFlags.WEB_HIDDEN.getEnumValue();
        }
        if (this.processDefinition.getExecuteOnWeb()) {
            n |= DeploymentFlags.EXECUTE_WEB.getEnumValue();
        }
        if (this.processDefinition.getManualPercentageComplete()) {
            n |= DeploymentFlags.MANUAL_PERCENT_COMPLETE.getEnumValue();
        }
        this.engineDeployment.Status.set(Boolean.valueOf(true));
        this.engineDeployment.flags.set(Integer.valueOf(n));
        try {
            this.engineDeployment.save();
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to update status on engine deployment", cTEDBException);
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_CREATE_DEPLOYMENT", new Object[0]);
            throw new EvFailureException(evMessageContainer);
        }
        this.commServeDeployment.flags.set(Integer.valueOf(n));
        this.commServeDeployment.Status.set(Integer.valueOf(1));
        try {
            this.commServeDeployment.save();
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to update status on commserv deployment", cTEDBException);
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_CREATE_DEPLOYMENT", new Object[0]);
            throw new EvFailureException(evMessageContainer);
        }
        boolean bl = false;
        if (this.processDefinition.getExecuteOnWeb()) {
            if ((this.definition.flags & WorkflowFlags.EXECUTE_WEB.getEnumValue()) == 0) {
                bl = true;
                this.definition.setFlag(WorkflowFlags.EXECUTE_WEB);
            }
        } else if ((this.definition.flags & WorkflowFlags.EXECUTE_WEB.getEnumValue()) > 0) {
            bl = true;
            this.definition.removeFlag(WorkflowFlags.EXECUTE_WEB);
        }
        if (!this.definition.getTags().equals(this.processDefinition.getTags())) {
            bl = true;
            this.definition.setTags(this.processDefinition.getTags());
        }
        if (bl) {
            try {
                this.definition.save();
            }
            catch (CTEDBException cTEDBException) {
                logger.error("failed to update WF_Definition row during deployment", cTEDBException);
            }
        }
        logger.info("deployment complete for workflow [%s]", this.definition.name);
    }

    private void applySchema(XMLSchema xMLSchema, Element element) {
        for (XMLSchema xMLSchema2 : xMLSchema.getChildren()) {
            List list = element.getChildren(xMLSchema2.getName());
            if (list != null && list.size() != 0) continue;
            element.addContent((Content)new Element(xMLSchema2.getName()));
        }
    }

    public XMLSchema convertSchema(String string, Element element) throws Exception {
        Element element2 = JDOMUtil.parseXml(string);
        SchemaDocument schemaDocument = SchemaTypeSystem.parse((Element)element2, (SchemaTypeSystem)this.schemaManager);
        SchemaElement schemaElement = schemaDocument.getElement(element.getName());
        if (schemaElement != null) {
            return SchemaEncoder.encode((SchemaProperty)schemaElement);
        }
        return SchemaEncoder.encode((Element)element);
    }

    private ActivitySchema getActivitySchema(String string, String string2) throws EvFailureException {
        SchemaDocument schemaDocument;
        ActivitySchema activitySchema = new ActivitySchema();
        try {
            schemaDocument = SchemaTypeSystem.parse((Element)JDOMUtil.parseXml(string), (SchemaTypeSystem)this.schemaManager);
        }
        catch (Exception exception) {
            logger.error("failed to parse schema for activity [" + string2 + "], schema [" + string + "]", exception);
            return null;
        }
        SchemaType schemaType = schemaDocument.getType(string2);
        if (schemaType == null) {
            logger.warn("failed to locate schema type for activity name [%s], schema [%s]", string2, string);
            return null;
        }
        if (schemaType.getProperties() != null) {
            for (SchemaProperty schemaProperty : schemaType.getProperties()) {
                if (schemaProperty.getName().getLocalPart().equalsIgnoreCase("inputs")) {
                    activitySchema.setInputs(SchemaEncoder.encode((SchemaProperty)schemaProperty));
                    continue;
                }
                if (!schemaProperty.getName().getLocalPart().equalsIgnoreCase("outputs")) continue;
                activitySchema.setOutputs(SchemaEncoder.encode((SchemaProperty)schemaProperty));
            }
        }
        return activitySchema;
    }

    private ActivitySchema getActivitySchema(ActivityDefinition activityDefinition) throws EvFailureException {
        WF_Activity_t wF_Activity_t = this.getActivityRow(activityDefinition.getName(), activityDefinition.getNamespaceUri());
        if (activityDefinition.getSchema().trim().length() > 0) {
            logger.debug("building schema for activity [%s] from XSD Schema [%s] in ActivityDefinition", activityDefinition.getUniqueName(), activityDefinition.getSchema());
            return this.getActivitySchema(activityDefinition.getSchema(), activityDefinition.getName());
        }
        if (!wF_Activity_t.ActivitySchema.isNull()) {
            try {
                logger.debug("building schema for activity [%s] from the XMLSchema in database row", activityDefinition.getUniqueName());
                return (ActivitySchema)WorkflowUtils.decodeMessage(wF_Activity_t.ActivitySchema.get(), (Object)new ActivitySchema());
            }
            catch (Exception exception) {
                logger.error("failed to decode Workflow::ActivitySchema for activity [" + activityDefinition.getUniqueName() + "], xml [" + wF_Activity_t.ActivitySchema.get() + "]", exception);
                throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
            }
        }
        if (!wF_Activity_t.SchemaFile.isNull() && wF_Activity_t.SchemaFile.get().length() > 0) {
            logger.debug("building schema for activity [%s] from XSD SchemaFile [%s] in database row", activityDefinition.getUniqueName(), wF_Activity_t.SchemaFile.get());
            return this.getActivitySchema(wF_Activity_t.SchemaFile.get(), activityDefinition.getName());
        }
        logger.debug("building schema for activity [%s] from XSD global schema system", activityDefinition.getUniqueName());
        SchemaType schemaType = this.schemaManager.getGlobalType(activityDefinition.getNamespaceUri(), activityDefinition.getName());
        if (schemaType != null) {
            return SchemaEncoder.encodeActivity((SchemaType)schemaType);
        }
        logger.warn("could not find global schema for activity [%s], namespace [%s]", activityDefinition.getName(), activityDefinition.getNamespaceUri());
        return new ActivitySchema();
    }

    private void appendActivitySchema(List<ActivityDefinition> list) throws EvFailureException {
        for (ActivityDefinition activityDefinition : list) {
            if (activityDefinition.getActivitySchema(false) == null) {
                activityDefinition.setActivitySchema(this.getActivitySchema(activityDefinition));
            } else {
                logger.debug("building schema for activity [%s] from the XMLSchema in ActivityDefinition", activityDefinition.getUniqueName());
            }
            XMLSchema xMLSchema = new XMLSchema(activityDefinition.getActivitySchema().getOutputs());
            xMLSchema.setName(activityDefinition.getUniqueName());
            XMLSchema xMLSchema2 = SchemaUtils.getChild((XMLSchema)xMLSchema, (String)"system");
            if (xMLSchema2 != null) {
                xMLSchema.getChildren().remove(xMLSchema2);
            }
            xMLSchema.getChildren().add(this.activitySystem);
            this.executionSchema.getChildren().add(xMLSchema);
            try {
                logger.debug("added activity [%s] output schema to execution outputs [%s]", activityDefinition.getUniqueName(), XMLEncoder.encode((Object)xMLSchema));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (activityDefinition.getSuperProcess(false) == null) continue;
            this.appendActivitySchema(activityDefinition.getSuperProcess().getActivity());
        }
    }

    private void validateXPath(String string, String string2) throws EvFailureException {
        this.validateXPath(string, string2, EventMessage.getInstance().getMessageId("JM_WORKFLOW_INVALID_XPATH"));
    }

    private void validateXPath(String string, String string2, int n) throws EvFailureException {
        if (!WorkflowRegistry.getInstance().isValidateXPath()) {
            logger.trace("skipping validation of xpath due to registry setting");
            return;
        }
        if (string2 == null || string2.trim().length() == 0) {
            return;
        }
        logger.trace("validating xpath expressions in [%s]", string);
        Pattern pattern = Pattern.compile("(?i)(xpath:\\{[^}]+}|\\{\\{[^}}]+}})");
        Matcher matcher = pattern.matcher(StringEscapeUtils.unescapeXml((String)string2));
        while (matcher.find()) {
            Object object;
            Object object2;
            Object object3;
            String string3 = matcher.group();
            logger.trace("validating xpath expression %s", string3);
            String string4 = ExpressionUtils.getExpression(string3);
            if (string4.indexOf("[0]") > 0) {
                logger.error("found a 0 indexed element search in expression [" + string3 + "]");
                object3 = new EvMessageContainer(n, string3, string);
                throw new EvFailureException((EvMessageContainer)object3);
            }
            try {
                XPathFactory.instance().compile(string4);
            }
            catch (Throwable throwable) {
                logger.error("failed compile xpath expression [" + string3 + "]", throwable);
                object2 = new EvMessageContainer(n, string3, string);
                throw new EvFailureException((EvMessageContainer)object2);
            }
            string4 = string4.replaceAll("\\[(.*?)\\]", "");
            try {
                object3 = XPathFactory.instance().compile(string4);
            }
            catch (Throwable throwable) {
                object = null;
                object = throwable.getCause() != null ? throwable.getCause().getMessage() : throwable.getMessage();
                logger.warn("failed to compile cleaned xpath expression [%s], error [%s]", string4, object);
                continue;
            }
            object2 = object3.evaluateFirst((Object)this.executionDocument);
            if (object2 != null) continue;
            logger.error("[" + string + "] could not retrieve target for xpath expression [" + string3 + "]");
            object = new EvMessageContainer(n, string3, string);
            throw new EvFailureException((EvMessageContainer)object);
        }
    }

    private void deployImports() throws EvFailureException {
        if (this.processDefinition.getImports(false) != null && this.processDefinition.getImports().size() > 0) {
            for (ImportsDefinition importsDefinition : this.processDefinition.getImports()) {
                Object object;
                logger.info("deploying import [%s], class [%s]", importsDefinition.getName(), importsDefinition.getClassName());
                if (importsDefinition.getName() == null || importsDefinition.getName().trim().length() == 0) {
                    try {
                        logger.error("workflow import is missing name, xml [" + XMLEncoder.encode((Object)importsDefinition) + "]");
                    }
                    catch (Exception exception) {
                        logger.error("workflow import is missing name", exception);
                    }
                    object = EventMessage.getContainer("JM_WORKFLOW_INVALID_IMPORT", new Object[0]);
                    throw new EvFailureException((EvMessageContainer)object);
                }
                object = null;
                try {
                    object = this.getClass().getClassLoader().loadClass(importsDefinition.getClassName());
                }
                catch (Exception exception) {
                    logger.error("failed to load class [" + importsDefinition.getClassName() + "] for import [" + importsDefinition.getName() + "]", exception);
                    EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_INSTANTIATE_CLASS", importsDefinition.getClassName());
                    throw new EvFailureException(evMessageContainer);
                }
                WF_Imports_t wF_Imports_t = this.database.newImport();
                wF_Imports_t.ClassName.set(((Class)object).getName());
                wF_Imports_t.DeploymentId.set(this.engineDeployment.DeploymentId.get());
                wF_Imports_t.Name.set(importsDefinition.getName());
                try {
                    wF_Imports_t.save();
                }
                catch (CTEDBException cTEDBException) {
                    logger.error("failed to save workflow import [" + importsDefinition.getName() + "]", cTEDBException);
                    EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_CREATE_DEPLOYMENT", new Object[0]);
                    throw new EvFailureException(evMessageContainer);
                }
            }
        }
    }

    private void deploySteps() throws EvFailureException {
        this.buildStartStep(this.processDefinition.getStart(), null);
        this.deploySteps(this.processDefinition.getActivity(), null);
    }

    private void deploySteps(List<ActivityDefinition> list, WF_Steps_t wF_Steps_t) throws EvFailureException {
        for (ActivityDefinition activityDefinition : list) {
            WF_Steps_t wF_Steps_t2 = this.buildActivityStep(activityDefinition, wF_Steps_t);
            if (activityDefinition.getSuperProcess(false) == null || activityDefinition.getSuperProcess().getStart(false) == null || activityDefinition.getSuperProcess().getActivity().size() <= 0) continue;
            logger.info("activity [%s] is a super process, begin parsing child activities", activityDefinition.getUniqueName());
            this.buildStartStep(activityDefinition.getSuperProcess().getStart(), wF_Steps_t2);
            this.deploySteps(activityDefinition.getSuperProcess().getActivity(), wF_Steps_t2);
        }
    }

    private WF_Steps_t buildStartStep(ActivityDefinition activityDefinition, WF_Steps_t wF_Steps_t) throws EvFailureException {
        logger.info("deploying start activity [%s]", activityDefinition.getUniqueName());
        WF_Activity_t wF_Activity_t = new WF_Activity_t();
        wF_Activity_t.ActivityId.set(Integer.valueOf(0));
        wF_Activity_t.Class.set(StartActivity.class.getName());
        return this.buildStep(activityDefinition, wF_Activity_t, wF_Steps_t, null, true);
    }

    private WF_Steps_t buildStep(ActivityDefinition activityDefinition, WF_Activity_t wF_Activity_t, WF_Steps_t wF_Steps_t, Integer n, boolean bl) throws EvFailureException {
        if (activityDefinition.getUniqueName().trim().length() == 0) {
            logger.error("invalid unique name for activity [" + activityDefinition.getName() + "]");
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_INVALID_UNIQUENAME", activityDefinition.getUniqueName());
            throw new EvFailureException(evMessageContainer);
        }
        try {
            new Element(activityDefinition.getUniqueName());
        }
        catch (IllegalNameException illegalNameException) {
            logger.error("invalid unique name for activity [" + activityDefinition.getName() + "]");
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_INVALID_UNIQUENAME", activityDefinition.getUniqueName());
            throw new EvFailureException(evMessageContainer);
        }
        if (!this.uniqueNames.add(activityDefinition.getUniqueName())) {
            logger.error("duplicate unique name found [" + activityDefinition.getUniqueName() + "]");
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_DUPLICATE_UNIQUENAME", activityDefinition.getUniqueName());
            throw new EvFailureException(evMessageContainer);
        }
        this.validateXPath(activityDefinition.getUniqueName(), activityDefinition.getOnEnter().getScript());
        this.validateXPath(activityDefinition.getUniqueName(), activityDefinition.getOnExit().getScript());
        this.validateXPath(activityDefinition.getUniqueName(), activityDefinition.getOutputs().getInputs());
        this.validateXPath(activityDefinition.getUniqueName(), activityDefinition.getOutputs().getVariables());
        this.validateXPath(activityDefinition.getUniqueName(), activityDefinition.getRepeatUntil());
        if (activityDefinition.getInputs().size() > 0) {
            this.validateXPath(activityDefinition.getUniqueName(), (String)activityDefinition.getInputs().get(0));
        }
        if (activityDefinition.getActivitySchema().getInputs(false) != null && activityDefinition.getActivitySchema().getInputs().getChildren().size() > 0) {
            try {
                this.validateXPath(activityDefinition.getUniqueName(), XMLEncoder.encode((Object)activityDefinition.getActivitySchema().getInputs()));
            }
            catch (Exception exception) {
                logger.error("failed to encode input schema for activity [" + activityDefinition.getUniqueName() + "]");
                throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
            }
        }
        WF_Steps_t wF_Steps_t2 = this.database.newStep();
        if (wF_Steps_t != null) {
            wF_Steps_t2.ParentStepId.set(wF_Steps_t.StepId.get());
        }
        wF_Steps_t2.DeploymentId.set(this.engineDeployment.DeploymentId.get());
        wF_Steps_t2.ActivityId.set(wF_Activity_t.ActivityId.get());
        wF_Steps_t2.ClassName.set(wF_Activity_t.Class.get());
        wF_Steps_t2.Operation.set(wF_Activity_t.Operation.get());
        wF_Steps_t2.LocationId.set(n);
        wF_Steps_t2.WorkflowStart.set(Boolean.valueOf(bl));
        wF_Steps_t2.Definition.set(wF_Activity_t.Definition.get());
        DeploymentManager.populateStepRow(activityDefinition, wF_Steps_t2);
        try {
            wF_Steps_t2.save();
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to save activity [" + activityDefinition.getName() + "]", cTEDBException);
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_CREATE_DEPLOYMENT", new Object[0]);
            throw new EvFailureException(evMessageContainer);
        }
        this.deploymentSteps.put(activityDefinition.getUniqueName(), wF_Steps_t2);
        this.addTransitions(wF_Steps_t2, activityDefinition);
        return wF_Steps_t2;
    }

    protected static void populateStepRow(ActivityDefinition activityDefinition, WF_Steps_t wF_Steps_t) {
        wF_Steps_t.Name.set(activityDefinition.getName());
        wF_Steps_t.Namespace.set(activityDefinition.getNamespaceUri());
        wF_Steps_t.DisplayName.set(activityDefinition.getDisplayName());
        wF_Steps_t.UniqueName.set(activityDefinition.getUniqueName());
        wF_Steps_t.Description.set(activityDefinition.getDescription());
        wF_Steps_t.ServiceLocation.set(activityDefinition.getServiceLocation());
        wF_Steps_t.ContinueOnFailure.set(activityDefinition.getContinueOnFailure(false));
        wF_Steps_t.MaxRestarts.set(activityDefinition.getMaxRestarts(false));
        wF_Steps_t.timeout.set(Integer.valueOf(activityDefinition.getTimeout()));
        try {
            wF_Steps_t.ActivitySchema.set(WorkflowUtils.encodeMessage(activityDefinition.getActivitySchema()));
        }
        catch (Exception exception) {
            logger.error("failed to encode Workflow::ActivityDefinition", exception);
        }
        if (activityDefinition.getInputs().size() > 0) {
            wF_Steps_t.Inputs.set((String)activityDefinition.getInputs().get(0));
        }
        int n = 0;
        if (activityDefinition.getInteractive()) {
            n |= StepFlags.INTERACTIVE.getEnumValue();
        }
        if (activityDefinition.getWaitSetting()) {
            n |= StepFlags.WAIT_OBJ.getEnumValue();
        }
        if (activityDefinition.getSkipAttempt()) {
            n |= StepFlags.SKIP_ATTEMPT.getEnumValue();
        }
        if (activityDefinition.getCommented()) {
            n |= StepFlags.COMMENTED.getEnumValue();
        }
        if (activityDefinition.getBreakpoint()) {
            n |= StepFlags.BREAKPOINT.getEnumValue();
        }
        if (activityDefinition.getJobMode()) {
            n |= StepFlags.JOB_MODE.getEnumValue();
        }
        wF_Steps_t.flags.set(Integer.valueOf(n));
        if (activityDefinition.getRestartInterval(false) != null) {
            wF_Steps_t.RestartInterval.set(Integer.valueOf(activityDefinition.getRestartInterval() * 60));
        }
        try {
            wF_Steps_t.Outputs.set(XMLEncoder.encodeWithoutXmlHeader((Object)activityDefinition.getOutputs()));
        }
        catch (Exception exception) {
            logger.error("error encoding activity [" + wF_Steps_t.UniqueName.get() + "] outputs", exception);
        }
        try {
            wF_Steps_t.OnEnter.set(XMLEncoder.encodeWithoutXmlHeader((Object)activityDefinition.getOnEnter()));
        }
        catch (Exception exception) {
            logger.error("error encoding activity [" + wF_Steps_t.UniqueName.get() + "] onEnter", exception);
        }
        try {
            wF_Steps_t.OnExit.set(XMLEncoder.encodeWithoutXmlHeader((Object)activityDefinition.getOnExit()));
        }
        catch (Exception exception) {
            logger.error("error encoding activity [" + wF_Steps_t.UniqueName.get() + "] OnExit", exception);
        }
        try {
            wF_Steps_t.StepXml.set(XMLEncoder.encodeWithoutXmlHeader((Object)activityDefinition));
        }
        catch (Exception exception) {
            logger.error("error encoding activity [" + wF_Steps_t.UniqueName.get() + "]", exception);
        }
        wF_Steps_t.RepeatUntil.set(activityDefinition.getRepeatUntil(false));
        if (activityDefinition.getSuperProcess(false) != null && activityDefinition.getSuperProcess().getStart(false) != null && activityDefinition.getSuperProcess().getActivity().size() > 0) {
            wF_Steps_t.SuperProcess.set(Boolean.valueOf(true));
        } else {
            wF_Steps_t.SuperProcess.set(Boolean.valueOf(false));
        }
        if (activityDefinition.getProperties(false) != null) {
            try {
                wF_Steps_t.FormProperties.set(XMLEncoder.encodeWithoutXmlHeader((Object)activityDefinition.getProperties()));
            }
            catch (Exception exception) {
                logger.error("error encoding FormProperties for activity [" + wF_Steps_t.UniqueName.get() + "]", exception);
            }
        }
    }

    protected WF_Activity_t getActivityRow(String string, String string2) throws EvFailureException {
        QName qName = new QName(string2, string);
        WF_Activity_t wF_Activity_t = this.deploymentActivities.get(qName);
        if (wF_Activity_t != null) {
            return wF_Activity_t;
        }
        wF_Activity_t = new WF_Activity_t();
        String string3 = String.format("Name = '%s' AND SchemaId in (Select SchemaId From WF_Schema Where Namespace = '%s')", string, string2);
        try {
            if (!wF_Activity_t.fill(string3)) {
                this.missingWorkflowActivity = true;
                logger.error("could not find activity using where clause [" + string3 + "]");
                EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_LOAD_ACTIVITY", string);
                throw new EvFailureException(evMessageContainer);
            }
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to retrieve activity from commserv", cTEDBException);
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_LOAD_ACTIVITY", string);
            throw new EvFailureException(evMessageContainer);
        }
        this.deploymentActivities.put(qName, wF_Activity_t);
        return wF_Activity_t;
    }

    private WF_Steps_t buildActivityStep(ActivityDefinition activityDefinition, WF_Steps_t wF_Steps_t) throws EvFailureException {
        Object object;
        Class<?> clazz;
        logger.info("deploying activity [%s]", activityDefinition.getUniqueName());
        WF_Activity_t wF_Activity_t = this.getActivityRow(activityDefinition.getName(), activityDefinition.getNamespaceUri());
        try {
            clazz = this.getClass().getClassLoader().loadClass(wF_Activity_t.Class.get());
        }
        catch (Exception exception) {
            logger.error("failed to load class [" + wF_Activity_t.Class.get() + "] for activity [" + activityDefinition.getName() + "]", exception);
            EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_INSTANTIATE_CLASS", wF_Activity_t.Class.get());
            throw new EvFailureException(evMessageContainer);
        }
        if (ActivityValidator.class.isAssignableFrom(clazz)) {
            logger.info("validating activity [%s] using ActivityValidator [%s]", activityDefinition.getUniqueName(), clazz.getName());
            try {
                object = (ActivityValidator)ReflectionUtils.newInstance(clazz);
            }
            catch (Exception exception) {
                logger.error("failed to load class [" + wF_Activity_t.Class.get() + "] for activity [" + activityDefinition.getName() + "]");
                EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_INSTANTIATE_CLASS", wF_Activity_t.Class.get());
                throw new EvFailureException(evMessageContainer);
            }
            object.validate(activityDefinition);
        }
        if (wF_Steps_t == null && WorkflowInputDesigner.class.isAssignableFrom(clazz)) {
            this.inputDesigner = true;
        }
        object = new WF_Schema_t();
        try {
            object.fill(String.format("SchemaId = %s", wF_Activity_t.SchemaId.get()));
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to load WF_Schema row for schema id [" + wF_Activity_t.SchemaId.get() + "] for activity [" + activityDefinition.getName() + "]", cTEDBException);
        }
        return this.buildStep(activityDefinition, wF_Activity_t, wF_Steps_t, ((WF_Schema_t)((Object)object)).LocationId.get(), false);
    }

    private void addTransitions(WF_Steps_t wF_Steps_t, ActivityDefinition activityDefinition) {
        if (activityDefinition.getTransition(false) != null) {
            logger.debug("retrieved [%s] transitions from activity [%s]", activityDefinition.getTransition().size(), activityDefinition.getUniqueName());
            for (TransitionDefinition transitionDefinition : activityDefinition.getTransition()) {
                this.deploymentTransitions.add(new TransitionWrapper(wF_Steps_t, transitionDefinition));
            }
        } else {
            logger.debug("activity [%s] does not contain any transitions", activityDefinition.getUniqueName());
        }
    }

    private void deployTransitions() throws EvFailureException {
        for (TransitionWrapper transitionWrapper : this.deploymentTransitions) {
            Object object;
            TransitionDefinition transitionDefinition = transitionWrapper.transition;
            WF_Steps_t wF_Steps_t = transitionWrapper.stepRow;
            WF_Steps_t wF_Steps_t2 = this.deploymentSteps.get(transitionDefinition.getActivity());
            if (wF_Steps_t2 == null) {
                logger.error("failed to lookup target activity [" + transitionDefinition.getActivity() + "] for transition source [" + wF_Steps_t.UniqueName.get() + "]");
                object = EventMessage.getContainer("JM_WORKFLOW_INVALID_TRANSITION", wF_Steps_t.UniqueName.get());
                throw new EvFailureException((EvMessageContainer)object);
            }
            logger.debug("deploying transtion record for source [%s], target [%s]", wF_Steps_t.UniqueName.get(), wF_Steps_t2.UniqueName.get());
            this.validateXPath(wF_Steps_t.UniqueName.get(), transitionDefinition.getCondition().getScript(), EventMessage.getInstance().getMessageId("JM_WORKFLOW_INVALID_XPATH_TRAN"));
            if (transitionDefinition.getInputs().size() > 0) {
                this.validateXPath(wF_Steps_t.UniqueName.get(), (String)transitionDefinition.getInputs().get(0), EventMessage.getInstance().getMessageId("JM_WORKFLOW_INVALID_XPATH_TRAN"));
            }
            object = this.database.newStepTransition();
            ((WF_StepTransitions_t)((Object)object)).StepId.set(wF_Steps_t.StepId.get());
            ((WF_StepTransitions_t)((Object)object)).SourceActivity.set(wF_Steps_t.UniqueName.get());
            ((WF_StepTransitions_t)((Object)object)).TargetActivity.set(wF_Steps_t2.UniqueName.get());
            ((WF_StepTransitions_t)((Object)object)).TargetStepId.set(wF_Steps_t2.StepId.get());
            DeploymentManager.populateStepTransition((WF_StepTransitions_t)((Object)object), transitionDefinition);
            try {
                object.save();
            }
            catch (CTEDBException cTEDBException) {
                logger.error("failed to save transtion for activity [" + wF_Steps_t.UniqueName.get() + "]", cTEDBException);
                EvMessageContainer evMessageContainer = EventMessage.getContainer("JM_WORKFLOW_FAILED_CREATE_DEPLOYMENT", new Object[0]);
                throw new EvFailureException(evMessageContainer);
            }
        }
    }

    protected static void populateStepTransition(WF_StepTransitions_t wF_StepTransitions_t, TransitionDefinition transitionDefinition) {
        wF_StepTransitions_t.DisplayName.set(transitionDefinition.getDisplayName());
        if (transitionDefinition.getCondition(false) != null) {
            try {
                wF_StepTransitions_t.Condition.set(XMLEncoder.encodeWithoutXmlHeader((Object)transitionDefinition.getCondition()));
            }
            catch (Exception exception) {
                logger.error("error encoding condition for activity [" + wF_StepTransitions_t.SourceActivity.get() + "] transition", exception);
            }
        }
        if (transitionDefinition.getStatus(false) == null) {
            wF_StepTransitions_t.Status.set(Integer.valueOf(TransitionStatus.ANY.getEnumValue()));
        } else {
            wF_StepTransitions_t.Status.set(Integer.valueOf(transitionDefinition.getStatus().getEnumValue()));
        }
        wF_StepTransitions_t.Value.set(transitionDefinition.getValue(false));
        wF_StepTransitions_t.TransitionIndex.set(Integer.valueOf(transitionDefinition.getTransitionIndex()));
        try {
            wF_StepTransitions_t.TransitionXml.set(XMLEncoder.encodeWithoutXmlHeader((Object)transitionDefinition));
        }
        catch (Exception exception) {
            logger.error("error encoding activity [" + wF_StepTransitions_t.SourceActivity.get() + "] transition", exception);
        }
        int n = 0;
        if (transitionDefinition.getCommented()) {
            n |= TransitionFlags.COMMENTED.getEnumValue();
        }
        wF_StepTransitions_t.flags.set(Integer.valueOf(n));
        if (transitionDefinition.getInputs().size() > 0) {
            wF_StepTransitions_t.Inputs.set((String)transitionDefinition.getInputs().get(0));
        }
    }

    private void createWorkflowActivity(WF_Definition_t wF_Definition_t) {
        String string = SchemaUtils.formatName((String)wF_Definition_t.Name.get());
        logger.info("creating activity for workflow process [%s]", wF_Definition_t.Name.get());
        try {
            String string2;
            WF_ActivityGroup_t wF_ActivityGroup_t;
            XMLSchema xMLSchema;
            WF_SchemaLocation_t wF_SchemaLocation_t = new WF_SchemaLocation_t();
            String string3 = String.format("LocationUrl = '%s'", "workflow_activities.jar");
            if (!wF_SchemaLocation_t.fill(string3)) {
                logger.error("cannot find internal workflow schema [workflow_activities.jar]");
                return;
            }
            WF_Schema_t wF_Schema_t = new WF_Schema_t();
            String string4 = String.format("Namespace = '%s'", "commvault.workflow.activities");
            if (!wF_Schema_t.fill(string4)) {
                wF_Schema_t.Namespace.set("commvault.workflow.activities");
                wF_Schema_t.XsdSchema.set("");
                wF_Schema_t.LocationId.set(wF_SchemaLocation_t.LocationId.get());
                wF_Schema_t.Modified.set(CTEDBTimestamp.getNow());
                wF_Schema_t.save();
            }
            ActivitySchema activitySchema = new ActivitySchema();
            activitySchema.setInputs(this.processInputSchema);
            if (this.processOutputSchema != null && this.processOutputSchema.getChildren().size() > 0) {
                activitySchema.setOutputs(this.processOutputSchema);
            } else if (WorkflowRegistry.getInstance().getAppendActivityOutputsToExecution()) {
                activitySchema.getOutputs().getChildren().add(this.executionSchema);
            } else {
                xMLSchema = new XMLSchema();
                xMLSchema.setName("workflow");
                xMLSchema.getChildren().add(this.processInputSchema);
                xMLSchema.getChildren().add(this.processVariableSchema);
                activitySchema.getOutputs().getChildren().add(xMLSchema);
            }
            activitySchema.getInputs().setName("inputs");
            activitySchema.getOutputs().setName("outputs");
            xMLSchema = WorkflowUtils.encodeMessage(activitySchema, "activitySchema");
            WF_Activity_t wF_Activity_t = new WF_Activity_t();
            String string5 = !wF_Definition_t.ActivityId.isNull() && wF_Definition_t.ActivityId.get() > 0 ? String.format("ActivityId = %s", wF_Definition_t.ActivityId.get()) : String.format("Name = '%s' AND SchemaId = %s", string, wF_Schema_t.SchemaId.get());
            if (!wF_Activity_t.fill(string5)) {
                wF_Activity_t.Created.set(CTEDBTimestamp.getNow());
            } else {
                this.validateActivityId(wF_Activity_t.ActivityId.get(), wF_Definition_t.WorkflowId.get());
            }
            wF_Activity_t.Name.set(string);
            wF_Activity_t.DisplayName.set(wF_Definition_t.Name.get());
            wF_Activity_t.Description.set(wF_Definition_t.Description.get());
            wF_Activity_t.Class.set(ExecuteWorkflow.class.getName());
            wF_Activity_t.SchemaFile.set("");
            wF_Activity_t.ActivitySchema.set((Element)xMLSchema);
            wF_Activity_t.SchemaId.set(wF_Schema_t.SchemaId.get());
            wF_Activity_t.Icon.set(this.getWorkflowImage());
            wF_Activity_t.Modified.set(CTEDBTimestamp.getNow());
            wF_Activity_t.save();
            wF_Definition_t.ActivityId.set(wF_Activity_t.ActivityId.get());
            wF_Definition_t.save();
            WF_ActivitySet_t wF_ActivitySet_t = new WF_ActivitySet_t();
            String string6 = String.format("Name = '%s'", "Workflows");
            if (!wF_ActivitySet_t.fill(string6)) {
                wF_ActivitySet_t.Name.set("Workflows");
                wF_ActivitySet_t.Description.set("");
                wF_ActivitySet_t.save();
            }
            if (!(wF_ActivityGroup_t = new WF_ActivityGroup_t()).fill(string2 = String.format("ActivityId = %s", wF_Activity_t.ActivityId.get()))) {
                wF_ActivityGroup_t.ActivityId.set(wF_Activity_t.ActivityId.get());
            }
            wF_ActivityGroup_t.ActivitySetId.set(wF_ActivitySet_t.ActivitySetId.get());
            wF_ActivityGroup_t.save();
            logger.info("succesfully created workflow activity [%s]", string);
        }
        catch (Exception exception) {
            logger.error("error creating activity for workflow [" + wF_Definition_t.Name.get() + "]", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateActivityId(Integer n, int n2) throws Exception {
        if (n == null) {
            return;
        }
        String string = "Select WorkflowId, Name From WF_Definition Where ActivityId = " + n + " AND WorkflowId <> " + n2;
        try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getCommCellConnection().createReservation();){
            PreparedStatement preparedStatement = cTEDBReservation.createStatement(string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                throw new Exception("activity id [" + n + "] already belongs to workflow [" + resultSet.getString("Name") + "], workflow id [" + resultSet.getInt("WorkflowId") + "]");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateBusinessLogic() throws EvFailureException {
        Object object;
        void var4_7;
        void var6_11;
        CTEDBReservation cTEDBReservation = this.processDefinition.getBusinessLogicMessage().split(",");
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        CTEDBReservation object2 = cTEDBReservation;
        int n = ((String[])object2).length;
        boolean bl2 = false;
        while (var6_11 < n) {
            String string = object2[var6_11];
            if (bl) {
                stringBuffer.append(",");
            } else {
                bl = true;
            }
            stringBuffer.append("'").append(StringUtils.replace((String)string, (String)"'", (String)"''")).append("'");
            ++var6_11;
        }
        if (this.processDefinition.getBusinessLogicProcessing().equals("Request")) {
            String string = "preProcess";
        } else {
            String string = "postProcess";
        }
        String string = "SELECT workflowname FROM App_MessageHandler Where messagename = ? and type = ? and workflowId not in (?)";
        for (String string2 : cTEDBReservation) {
            try (CTEDBReservation cTEDBReservation2 = WorkflowProperties.getInstance().getCommCellConnection().createReservation();){
                Object object3 = cTEDBReservation2.createStatement(string);
                object3.setString(1, string2);
                object3.setString(2, (String)var4_7);
                object3.setInt(3, this.definition.workflowId);
                object = object3.executeQuery();
                if (!object.next()) continue;
                logger.error("message [" + string2 + "], type [" + (String)var4_7 + "] already belongs to workflow [" + object.getString(1) + "]");
                throw new EvFailureException(new EvMessageContainer("message already configured for business logic workflow"));
            }
        }
        String string3 = "DECLARE @messagename nvarchar(512) = ? \nDECLARE @workflowid int = ? \nDECLARE @workflowname nvarchar(512) = ? \nDECLARE @level nvarchar(512) = ? \nDECLARE @type nvarchar(512) = ? \nDECLARE @enabled int = ? \nDECLARE @execBy nvarchar(512) = ? \nIF EXISTS(Select * From App_MessageHandler Where workflowId = @workflowid and messagename = @messagename) \n   UPDATE App_MessageHandler SET level = @level, type = @type, enabled = @enabled, executedby = @execBy, workflowname = @workflowname Where workflowId = @workflowid and messagename = @messagename \nELSE \n   INSERT INTO App_MessageHandler(messagename, workflowname, level, type, clientId, enabled, featureVersion, timeout, executedby, workflowId) VALUES (@messagename, @workflowname, @level, @type, 0, @enabled, 0, 0, @execBy, @workflowid) \n";
        String string4 = "DELETE FROM App_MessageHandler WHERE workflowId = ? AND messagename not in (%s)";
        for (Object object3 : cTEDBReservation) {
            object = WorkflowProperties.getInstance().getCommCellConnection().createReservation();
            try {
                PreparedStatement preparedStatement = object.createStatement(string3);
                preparedStatement.setString(1, (String)object3);
                preparedStatement.setInt(2, this.definition.workflowId);
                preparedStatement.setString(3, this.processDefinition.getName());
                preparedStatement.setString(4, "messageLevel");
                preparedStatement.setString(5, (String)var4_7);
                preparedStatement.setInt(6, (this.definition.flags & WorkflowFlags.DISABLED.getEnumValue()) > 0 ? 0 : 1);
                preparedStatement.setString(7, this.processDefinition.getBusinessLogicExecutedBy());
                preparedStatement.executeUpdate();
            }
            catch (Exception exception) {
                logger.error("failed to update App_MessageHandler table for BL workflow [" + this.processDefinition.getName() + "]", exception);
                throw new EvFailureException(new EvMessageContainer(exception.getMessage()));
            }
            finally {
                object.close();
            }
        }
        if (stringBuffer.length() > 0) {
            try (CTEDBReservation cTEDBReservation3 = WorkflowProperties.getInstance().getCommCellConnection().createReservation();){
                PreparedStatement preparedStatement = cTEDBReservation3.createStatement(String.format(string4, stringBuffer.toString()));
                preparedStatement.setInt(1, this.definition.workflowId);
                preparedStatement.executeUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getWorkflowImage() {
        InputStream inputStream = this.getClass().getResourceAsStream(WF_IMAGE_LOCATION);
        if (inputStream == null) {
            logger.warn("could not retrieve workflow image [%s] from internal jar", WF_IMAGE_LOCATION);
            return null;
        }
        try {
            String string = WorkflowUtils.encodeImage(inputStream);
            return string;
        }
        catch (Exception exception) {
            logger.error("error encoding workflow image [/workflow_process.png] from internal jar", exception);
            String string = null;
            return string;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static class WFDefinition {
        public int workflowId;
        public String name;
        public String description;
        public Element definition;
        public int version;
        public int userId;
        public int flags = 0;
        private WF_Definition_t definitionRow;

        public WFDefinition() {
        }

        public WFDefinition(WF_Definition_t wF_Definition_t) {
            this.definitionRow = wF_Definition_t;
            this.workflowId = wF_Definition_t.WorkflowId.get();
            this.name = wF_Definition_t.Name.get();
            this.definition = wF_Definition_t.Definition.get();
            this.description = wF_Definition_t.Description.get();
            this.version = wF_Definition_t.Version.get();
            this.userId = wF_Definition_t.userId.get();
            this.flags = wF_Definition_t.flags.get();
        }

        public void setFlag(WorkflowFlags workflowFlags) {
            if (this.definitionRow != null) {
                this.definitionRow.flags.set(Integer.valueOf(this.flags | workflowFlags.getEnumValue()));
            }
        }

        public void removeFlag(WorkflowFlags workflowFlags) {
            if (this.definitionRow != null) {
                this.definitionRow.flags.set(Integer.valueOf(this.flags & ~workflowFlags.getEnumValue()));
            }
        }

        public void save() throws CTEDBException {
            if (this.definitionRow != null) {
                this.definitionRow.save();
            }
        }

        public String getTags() {
            if (this.definitionRow == null) {
                return "";
            }
            if (this.definitionRow.Tags.isNull()) {
                return "";
            }
            return this.definitionRow.Tags.get();
        }

        public void setTags(String string) {
            if (this.definitionRow != null) {
                this.definitionRow.Tags.set(string);
            }
        }
    }

    private static class TransitionWrapper {
        private final WF_Steps_t stepRow;
        private final TransitionDefinition transition;

        public TransitionWrapper(WF_Steps_t wF_Steps_t, TransitionDefinition transitionDefinition) {
            this.stepRow = wF_Steps_t;
            this.transition = transitionDefinition;
        }
    }
}

