/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow;

import commvault.cte.db.CTEDBConnection;
import commvault.cte.db.CTEDBException;
import commvault.cte.db.CTEDBReservation;
import commvault.cte.util.DateUtilities;
import commvault.cte.workflow.EngineProperties;
import commvault.cte.workflow.Repeatable;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.db.cs.WFCleanHistory_p;
import commvault.cte.workflow.db.engine.WF_Process_t;
import commvault.cte.workflow.logger.CTELogger;
import java.sql.PreparedStatement;
import java.util.List;

public class DataAging
implements Repeatable {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(DataAging.class);
    private static final DataAging instance = new DataAging();
    private static int CHECK_INTERVAL = 300;
    private Thread agingThread;

    public static DataAging getInstance() {
        return instance;
    }

    private DataAging() {
    }

    @Override
    public void run() {
        Integer n = EngineProperties.getInstance().getLastDataAging();
        if (n == null || DateUtilities.getNow() > n + WorkflowRegistry.getInstance().getDataAgingInterval()) {
            this.execute();
        }
    }

    public void execute() {
        if (this.agingThread != null) {
            logger.error("cannot start the data aging process since it is already running");
            return;
        }
        logger.info("data aging job started");
        EngineProperties.getInstance().setLastDataAging(DateUtilities.getNow());
        this.agingThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    DataAging.this.doWork();
                }
                catch (Throwable throwable) {
                    logger.error("uncaught exception executing data aging", throwable);
                }
                try {
                    DataAging.this.cleanMessages();
                }
                catch (Throwable throwable) {
                    logger.error("uncaught exception cleaning message", throwable);
                }
                try {
                    DataAging.this.cleanDefinitionHistory();
                }
                catch (Throwable throwable) {
                    logger.error("uncaught exception cleaning definition history", throwable);
                }
                try {
                    DataAging.this.cleanInteractions();
                }
                catch (Throwable throwable) {
                    logger.error("uncaught exception cleaning interactions", throwable);
                }
                logger.info("data aging job completed");
                DataAging.this.agingThread = null;
            }
        }, "DataAging");
        this.agingThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanInteractions() {
        String string = String.format("DELETE FROM WF_Interaction Where clientId = %s AND status > 0 AND created < dbo.GetUnixTime(DATEADD(Day, -%s, GETUTCDATE()))", WorkflowProperties.getInstance().getClient().getClientId(), WorkflowRegistry.getInstance().getInteractionRetentionDays());
        try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getCommCellConnection().createReservation();){
            PreparedStatement preparedStatement = cTEDBReservation.createStatement(string);
            preparedStatement.executeUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanMessages() {
        String string = String.format("DELETE FROM WF_MessageQueue WHERE Completed < DATEADD(Day, -%s, GETUTCDATE())", 7);
        try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getEngineConnection().createReservation();){
            PreparedStatement preparedStatement = cTEDBReservation.createStatement(string);
            preparedStatement.executeUpdate();
        }
    }

    private void cleanDefinitionHistory() {
        logger.trace("performing data aging for workflow definition history [WFCleanHistory]");
        WFCleanHistory_p wFCleanHistory_p = new WFCleanHistory_p();
        wFCleanHistory_p.daysToKeep.set(Integer.valueOf(30));
        wFCleanHistory_p.revisionsToKeep.set(Integer.valueOf(0));
        try {
            wFCleanHistory_p.execute();
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to execute stored procedure [WFCleanHistory]", cTEDBException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWork() {
        List<WF_Process_t> list;
        logger.trace("performing data aging for workflow jobs and deployments");
        int n = WorkflowRegistry.getInstance().getJobRetentionDays();
        if (n <= 0) {
            logger.error("cannot run data aging, settings for days to keep is less then or equal to zero [" + n + "]");
            return;
        }
        String string = String.format("(%s - EndTime) > %s", DateUtilities.getNow(), n * 86400);
        try {
            logger.trace("retrieving jobs to prune with where clause [%s]", string);
            list = WF_Process_t.select(string);
        }
        catch (CTEDBException cTEDBException) {
            logger.error("failed to retrieve jobs for data aging older then " + n + " days using where clause [" + string + "]", cTEDBException);
            return;
        }
        if (list.size() > 0) {
            CTEDBConnection cTEDBConnection = WorkflowProperties.getInstance().getEngineConnection();
            while (list.size() > 0) {
                String string2 = this.nextGroup(list);
                logger.debug("data aging running for jobs [%s]", string2);
                String string3 = String.format("DELETE FROM WF_Process WHERE jobId IN (%s)", string2);
                try (CTEDBReservation cTEDBReservation = cTEDBConnection.createReservation();){
                    cTEDBReservation.executeUpdate(string3);
                }
            }
        } else {
            logger.debug("data aging found no jobs to prune");
        }
        this.cleanDeployments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanDeployments() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DELETE d ");
        stringBuilder.append("FROM WF_Deployments d ");
        stringBuilder.append("INNER JOIN ");
        stringBuilder.append("(");
        stringBuilder.append("SELECT WorkflowId, MAX(DeploymentId) As LatestDeployment ");
        stringBuilder.append("FROM WF_Deployments GROUP BY WorkflowId");
        stringBuilder.append(") l ON d.WorkflowId = l.WorkflowId AND d.DeploymentId < l.LatestDeployment ");
        stringBuilder.append("WHERE d.DeploymentId not in (SELECT s.DeploymentId FROM WF_Steps s INNER JOIN WF_ProcessSteps p ON s.StepId = p.StepId) ");
        stringBuilder.append("AND d.DeploymentId not in (Select DeploymentId From WF_Process)");
        try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getEngineConnection().createReservation();){
            PreparedStatement preparedStatement = cTEDBReservation.createStatement(stringBuilder.toString());
            preparedStatement.executeUpdate();
        }
    }

    private String nextGroup(List<WF_Process_t> list) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (list.size() > 0) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            WF_Process_t wF_Process_t = list.get(0);
            list.remove(0);
            stringBuffer.append(wF_Process_t.jobId.get());
            if (++n != 10) continue;
            break;
        }
        return stringBuffer.toString();
    }

    @Override
    public int getInterval() {
        return CHECK_INTERVAL;
    }
}

