/*
 * Decompiled with CFR 0.152.
 */
package docusign.resteasy.providers;

import commvault.cte.workflow.logger.CTELogger;
import docusign.client.dto.DocumentFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.ParseException;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang3.StringUtils;
import org.jboss.resteasy.plugins.providers.ProviderHelper;

@Provider
@Produces(value={"*/*"})
@Consumes(value={"*/*"})
public class DocumentFileProvider
implements MessageBodyReader<DocumentFile> {
    private static final String PREFIX = "pfx";
    private static final String SUFFIX = "sfx";
    private static final String PARAM_FILENAME = "filename";
    private static final String PARAM_DOCUMENT_ID = "documentId";
    private String downloadDirectory = null;
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(DocumentFileProvider.class);

    public boolean isReadable(Class<?> clazz, Type type, Annotation[] annotationArray, MediaType mediaType) {
        return DocumentFile.class == clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentFile readFrom(Class<DocumentFile> clazz, Type type, Annotation[] annotationArray, MediaType mediaType, MultivaluedMap<String, String> multivaluedMap, InputStream inputStream) throws IOException {
        File file = null;
        String string = (String)multivaluedMap.getFirst((Object)"Content-Disposition");
        ContentDisposition contentDisposition = null;
        try {
            contentDisposition = this.getContentDisposition(string);
        }
        catch (ParseException parseException) {
            throw new IOException("Error occurred while parsing header. Content-Disposition : " + string, parseException);
        }
        DocumentFile documentFile = new DocumentFile();
        String string2 = null;
        String string3 = null;
        if (contentDisposition != null) {
            this.setDocumentAttributes(contentDisposition, documentFile);
            string3 = this.getFileSuffix(contentDisposition, mediaType);
            string2 = this.getFilePrefix(contentDisposition);
        } else {
            logger.info("Content Disposition header not found in response. All the attributes DocumentFile instance won't be populated.");
            string3 = this.getFileSuffix(mediaType);
        }
        if (StringUtils.isBlank(string2)) {
            string2 = PREFIX;
        }
        if (StringUtils.isBlank((CharSequence)string3)) {
            string3 = SUFFIX;
        }
        if (this.downloadDirectory != null) {
            try {
                file = File.createTempFile(string2, string3, new File(this.downloadDirectory));
            }
            catch (IOException iOException) {
                logger.error("Could not bind to specified download directory " + this.downloadDirectory + " so will use temp dir.");
            }
        }
        if (file == null) {
            file = File.createTempFile(string2, string3);
        }
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));){
            ProviderHelper.writeTo((InputStream)inputStream, (OutputStream)bufferedOutputStream);
        }
        documentFile.setDocFile(file);
        return documentFile;
    }

    private String getFilePrefix(ContentDisposition contentDisposition) {
        String string = contentDisposition.getParameter(PARAM_FILENAME);
        return StringUtils.substringBeforeLast((String)string, (String)".");
    }

    private void setDocumentAttributes(ContentDisposition contentDisposition, DocumentFile documentFile) {
        documentFile.setDocumentId(contentDisposition.getParameter(PARAM_DOCUMENT_ID));
        documentFile.setName(contentDisposition.getParameter(PARAM_FILENAME));
    }

    private String getFileSuffix(ContentDisposition contentDisposition, MediaType mediaType) {
        String string = contentDisposition.getParameter(PARAM_FILENAME);
        return this.getFileSuffix(mediaType, string);
    }

    private String getFileSuffix(MediaType mediaType) {
        return this.getFileSuffix(mediaType, null);
    }

    private String getFileSuffix(MediaType mediaType, String string) {
        String string2 = StringUtils.substringAfterLast((String)string, (String)".");
        String string3 = StringUtils.defaultString((String)mediaType.getSubtype());
        boolean bl = StringUtils.isBlank((CharSequence)string2);
        boolean bl2 = StringUtils.isBlank((CharSequence)string3);
        string2 = !bl && string3.equalsIgnoreCase(string2) ? "." + string2 : (!bl && bl2 ? "." + string2 : (bl && !bl2 ? "." + string3 : (!bl && !bl2 ? "." + string2 + "." + string3 : ".pdf")));
        return string2;
    }

    private ContentDisposition getContentDisposition(String string) throws ParseException {
        if (StringUtils.isBlank((CharSequence)string)) {
            return null;
        }
        return new ContentDisposition(string);
    }

    public boolean isWriteable(Class<?> clazz, Type type, Annotation[] annotationArray, MediaType mediaType) {
        return File.class.isAssignableFrom(clazz);
    }

    public long getSize(File file, Class<?> clazz, Type type, Annotation[] annotationArray, MediaType mediaType) {
        return file.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(File file, Class<?> clazz, Type type, Annotation[] annotationArray, MediaType mediaType, MultivaluedMap<String, Object> multivaluedMap, OutputStream outputStream) throws IOException {
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
            ProviderHelper.writeTo((InputStream)bufferedInputStream, (OutputStream)outputStream);
        }
    }
}

