/*
 * Decompiled with CFR 0.152.
 */
package docusign.client.utils;

import docusign.client.dto.Document;
import docusign.client.dto.DocumentSignatureRequest;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.activation.FileDataSource;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataOutput;
import org.jboss.resteasy.plugins.providers.multipart.OutputPart;

public class DocuSignUtils {
    public static MultipartFormDataOutput generateMultipartFormDataOutput(DocumentSignatureRequest documentSignatureRequest) {
        MultipartFormDataOutput multipartFormDataOutput = new MultipartFormDataOutput();
        OutputPart outputPart = multipartFormDataOutput.addFormData("envelope_definition", (Object)documentSignatureRequest, MediaType.APPLICATION_JSON_TYPE);
        for (Document document : documentSignatureRequest.getDocuments()) {
            FileDataSource fileDataSource = new FileDataSource(document.getPath());
            OutputPart outputPart2 = multipartFormDataOutput.addFormData(document.getName(), (Object)fileDataSource, MediaType.valueOf((String)fileDataSource.getContentType()));
            outputPart2.getHeaders().putSingle((Object)"Content-Disposition", (Object)DocuSignUtils.getContentDispositionHeader(document));
        }
        return multipartFormDataOutput;
    }

    public static String getCommaSeparatedValue(List<? extends Enum<?>> list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Enum<?> enum_ : list) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(enum_.name());
        }
        return stringBuffer.toString();
    }

    public static String getContentDispositionHeader(Document document) {
        return "file; filename=\"" + document.getName() + "\"; documentId=" + document.getDocumentId();
    }

    public static Iterable<Class<?>> getClasses(String string) throws ClassNotFoundException, IOException {
        Serializable serializable;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String string2 = string.replace('.', '/');
        Enumeration<URL> enumeration = classLoader.getResources(string2);
        ArrayList<File> arrayList = new ArrayList<File>();
        while (enumeration.hasMoreElements()) {
            serializable = enumeration.nextElement();
            arrayList.add(new File(((URL)serializable).getFile()));
        }
        serializable = new ArrayList();
        for (File file : arrayList) {
            serializable.addAll(DocuSignUtils.findClasses(file, string));
        }
        return serializable;
    }

    public static List<Class<?>> findClasses(File file, String string) throws ClassNotFoundException {
        List<Class<?>> list = null;
        list = file.exists() ? DocuSignUtils.findClassesInDirectory(file, string) : DocuSignUtils.findClassesInJar(file.getPath(), string);
        return list;
    }

    private static List<Class<?>> findClassesInDirectory(File file, String string) throws ClassNotFoundException {
        File[] fileArray;
        ArrayList arrayList = new ArrayList();
        for (File file2 : fileArray = file.listFiles()) {
            if (file2.isDirectory()) {
                arrayList.addAll(DocuSignUtils.findClasses(file2, string + "." + file2.getName()));
                continue;
            }
            if (!file2.getName().endsWith(".class")) continue;
            arrayList.add(Class.forName(string + '.' + file2.getName().substring(0, file2.getName().length() - 6)));
        }
        return arrayList;
    }

    private static List<Class<?>> findClassesInJar(String string, String string2) throws ClassNotFoundException {
        ArrayList arrayList = new ArrayList();
        try {
            String string3 = string.replaceFirst("[.]jar[!].*", ".jar").replaceFirst("file:", "");
            String string4 = string2.replace('.', '/');
            JarFile jarFile = new JarFile(string3);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                String string5 = jarEntry.getName();
                if (!string5.startsWith(string4) || string5.length() <= string4.length() + "/".length()) continue;
                String string6 = string5.replace('/', '.').replace('\\', '.').replace(".class", "");
                arrayList.add(Class.forName(string6));
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(string2 + " (" + string + ") does not appear to be a valid package", iOException);
        }
        return arrayList;
    }
}

