/*
 * Decompiled with CFR 0.152.
 */
package docusign.client.services;

import docusign.client.base.BaseService;
import docusign.client.credential.DocuSignCredentials;
import docusign.client.dto.AuditEventsResponse;
import docusign.client.dto.CustomField;
import docusign.client.dto.Document;
import docusign.client.dto.DocumentFile;
import docusign.client.dto.DocumentInfo;
import docusign.client.dto.Envelope;
import docusign.client.dto.EnvelopeDetailInfo;
import docusign.client.dto.EnvelopeDocumentInfo;
import docusign.client.dto.EnvelopeInfo;
import docusign.client.dto.EnvelopeNotificationInfo;
import docusign.client.dto.EnvelopeStatusQueryForm;
import docusign.client.dto.EnvelopeStatusResponse;
import docusign.client.dto.StatusChangeRequest;
import docusign.client.dto.VoidEnvelopeRequest;
import docusign.client.dto.recipients.RecipientStatusCollection;
import docusign.client.dto.user.LoginAccount;
import docusign.client.envelope.attributes.Status;
import docusign.client.exception.EnvelopeException;
import docusign.client.exception.ServiceInitException;
import docusign.client.exception.SignatureRequestException;
import docusign.client.resources.EnvelopeResource;
import docusign.client.utils.DocuSignUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.activation.FileDataSource;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataOutput;
import org.jboss.resteasy.plugins.providers.multipart.OutputPart;

public class EnvelopeService
extends BaseService<EnvelopeResource> {
    public EnvelopeService(String string, DocuSignCredentials docuSignCredentials) throws ServiceInitException {
        super(string, docuSignCredentials);
    }

    public EnvelopeService(DocuSignCredentials docuSignCredentials, LoginAccount loginAccount) throws ServiceInitException {
        super(loginAccount, docuSignCredentials);
    }

    public void sendFromDrafts(String string, String string2) throws EnvelopeException {
        StatusChangeRequest statusChangeRequest = new StatusChangeRequest();
        statusChangeRequest.setStatus(Status.sent);
        statusChangeRequest.setStatusReason(string2);
        ClientResponse<String> clientResponse = ((EnvelopeResource)this.resourceProxy).changeStatus(string, statusChangeRequest);
        this.validateResponseSuccess(clientResponse, EnvelopeException.class);
    }

    public void changeStatus(String string, StatusChangeRequest statusChangeRequest) throws EnvelopeException {
        ClientResponse<String> clientResponse = ((EnvelopeResource)this.resourceProxy).changeStatus(string, statusChangeRequest);
        this.validateResponseSuccess(clientResponse, EnvelopeException.class);
    }

    public void voidEnvelope(String string, VoidEnvelopeRequest voidEnvelopeRequest) throws EnvelopeException {
        ClientResponse<String> clientResponse = ((EnvelopeResource)this.resourceProxy).voidEnvelope(string, voidEnvelopeRequest);
        this.validateResponseSuccess(clientResponse, EnvelopeException.class);
    }

    public AuditEventsResponse getAuditEvents(String string) throws EnvelopeException {
        ClientResponse<AuditEventsResponse> clientResponse = ((EnvelopeResource)this.resourceProxy).getAuditEvents(string);
        return this.parseEntityFromResponse(clientResponse, EnvelopeException.class);
    }

    public void addDocumentToDraftEnvelope(String string, Document document) throws EnvelopeException {
        FileDataSource fileDataSource = new FileDataSource(document.getPath());
        String string2 = DocuSignUtils.getContentDispositionHeader(document);
        ClientResponse<String> clientResponse = ((EnvelopeResource)this.resourceProxy).addDocumentToDraftEnvelope(string2, string, document.getDocumentId().toString(), fileDataSource.getFile());
        this.validateResponseSuccess(clientResponse, EnvelopeException.class);
    }

    public EnvelopeDetailInfo getEnvelope(String string) throws EnvelopeException {
        ClientResponse<EnvelopeDetailInfo> clientResponse = ((EnvelopeResource)this.resourceProxy).getEnvelope(string);
        return this.parseEntityFromResponse(clientResponse, EnvelopeException.class);
    }

    public String saveToDrafts(Envelope envelope) throws SignatureRequestException {
        MultipartFormDataOutput multipartFormDataOutput = this.generateMultipartFormDataOutput(envelope);
        ClientResponse<Map<String, String>> clientResponse = ((EnvelopeResource)this.resourceProxy).saveToDrafts(multipartFormDataOutput);
        return this.parseEntityFromResponse(clientResponse, SignatureRequestException.class).get("envelopeId");
    }

    private MultipartFormDataOutput generateMultipartFormDataOutput(Envelope envelope) {
        MultipartFormDataOutput multipartFormDataOutput = new MultipartFormDataOutput();
        multipartFormDataOutput.addFormData("request-type", (Object)"Save envelope as draft", MediaType.APPLICATION_JSON_TYPE);
        multipartFormDataOutput.addFormData("envelope_definition", (Object)envelope, MediaType.APPLICATION_JSON_TYPE);
        for (DocumentInfo documentInfo : envelope.getDocuments()) {
            FileDataSource fileDataSource = new FileDataSource(documentInfo.getPath());
            OutputPart outputPart = multipartFormDataOutput.addFormData(documentInfo.getName(), (Object)fileDataSource, MediaType.valueOf((String)fileDataSource.getContentType()));
            outputPart.getHeaders().putSingle((Object)"Content-Disposition", (Object)DocuSignUtils.getContentDispositionHeader(documentInfo));
        }
        return multipartFormDataOutput;
    }

    public EnvelopeStatusResponse getEnvelopeStatus(EnvelopeStatusQueryForm envelopeStatusQueryForm) throws EnvelopeException {
        ClientResponse<EnvelopeStatusResponse> clientResponse = ((EnvelopeResource)this.resourceProxy).getEnvelopeStatus(envelopeStatusQueryForm);
        return this.parseEntityFromResponse(clientResponse, EnvelopeException.class);
    }

    public EnvelopeInfo getEnvelopeStatus(String string) throws EnvelopeException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        EnvelopeStatusQueryForm envelopeStatusQueryForm = new EnvelopeStatusQueryForm();
        envelopeStatusQueryForm.setEnvelopeIds(arrayList);
        ClientResponse<EnvelopeStatusResponse> clientResponse = ((EnvelopeResource)this.resourceProxy).getEnvelopeStatus(envelopeStatusQueryForm);
        EnvelopeStatusResponse envelopeStatusResponse = this.parseEntityFromResponse(clientResponse, EnvelopeException.class);
        if (envelopeStatusResponse != null && envelopeStatusResponse.getEnvelopes() != null && envelopeStatusResponse.getEnvelopes().size() > 0) {
            return envelopeStatusResponse.getEnvelopes().get(0);
        }
        return null;
    }

    public DocumentFile getCertificate(String string) throws EnvelopeException {
        ClientResponse<DocumentFile> clientResponse = ((EnvelopeResource)this.resourceProxy).getCertificate(string, null, null);
        return this.parseEntityFromResponse(clientResponse, EnvelopeException.class);
    }

    public DocumentFile getCertificate(String string, Boolean bl, Boolean bl2) throws EnvelopeException {
        ClientResponse<DocumentFile> clientResponse = ((EnvelopeResource)this.resourceProxy).getCertificate(string, bl, bl2);
        return this.parseEntityFromResponse(clientResponse, EnvelopeException.class);
    }

    public DocumentFile getDocumentsCombined(String string) throws EnvelopeException {
        ClientResponse<DocumentFile> clientResponse = ((EnvelopeResource)this.resourceProxy).getDocumentsCombined(string);
        return this.parseEntityFromResponse(clientResponse, EnvelopeException.class);
    }

    public EnvelopeDocumentInfo getDocumentsInfo(String string) throws EnvelopeException {
        ClientResponse<EnvelopeDocumentInfo> clientResponse = ((EnvelopeResource)this.resourceProxy).getDocumentsInfo(string);
        return this.parseEntityFromResponse(clientResponse, EnvelopeException.class);
    }

    public DocumentFile getDocument(String string, String string2) throws EnvelopeException {
        ClientResponse<DocumentFile> clientResponse = ((EnvelopeResource)this.resourceProxy).getDocument(string, string2);
        return this.parseEntityFromResponse(clientResponse, EnvelopeException.class);
    }

    public List<CustomField> getCustomFields(String string) throws EnvelopeException {
        ClientResponse<Map<String, List<CustomField>>> clientResponse = ((EnvelopeResource)this.resourceProxy).getCustomFields(string);
        Map<String, List<CustomField>> map = this.parseEntityFromResponse(clientResponse, EnvelopeException.class);
        if (map != null) {
            return map.get("customFields");
        }
        return null;
    }

    public EnvelopeNotificationInfo getNotificationInfo(String string) throws EnvelopeException {
        ClientResponse<EnvelopeNotificationInfo> clientResponse = ((EnvelopeResource)this.resourceProxy).getNotificationInfo(string);
        return this.parseEntityFromResponse(clientResponse, EnvelopeException.class);
    }

    public RecipientStatusCollection getRecipientStatus(String string) throws EnvelopeException {
        ClientResponse<RecipientStatusCollection> clientResponse = ((EnvelopeResource)this.resourceProxy).getRecipientStatus(string, null, null);
        return this.parseEntityFromResponse(clientResponse, EnvelopeException.class);
    }

    public RecipientStatusCollection getRecipientStatus(String string, Boolean bl, Boolean bl2) throws EnvelopeException {
        ClientResponse<RecipientStatusCollection> clientResponse = ((EnvelopeResource)this.resourceProxy).getRecipientStatus(string, bl, bl2);
        return this.parseEntityFromResponse(clientResponse, EnvelopeException.class);
    }

    @Override
    protected Class<EnvelopeResource> getResourceClass() {
        return EnvelopeResource.class;
    }
}

