/*
 * Decompiled with CFR 0.152.
 */
package docusign.client.resources;

import docusign.client.base.Resource;
import docusign.client.dto.AuditEventsResponse;
import docusign.client.dto.CustomField;
import docusign.client.dto.DocumentFile;
import docusign.client.dto.EnvelopeDetailInfo;
import docusign.client.dto.EnvelopeDocumentInfo;
import docusign.client.dto.EnvelopeNotificationInfo;
import docusign.client.dto.EnvelopeStatusQueryForm;
import docusign.client.dto.EnvelopeStatusResponse;
import docusign.client.dto.StatusChangeRequest;
import docusign.client.dto.VoidEnvelopeRequest;
import docusign.client.dto.recipients.RecipientStatusCollection;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jboss.resteasy.annotations.Form;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataOutput;

@Path(value="/")
public interface EnvelopeResource
extends Resource {
    @PUT
    @Path(value="envelopes/{envelopeId}")
    @Consumes(value={"application/json"})
    public ClientResponse<String> voidEnvelope(@PathParam(value="envelopeId") String var1, VoidEnvelopeRequest var2);

    @PUT
    @Path(value="envelopes/{envelopeId}/status")
    @Consumes(value={"application/json"})
    public ClientResponse<String> changeStatus(@PathParam(value="envelopeId") String var1, StatusChangeRequest var2);

    @PUT
    @Path(value="envelopes/{envelopeId}/documents/{documentId}")
    @Consumes(value={"application/octet-stream"})
    public ClientResponse<String> addDocumentToDraftEnvelope(@HeaderParam(value="Content-Disposition") String var1, @PathParam(value="envelopeId") String var2, @PathParam(value="documentId") String var3, File var4);

    @GET
    @Path(value="envelopes/{envelopeId}/audit_events")
    @Produces(value={"application/json"})
    public ClientResponse<AuditEventsResponse> getAuditEvents(@PathParam(value="envelopeId") String var1);

    @GET
    @Path(value="envelopes/{envelopeId}")
    @Produces(value={"application/json"})
    public ClientResponse<EnvelopeDetailInfo> getEnvelope(@PathParam(value="envelopeId") String var1);

    @POST
    @Path(value="folders/draft")
    @Consumes(value={"multipart/form-data"})
    public ClientResponse<Map<String, String>> saveToDrafts(MultipartFormDataOutput var1);

    @GET
    @Path(value="envelopes")
    @Produces(value={"application/json"})
    public ClientResponse<EnvelopeStatusResponse> getEnvelopeStatus(@Form EnvelopeStatusQueryForm var1);

    @GET
    @Path(value="envelopes/{envelopeId}/documents/certificate")
    public ClientResponse<DocumentFile> getCertificate(@PathParam(value="envelopeId") String var1, @QueryParam(value="watermark") Boolean var2, @QueryParam(value="certificate") Boolean var3);

    @GET
    @Path(value="envelopes/{envelopeId}/documents/combined")
    public ClientResponse<DocumentFile> getDocumentsCombined(@PathParam(value="envelopeId") String var1);

    @GET
    @Path(value="envelopes/{envelopeId}/documents")
    @Produces(value={"application/json"})
    public ClientResponse<EnvelopeDocumentInfo> getDocumentsInfo(@PathParam(value="envelopeId") String var1);

    @GET
    @Path(value="/envelopes/{envelopeId}/documents/{documentId}")
    public ClientResponse<DocumentFile> getDocument(@PathParam(value="envelopeId") String var1, @PathParam(value="documentId") String var2);

    @GET
    @Path(value="/envelopes/{envelopeId}/custom_fields")
    @Produces(value={"application/json"})
    public ClientResponse<Map<String, List<CustomField>>> getCustomFields(@PathParam(value="envelopeId") String var1);

    @GET
    @Path(value="/envelopes/{envelopeId}/notification")
    @Produces(value={"application/json"})
    public ClientResponse<EnvelopeNotificationInfo> getNotificationInfo(@PathParam(value="envelopeId") String var1);

    @GET
    @Path(value="/envelopes/{envelopeId}/recipients")
    @Produces(value={"application/json"})
    public ClientResponse<RecipientStatusCollection> getRecipientStatus(@PathParam(value="envelopeId") String var1, @QueryParam(value="include_tabs") Boolean var2, @QueryParam(value="include_extended") Boolean var3);
}

