/*
 * Decompiled with CFR 0.152.
 */
package docusign.client.dto;

import docusign.client.dto.AuditEventField;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonProperty;

public class AuditEvent {
    private DateFormat iso8601DateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    public static final String LOG_TIME = "logTime";
    public static final String SOURCE = "Source";
    public static final String USERNAME = "UserName";
    public static final String USER_ID = "UserId";
    public static final String ACTION = "Action";
    public static final String MESSAGE = "Message";
    public static final String ENVELOPE_STATUS = "EnvelopeStatus";
    public static final String CLIENT_IP_ADDRESS = "ClientIPAddress";
    public static final String INFORMATION = "Information";
    public static final String GEO_LOCATION = "GeoLocation";
    public static final String LANGUAGE = "Language";
    @JsonProperty
    private List<AuditEventField> eventFields;
    private Map<String, String> eventFieldMap;

    public List<AuditEventField> getEventFields() {
        return this.eventFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, String> getMap() {
        if (this.eventFieldMap != null) return this.eventFieldMap;
        Class<AuditEvent> clazz = AuditEvent.class;
        synchronized (AuditEvent.class) {
            if (this.eventFieldMap != null) return this.eventFieldMap;
            Class<AuditEvent> clazz2 = AuditEvent.class;
            synchronized (AuditEvent.class) {
                this.eventFieldMap = new HashMap<String, String>(this.eventFields.size());
                for (AuditEventField auditEventField : this.eventFields) {
                    this.eventFieldMap.put(auditEventField.getName(), auditEventField.getValue());
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.eventFieldMap;
            }
        }
    }

    public String getEventField(String string) {
        return this.getMap().get(string);
    }

    public Date getLogTime() {
        String string = this.getEventField(LOG_TIME);
        Date date = null;
        if (string != null) {
            try {
                date = this.iso8601DateFormat.parse(string);
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
        }
        return date;
    }

    public String getMessage() {
        String string = this.getEventField(MESSAGE);
        return string;
    }

    public String getAction() {
        String string = this.getEventField(ACTION);
        return string;
    }

    public String getGeoLocation() {
        String string = this.getEventField(GEO_LOCATION);
        return string;
    }
}

