/*
 * Decompiled with CFR 0.152.
 */
package docusign.client.base;

import docusign.client.base.DocuSignClient;
import docusign.client.base.Resource;
import docusign.client.credential.DocuSignCredentials;
import docusign.client.dto.ErrorResponse;
import docusign.client.exception.DocuSignException;
import java.lang.reflect.InvocationTargetException;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.ClientResponseFailure;

public abstract class Service<RT extends Resource> {
    private final String restBaseUri;
    protected final RT resourceProxy;

    public Service(String string, DocuSignCredentials docuSignCredentials) {
        this.restBaseUri = string;
        this.resourceProxy = (Resource)this.getResourceProxy(this.getResourceClass(), string, docuSignCredentials);
    }

    public String getRestBaseUri() {
        return this.restBaseUri;
    }

    protected abstract Class<RT> getResourceClass();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T, EX extends DocuSignException> T parseEntityFromResponse(ClientResponse<T> clientResponse, Class<EX> clazz) throws EX {
        Object object = null;
        try {
            this.validateResponseSuccess(clientResponse, clazz);
            object = clientResponse.getEntity();
        }
        finally {
            clientResponse.releaseConnection();
        }
        return (T)object;
    }

    protected <EX extends DocuSignException> void validateResponseSuccess(ClientResponse<?> clientResponse, Class<EX> clazz) throws EX {
        if (clientResponse.getResponseStatus().getFamily() != Response.Status.Family.SUCCESSFUL) {
            ErrorResponse errorResponse = null;
            ClientResponseFailure clientResponseFailure = null;
            try {
                errorResponse = (ErrorResponse)clientResponse.getEntity(ErrorResponse.class);
            }
            catch (ClientResponseFailure clientResponseFailure2) {
                clientResponseFailure = clientResponseFailure2;
            }
            DocuSignException docuSignException = null;
            String string = "Error occurred while creating new instance of exception class of type " + clazz.getCanonicalName() + " to throw the following error:\n" + errorResponse;
            try {
                docuSignException = clientResponseFailure != null ? (DocuSignException)clazz.getConstructor(String.class, Throwable.class).newInstance(new Object[]{clientResponseFailure.getMessage(), clientResponseFailure}) : (DocuSignException)clazz.getConstructor(String.class).newInstance("Request processing failed. HTTP Status: " + clientResponse.getStatus() + "\n Error:" + errorResponse);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalStateException(string, illegalArgumentException);
            }
            catch (SecurityException securityException) {
                throw new IllegalStateException(string, securityException);
            }
            catch (InstantiationException instantiationException) {
                throw new IllegalStateException(string, instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException(string, illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IllegalStateException(string, invocationTargetException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalStateException(string, noSuchMethodException);
            }
            docuSignException.setErrorResponse(errorResponse);
            throw docuSignException;
        }
    }

    protected <T> T getResourceProxy(Class<T> clazz, String string, DocuSignCredentials docuSignCredentials) {
        return DocuSignClient.getClientService(clazz, string, docuSignCredentials);
    }
}

