/*
 * Decompiled with CFR 0.152.
 */
package docusign.client.base;

import commvault.cte.workflow.logger.CTELogger;
import docusign.client.credential.DocuSignCredentials;
import docusign.resteasy.providers.DocumentFileProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.ProxyFactory;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class DocuSignClient {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(DocuSignClient.class);

    private static void initializeProviderFactory() {
        try {
            ResteasyProviderFactory resteasyProviderFactory = ResteasyProviderFactory.getInstance();
            DocuSignClient.registerResteasyProvider(resteasyProviderFactory, DocumentFileProvider.class);
            RegisterBuiltin.register((ResteasyProviderFactory)resteasyProviderFactory);
        }
        catch (Exception exception) {
            logger.error("Error occurred while registering custom resteasy providers " + exception);
        }
    }

    private static void registerResteasyProvider(ResteasyProviderFactory resteasyProviderFactory, Class<?> clazz) {
        boolean bl = false;
        if (!bl) {
            resteasyProviderFactory.registerProvider(clazz);
            logger.info("Registered custom Provider with Resteasy:" + clazz.getName());
        } else {
            logger.info("Provider is already registered with Resteasy. Ignoring registration request:" + clazz.getName());
        }
    }

    public static <T> T getClientService(Class<T> clazz, String string, final DocuSignCredentials docuSignCredentials) {
        logger.info("Generating REST resource proxy for: " + clazz.getName());
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        ApacheHttpClient4Executor apacheHttpClient4Executor = new ApacheHttpClient4Executor((HttpClient)defaultHttpClient){

            public ClientResponse execute(ClientRequest clientRequest) throws Exception {
                docuSignCredentials.setHeader(clientRequest);
                return super.execute(clientRequest);
            }
        };
        return (T)ProxyFactory.create(clazz, (String)string, (ClientExecutor)apacheHttpClient4Executor);
    }

    static {
        DocuSignClient.initializeProviderFactory();
    }
}

