/*
 * Decompiled with CFR 0.152.
 */
package activities;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.InputOutput;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.logger.LoggerLevel;
import docusign.client.exception.LoginException;
import docusign.client.exception.ServiceInitException;
import docusignWrapper.DocusignWrapper;
import workflow.types.EncryptedString;

public class Login
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(Login.class);
    @InputOutput
    public String serviceUrl;
    @InputOutput
    public String userEmail;
    @InputOutput
    public EncryptedString password;
    @InputOutput
    public String integratorKey;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        logger.info("Login with user mail ID: " + this.userEmail);
        try {
            if (this.serviceUrl.isEmpty()) {
                String string = "Empty serviceUrl provided, Please provide a valid serviceUrl";
                throw new LoginException(string);
            }
            DocusignWrapper.Login(this.serviceUrl, this.userEmail, this.password.getPlainText(), this.integratorKey);
        }
        catch (LoginException loginException) {
            logger.debugJob(LoggerLevel.ERROR, Long.valueOf(activityContext.getJobId()), "failed to authenticate DocuSign user [%s]", new Object[]{this.userEmail});
            logger.error((Throwable)loginException);
            activityContext.setFailureReason(new EvMessageContainer(loginException.getMessage()));
            return AttemptStatus.FAILED;
        }
        catch (ServiceInitException serviceInitException) {
            logger.debugJob(LoggerLevel.ERROR, Long.valueOf(activityContext.getJobId()), "Service init exception", new Object[0]);
            logger.error((Throwable)serviceInitException);
            activityContext.setFailureReason(new EvMessageContainer(serviceInitException.getMessage()));
            return AttemptStatus.FAILED;
        }
        catch (Exception exception) {
            logger.debugJob(LoggerLevel.ERROR, Long.valueOf(activityContext.getJobId()), "Exception in Login", new Object[0]);
            logger.error((Throwable)exception);
            activityContext.setFailureReason(new EvMessageContainer(exception.getMessage()));
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

