/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsPeer;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsNonceGenerator;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Times;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class AbstractTlsContext
implements TlsContext {
    private static long counter = Times.nanoTime();
    private TlsCrypto crypto;
    private int connectionEnd;
    private TlsNonceGenerator nonceGenerator;
    private SecurityParameters securityParametersHandshake = null;
    private SecurityParameters securityParametersConnection = null;
    private ProtocolVersion[] clientSupportedVersions = null;
    private ProtocolVersion clientVersion = null;
    private TlsSession session = null;
    private Object userObject = null;

    private static synchronized long nextCounterValue() {
        return ++counter;
    }

    private static TlsNonceGenerator createNonceGenerator(TlsCrypto tlsCrypto, int n) {
        byte[] byArray = new byte[16];
        Pack.longToBigEndian((long)AbstractTlsContext.nextCounterValue(), (byte[])byArray, (int)0);
        Pack.longToBigEndian((long)Times.nanoTime(), (byte[])byArray, (int)8);
        byArray[0] = (byte)n;
        return tlsCrypto.createNonceGenerator(byArray);
    }

    AbstractTlsContext(TlsCrypto tlsCrypto, int n) {
        this.crypto = tlsCrypto;
        this.connectionEnd = n;
        this.nonceGenerator = AbstractTlsContext.createNonceGenerator(tlsCrypto, n);
    }

    synchronized void handshakeBeginning(TlsPeer tlsPeer) throws IOException {
        if (null != this.securityParametersHandshake) {
            throw new TlsFatalAlert(80);
        }
        this.securityParametersHandshake = new SecurityParameters();
        this.securityParametersHandshake.entity = this.connectionEnd;
        if (null != this.securityParametersConnection) {
            this.securityParametersHandshake.renegotiating = true;
            this.securityParametersHandshake.secureRenegotiation = this.securityParametersConnection.isSecureRenegotiation();
            this.securityParametersHandshake.negotiatedVersion = this.securityParametersConnection.getNegotiatedVersion();
        }
        tlsPeer.notifyHandshakeBeginning();
    }

    synchronized void handshakeComplete(TlsPeer tlsPeer, TlsSession tlsSession) throws IOException {
        if (null == this.securityParametersHandshake) {
            throw new TlsFatalAlert(80);
        }
        this.session = tlsSession;
        this.securityParametersConnection = this.securityParametersHandshake;
        tlsPeer.notifyHandshakeComplete();
        this.securityParametersHandshake = null;
    }

    public TlsCrypto getCrypto() {
        return this.crypto;
    }

    public TlsNonceGenerator getNonceGenerator() {
        return this.nonceGenerator;
    }

    public synchronized SecurityParameters getSecurityParameters() {
        return null != this.securityParametersHandshake ? this.securityParametersHandshake : this.securityParametersConnection;
    }

    public synchronized SecurityParameters getSecurityParametersConnection() {
        return this.securityParametersConnection;
    }

    public synchronized SecurityParameters getSecurityParametersHandshake() {
        return this.securityParametersHandshake;
    }

    public ProtocolVersion[] getClientSupportedVersions() {
        return this.clientSupportedVersions;
    }

    public void setClientSupportedVersions(ProtocolVersion[] protocolVersionArray) {
        this.clientSupportedVersions = protocolVersionArray;
    }

    public ProtocolVersion getClientVersion() {
        return this.clientVersion;
    }

    void setClientVersion(ProtocolVersion protocolVersion) {
        this.clientVersion = protocolVersion;
    }

    public ProtocolVersion getServerVersion() {
        return this.getSecurityParameters().getNegotiatedVersion();
    }

    public TlsSession getResumableSession() {
        TlsSession tlsSession = this.getSession();
        if (tlsSession == null || !tlsSession.isResumable()) {
            return null;
        }
        return tlsSession;
    }

    public TlsSession getSession() {
        return this.session;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public byte[] exportChannelBinding(int n) {
        SecurityParameters securityParameters = this.getSecurityParametersConnection();
        if (null == securityParameters) {
            throw new IllegalStateException("Export of channel bindings unavailable before handshake completion");
        }
        switch (n) {
            case 0: {
                byte[] byArray = securityParameters.getTLSServerEndPoint();
                return byArray.length < 1 ? null : Arrays.clone((byte[])byArray);
            }
            case 1: {
                return Arrays.clone((byte[])securityParameters.getTLSUnique());
            }
        }
        throw new UnsupportedOperationException();
    }

    public byte[] exportEarlyKeyingMaterial(String string, byte[] byArray, int n) {
        if (byArray != null && !TlsUtils.isValidUint16(byArray.length)) {
            throw new IllegalArgumentException("'context_value' must have length less than 2^16 (or be null)");
        }
        TlsSecret tlsSecret = null;
        return this.exportKeyingMaterial13(tlsSecret, string, byArray, n);
    }

    public byte[] exportKeyingMaterial(String string, byte[] byArray, int n) {
        SecurityParameters securityParameters = this.getSecurityParametersConnection();
        if (null == securityParameters) {
            throw new IllegalStateException("Export of key material unavailable before handshake completion");
        }
        if (!securityParameters.isExtendedMasterSecret()) {
            throw new IllegalStateException("cannot export keying material without extended_master_secret");
        }
        if (TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion())) {
            TlsSecret tlsSecret = null;
            return this.exportKeyingMaterial13(tlsSecret, string, byArray, n);
        }
        byte[] byArray2 = TlsUtils.calculateExporterSeed(securityParameters, byArray);
        return TlsUtils.PRF(securityParameters, securityParameters.getMasterSecret(), string, byArray2, n).extract();
    }

    protected byte[] exportKeyingMaterial13(TlsSecret tlsSecret, String string, byte[] byArray, int n) {
        if (byArray == null) {
            byArray = TlsUtils.EMPTY_BYTES;
        }
        throw new UnsupportedOperationException();
    }
}

