/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.util.List;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.KeyStoreBuilderParameters;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.X509ExtendedKeyManager;
import org.bouncycastle.jsse.provider.KeyStoreConfig;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvX509KeyManager;
import org.bouncycastle.jsse.provider.ProvX509KeyManagerSimple;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvKeyManagerFactorySpi
extends KeyManagerFactorySpi {
    private static final Logger LOG = Logger.getLogger(ProvKeyManagerFactorySpi.class.getName());
    protected X509ExtendedKeyManager x509KeyManager = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static KeyStoreConfig getDefaultKeyStore() throws Exception {
        String string = KeyStore.getDefaultType();
        String string2 = null;
        char[] cArray = null;
        String string3 = PropertyUtils.getSystemProperty("javax.net.ssl.keyStore");
        if (!"NONE".equals(string3) && null != string3 && new File(string3).exists()) {
            string2 = string3;
        }
        KeyStore keyStore = ProvKeyManagerFactorySpi.createKeyStore(string);
        String string4 = PropertyUtils.getSystemProperty("javax.net.ssl.keyStorePassword");
        if (null != string4) {
            cArray = string4.toCharArray();
        }
        InputStream inputStream = null;
        try {
            if (null == string2) {
                LOG.info("Initializing empty key store");
            } else {
                LOG.info("Initializing with key store at path: " + string2);
                inputStream = new BufferedInputStream(new FileInputStream(string2));
            }
            keyStore.load(inputStream, cArray);
        }
        finally {
            if (null != inputStream) {
                inputStream.close();
            }
        }
        return new KeyStoreConfig(keyStore, cArray);
    }

    ProvKeyManagerFactorySpi() {
    }

    protected KeyManager[] engineGetKeyManagers() {
        if (null == this.x509KeyManager) {
            throw new IllegalStateException("KeyManagerFactory not initialized");
        }
        return new KeyManager[]{this.x509KeyManager};
    }

    protected void engineInit(KeyStore keyStore, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        this.x509KeyManager = new ProvX509KeyManagerSimple(keyStore, cArray);
    }

    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
        if (!(managerFactoryParameters instanceof KeyStoreBuilderParameters)) {
            throw new InvalidAlgorithmParameterException("Parameters must be instance of KeyStoreBuilderParameters");
        }
        List<KeyStore.Builder> list = ((KeyStoreBuilderParameters)managerFactoryParameters).getParameters();
        this.x509KeyManager = new ProvX509KeyManager(list);
    }

    private static KeyStore createKeyStore(String string) throws NoSuchProviderException, KeyStoreException {
        String string2 = ProvKeyManagerFactorySpi.getKeyStoreType(string);
        String string3 = PropertyUtils.getSystemProperty("javax.net.ssl.keyStoreProvider");
        return null == string3 || string3.length() < 1 ? KeyStore.getInstance(string2) : KeyStore.getInstance(string2, string3);
    }

    private static String getKeyStoreType(String string) {
        String string2 = PropertyUtils.getSystemProperty("javax.net.ssl.keyStoreType");
        return null == string2 ? string : string2;
    }
}

