/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.AlgorithmParameters;
import java.security.Key;
import java.util.Set;
import org.bouncycastle.jsse.java.security.BCCryptoPrimitive;
import org.bouncycastle.jsse.provider.AbstractAlgorithmConstraints;
import org.bouncycastle.jsse.provider.AlgorithmDecomposer;
import org.bouncycastle.jsse.provider.PropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class DisabledAlgorithmConstraints
extends AbstractAlgorithmConstraints {
    private final Set<String> disabledAlgorithms;

    static DisabledAlgorithmConstraints create(AlgorithmDecomposer algorithmDecomposer, String string, String string2) {
        String[] stringArray = PropertyUtils.getStringArraySecurityProperty(string, string2);
        if (null == stringArray) {
            return null;
        }
        return new DisabledAlgorithmConstraints(algorithmDecomposer, DisabledAlgorithmConstraints.asUnmodifiableSet(stringArray));
    }

    private DisabledAlgorithmConstraints(AlgorithmDecomposer algorithmDecomposer, Set<String> set) {
        super(algorithmDecomposer);
        this.disabledAlgorithms = set;
    }

    @Override
    public final boolean permits(Set<BCCryptoPrimitive> set, String string, AlgorithmParameters algorithmParameters) {
        this.checkPrimitives(set);
        this.checkAlgorithmName(string);
        if (this.containsAnyPartIgnoreCase(this.disabledAlgorithms, string)) {
            return false;
        }
        if (null == algorithmParameters) {
            return true;
        }
        return true;
    }

    @Override
    public final boolean permits(Set<BCCryptoPrimitive> set, Key key) {
        return this.checkConstraints(set, "", key, null);
    }

    @Override
    public final boolean permits(Set<BCCryptoPrimitive> set, String string, Key key, AlgorithmParameters algorithmParameters) {
        this.checkAlgorithmName(string);
        return this.checkConstraints(set, string, key, algorithmParameters);
    }

    private boolean checkConstraints(Set<BCCryptoPrimitive> set, String string, Key key, AlgorithmParameters algorithmParameters) {
        this.checkPrimitives(set);
        this.checkKey(key);
        if (this.isAlgorithmSpecified(string) && !this.permits(set, string, algorithmParameters)) {
            return false;
        }
        return this.permits(set, key.getAlgorithm(), null);
    }
}

