/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.builtins.RegExpBuiltins;
import com.oracle.truffle.js.builtins.RegExpPrototypeBuiltins;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSBuiltinObject;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.joni.JoniRegexEngine;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyProxy;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.truffleinterop.JSInteropUtil;
import com.oracle.truffle.js.runtime.util.TRegexUtil;
import java.util.EnumSet;

public final class JSRegExp
extends JSBuiltinObject
implements JSConstructorFactory.Default,
PrototypeSupplier {
    public static final JSRegExp INSTANCE = new JSRegExp();
    public static final String CLASS_NAME = "RegExp";
    public static final String PROTOTYPE_NAME = "RegExp.prototype";
    public static final String MULTILINE = "multiline";
    public static final String GLOBAL = "global";
    public static final String IGNORE_CASE = "ignoreCase";
    public static final String STICKY = "sticky";
    public static final String UNICODE = "unicode";
    public static final String DOT_ALL = "dotAll";
    public static final String SOURCE = "source";
    public static final String FLAGS = "flags";
    public static final String LAST_INDEX = "lastIndex";
    public static final String INPUT = "input";
    public static final String GROUPS = "groups";
    public static final String INDEX = "index";
    private static final HiddenKey COMPILED_REGEX_ID = new HiddenKey("compiledRegex");
    private static final Property COMPILED_REGEX_PROPERTY;
    private static final HiddenKey GROUPS_FACTORY_ID;
    private static final Property GROUPS_FACTORY_PROPERTY;
    private static final Property LAZY_INDEX_PROXY;
    public static final HiddenKey GROUPS_RESULT_ID;
    public static final HiddenKey GROUPS_ORIGINAL_INPUT_ID;
    private static final Property GROUPS_RESULT_PROPERTY;
    private static final Property GROUPS_ORIGINAL_INPUT_PROPERTY;

    private JSRegExp() {
    }

    public static Object getCompiledRegex(DynamicObject thisObj) {
        assert (JSRegExp.isJSRegExp(thisObj));
        return COMPILED_REGEX_PROPERTY.get(thisObj, JSRegExp.isJSRegExp(thisObj));
    }

    public static Object getCompiledRegexUnchecked(DynamicObject thisObj, boolean guard) {
        assert (JSRegExp.isJSRegExp(thisObj));
        return COMPILED_REGEX_PROPERTY.get(thisObj, guard);
    }

    public static JSObjectFactory getGroupsFactory(DynamicObject thisObj) {
        assert (JSRegExp.isJSRegExp(thisObj));
        return (JSObjectFactory)GROUPS_FACTORY_PROPERTY.get(thisObj, JSRegExp.isJSRegExp(thisObj));
    }

    public static JSObjectFactory getGroupsFactoryUnchecked(DynamicObject thisObj, boolean guard) {
        assert (JSRegExp.isJSRegExp(thisObj));
        return (JSObjectFactory)GROUPS_FACTORY_PROPERTY.get(thisObj, guard);
    }

    public static DynamicObject create(JSContext ctx, Object compiledRegex) {
        DynamicObject obj = JSRegExp.create(ctx, compiledRegex, JSRegExp.computeGroupsFactory(ctx, compiledRegex));
        JSObjectUtil.putDataProperty(ctx, obj, LAST_INDEX, 0, JSAttributes.notConfigurableNotEnumerableWritable());
        return obj;
    }

    public static DynamicObject create(JSContext ctx, Object compiledRegex, JSObjectFactory groupsFactory) {
        DynamicObject regExp = JSObject.create(ctx, ctx.getRegExpFactory(), compiledRegex, groupsFactory);
        assert (JSRegExp.isJSRegExp(regExp));
        return regExp;
    }

    private static void initialize(JSContext ctx, DynamicObject regExp, Object regex) {
        COMPILED_REGEX_PROPERTY.setSafe(regExp, regex, null);
        GROUPS_FACTORY_PROPERTY.setSafe(regExp, (Object)JSRegExp.computeGroupsFactory(ctx, regex), null);
    }

    public static void updateCompilation(JSContext ctx, DynamicObject thisObj, Object regex) {
        assert (JSRegExp.isJSRegExp(thisObj) && regex != null);
        JSRegExp.initialize(ctx, thisObj, regex);
    }

    @CompilerDirectives.TruffleBoundary
    private static JSObjectFactory computeGroupsFactory(JSContext ctx, Object compiledRegex) {
        Object namedCaptureGroups = TRegexUtil.InteropReadMemberNode.getUncached().execute(compiledRegex, GROUPS);
        if (TRegexUtil.InteropIsNullNode.getUncached().execute(namedCaptureGroups)) {
            return null;
        }
        return JSRegExp.buildGroupsFactory(ctx, namedCaptureGroups);
    }

    @CompilerDirectives.TruffleBoundary
    public static JSObjectFactory buildGroupsFactory(JSContext ctx, Object namedCaptureGroups) {
        Shape groupsShape = ctx.getEmptyShapeNullPrototype();
        groupsShape = groupsShape.addProperty(GROUPS_RESULT_PROPERTY);
        groupsShape = groupsShape.addProperty(GROUPS_ORIGINAL_INPUT_PROPERTY);
        for (Object key : JSInteropUtil.keys(namedCaptureGroups)) {
            String groupName = (String)key;
            int groupIndex = TRegexUtil.InteropReadIntMemberNode.getUncached().execute(namedCaptureGroups, groupName);
            Property groupProperty = JSObjectUtil.makeProxyProperty(groupName, new LazyNamedCaptureGroupProperty(groupName, groupIndex), JSAttributes.getDefault());
            groupsShape = groupsShape.addProperty(groupProperty);
        }
        return JSObjectFactory.createBound(ctx, Null.instance, groupsShape.createFactory());
    }

    @CompilerDirectives.TruffleBoundary
    public static String prototypeToString(DynamicObject thisObj) {
        Object regex = JSRegExp.getCompiledRegex(thisObj);
        TRegexUtil.InteropReadStringMemberNode readString = TRegexUtil.InteropReadStringMemberNode.getUncached();
        String pattern = readString.execute(regex, "pattern");
        if (pattern.length() == 0) {
            pattern = "(?:)";
        }
        String flags = readString.execute(TRegexUtil.InteropReadMemberNode.getUncached().execute(regex, FLAGS), SOURCE);
        return "/" + pattern + '/' + flags;
    }

    public static boolean isJSRegExp(Object obj) {
        return JSObject.isDynamicObject(obj) && JSRegExp.isJSRegExp((DynamicObject)obj);
    }

    public static boolean isJSRegExp(DynamicObject obj) {
        return JSRegExp.isInstance(obj, (JSClass)INSTANCE);
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        JSContext ctx = realm.getContext();
        DynamicObject prototype = JSObject.createInit(realm, realm.getObjectPrototype(), (JSClass)(ctx.getEcmaScriptVersion() < 6 ? INSTANCE : JSUserObject.INSTANCE));
        if (ctx.getEcmaScriptVersion() < 6) {
            JSObjectUtil.putHiddenProperty(prototype, COMPILED_REGEX_PROPERTY, JSRegExp.compileEarly("", ""));
            JSObjectUtil.putDataProperty(ctx, prototype, LAST_INDEX, 0, JSAttributes.notConfigurableNotEnumerableWritable());
        }
        JSRegExp.putRegExpPropertyAccessor(realm, prototype, SOURCE);
        JSRegExp.putRegExpPropertyAccessor(realm, prototype, FLAGS);
        JSRegExp.putRegExpPropertyAccessor(realm, prototype, MULTILINE);
        JSRegExp.putRegExpPropertyAccessor(realm, prototype, GLOBAL);
        JSRegExp.putRegExpPropertyAccessor(realm, prototype, IGNORE_CASE);
        if (ctx.getEcmaScriptVersion() >= 6) {
            JSRegExp.putRegExpPropertyAccessor(realm, prototype, STICKY);
            JSRegExp.putRegExpPropertyAccessor(realm, prototype, UNICODE);
        }
        if (ctx.getEcmaScriptVersion() >= 9) {
            JSRegExp.putRegExpPropertyAccessor(realm, prototype, DOT_ALL);
        }
        JSObjectUtil.putConstructorProperty(ctx, prototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, RegExpPrototypeBuiltins.BUILTINS);
        return prototype;
    }

    private static void putRegExpPropertyAccessor(JSRealm realm, DynamicObject prototype, String name) {
        DynamicObject getter = realm.lookupFunction(RegExpPrototypeBuiltins.RegExpPrototypeGetterBuiltins.BUILTINS, name);
        JSObjectUtil.putConstantAccessorProperty(realm.getContext(), prototype, name, getter, Undefined.instance);
    }

    private static Object compileEarly(String pattern, String flags) {
        JoniRegexEngine tempEngine = new JoniRegexEngine(null);
        return TRegexUtil.CompileRegexNode.getUncached().execute(tempEngine, pattern, flags);
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, DynamicObject thisObj) {
        return JSObjectUtil.getProtoChildShape(thisObj, INSTANCE, ctx).addProperty(COMPILED_REGEX_PROPERTY).addProperty(GROUPS_FACTORY_PROPERTY);
    }

    public static Shape makeLazyRegexArrayShape(JSContext ctx, DynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, JSArray.INSTANCE, ctx);
        initialShape = JSArray.addArrayProperties(initialShape);
        initialShape = initialShape.addProperty(JSAbstractArray.LAZY_REGEX_RESULT_PROPERTY);
        initialShape = initialShape.addProperty(JSAbstractArray.LAZY_REGEX_ORIGINAL_INPUT_PROPERTY);
        Property inputProperty = JSObjectUtil.makeDataProperty(INPUT, initialShape.allocator().locationForType(String.class, EnumSet.of(LocationModifier.NonNull)), JSAttributes.getDefault());
        initialShape = initialShape.addProperty(inputProperty);
        initialShape = initialShape.addProperty(JSArray.ARRAY_LENGTH_PROXY_PROPERTY);
        initialShape = initialShape.addProperty(LAZY_INDEX_PROXY);
        initialShape = initialShape.addProperty(JSObjectUtil.makeDataProperty(GROUPS, initialShape.allocator().locationForType(DynamicObject.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)), JSAttributes.getDefault()));
        return initialShape;
    }

    @Override
    public void fillConstructor(JSRealm realm, DynamicObject constructor) {
        JSContext context = realm.getContext();
        JSRegExp.putConstructorSpeciesGetter(realm, constructor);
        if (context.isOptionRegexpStaticResult()) {
            if (context.isOptionNashornCompatibilityMode()) {
                JSRegExp.putRegExpStaticPropertyAccessor(realm, constructor, JSContext.BuiltinFunctionKey.RegExpInput, INPUT);
                JSRegExp.putRegExpStaticPropertyAccessor(realm, constructor, JSContext.BuiltinFunctionKey.RegExpMultiLine, MULTILINE);
                JSRegExp.putRegExpStaticPropertyAccessor(realm, constructor, JSContext.BuiltinFunctionKey.RegExpLastMatch, "lastMatch");
                JSRegExp.putRegExpStaticPropertyAccessor(realm, constructor, JSContext.BuiltinFunctionKey.RegExpLastParen, "lastParen");
                JSRegExp.putRegExpStaticPropertyAccessor(realm, constructor, JSContext.BuiltinFunctionKey.RegExpLeftContext, "leftContext");
                JSRegExp.putRegExpStaticPropertyAccessor(realm, constructor, JSContext.BuiltinFunctionKey.RegExpRightContext, "rightContext");
            } else {
                JSRegExp.putRegExpStaticPropertyAccessor(realm, constructor, JSContext.BuiltinFunctionKey.RegExpInput, INPUT);
                JSRegExp.putRegExpStaticPropertyAccessor(realm, constructor, JSContext.BuiltinFunctionKey.RegExpLastMatch, "lastMatch");
                JSRegExp.putRegExpStaticPropertyAccessor(realm, constructor, JSContext.BuiltinFunctionKey.RegExpLastParen, "lastParen");
                JSRegExp.putRegExpStaticPropertyAccessor(realm, constructor, JSContext.BuiltinFunctionKey.RegExpLeftContext, "leftContext");
                JSRegExp.putRegExpStaticPropertyAccessor(realm, constructor, JSContext.BuiltinFunctionKey.RegExpRightContext, "rightContext");
                JSRegExp.putRegExpStaticPropertyAccessor(realm, constructor, JSContext.BuiltinFunctionKey.RegExp$_, INPUT, "$_");
                JSRegExp.putRegExpStaticPropertyAccessor(realm, constructor, JSContext.BuiltinFunctionKey.RegExp$And, "lastMatch", "$&");
                JSRegExp.putRegExpStaticPropertyAccessor(realm, constructor, JSContext.BuiltinFunctionKey.RegExp$Plus, "lastParen", "$+");
                JSRegExp.putRegExpStaticPropertyAccessor(realm, constructor, JSContext.BuiltinFunctionKey.RegExp$Apostrophe, "leftContext", "$`");
                JSRegExp.putRegExpStaticPropertyAccessor(realm, constructor, JSContext.BuiltinFunctionKey.RegExp$Quote, "rightContext", "$'");
            }
            JSRegExp.putRegExpStaticPropertyAccessor(realm, constructor, JSContext.BuiltinFunctionKey.RegExp$1, "$1");
            JSRegExp.putRegExpStaticPropertyAccessor(realm, constructor, JSContext.BuiltinFunctionKey.RegExp$2, "$2");
            JSRegExp.putRegExpStaticPropertyAccessor(realm, constructor, JSContext.BuiltinFunctionKey.RegExp$3, "$3");
            JSRegExp.putRegExpStaticPropertyAccessor(realm, constructor, JSContext.BuiltinFunctionKey.RegExp$4, "$4");
            JSRegExp.putRegExpStaticPropertyAccessor(realm, constructor, JSContext.BuiltinFunctionKey.RegExp$5, "$5");
            JSRegExp.putRegExpStaticPropertyAccessor(realm, constructor, JSContext.BuiltinFunctionKey.RegExp$6, "$6");
            JSRegExp.putRegExpStaticPropertyAccessor(realm, constructor, JSContext.BuiltinFunctionKey.RegExp$7, "$7");
            JSRegExp.putRegExpStaticPropertyAccessor(realm, constructor, JSContext.BuiltinFunctionKey.RegExp$8, "$8");
            JSRegExp.putRegExpStaticPropertyAccessor(realm, constructor, JSContext.BuiltinFunctionKey.RegExp$9, "$9");
        }
    }

    private static void putRegExpStaticPropertyAccessor(JSRealm realm, DynamicObject constructor, JSContext.BuiltinFunctionKey builtinKey, String getterName) {
        JSRegExp.putRegExpStaticPropertyAccessor(realm, constructor, builtinKey, getterName, getterName);
    }

    private static void putRegExpStaticPropertyAccessor(JSRealm realm, DynamicObject constructor, JSContext.BuiltinFunctionKey builtinKey, String getterName, String propertyName) {
        JSContext ctx = realm.getContext();
        DynamicObject getter = realm.lookupFunction(RegExpBuiltins.BUILTINS, getterName);
        String setterName = "set " + propertyName;
        JSFunctionData setterData = ctx.getOrCreateBuiltinFunctionData(builtinKey, c -> JSFunctionData.createCallOnly(c, ctx.getEmptyFunctionCallTarget(), 0, setterName));
        DynamicObject setter = JSFunction.create(realm, setterData);
        JSObjectUtil.putConstantAccessorProperty(ctx, constructor, propertyName, getter, setter, JSRegExp.getRegExpStaticResultPropertyAccessorJSAttributes(ctx));
    }

    private static int getRegExpStaticResultPropertyAccessorJSAttributes(JSContext context) {
        return context.isOptionNashornCompatibilityMode() ? JSAttributes.notConfigurableEnumerableWritable() : JSAttributes.configurableNotEnumerableWritable();
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    @Override
    public String getBuiltinToStringTag(DynamicObject object) {
        return this.getClassName(object);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String safeToString(DynamicObject obj, int depth, JSContext context) {
        if (context.isOptionNashornCompatibilityMode()) {
            return "[RegExp " + JSRegExp.prototypeToString(obj) + "]";
        }
        return JSRegExp.prototypeToString(obj);
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getRegExpPrototype();
    }

    @CompilerDirectives.TruffleBoundary
    public static CharSequence escapeRegExpPattern(CharSequence pattern) {
        if (pattern.length() == 0) {
            return "(?:)";
        }
        int extraChars = JSRegExp.escapeRegExpExtraCharCount(pattern);
        if (extraChars == 0) {
            return pattern;
        }
        return JSRegExp.escapeRegExpPattern(pattern, extraChars);
    }

    private static int escapeRegExpExtraCharCount(CharSequence pattern) {
        int extraChars = 0;
        boolean insideCharClass = false;
        block12: for (int i = 0; i < pattern.length(); ++i) {
            switch (pattern.charAt(i)) {
                case '\\': {
                    assert (i + 1 < pattern.length());
                    switch (pattern.charAt(++i)) {
                        case '\n': 
                        case '\r': {
                            extraChars = Math.max(extraChars, 1);
                            break;
                        }
                        case '\u2028': 
                        case '\u2029': {
                            extraChars += 4;
                        }
                    }
                    continue block12;
                }
                case '\n': 
                case '\r': {
                    ++extraChars;
                    continue block12;
                }
                case '\u2028': 
                case '\u2029': {
                    extraChars += 5;
                    continue block12;
                }
                case '/': {
                    if (insideCharClass) continue block12;
                    ++extraChars;
                    continue block12;
                }
                case '[': {
                    insideCharClass = true;
                    continue block12;
                }
                case ']': {
                    insideCharClass = false;
                }
            }
        }
        return extraChars;
    }

    @CompilerDirectives.TruffleBoundary
    private static String escapeRegExpPattern(CharSequence pattern, int extraChars) {
        StringBuilder sb = new StringBuilder(pattern.length() + extraChars);
        boolean insideCharClass = false;
        block16: for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            switch (c) {
                case '\\': {
                    assert (i + 1 < pattern.length());
                    sb.append(c);
                    c = pattern.charAt(++i);
                    switch (c) {
                        case '\n': {
                            sb.append('n');
                            continue block16;
                        }
                        case '\r': {
                            sb.append('r');
                            continue block16;
                        }
                        case '\u2028': {
                            sb.append("u2028");
                            continue block16;
                        }
                        case '\u2029': {
                            sb.append("u2029");
                            continue block16;
                        }
                    }
                    sb.append(c);
                    continue block16;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block16;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block16;
                }
                case '\u2028': {
                    sb.append("\\u2028");
                    continue block16;
                }
                case '\u2029': {
                    sb.append("\\u2029");
                    continue block16;
                }
                case '/': {
                    if (!insideCharClass) {
                        sb.append("\\/");
                        continue block16;
                    }
                    sb.append('/');
                    continue block16;
                }
                case '[': {
                    insideCharClass = true;
                    sb.append(c);
                    continue block16;
                }
                case ']': {
                    insideCharClass = false;
                    sb.append(c);
                    continue block16;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    static {
        GROUPS_FACTORY_ID = new HiddenKey("groupsFactory");
        LAZY_INDEX_PROXY = JSObjectUtil.makeProxyProperty(INDEX, new LazyRegexResultIndexProxyProperty(), JSAttributes.getDefault());
        GROUPS_RESULT_ID = new HiddenKey("regexResult");
        GROUPS_ORIGINAL_INPUT_ID = new HiddenKey("regexResultOriginalIndex");
        Shape.Allocator regExpAllocator = JSShape.makeAllocator(JSObject.LAYOUT);
        regExpAllocator.addLocation(JSObject.PROTO_PROPERTY.getLocation());
        COMPILED_REGEX_PROPERTY = JSObjectUtil.makeHiddenProperty(COMPILED_REGEX_ID, regExpAllocator.locationForType(Object.class, EnumSet.of(LocationModifier.NonNull)));
        GROUPS_FACTORY_PROPERTY = JSObjectUtil.makeHiddenProperty(GROUPS_FACTORY_ID, regExpAllocator.locationForType(JSObjectFactory.class));
        Shape.Allocator resultAllocator = JSShape.makeAllocator(JSObject.LAYOUT);
        GROUPS_RESULT_PROPERTY = JSObjectUtil.makeHiddenProperty(GROUPS_RESULT_ID, resultAllocator.locationForType(Object.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)));
        GROUPS_ORIGINAL_INPUT_PROPERTY = JSObjectUtil.makeHiddenProperty(GROUPS_ORIGINAL_INPUT_ID, resultAllocator.locationForType(String.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)));
    }

    public static class LazyNamedCaptureGroupProperty
    implements PropertyProxy {
        private final String groupName;
        private final int groupIndex;
        private final TRegexUtil.TRegexMaterializeResultNode materializeNode = TRegexUtil.TRegexMaterializeResultNode.getUncached();

        public LazyNamedCaptureGroupProperty(String groupName, int groupIndex) {
            this.groupName = groupName;
            this.groupIndex = groupIndex;
        }

        public int getGroupIndex() {
            return this.groupIndex;
        }

        @Override
        public Object get(DynamicObject object) {
            Object regexResult = GROUPS_RESULT_PROPERTY.get(object, false);
            String input = (String)GROUPS_ORIGINAL_INPUT_PROPERTY.get(object, false);
            return this.materializeNode.materializeGroup(regexResult, this.groupIndex, input);
        }

        @Override
        public boolean set(DynamicObject object, Object value) {
            JSObjectUtil.defineDataProperty(object, this.groupName, value, JSAttributes.getDefault());
            return true;
        }
    }

    public static class LazyRegexResultIndexProxyProperty
    implements PropertyProxy {
        @Override
        public Object get(DynamicObject object) {
            return TRegexUtil.InvokeGetGroupBoundariesMethodNode.getUncached().execute(JSAbstractArray.arrayGetRegexResult(object), "getStart", 0);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean set(DynamicObject object, Object value) {
            JSObjectUtil.defineDataProperty(object, JSRegExp.INDEX, value, JSAttributes.getDefault());
            return true;
        }
    }
}

