/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.binary.JSBitwiseAndNode;
import com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.LargeInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSBitwiseAndNode.class)
public final class JSBitwiseAndNodeGen
extends JSBitwiseAndNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @Node.Child
    private JSToInt32Node double_leftInt32_;
    @Node.Child
    private JSToInt32Node double_rightInt32_;
    @Node.Child
    private GenericData generic_cache;

    private JSBitwiseAndNodeGen(JavaScriptNode left, JavaScriptNode right) {
        super(left, right);
    }

    @Override
    public Object executeObject(Object leftNodeValue, Object rightNodeValue) {
        GenericData s6_;
        int state = this.state_;
        if ((state & 3) != 0 && rightNodeValue instanceof Integer) {
            int rightNodeValue_ = (Integer)rightNodeValue;
            if ((state & 1) != 0 && leftNodeValue instanceof Integer) {
                int leftNodeValue_ = (Integer)leftNodeValue;
                return this.doInteger(leftNodeValue_, rightNodeValue_);
            }
            if ((state & 2) != 0 && leftNodeValue instanceof LargeInteger) {
                LargeInteger leftNodeValue_ = (LargeInteger)leftNodeValue;
                return this.doLargeIntegerInt(leftNodeValue_, rightNodeValue_);
            }
        }
        if ((state & 4) != 0 && leftNodeValue instanceof Integer) {
            int leftNodeValue_ = (Integer)leftNodeValue;
            if (rightNodeValue instanceof LargeInteger) {
                LargeInteger rightNodeValue_ = (LargeInteger)rightNodeValue;
                return this.doIntLargeInteger(leftNodeValue_, rightNodeValue_);
            }
        }
        if ((state & 8) != 0 && JSTypesGen.isImplicitDouble((state & 0x3C0) >>> 6, leftNodeValue)) {
            double leftNodeValue_ = JSTypesGen.asImplicitDouble((state & 0x3C0) >>> 6, leftNodeValue);
            if (JSTypesGen.isImplicitDouble((state & 0x3C00) >>> 10, rightNodeValue)) {
                double rightNodeValue_ = JSTypesGen.asImplicitDouble((state & 0x3C00) >>> 10, rightNodeValue);
                return this.doDouble(leftNodeValue_, rightNodeValue_, this.double_leftInt32_, this.double_rightInt32_);
            }
        }
        if ((state & 0x10) != 0 && leftNodeValue instanceof BigInt) {
            BigInt leftNodeValue_ = (BigInt)leftNodeValue;
            if (rightNodeValue instanceof BigInt) {
                BigInt rightNodeValue_ = (BigInt)rightNodeValue;
                return this.doBigInt(leftNodeValue_, rightNodeValue_);
            }
        }
        if ((state & 0x20) != 0 && (s6_ = this.generic_cache) != null) {
            return this.doGeneric(leftNodeValue, rightNodeValue, s6_.leftNumeric_, s6_.rightNumeric_, s6_.and_, s6_.mixedNumericTypes_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 0x3E) == 0 && (state & 0x3F) != 0) {
            return this.execute_int_int0(frameValue, state);
        }
        if ((state & 0x37) == 0 && (state & 0x3F) != 0) {
            return this.execute_double_double1(frameValue, state);
        }
        if ((state & 0x3D) == 0 && (state & 0x3F) != 0) {
            return this.execute_int2(frameValue, state);
        }
        if ((state & 0x3B) == 0 && (state & 0x3F) != 0) {
            return this.execute_int3(frameValue, state);
        }
        return this.execute_generic4(frameValue, state);
    }

    private Object execute_int_int0(VirtualFrame frameValue, int state) {
        int rightNodeValue_;
        int leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state & 1) != 0);
        return this.doInteger(leftNodeValue_, rightNodeValue_);
    }

    private Object execute_double_double1(VirtualFrame frameValue, int state) {
        double rightNodeValue_;
        double leftNodeValue_;
        int leftNodeValue_int = 0;
        long leftNodeValue_long = 0L;
        try {
            if ((state & 0x380) == 0 && (state & 0x3F) != 0) {
                leftNodeValue_long = this.leftNode.executeLong(frameValue);
                leftNodeValue_ = JSTypes.longToDouble(leftNodeValue_long);
            } else if ((state & 0x340) == 0 && (state & 0x3F) != 0) {
                leftNodeValue_int = this.leftNode.executeInt(frameValue);
                leftNodeValue_ = JSTypes.intToDouble(leftNodeValue_int);
            } else if ((state & 0x2C0) == 0 && (state & 0x3F) != 0) {
                leftNodeValue_ = this.leftNode.executeDouble(frameValue);
            } else {
                Object leftNodeValue__ = this.leftNode.execute(frameValue);
                leftNodeValue_ = JSTypesGen.expectImplicitDouble((state & 0x3C0) >>> 6, leftNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        int rightNodeValue_int = 0;
        long rightNodeValue_long = 0L;
        try {
            if ((state & 0x3800) == 0 && (state & 0x3F) != 0) {
                rightNodeValue_long = this.rightNode.executeLong(frameValue);
                rightNodeValue_ = JSTypes.longToDouble(rightNodeValue_long);
            } else if ((state & 0x3400) == 0 && (state & 0x3F) != 0) {
                rightNodeValue_int = this.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else if ((state & 0x2C00) == 0 && (state & 0x3F) != 0) {
                rightNodeValue_ = this.rightNode.executeDouble(frameValue);
            } else {
                Object rightNodeValue__ = this.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((state & 0x3C00) >>> 10, rightNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize((state & 0x380) == 0 && (state & 0x3F) != 0 ? (Number)leftNodeValue_long : (Number)((state & 0x340) == 0 && (state & 0x3F) != 0 ? (Number)leftNodeValue_int : (Number)leftNodeValue_), ex.getResult());
        }
        assert ((state & 8) != 0);
        return this.doDouble(leftNodeValue_, rightNodeValue_, this.double_leftInt32_, this.double_rightInt32_);
    }

    private Object execute_int2(VirtualFrame frameValue, int state) {
        int rightNodeValue_;
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        try {
            rightNodeValue_ = this.rightNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state & 2) != 0);
        if (leftNodeValue_ instanceof LargeInteger) {
            LargeInteger leftNodeValue__ = (LargeInteger)leftNodeValue_;
            return this.doLargeIntegerInt(leftNodeValue__, rightNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    private Object execute_int3(VirtualFrame frameValue, int state) {
        int leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        assert ((state & 4) != 0);
        if (rightNodeValue_ instanceof LargeInteger) {
            LargeInteger rightNodeValue__ = (LargeInteger)rightNodeValue_;
            return this.doIntLargeInteger(leftNodeValue_, rightNodeValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    private Object execute_generic4(VirtualFrame frameValue, int state) {
        GenericData s6_;
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        if ((state & 3) != 0 && rightNodeValue_ instanceof Integer) {
            int rightNodeValue__ = (Integer)rightNodeValue_;
            if ((state & 1) != 0 && leftNodeValue_ instanceof Integer) {
                int leftNodeValue__ = (Integer)leftNodeValue_;
                return this.doInteger(leftNodeValue__, rightNodeValue__);
            }
            if ((state & 2) != 0 && leftNodeValue_ instanceof LargeInteger) {
                LargeInteger leftNodeValue__ = (LargeInteger)leftNodeValue_;
                return this.doLargeIntegerInt(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state & 4) != 0 && leftNodeValue_ instanceof Integer) {
            int leftNodeValue__ = (Integer)leftNodeValue_;
            if (rightNodeValue_ instanceof LargeInteger) {
                LargeInteger rightNodeValue__ = (LargeInteger)rightNodeValue_;
                return this.doIntLargeInteger(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state & 8) != 0 && JSTypesGen.isImplicitDouble((state & 0x3C0) >>> 6, leftNodeValue_)) {
            double leftNodeValue__ = JSTypesGen.asImplicitDouble((state & 0x3C0) >>> 6, leftNodeValue_);
            if (JSTypesGen.isImplicitDouble((state & 0x3C00) >>> 10, rightNodeValue_)) {
                double rightNodeValue__ = JSTypesGen.asImplicitDouble((state & 0x3C00) >>> 10, rightNodeValue_);
                return this.doDouble(leftNodeValue__, rightNodeValue__, this.double_leftInt32_, this.double_rightInt32_);
            }
        }
        if ((state & 0x10) != 0 && leftNodeValue_ instanceof BigInt) {
            BigInt leftNodeValue__ = (BigInt)leftNodeValue_;
            if (rightNodeValue_ instanceof BigInt) {
                BigInt rightNodeValue__ = (BigInt)rightNodeValue_;
                return this.doBigInt(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state & 0x20) != 0 && (s6_ = this.generic_cache) != null) {
            return this.doGeneric(leftNodeValue_, rightNodeValue_, s6_.leftNumeric_, s6_.rightNumeric_, s6_.and_, s6_.mixedNumericTypes_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    @Override
    public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
        int state = this.state_;
        if ((state & 0x20) != 0) {
            return JSTypesGen.expectInteger(this.execute(frameValue));
        }
        if ((state & 0xE) == 0 && (state & 0xF) != 0) {
            return this.executeInt_int_int5(frameValue, state);
        }
        if ((state & 7) == 0 && (state & 0xF) != 0) {
            return this.executeInt_double_double6(frameValue, state);
        }
        if ((state & 0xD) == 0 && (state & 0xF) != 0) {
            return this.executeInt_int7(frameValue, state);
        }
        if ((state & 0xB) == 0 && (state & 0xF) != 0) {
            return this.executeInt_int8(frameValue, state);
        }
        return this.executeInt_generic9(frameValue, state);
    }

    private int executeInt_int_int5(VirtualFrame frameValue, int state) throws UnexpectedResultException {
        int rightNodeValue_;
        int leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return JSTypesGen.expectInteger(this.executeAndSpecialize(ex.getResult(), rightNodeValue));
        }
        try {
            rightNodeValue_ = this.rightNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectInteger(this.executeAndSpecialize(leftNodeValue_, ex.getResult()));
        }
        assert ((state & 1) != 0);
        return this.doInteger(leftNodeValue_, rightNodeValue_);
    }

    private int executeInt_double_double6(VirtualFrame frameValue, int state) throws UnexpectedResultException {
        double rightNodeValue_;
        double leftNodeValue_;
        int leftNodeValue_int = 0;
        long leftNodeValue_long = 0L;
        try {
            if ((state & 0x380) == 0 && (state & 0x3F) != 0) {
                leftNodeValue_long = this.leftNode.executeLong(frameValue);
                leftNodeValue_ = JSTypes.longToDouble(leftNodeValue_long);
            } else if ((state & 0x340) == 0 && (state & 0x3F) != 0) {
                leftNodeValue_int = this.leftNode.executeInt(frameValue);
                leftNodeValue_ = JSTypes.intToDouble(leftNodeValue_int);
            } else if ((state & 0x2C0) == 0 && (state & 0x3F) != 0) {
                leftNodeValue_ = this.leftNode.executeDouble(frameValue);
            } else {
                Object leftNodeValue__ = this.leftNode.execute(frameValue);
                leftNodeValue_ = JSTypesGen.expectImplicitDouble((state & 0x3C0) >>> 6, leftNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return JSTypesGen.expectInteger(this.executeAndSpecialize(ex.getResult(), rightNodeValue));
        }
        int rightNodeValue_int = 0;
        long rightNodeValue_long = 0L;
        try {
            if ((state & 0x3800) == 0 && (state & 0x3F) != 0) {
                rightNodeValue_long = this.rightNode.executeLong(frameValue);
                rightNodeValue_ = JSTypes.longToDouble(rightNodeValue_long);
            } else if ((state & 0x3400) == 0 && (state & 0x3F) != 0) {
                rightNodeValue_int = this.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else if ((state & 0x2C00) == 0 && (state & 0x3F) != 0) {
                rightNodeValue_ = this.rightNode.executeDouble(frameValue);
            } else {
                Object rightNodeValue__ = this.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((state & 0x3C00) >>> 10, rightNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectInteger(this.executeAndSpecialize((state & 0x380) == 0 && (state & 0x3F) != 0 ? (Number)leftNodeValue_long : (Number)((state & 0x340) == 0 && (state & 0x3F) != 0 ? (Number)leftNodeValue_int : (Number)leftNodeValue_), ex.getResult()));
        }
        assert ((state & 8) != 0);
        return this.doDouble(leftNodeValue_, rightNodeValue_, this.double_leftInt32_, this.double_rightInt32_);
    }

    private int executeInt_int7(VirtualFrame frameValue, int state) throws UnexpectedResultException {
        int rightNodeValue_;
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        try {
            rightNodeValue_ = this.rightNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectInteger(this.executeAndSpecialize(leftNodeValue_, ex.getResult()));
        }
        assert ((state & 2) != 0);
        if (leftNodeValue_ instanceof LargeInteger) {
            LargeInteger leftNodeValue__ = (LargeInteger)leftNodeValue_;
            return this.doLargeIntegerInt(leftNodeValue__, rightNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
    }

    private int executeInt_int8(VirtualFrame frameValue, int state) throws UnexpectedResultException {
        int leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return JSTypesGen.expectInteger(this.executeAndSpecialize(ex.getResult(), rightNodeValue));
        }
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        assert ((state & 4) != 0);
        if (rightNodeValue_ instanceof LargeInteger) {
            LargeInteger rightNodeValue__ = (LargeInteger)rightNodeValue_;
            return this.doIntLargeInteger(leftNodeValue_, rightNodeValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
    }

    private int executeInt_generic9(VirtualFrame frameValue, int state) throws UnexpectedResultException {
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        if ((state & 3) != 0 && rightNodeValue_ instanceof Integer) {
            int rightNodeValue__ = (Integer)rightNodeValue_;
            if ((state & 1) != 0 && leftNodeValue_ instanceof Integer) {
                int leftNodeValue__ = (Integer)leftNodeValue_;
                return this.doInteger(leftNodeValue__, rightNodeValue__);
            }
            if ((state & 2) != 0 && leftNodeValue_ instanceof LargeInteger) {
                LargeInteger leftNodeValue__ = (LargeInteger)leftNodeValue_;
                return this.doLargeIntegerInt(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state & 4) != 0 && leftNodeValue_ instanceof Integer) {
            int leftNodeValue__ = (Integer)leftNodeValue_;
            if (rightNodeValue_ instanceof LargeInteger) {
                LargeInteger rightNodeValue__ = (LargeInteger)rightNodeValue_;
                return this.doIntLargeInteger(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state & 8) != 0 && JSTypesGen.isImplicitDouble((state & 0x3C0) >>> 6, leftNodeValue_)) {
            double leftNodeValue__ = JSTypesGen.asImplicitDouble((state & 0x3C0) >>> 6, leftNodeValue_);
            if (JSTypesGen.isImplicitDouble((state & 0x3C00) >>> 10, rightNodeValue_)) {
                double rightNodeValue__ = JSTypesGen.asImplicitDouble((state & 0x3C00) >>> 10, rightNodeValue_);
                return this.doDouble(leftNodeValue__, rightNodeValue__, this.double_leftInt32_, this.double_rightInt32_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state = this.state_;
        try {
            if ((state & 0x30) == 0 && (state & 0x3F) != 0) {
                this.executeInt(frameValue);
                return;
            }
            this.execute(frameValue);
            return;
        }
        catch (UnexpectedResultException ex) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            int doubleCast0;
            if (rightNodeValue instanceof Integer) {
                int rightNodeValue_ = (Integer)rightNodeValue;
                if ((exclude & 1) == 0 && leftNodeValue instanceof Integer) {
                    int leftNodeValue_ = (Integer)leftNodeValue;
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    Integer n = this.doInteger(leftNodeValue_, rightNodeValue_);
                    return n;
                }
                if ((exclude & 2) == 0 && leftNodeValue instanceof LargeInteger) {
                    LargeInteger leftNodeValue_ = (LargeInteger)leftNodeValue;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    Integer n = this.doLargeIntegerInt(leftNodeValue_, rightNodeValue_);
                    return n;
                }
            }
            if ((exclude & 4) == 0 && leftNodeValue instanceof Integer) {
                int leftNodeValue_ = (Integer)leftNodeValue;
                if (rightNodeValue instanceof LargeInteger) {
                    LargeInteger rightNodeValue_ = (LargeInteger)rightNodeValue;
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    Integer n = this.doIntLargeInteger(leftNodeValue_, rightNodeValue_);
                    return n;
                }
            }
            if ((exclude & 8) == 0 && (doubleCast0 = JSTypesGen.specializeImplicitDouble(leftNodeValue)) != 0) {
                double leftNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast0, leftNodeValue);
                int doubleCast1 = JSTypesGen.specializeImplicitDouble(rightNodeValue);
                if (doubleCast1 != 0) {
                    double rightNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast1, rightNodeValue);
                    this.double_leftInt32_ = (JSToInt32Node)super.insert((Node)JSToInt32Node.create());
                    this.double_rightInt32_ = (JSToInt32Node)super.insert((Node)JSToInt32Node.create());
                    state |= doubleCast0 << 6;
                    state |= doubleCast1 << 10;
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    Integer n = this.doDouble(leftNodeValue_, rightNodeValue_, this.double_leftInt32_, this.double_rightInt32_);
                    return n;
                }
            }
            if ((exclude & 0x10) == 0 && leftNodeValue instanceof BigInt) {
                BigInt leftNodeValue_ = (BigInt)leftNodeValue;
                if (rightNodeValue instanceof BigInt) {
                    BigInt rightNodeValue_ = (BigInt)rightNodeValue;
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    BigInt bigInt = this.doBigInt(leftNodeValue_, rightNodeValue_);
                    return bigInt;
                }
            }
            GenericData s6_ = (GenericData)super.insert((Node)new GenericData());
            s6_.leftNumeric_ = s6_.insertAccessor(JSToNumericNode.create());
            s6_.rightNumeric_ = s6_.insertAccessor(JSToNumericNode.create());
            s6_.and_ = s6_.insertAccessor(JSBitwiseAndNode.createInner());
            s6_.mixedNumericTypes_ = BranchProfile.create();
            this.generic_cache = s6_;
            this.exclude_ = exclude |= 0x1F;
            state &= 0xFFFFFFE0;
            this.state_ = state |= 0x20;
            lock.unlock();
            hasLock = false;
            Object object = this.doGeneric(leftNodeValue, rightNodeValue, s6_.leftNumeric_, s6_.rightNumeric_, s6_.and_, s6_.mixedNumericTypes_);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 0x3F) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0x3F & (state & 0x3F) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[7];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doInteger";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : ((exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[1] = s;
        s = new Object[3];
        s[0] = "doLargeIntegerInt";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : ((exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[2] = s;
        s = new Object[3];
        s[0] = "doIntLargeInteger";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : ((exclude & 4) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[3] = s;
        s = new Object[3];
        s[0] = "doDouble";
        if ((state & 8) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            cached.add(Arrays.asList(this.double_leftInt32_, this.double_rightInt32_));
            s[2] = cached;
        } else {
            s[1] = (exclude & 8) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[4] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : ((exclude & 0x10) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[5] = s;
        s = new Object[3];
        s[0] = "doGeneric";
        if ((state & 0x20) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            GenericData s6_ = this.generic_cache;
            if (s6_ != null) {
                cached.add(Arrays.asList(new Cloneable[]{s6_.leftNumeric_, s6_.rightNumeric_, s6_.and_, s6_.mixedNumericTypes_}));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[6] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static JSBitwiseAndNode create(JavaScriptNode left, JavaScriptNode right) {
        return new JSBitwiseAndNodeGen(left, right);
    }

    @GeneratedBy(value=JSBitwiseAndNode.class)
    private static final class GenericData
    extends Node {
        @Node.Child
        JSToNumericNode leftNumeric_;
        @Node.Child
        JSToNumericNode rightNumeric_;
        @Node.Child
        JSBitwiseAndNode and_;
        @CompilerDirectives.CompilationFinal
        BranchProfile mixedNumericTypes_;

        GenericData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

