/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.HasHiddenKeyCacheNode;
import com.oracle.truffle.js.nodes.access.PrivateFieldSetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=PrivateFieldSetNode.class)
public final class PrivateFieldSetNodeGen
extends PrivateFieldSetNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @Node.Child
    private CachedKeyData cachedKey_cache;

    private PrivateFieldSetNodeGen(JavaScriptNode targetNode, JavaScriptNode keyNode, JavaScriptNode valueNode, JSContext context) {
        super(targetNode, keyNode, valueNode, context);
    }

    @Override
    public Object execute(Object targetNodeValue, Object keyNodeValue, Object valueNodeValue) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 3) != 0 && JSTypes.isDynamicObject(targetNodeValue)) {
                DynamicObject targetNodeValue_ = (DynamicObject)targetNodeValue;
                if (keyNodeValue instanceof HiddenKey) {
                    CachedKeyData s1_;
                    HiddenKey keyNodeValue_ = (HiddenKey)keyNodeValue;
                    if ((state & 1) != 0 && (s1_ = this.cachedKey_cache) != null && keyNodeValue_ == s1_.cachedKey_ && JSGuards.isJSObject(targetNodeValue_)) {
                        return this.doCachedKey(targetNodeValue_, keyNodeValue_, valueNodeValue, s1_.cachedKey_, s1_.hasNode_, s1_.setNode_);
                    }
                    if ((state & 2) != 0 && JSGuards.isJSObject(targetNodeValue_)) {
                        return this.doUncachedKey(targetNodeValue_, keyNodeValue_, valueNodeValue);
                    }
                }
            }
            if ((state & 4) != 0 && PrivateFieldSetNodeGen.fallbackGuard_(targetNodeValue, keyNodeValue, valueNodeValue)) {
                return this.doFallback(targetNodeValue, keyNodeValue, valueNodeValue);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(targetNodeValue, keyNodeValue, valueNodeValue);
    }

    @Override
    public Object executeWithTarget(VirtualFrame frameValue, Object targetNodeValue) {
        int state = this.state_;
        Object keyNodeValue_ = this.keyNode.execute(frameValue);
        Object valueNodeValue_ = this.valueNode.execute(frameValue);
        if (state != 0) {
            if ((state & 3) != 0 && JSTypes.isDynamicObject(targetNodeValue)) {
                DynamicObject targetNodeValue_ = (DynamicObject)targetNodeValue;
                if (keyNodeValue_ instanceof HiddenKey) {
                    CachedKeyData s1_;
                    HiddenKey keyNodeValue__ = (HiddenKey)keyNodeValue_;
                    if ((state & 1) != 0 && (s1_ = this.cachedKey_cache) != null && keyNodeValue__ == s1_.cachedKey_ && JSGuards.isJSObject(targetNodeValue_)) {
                        return this.doCachedKey(targetNodeValue_, keyNodeValue__, valueNodeValue_, s1_.cachedKey_, s1_.hasNode_, s1_.setNode_);
                    }
                    if ((state & 2) != 0 && JSGuards.isJSObject(targetNodeValue_)) {
                        return this.doUncachedKey(targetNodeValue_, keyNodeValue__, valueNodeValue_);
                    }
                }
            }
            if ((state & 4) != 0 && PrivateFieldSetNodeGen.fallbackGuard_(targetNodeValue, keyNodeValue_, valueNodeValue_)) {
                return this.doFallback(targetNodeValue, keyNodeValue_, valueNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(targetNodeValue, keyNodeValue_, valueNodeValue_);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        Object targetNodeValue_ = this.targetNode.execute(frameValue);
        Object keyNodeValue_ = this.keyNode.execute(frameValue);
        Object valueNodeValue_ = this.valueNode.execute(frameValue);
        if (state != 0) {
            if ((state & 3) != 0 && JSTypes.isDynamicObject(targetNodeValue_)) {
                DynamicObject targetNodeValue__ = (DynamicObject)targetNodeValue_;
                if (keyNodeValue_ instanceof HiddenKey) {
                    CachedKeyData s1_;
                    HiddenKey keyNodeValue__ = (HiddenKey)keyNodeValue_;
                    if ((state & 1) != 0 && (s1_ = this.cachedKey_cache) != null && keyNodeValue__ == s1_.cachedKey_ && JSGuards.isJSObject(targetNodeValue__)) {
                        return this.doCachedKey(targetNodeValue__, keyNodeValue__, valueNodeValue_, s1_.cachedKey_, s1_.hasNode_, s1_.setNode_);
                    }
                    if ((state & 2) != 0 && JSGuards.isJSObject(targetNodeValue__)) {
                        return this.doUncachedKey(targetNodeValue__, keyNodeValue__, valueNodeValue_);
                    }
                }
            }
            if ((state & 4) != 0 && PrivateFieldSetNodeGen.fallbackGuard_(targetNodeValue_, keyNodeValue_, valueNodeValue_)) {
                return this.doFallback(targetNodeValue_, keyNodeValue_, valueNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(targetNodeValue_, keyNodeValue_, valueNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.execute(frameValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object targetNodeValue, Object keyNodeValue, Object valueNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (JSTypes.isDynamicObject(targetNodeValue)) {
                DynamicObject targetNodeValue_ = (DynamicObject)targetNodeValue;
                if (keyNodeValue instanceof HiddenKey) {
                    HiddenKey keyNodeValue_ = (HiddenKey)keyNodeValue;
                    if (exclude == 0) {
                        CachedKeyData s1_ = this.cachedKey_cache;
                        boolean CachedKey_duplicateFound_ = false;
                        if ((state & 1) != 0 && keyNodeValue_ == s1_.cachedKey_ && JSGuards.isJSObject(targetNodeValue_)) {
                            CachedKey_duplicateFound_ = true;
                        }
                        if (!CachedKey_duplicateFound_ && JSGuards.isJSObject(targetNodeValue_) && (state & 1) == 0) {
                            s1_ = (CachedKeyData)super.insert((Node)new CachedKeyData());
                            s1_.cachedKey_ = keyNodeValue_;
                            s1_.hasNode_ = s1_.insertAccessor(HasHiddenKeyCacheNode.create(keyNodeValue_));
                            s1_.setNode_ = s1_.insertAccessor(PropertySetNode.createSetHidden(keyNodeValue_, this.context));
                            this.cachedKey_cache = s1_;
                            this.state_ = state |= 1;
                            CachedKey_duplicateFound_ = true;
                        }
                        if (CachedKey_duplicateFound_) {
                            lock.unlock();
                            hasLock = false;
                            Object object = this.doCachedKey(targetNodeValue_, keyNodeValue_, valueNodeValue, s1_.cachedKey_, s1_.hasNode_, s1_.setNode_);
                            return object;
                        }
                    }
                    if (JSGuards.isJSObject(targetNodeValue_)) {
                        this.exclude_ = exclude |= 1;
                        this.cachedKey_cache = null;
                        state &= 0xFFFFFFFE;
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        Object object = this.doUncachedKey(targetNodeValue_, keyNodeValue_, valueNodeValue);
                        return object;
                    }
                }
            }
            this.state_ = state |= 4;
            lock.unlock();
            hasLock = false;
            Object object = this.doFallback(targetNodeValue, keyNodeValue, valueNodeValue);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        Object[] data = new Object[4];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doCachedKey";
        if ((state & 1) != 0) {
            s[1] = (byte)1;
            ArrayList<List<Object>> cached = new ArrayList<List<Object>>();
            CachedKeyData s1_ = this.cachedKey_cache;
            if (s1_ != null) {
                cached.add(Arrays.asList(new Object[]{s1_.cachedKey_, s1_.hasNode_, s1_.setNode_}));
            }
            s[2] = cached;
        } else {
            s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doUncachedKey";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doFallback";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        return Introspection.Provider.create((Object[])data);
    }

    private static boolean fallbackGuard_(Object targetNodeValue, Object keyNodeValue, Object valueNodeValue) {
        DynamicObject targetNodeValue_;
        return !JSTypes.isDynamicObject(targetNodeValue) || !(keyNodeValue instanceof HiddenKey) || !JSGuards.isJSObject(targetNodeValue_ = (DynamicObject)targetNodeValue);
    }

    public static PrivateFieldSetNode create(JavaScriptNode targetNode, JavaScriptNode keyNode, JavaScriptNode valueNode, JSContext context) {
        return new PrivateFieldSetNodeGen(targetNode, keyNode, valueNode, context);
    }

    @GeneratedBy(value=PrivateFieldSetNode.class)
    private static final class CachedKeyData
    extends Node {
        @CompilerDirectives.CompilationFinal
        HiddenKey cachedKey_;
        @Node.Child
        HasHiddenKeyCacheNode hasNode_;
        @Node.Child
        PropertySetNode setNode_;

        CachedKeyData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

