/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.ReadNode;
import com.oracle.truffle.js.nodes.access.HasHiddenKeyCacheNode;
import com.oracle.truffle.js.nodes.access.JSTargetableNode;
import com.oracle.truffle.js.nodes.access.PrivateFieldGetNodeGen;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Objects;

public abstract class PrivateFieldGetNode
extends JSTargetableNode
implements ReadNode {
    @Node.Child
    @Executed
    protected JavaScriptNode targetNode;
    @Node.Child
    @Executed
    protected JavaScriptNode keyNode;
    protected final JSContext context;

    public static PrivateFieldGetNode create(JavaScriptNode targetNode, JavaScriptNode keyNode, JSContext context) {
        return PrivateFieldGetNodeGen.create(targetNode, keyNode, context);
    }

    protected PrivateFieldGetNode(JavaScriptNode targetNode, JavaScriptNode keyNode, JSContext context) {
        this.targetNode = targetNode;
        this.keyNode = keyNode;
        this.context = context;
    }

    @Specialization(guards={"key == cachedKey", "isJSObject(target)"}, limit="1")
    Object doCachedKey(DynamicObject target, HiddenKey key, @Cached(value="key") HiddenKey cachedKey, @Cached(value="create(key)") HasHiddenKeyCacheNode hasNode, @Cached(value="createGetHidden(key, context)") PropertyGetNode getNode) {
        if (hasNode.executeHasHiddenKey(target)) {
            return getNode.getValue(target);
        }
        return this.missing(key);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isJSObject(target)"}, replaces={"doCachedKey"})
    Object doUncachedKey(DynamicObject target, HiddenKey key) {
        if (target.containsKey((Object)key)) {
            return target.get((Object)key, (Object)Undefined.instance);
        }
        return this.missing(key);
    }

    @CompilerDirectives.TruffleBoundary
    private Object missing(HiddenKey key) {
        throw Errors.createTypeErrorCannotGetPrivateMember(key.getName(), this);
    }

    @CompilerDirectives.TruffleBoundary
    @Fallback
    Object doFallback(Object target, Object key) {
        throw Errors.createTypeErrorCannotGetProperty(this.context, this.keyAsString(), target, false, this);
    }

    @CompilerDirectives.TruffleBoundary
    private String keyAsString() {
        return this.keyNode.expressionToString();
    }

    @Override
    public final JavaScriptNode getTarget() {
        return this.targetNode;
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return PrivateFieldGetNode.create(PrivateFieldGetNode.cloneUninitialized(this.targetNode), PrivateFieldGetNode.cloneUninitialized(this.keyNode), this.context);
    }

    @Override
    public String expressionToString() {
        if (this.targetNode != null && this.keyNode != null) {
            return Objects.toString(this.targetNode.expressionToString(), "(intermediate value)") + "." + Objects.toString(this.keyAsString(), "(intermediate value)");
        }
        return null;
    }
}

