/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSWriteScopeFrameSlotNode;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.runtime.LargeInteger;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSWriteScopeFrameSlotNode.class)
final class JSWriteScopeFrameSlotNodeGen
extends JSWriteScopeFrameSlotNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;

    private JSWriteScopeFrameSlotNodeGen(FrameSlot frameSlot, ScopeFrameNode scopeFrameNode, JavaScriptNode rhsNode) {
        super(frameSlot, scopeFrameNode, rhsNode);
    }

    @Override
    Object executeEvaluated(VirtualFrame frameValue, Frame scopeFrameNodeValue, Object rhsNodeValue) {
        int state = this.state_;
        if ((state & 0x7F) != 0) {
            int rhsNodeValue_;
            if ((state & 1) != 0 && rhsNodeValue instanceof Boolean) {
                rhsNodeValue_ = ((Boolean)rhsNodeValue).booleanValue();
                if (this.isBooleanKind(scopeFrameNodeValue)) {
                    return this.doBoolean(scopeFrameNodeValue, rhsNodeValue_ != 0);
                }
            }
            if ((state & 6) != 0 && rhsNodeValue instanceof Integer) {
                rhsNodeValue_ = (Integer)rhsNodeValue;
                if ((state & 2) != 0 && this.isIntegerKind(scopeFrameNodeValue)) {
                    return this.doInteger(scopeFrameNodeValue, rhsNodeValue_);
                }
                if ((state & 4) != 0 && this.isLongKind(scopeFrameNodeValue)) {
                    return this.doLargeIntegerInt(scopeFrameNodeValue, rhsNodeValue_);
                }
            }
            if ((state & 8) != 0 && rhsNodeValue instanceof LargeInteger) {
                LargeInteger rhsNodeValue_2 = (LargeInteger)rhsNodeValue;
                if (this.isLongKind(scopeFrameNodeValue)) {
                    return this.doLargeInteger(scopeFrameNodeValue, rhsNodeValue_2);
                }
            }
            if ((state & 0x10) != 0 && rhsNodeValue instanceof Long) {
                long rhsNodeValue_3 = (Long)rhsNodeValue;
                if (this.ensureObjectKind(scopeFrameNodeValue)) {
                    return this.doLong(scopeFrameNodeValue, rhsNodeValue_3);
                }
            }
            if ((state & 0x20) != 0 && JSTypesGen.isImplicitDouble((state & 0x780) >>> 7, rhsNodeValue)) {
                double rhsNodeValue_4 = JSTypesGen.asImplicitDouble((state & 0x780) >>> 7, rhsNodeValue);
                if (this.isDoubleKind(scopeFrameNodeValue)) {
                    return this.doDouble(scopeFrameNodeValue, rhsNodeValue_4);
                }
            }
            if ((state & 0x40) != 0 && this.ensureObjectKind(scopeFrameNodeValue)) {
                return this.doObject(scopeFrameNodeValue, rhsNodeValue);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(scopeFrameNodeValue, rhsNodeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        Frame scopeFrameNodeValue_ = this.scopeFrameNode.executeFrame((Frame)frameValue);
        if ((state & 0x7E) == 0 && (state & 0x7F) != 0) {
            return this.execute_boolean0(frameValue, state, scopeFrameNodeValue_);
        }
        if ((state & 0x79) == 0 && (state & 0x7F) != 0) {
            return this.execute_int1(frameValue, state, scopeFrameNodeValue_);
        }
        if ((state & 0x6F) == 0 && (state & 0x7F) != 0) {
            return this.execute_long2(frameValue, state, scopeFrameNodeValue_);
        }
        if ((state & 0x5F) == 0 && (state & 0x7F) != 0) {
            return this.execute_double3(frameValue, state, scopeFrameNodeValue_);
        }
        return this.execute_generic4(frameValue, state, scopeFrameNodeValue_);
    }

    private Object execute_boolean0(VirtualFrame frameValue, int state, Frame scopeFrameNodeValue_) {
        boolean rhsNodeValue_;
        try {
            rhsNodeValue_ = this.rhsNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(scopeFrameNodeValue_, ex.getResult());
        }
        assert ((state & 1) != 0);
        if (this.isBooleanKind(scopeFrameNodeValue_)) {
            return this.doBoolean(scopeFrameNodeValue_, rhsNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(scopeFrameNodeValue_, rhsNodeValue_);
    }

    private Object execute_int1(VirtualFrame frameValue, int state, Frame scopeFrameNodeValue_) {
        int rhsNodeValue_;
        try {
            rhsNodeValue_ = this.rhsNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(scopeFrameNodeValue_, ex.getResult());
        }
        if ((state & 6) != 0) {
            if ((state & 2) != 0 && this.isIntegerKind(scopeFrameNodeValue_)) {
                return this.doInteger(scopeFrameNodeValue_, rhsNodeValue_);
            }
            if ((state & 4) != 0 && this.isLongKind(scopeFrameNodeValue_)) {
                return this.doLargeIntegerInt(scopeFrameNodeValue_, rhsNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(scopeFrameNodeValue_, rhsNodeValue_);
    }

    private Object execute_long2(VirtualFrame frameValue, int state, Frame scopeFrameNodeValue_) {
        long rhsNodeValue_;
        try {
            rhsNodeValue_ = this.rhsNode.executeLong(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(scopeFrameNodeValue_, ex.getResult());
        }
        assert ((state & 0x10) != 0);
        if (this.ensureObjectKind(scopeFrameNodeValue_)) {
            return this.doLong(scopeFrameNodeValue_, rhsNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(scopeFrameNodeValue_, rhsNodeValue_);
    }

    private Object execute_double3(VirtualFrame frameValue, int state, Frame scopeFrameNodeValue_) {
        double rhsNodeValue_;
        int rhsNodeValue_int = 0;
        long rhsNodeValue_long = 0L;
        try {
            if ((state & 0x700) == 0 && (state & 0x7F) != 0) {
                rhsNodeValue_long = this.rhsNode.executeLong(frameValue);
                rhsNodeValue_ = JSTypes.longToDouble(rhsNodeValue_long);
            } else if ((state & 0x680) == 0 && (state & 0x7F) != 0) {
                rhsNodeValue_int = this.rhsNode.executeInt(frameValue);
                rhsNodeValue_ = JSTypes.intToDouble(rhsNodeValue_int);
            } else if ((state & 0x580) == 0 && (state & 0x7F) != 0) {
                rhsNodeValue_ = this.rhsNode.executeDouble(frameValue);
            } else {
                Object rhsNodeValue__ = this.rhsNode.execute(frameValue);
                rhsNodeValue_ = JSTypesGen.expectImplicitDouble((state & 0x780) >>> 7, rhsNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(scopeFrameNodeValue_, ex.getResult());
        }
        assert ((state & 0x20) != 0);
        if (this.isDoubleKind(scopeFrameNodeValue_)) {
            return this.doDouble(scopeFrameNodeValue_, rhsNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(scopeFrameNodeValue_, (state & 0x700) == 0 && (state & 0x7F) != 0 ? (Number)rhsNodeValue_long : (Number)((state & 0x680) == 0 && (state & 0x7F) != 0 ? (Number)rhsNodeValue_int : (Number)rhsNodeValue_));
    }

    private Object execute_generic4(VirtualFrame frameValue, int state, Frame scopeFrameNodeValue_) {
        Object rhsNodeValue_ = this.rhsNode.execute(frameValue);
        if ((state & 0x7F) != 0) {
            int rhsNodeValue__;
            if ((state & 1) != 0 && rhsNodeValue_ instanceof Boolean) {
                rhsNodeValue__ = ((Boolean)rhsNodeValue_).booleanValue();
                if (this.isBooleanKind(scopeFrameNodeValue_)) {
                    return this.doBoolean(scopeFrameNodeValue_, rhsNodeValue__ != 0);
                }
            }
            if ((state & 6) != 0 && rhsNodeValue_ instanceof Integer) {
                rhsNodeValue__ = (Integer)rhsNodeValue_;
                if ((state & 2) != 0 && this.isIntegerKind(scopeFrameNodeValue_)) {
                    return this.doInteger(scopeFrameNodeValue_, rhsNodeValue__);
                }
                if ((state & 4) != 0 && this.isLongKind(scopeFrameNodeValue_)) {
                    return this.doLargeIntegerInt(scopeFrameNodeValue_, rhsNodeValue__);
                }
            }
            if ((state & 8) != 0 && rhsNodeValue_ instanceof LargeInteger) {
                LargeInteger rhsNodeValue__2 = (LargeInteger)rhsNodeValue_;
                if (this.isLongKind(scopeFrameNodeValue_)) {
                    return this.doLargeInteger(scopeFrameNodeValue_, rhsNodeValue__2);
                }
            }
            if ((state & 0x10) != 0 && rhsNodeValue_ instanceof Long) {
                long rhsNodeValue__3 = (Long)rhsNodeValue_;
                if (this.ensureObjectKind(scopeFrameNodeValue_)) {
                    return this.doLong(scopeFrameNodeValue_, rhsNodeValue__3);
                }
            }
            if ((state & 0x20) != 0 && JSTypesGen.isImplicitDouble((state & 0x780) >>> 7, rhsNodeValue_)) {
                double rhsNodeValue__4 = JSTypesGen.asImplicitDouble((state & 0x780) >>> 7, rhsNodeValue_);
                if (this.isDoubleKind(scopeFrameNodeValue_)) {
                    return this.doDouble(scopeFrameNodeValue_, rhsNodeValue__4);
                }
            }
            if ((state & 0x40) != 0 && this.ensureObjectKind(scopeFrameNodeValue_)) {
                return this.doObject(scopeFrameNodeValue_, rhsNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(scopeFrameNodeValue_, rhsNodeValue_);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
        boolean rhsNodeValue_;
        int state = this.state_;
        if ((state & 0x40) != 0) {
            return JSTypesGen.expectBoolean(this.execute(frameValue));
        }
        Frame scopeFrameNodeValue_ = this.scopeFrameNode.executeFrame((Frame)frameValue);
        try {
            rhsNodeValue_ = this.rhsNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectBoolean(this.executeAndSpecialize(scopeFrameNodeValue_, ex.getResult()));
        }
        if ((state & 1) != 0 && this.isBooleanKind(scopeFrameNodeValue_)) {
            return this.doBoolean(scopeFrameNodeValue_, rhsNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectBoolean(this.executeAndSpecialize(scopeFrameNodeValue_, rhsNodeValue_));
    }

    @Override
    public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
        double rhsNodeValue_;
        int state = this.state_;
        if ((state & 0x40) != 0) {
            return JSTypesGen.expectDouble(this.execute(frameValue));
        }
        Frame scopeFrameNodeValue_ = this.scopeFrameNode.executeFrame((Frame)frameValue);
        int rhsNodeValue_int = 0;
        long rhsNodeValue_long = 0L;
        try {
            if ((state & 0x700) == 0 && (state & 0x7F) != 0) {
                rhsNodeValue_long = this.rhsNode.executeLong(frameValue);
                rhsNodeValue_ = JSTypes.longToDouble(rhsNodeValue_long);
            } else if ((state & 0x680) == 0 && (state & 0x7F) != 0) {
                rhsNodeValue_int = this.rhsNode.executeInt(frameValue);
                rhsNodeValue_ = JSTypes.intToDouble(rhsNodeValue_int);
            } else if ((state & 0x580) == 0 && (state & 0x7F) != 0) {
                rhsNodeValue_ = this.rhsNode.executeDouble(frameValue);
            } else {
                Object rhsNodeValue__ = this.rhsNode.execute(frameValue);
                rhsNodeValue_ = JSTypesGen.expectImplicitDouble((state & 0x780) >>> 7, rhsNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectDouble(this.executeAndSpecialize(scopeFrameNodeValue_, ex.getResult()));
        }
        if ((state & 0x20) != 0 && this.isDoubleKind(scopeFrameNodeValue_)) {
            return this.doDouble(scopeFrameNodeValue_, rhsNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectDouble(this.executeAndSpecialize(scopeFrameNodeValue_, (state & 0x700) == 0 && (state & 0x7F) != 0 ? (Number)rhsNodeValue_long : (Number)((state & 0x680) == 0 && (state & 0x7F) != 0 ? (Number)rhsNodeValue_int : (Number)rhsNodeValue_)));
    }

    @Override
    public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
        int rhsNodeValue_;
        int state = this.state_;
        if ((state & 0x40) != 0) {
            return JSTypesGen.expectInteger(this.execute(frameValue));
        }
        Frame scopeFrameNodeValue_ = this.scopeFrameNode.executeFrame((Frame)frameValue);
        try {
            rhsNodeValue_ = this.rhsNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectInteger(this.executeAndSpecialize(scopeFrameNodeValue_, ex.getResult()));
        }
        if ((state & 6) != 0) {
            if ((state & 2) != 0 && this.isIntegerKind(scopeFrameNodeValue_)) {
                return this.doInteger(scopeFrameNodeValue_, rhsNodeValue_);
            }
            if ((state & 4) != 0 && this.isLongKind(scopeFrameNodeValue_)) {
                return this.doLargeIntegerInt(scopeFrameNodeValue_, rhsNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(this.executeAndSpecialize(scopeFrameNodeValue_, rhsNodeValue_));
    }

    @Override
    public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
        long rhsNodeValue_;
        int state = this.state_;
        if ((state & 0x40) != 0) {
            return JSTypesGen.expectLong(this.execute(frameValue));
        }
        Frame scopeFrameNodeValue_ = this.scopeFrameNode.executeFrame((Frame)frameValue);
        try {
            rhsNodeValue_ = this.rhsNode.executeLong(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectLong(this.executeAndSpecialize(scopeFrameNodeValue_, ex.getResult()));
        }
        if ((state & 0x10) != 0 && this.ensureObjectKind(scopeFrameNodeValue_)) {
            return this.doLong(scopeFrameNodeValue_, rhsNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectLong(this.executeAndSpecialize(scopeFrameNodeValue_, rhsNodeValue_));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state = this.state_;
        try {
            if ((state & 0x6F) == 0 && (state & 0x7F) != 0) {
                this.executeLong(frameValue);
                return;
            }
            if ((state & 0x79) == 0 && (state & 0x7F) != 0) {
                this.executeInt(frameValue);
                return;
            }
            if ((state & 0x5F) == 0 && (state & 0x7F) != 0) {
                this.executeDouble(frameValue);
                return;
            }
            if ((state & 0x7E) == 0 && (state & 0x7F) != 0) {
                this.executeBoolean(frameValue);
                return;
            }
            this.execute(frameValue);
            return;
        }
        catch (UnexpectedResultException ex) {
            return;
        }
    }

    private Object executeAndSpecialize(Frame scopeFrameNodeValue, Object rhsNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            int doubleCast1;
            int rhsNodeValue_;
            if ((exclude & 1) == 0 && rhsNodeValue instanceof Boolean) {
                rhsNodeValue_ = ((Boolean)rhsNodeValue).booleanValue();
                if (this.isBooleanKind(scopeFrameNodeValue)) {
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    Boolean bl = this.doBoolean(scopeFrameNodeValue, rhsNodeValue_ != 0);
                    return bl;
                }
            }
            if (rhsNodeValue instanceof Integer) {
                rhsNodeValue_ = (Integer)rhsNodeValue;
                if ((exclude & 2) == 0 && this.isIntegerKind(scopeFrameNodeValue)) {
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    Integer n = this.doInteger(scopeFrameNodeValue, rhsNodeValue_);
                    return n;
                }
                if ((exclude & 4) == 0 && this.isLongKind(scopeFrameNodeValue)) {
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    Integer n = this.doLargeIntegerInt(scopeFrameNodeValue, rhsNodeValue_);
                    return n;
                }
            }
            if ((exclude & 8) == 0 && rhsNodeValue instanceof LargeInteger) {
                LargeInteger rhsNodeValue_2 = (LargeInteger)rhsNodeValue;
                if (this.isLongKind(scopeFrameNodeValue)) {
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    LargeInteger largeInteger = this.doLargeInteger(scopeFrameNodeValue, rhsNodeValue_2);
                    return largeInteger;
                }
            }
            if ((exclude & 0x10) == 0 && rhsNodeValue instanceof Long) {
                long rhsNodeValue_3 = (Long)rhsNodeValue;
                if (this.ensureObjectKind(scopeFrameNodeValue)) {
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    Long l = this.doLong(scopeFrameNodeValue, rhsNodeValue_3);
                    return l;
                }
            }
            if ((exclude & 0x20) == 0 && (doubleCast1 = JSTypesGen.specializeImplicitDouble(rhsNodeValue)) != 0) {
                double rhsNodeValue_4 = JSTypesGen.asImplicitDouble(doubleCast1, rhsNodeValue);
                if (this.isDoubleKind(scopeFrameNodeValue)) {
                    this.exclude_ = exclude |= 0xE;
                    state &= 0xFFFFFFF1;
                    state |= doubleCast1 << 7;
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    Double d = this.doDouble(scopeFrameNodeValue, rhsNodeValue_4);
                    return d;
                }
            }
            if (this.ensureObjectKind(scopeFrameNodeValue)) {
                this.exclude_ = exclude |= 0x3F;
                state &= 0xFFFFFFC0;
                this.state_ = state |= 0x40;
                lock.unlock();
                hasLock = false;
                Object object = this.doObject(scopeFrameNodeValue, rhsNodeValue);
                return object;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.scopeFrameNode, this.rhsNode}, new Object[]{scopeFrameNodeValue, rhsNodeValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 0x7F) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0x7F & (state & 0x7F) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        Object[] data = new Object[8];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doBoolean";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : ((exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[1] = s;
        s = new Object[3];
        s[0] = "doInteger";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : ((exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[2] = s;
        s = new Object[3];
        s[0] = "doLargeIntegerInt";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : ((exclude & 4) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[3] = s;
        s = new Object[3];
        s[0] = "doLargeInteger";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : ((exclude & 8) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[4] = s;
        s = new Object[3];
        s[0] = "doLong";
        s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : ((exclude & 0x10) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[5] = s;
        s = new Object[3];
        s[0] = "doDouble";
        s[1] = (state & 0x20) != 0 ? Byte.valueOf((byte)1) : ((exclude & 0x20) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[6] = s;
        s = new Object[3];
        s[0] = "doObject";
        s[1] = (state & 0x40) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[7] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static JSWriteScopeFrameSlotNode create(FrameSlot frameSlot, ScopeFrameNode scopeFrameNode, JavaScriptNode rhsNode) {
        return new JSWriteScopeFrameSlotNodeGen(frameSlot, scopeFrameNode, rhsNode);
    }
}

