/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.adapter;

import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.base.Objects;
import com.jgoodies.common.base.Preconditions;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public final class TextComponentConnector {
    private final ValueModel subject;
    private final JTextComponent textComponent;
    private Document document;
    private final SubjectValueChangeHandler subjectValueChangeHandler;
    private final DocumentListener textChangeHandler;
    private final PropertyChangeListener documentChangeHandler;

    public TextComponentConnector(ValueModel subject, JTextArea textArea) {
        this(subject, (JTextComponent)textArea);
    }

    public TextComponentConnector(ValueModel subject, JTextField textField) {
        this(subject, (JTextComponent)textField);
    }

    private TextComponentConnector(ValueModel subject, JTextComponent textComponent) {
        this.subject = (ValueModel)Preconditions.checkNotNull((Object)subject, (String)"The subject must not be null.");
        this.textComponent = (JTextComponent)Preconditions.checkNotNull((Object)textComponent, (String)"The text component must not be null.");
        this.subjectValueChangeHandler = new SubjectValueChangeHandler();
        this.textChangeHandler = new TextChangeHandler();
        this.document = textComponent.getDocument();
        this.reregisterTextChangeHandler(null, this.document);
        subject.addValueChangeListener(this.subjectValueChangeHandler);
        this.documentChangeHandler = new DocumentChangeHandler();
        textComponent.addPropertyChangeListener("document", this.documentChangeHandler);
    }

    public static void connect(ValueModel subject, JTextArea textArea) {
        new TextComponentConnector(subject, textArea);
    }

    public static void connect(ValueModel subject, JTextField textField) {
        new TextComponentConnector(subject, textField);
    }

    public void updateSubject() {
        this.setSubjectText(this.getDocumentText());
    }

    public void updateTextComponent() {
        this.setDocumentTextSilently(this.getSubjectText());
    }

    private String getDocumentText() {
        return this.textComponent.getText();
    }

    private void setDocumentTextSilently(String newText) {
        this.textComponent.getDocument().removeDocumentListener(this.textChangeHandler);
        this.textComponent.setText(newText);
        this.textComponent.setCaretPosition(0);
        this.textComponent.getDocument().addDocumentListener(this.textChangeHandler);
    }

    private String getSubjectText() {
        String str = (String)this.subject.getValue();
        return str == null ? "" : str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSubjectText(String newText) {
        this.subjectValueChangeHandler.setUpdateLater(true);
        try {
            this.subject.setValue(newText);
        }
        finally {
            this.subjectValueChangeHandler.setUpdateLater(false);
        }
    }

    private void reregisterTextChangeHandler(Document oldDocument, Document newDocument) {
        if (oldDocument != null) {
            oldDocument.removeDocumentListener(this.textChangeHandler);
        }
        if (newDocument != null) {
            newDocument.addDocumentListener(this.textChangeHandler);
        }
    }

    public void release() {
        this.reregisterTextChangeHandler(this.document, null);
        this.subject.removeValueChangeListener(this.subjectValueChangeHandler);
        this.textComponent.removePropertyChangeListener("document", this.documentChangeHandler);
    }

    private final class DocumentChangeHandler
    implements PropertyChangeListener {
        private DocumentChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Document oldDocument = TextComponentConnector.this.document;
            Document newDocument = TextComponentConnector.this.textComponent.getDocument();
            TextComponentConnector.this.reregisterTextChangeHandler(oldDocument, newDocument);
            TextComponentConnector.this.document = newDocument;
        }
    }

    private final class SubjectValueChangeHandler
    implements PropertyChangeListener {
        private boolean updateLater;

        private SubjectValueChangeHandler() {
        }

        void setUpdateLater(boolean updateLater) {
            this.updateLater = updateLater;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String newText;
            String oldText = TextComponentConnector.this.getDocumentText();
            Object newValue = evt.getNewValue();
            String string = newText = newValue == null ? TextComponentConnector.this.getSubjectText() : (String)newValue;
            if (Objects.equals((Object)oldText, (Object)newText)) {
                return;
            }
            if (this.updateLater) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TextComponentConnector.this.setDocumentTextSilently(newText);
                    }
                });
            } else {
                TextComponentConnector.this.setDocumentTextSilently(newText);
            }
        }
    }

    private final class TextChangeHandler
    implements DocumentListener {
        private TextChangeHandler() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            TextComponentConnector.this.updateSubject();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            TextComponentConnector.this.updateSubject();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }
}

