/*
 * Decompiled with CFR 0.152.
 */
package workflow.types.data;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class MetaData {
    private List<ColumnData> columnData = new ArrayList<ColumnData>();

    public MetaData(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.columnData.add(new ColumnData(stringArray[i], i));
        }
    }

    public MetaData(List<ColumnData> list) {
        this.columnData = list;
    }

    public MetaData(ResultSetMetaData resultSetMetaData) throws SQLException {
        for (int i = 0; i < resultSetMetaData.getColumnCount(); ++i) {
            this.columnData.add(new ColumnData(resultSetMetaData.getColumnName(i + 1), i));
        }
    }

    public Integer getColumnIndex(String string) {
        for (ColumnData columnData : this.columnData) {
            if (!columnData.name.equalsIgnoreCase(string)) continue;
            return columnData.index;
        }
        return null;
    }

    public String getColumnName(int n) {
        return this.columnData.get(n).name;
    }

    public int getColumnCount() {
        return this.columnData.size();
    }

    public static class ColumnData {
        private String name;
        private int index;

        public ColumnData(String string, int n) {
            this.name = string;
            this.index = n;
        }
    }
}

