/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.util;

import java.nio.ByteBuffer;

public class RelocatableUtils {
    private static RelocatableUtils instance;
    byte[] data = null;
    public static final int intsize = 4;
    public static final int shortsize = 2;
    public static final int bytesize = 1;
    public static final int relocatablestringsize = 4;
    public static final int relocatablevectorsize = 8;
    public static final int relocatablemapsize = 16;
    public static final int fileheadersize = 16;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RelocatableUtils getInstance() {
        if (instance != null) return instance;
        Class<RelocatableUtils> clazz = RelocatableUtils.class;
        synchronized (RelocatableUtils.class) {
            if (instance != null) return instance;
            instance = new RelocatableUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setData(byte[] byArray) {
        this.data = byArray;
    }

    public int getIntAtLoc(int n) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.data, n, 4);
        return byteBuffer.getInt();
    }

    public int getRelocatablePointer(int n) {
        return n + this.getIntAtLoc(n);
    }

    public short getShortAtLoc(int n) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.data, n, 2);
        return byteBuffer.getShort();
    }

    public byte getByteAtLoc(int n) {
        return this.data[n];
    }

    public String getStringfromLoc(int n) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (int i = n; i < this.data.length && (char)this.data[i] != '\u0000'; ++i) {
            ++n2;
            stringBuilder.append(this.data[i]);
        }
        byte[] byArray = new byte[n2];
        for (int i = n; i < n + n2; ++i) {
            byArray[i - n] = this.data[i];
        }
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (Exception exception) {
            string = stringBuilder.toString();
        }
        return string;
    }

    public String getRelocatableString(int n) {
        int n2 = this.getRelocatablePointer(n);
        return this.getStringfromLoc(n2);
    }
}

