/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.util;

import commvault.cte.util.EnglishDuplicateStringInfo;
import commvault.cte.util.ExceptionFileNotFoundInLangPack;
import commvault.cte.util.FileInfo;
import commvault.cte.util.JavaGuiLanguagePack;
import commvault.cte.util.LangString;
import commvault.cte.util.LangStringInfo;
import commvault.cte.util.Logger;
import commvault.cte.util.RelocatableMap;
import commvault.cte.util.RelocatableUtils;
import commvault.cte.util.RelocatableVector;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class LookupInLangpack {
    private static LookupInLangpack instance;
    private JavaGuiLanguagePack lp;

    private LookupInLangpack() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LookupInLangpack getInstance() {
        if (instance != null) return instance;
        Class<LookupInLangpack> clazz = LookupInLangpack.class;
        synchronized (LookupInLangpack.class) {
            if (instance != null) return instance;
            LookupInLangpack lookupInLangpack = new LookupInLangpack();
            lookupInLangpack.loadLangPack();
            lookupInLangpack.lp = new JavaGuiLanguagePack();
            instance = lookupInLangpack;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public int getLocaleCode(String string) throws ExceptionFileNotFoundInLangPack {
        int n;
        int n2 = this.lp.extToLangCodeMap.getValueForStringKey(string);
        if (n2 == -1 && (n = string.indexOf(95)) != -1) {
            string = string.substring(0, n);
            n2 = this.lp.extToLangCodeMap.getValueForStringKey(string);
        }
        if (n2 == -1) {
            throw new ExceptionFileNotFoundInLangPack(string);
        }
        return RelocatableUtils.getInstance().getIntAtLoc(n2);
    }

    public LangString lookupDuplicateInFileInfo(String string, String string2, String string3, String string4) throws ExceptionFileNotFoundInLangPack {
        int n = this.getLocaleCode(string2);
        int n2 = this.lp.fileMap.getValueForStringKey(string);
        if (n2 != -1) {
            FileInfo fileInfo = new FileInfo(RelocatableUtils.getInstance().getRelocatablePointer(n2));
            int n3 = fileInfo.cvkeys.runCaseSensitiveBinarySearchForString(string3);
            if (n3 != -1) {
                int n4 = fileInfo.englishDuplicates.getValueForIntKey(n3);
                if (n4 != -1) {
                    Object object;
                    int n5;
                    int n6 = -1;
                    RelocatableVector relocatableVector = new RelocatableVector(RelocatableUtils.getInstance().getRelocatablePointer(n4), 4);
                    for (n5 = 0; n5 < relocatableVector.vecsize; ++n5) {
                        object = new EnglishDuplicateStringInfo(RelocatableUtils.getInstance().getRelocatablePointer(relocatableVector.getAtIndex(n5)));
                        if (!((EnglishDuplicateStringInfo)object).endlishDuplicateString.equals(string4)) continue;
                        n6 = ((EnglishDuplicateStringInfo)object).cvkeyid;
                        break;
                    }
                    if (n6 != -1) {
                        n5 = fileInfo.languageDuplicates.getValueForShortKey((short)n);
                        if (n5 != -1) {
                            object = new RelocatableMap(RelocatableUtils.getInstance().getRelocatablePointer(n5), 4, 4);
                            int n7 = ((RelocatableMap)object).getValueForIntKey(n6);
                            if (n7 != -1) {
                                LangStringInfo langStringInfo = new LangStringInfo(RelocatableUtils.getInstance().getRelocatablePointer(n7));
                                return new LangString(langStringInfo.langString, 0);
                            }
                            return new LangString("", -1);
                        }
                        return new LangString("", 2);
                    }
                    return new LangString("", 2);
                }
                return new LangString("", 2);
            }
            return new LangString("", 2);
        }
        throw new ExceptionFileNotFoundInLangPack(string);
    }

    public LangString lookupInFileInfo(String string, String string2, String string3) throws ExceptionFileNotFoundInLangPack {
        int n = this.getLocaleCode(string2);
        int n2 = this.lp.fileMap.getValueForStringKey(string);
        if (n2 != -1) {
            FileInfo fileInfo = new FileInfo(RelocatableUtils.getInstance().getRelocatablePointer(n2));
            int n3 = fileInfo.cvkeys.runCaseSensitiveBinarySearchForString(string3);
            if (n3 != -1) {
                int n4 = fileInfo.englishDuplicates.getValueForIntKey(n3);
                if (n4 == -1) {
                    RelocatableMap relocatableMap;
                    int n5;
                    int n6 = fileInfo.langStrings.getValueForShortKey((short)n);
                    if (n6 != -1 && (n5 = (relocatableMap = new RelocatableMap(RelocatableUtils.getInstance().getRelocatablePointer(n6), 4, 4)).getValueForIntKey(n3)) != -1) {
                        LangStringInfo langStringInfo = new LangStringInfo(RelocatableUtils.getInstance().getRelocatablePointer(n5));
                        return new LangString(langStringInfo.langString, 0);
                    }
                    return new LangString("", 2);
                }
                return new LangString("", 1);
            }
            return new LangString("", 2);
        }
        throw new ExceptionFileNotFoundInLangPack(string);
    }

    public void loadLangPack() {
        String string = "";
        try {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("cvJavaGuiLangPack.langpack");
            if (inputStream == null) {
                Logger.instance().println("cvJavaGuiLangPack inputstream null");
            } else {
                int n;
                Logger.instance().println("Found cvJavaGuiLangPack");
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[4096];
                while ((n = inputStream.read(byArray)) > 0) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                RelocatableUtils.getInstance().setData(byArray2);
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            Logger.instance().println("Java gui langpack not found: " + string);
        }
    }
}

