/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.util;

import commvault.cte.util.Application;
import commvault.cte.util.LoggingOutputStream;
import commvault.cte.util.StdOutErrLevel;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

public final class Logger {
    public static String LOG_FILE_NAME = "guilogging%u_%g.log";
    public static final Level OFF = Level.OFF;
    public static final Level ERROR = Level.SEVERE;
    public static final Level WARNING = Level.WARNING;
    public static final Level INFO = Level.INFO;
    public static final Level FINE = Level.FINE;
    public static final Level FINER = Level.FINER;
    public static final Level FINEST = Level.FINEST;
    public static final Level STDOUT = StdOutErrLevel.STDOUT;
    public static final Level STDERR = StdOutErrLevel.STDERR;
    public static final Level EV = StdOutErrLevel.EVENTS;
    public static final Level JC = StdOutErrLevel.JOBS;
    public static final Level NET = StdOutErrLevel.NET;
    public static final Level MESSAGE = StdOutErrLevel.MESSAGE;
    public static final Level ALL = Level.ALL;
    private java.util.logging.Logger logger = null;
    private Level prevLevel = OFF;
    private Level currentLevel = OFF;
    private File logFileName = new File(".");
    private static Logger instance;
    private LoggerType logType;
    private PrintStream origStdout;
    private PrintStream origStderr;

    private Logger() {
        this.logger = java.util.logging.Logger.getLogger("commvault.cte");
        this.logger.setUseParentHandlers(false);
        this.origStdout = System.out;
        this.origStderr = System.err;
    }

    public static void write(Level level, Object object, String string, Object object2) {
        Logger.instance().log(level, object, string, object2);
    }

    public void log(Level level, Object object, String string, Object ... objectArray) {
        if (this.isLogging(level)) {
            if (!(object instanceof String)) {
                object = object.getClass().getName();
            }
            for (Object object2 : objectArray) {
                if (object2 instanceof Throwable) {
                    this.logger.throwing(object.toString(), string, (Throwable)object2);
                    continue;
                }
                this.logger.logp(level, object == null ? null : object.toString(), string, object2.toString() + "\r\n");
            }
        }
    }

    public static Logger instance() {
        if (instance == null) {
            instance = new Logger();
        }
        return instance;
    }

    public boolean isLogging() {
        return this.isLogging(INFO);
    }

    public void setOutput(LoggerType loggerType) {
        boolean bl = this.logType != null && this.logger.getLevel() != null && this.logger.getLevel().intValue() > OFF.intValue();
        switch (loggerType) {
            case LOG_TO_CONSOLE: 
            case LOG_TO_FILE: {
                this.setOutput(loggerType, bl ? this.currentLevel : FINE);
                break;
            }
            default: {
                this.setOutput(loggerType, bl ? this.currentLevel : OFF);
            }
        }
    }

    public void setOutput(LoggerType loggerType, Level level) {
        this.logType = loggerType;
        for (Handler object : this.logger.getHandlers()) {
            this.logger.removeHandler(object);
        }
        switch (loggerType) {
            case NO_LOGGING: {
                System.setOut(this.origStdout);
                System.setErr(this.origStderr);
                this.setLevel(level);
                System.out.println("No Logging");
                break;
            }
            case LOG_TO_FILE: {
                try {
                    FileHandler fileHandler = new FileHandler(LOG_FILE_NAME, 15360000, 1, true);
                    fileHandler.setFormatter(new MyFormatter());
                    this.logger.addHandler(fileHandler);
                    Field field = FileHandler.class.getDeclaredField("files");
                    field.setAccessible(true);
                    File[] fileArray = (File[])field.get(fileHandler);
                    this.logFileName = fileArray != null && fileArray.length > 0 ? fileArray[0] : new File(".");
                    System.out.println("Logging to file: " + this.logFileName.getAbsoluteFile());
                    java.util.logging.Logger logger = java.util.logging.Logger.getLogger("stdout");
                    logger.setUseParentHandlers(false);
                    logger.addHandler(fileHandler);
                    LoggingOutputStream loggingOutputStream = new LoggingOutputStream(logger, STDOUT);
                    System.setOut(new PrintStream(loggingOutputStream, true));
                    java.util.logging.Logger logger2 = java.util.logging.Logger.getLogger("stderr");
                    logger2.setUseParentHandlers(false);
                    logger2.addHandler(fileHandler);
                    loggingOutputStream = new LoggingOutputStream(logger2, STDERR);
                    System.setErr(new PrintStream(loggingOutputStream, true));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.setLevel(level);
                System.out.println("Logging to file: " + this.logFileName.getAbsoluteFile());
                break;
            }
            case LOG_TO_CONSOLE: {
                System.setOut(this.origStdout);
                System.setErr(this.origStderr);
                this.logger.addHandler(new MyHandler(System.out, new MyFormatter()));
                this.setLevel(level);
                System.out.println("Logging to console");
                break;
            }
            default: {
                this.setLevel(level);
                System.out.println("No Logging");
            }
        }
    }

    public String getLogFileName() {
        return this.logFileName.getAbsolutePath();
    }

    public LoggerType getLogType() {
        return this.logType;
    }

    public boolean isLogging(Level level) {
        if (level == null || this.currentLevel == OFF) {
            return false;
        }
        return level.intValue() >= this.currentLevel.intValue() && this.currentLevel != OFF;
    }

    public void setLevel(Integer n) {
        Level level = null;
        switch (n) {
            case 0: {
                level = OFF;
                break;
            }
            case 1: {
                level = ERROR;
                break;
            }
            case 2: {
                level = INFO;
                break;
            }
            case 3: {
                level = FINE;
                break;
            }
            case 4: {
                level = FINER;
                break;
            }
            case 5: {
                level = FINEST;
                break;
            }
            case 6: {
                level = EV;
                break;
            }
            case 7: {
                level = JC;
                break;
            }
            case 8: {
                level = NET;
                break;
            }
            case 9: {
                level = MESSAGE;
                break;
            }
            case 10: {
                level = ALL;
            }
        }
        if (level != null) {
            this.setLevel(level);
        }
    }

    private void setLevel(Level level) {
        if (level == this.logger.getLevel()) {
            System.out.println("Logging Level NOT changed from " + this.prevLevel);
            return;
        }
        if (this.logger.getLevel() == null && level == OFF) {
            return;
        }
        if (this.logger.getLevel() != null) {
            this.prevLevel = this.logger.getLevel();
        }
        this.logger.setLevel(level);
        this.currentLevel = level;
        System.out.println("Logging Level changed from " + this.prevLevel + " to " + this.logger.getLevel());
        Handler[] handlerArray = this.logger.getHandlers();
        if (handlerArray != null && handlerArray.length > 0) {
            for (Handler handler : handlerArray) {
                handler.setLevel(level);
                System.out.println("Logging Level changed for " + handler.getClass().getSimpleName() + " from " + this.prevLevel + " to " + handler.getLevel());
            }
        }
    }

    public void println(Object ... objectArray) {
        this.println(INFO, objectArray);
    }

    public void println(Level level, Object ... objectArray) {
        if (this.isLogging(level)) {
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            int n = 2;
            if (stackTraceElementArray.length > 1) {
                for (int i = 1; i < stackTraceElementArray.length; ++i) {
                    if (stackTraceElementArray[i].getClassName().equalsIgnoreCase(this.getClass().getName())) continue;
                    n = i;
                    break;
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (Object object : objectArray) {
                if (object instanceof Throwable) {
                    this.logger.throwing(stackTraceElementArray[n].getClassName(), stackTraceElementArray[n].getMethodName(), (Throwable)object);
                    continue;
                }
                stringBuilder.append(object);
            }
            this.logger.logp(level, stackTraceElementArray[n].getClassName(), stackTraceElementArray[n].getMethodName(), stringBuilder.toString() + "\r\n");
        }
    }

    static {
        if (Application.instance().isWebstartGui()) {
            LOG_FILE_NAME = "%t/" + LOG_FILE_NAME;
        }
    }

    static class MyFormatter
    extends SimpleFormatter {
    }

    static class MyHandler
    extends StreamHandler {
        public MyHandler(OutputStream outputStream, Formatter formatter) {
            super(outputStream, formatter);
        }

        @Override
        public void close() {
            this.flush();
        }

        @Override
        public void publish(LogRecord logRecord) {
            super.publish(logRecord);
            this.flush();
        }
    }

    public static enum LoggerType {
        NO_LOGGING,
        LOG_TO_CONSOLE,
        LOG_TO_FILE;

    }
}

