/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.util;

import java.io.UnsupportedEncodingException;

public final class HexBin {
    private static final int BASELENGTH = 255;
    private static final int LOOKUPLENGTH = 16;
    private static byte[] hexNumberTable;
    private static byte[] lookUpHexAlphabet;

    static boolean isHex(byte by) {
        return hexNumberTable[by] != -1;
    }

    public static String bytesToString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return new String(HexBin.encode(byArray));
    }

    public static byte[] stringToBytes(String string) {
        return HexBin.decode(string.getBytes());
    }

    public static byte[] encode(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        int n2 = n * 2;
        byte[] byArray2 = new byte[n2];
        for (int i = 0; i < n; ++i) {
            byArray2[i * 2] = lookUpHexAlphabet[byArray[i] >> 4 & 0xF];
            byArray2[i * 2 + 1] = lookUpHexAlphabet[byArray[i] & 0xF];
        }
        return byArray2;
    }

    public static byte[] decode(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        if (n % 2 != 0) {
            return null;
        }
        int n2 = n / 2;
        byte[] byArray2 = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            if (!HexBin.isHex(byArray[i * 2]) || !HexBin.isHex(byArray[i * 2 + 1])) {
                return null;
            }
            byArray2[i] = (byte)(hexNumberTable[byArray[i * 2]] << 4 | hexNumberTable[byArray[i * 2 + 1]]);
        }
        return byArray2;
    }

    public static String decode(String string) {
        if (string == null) {
            return null;
        }
        byte[] byArray = null;
        try {
            byArray = HexBin.decode(string.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return byArray == null ? null : new String(byArray);
    }

    public static String encode(String string) {
        if (string == null) {
            return null;
        }
        byte[] byArray = null;
        try {
            byArray = HexBin.encode(string.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return byArray == null ? null : new String(byArray);
    }

    static {
        int n;
        hexNumberTable = new byte[255];
        lookUpHexAlphabet = new byte[16];
        for (n = 0; n < 255; ++n) {
            HexBin.hexNumberTable[n] = -1;
        }
        for (n = 57; n >= 48; --n) {
            HexBin.hexNumberTable[n] = (byte)(n - 48);
        }
        for (n = 70; n >= 65; --n) {
            HexBin.hexNumberTable[n] = (byte)(n - 65 + 10);
        }
        for (n = 102; n >= 97; --n) {
            HexBin.hexNumberTable[n] = (byte)(n - 97 + 10);
        }
        for (n = 0; n < 10; ++n) {
            HexBin.lookUpHexAlphabet[n] = (byte)(48 + n);
        }
        for (n = 10; n <= 15; ++n) {
            HexBin.lookUpHexAlphabet[n] = (byte)(65 + n - 10);
        }
    }
}

