/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.util;

import commvault.cte.util.EDTRuleViolation;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public abstract class CheckingRepaintManager
extends RepaintManager {
    @Override
    public synchronized void addInvalidComponent(JComponent jComponent) {
        this.checkEDTRule(jComponent);
        super.addInvalidComponent(jComponent);
    }

    @Override
    public synchronized void addDirtyRegion(JComponent jComponent, int n, int n2, int n3, int n4) {
        this.checkEDTRule(jComponent);
        super.addDirtyRegion(jComponent, n, n2, n3, n4);
    }

    protected void checkEDTRule(Component component) {
        if (this.violatesEDTRule(component)) {
            EDTRuleViolation eDTRuleViolation = new EDTRuleViolation(component);
            StackTraceElement[] stackTraceElementArray = eDTRuleViolation.getStackTrace();
            try {
                for (int i = stackTraceElementArray.length - 1; i >= 0; --i) {
                    if (!this.isLiableToEDTRule(stackTraceElementArray[i])) continue;
                    StackTraceElement[] stackTraceElementArray2 = new StackTraceElement[stackTraceElementArray.length - i];
                    System.arraycopy(stackTraceElementArray, i, stackTraceElementArray2, 0, stackTraceElementArray2.length);
                    eDTRuleViolation.setStackTrace(stackTraceElementArray2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.indicate(eDTRuleViolation);
        }
    }

    protected boolean violatesEDTRule(Component component) {
        return !SwingUtilities.isEventDispatchThread() && component.isShowing();
    }

    protected boolean isLiableToEDTRule(StackTraceElement stackTraceElement) throws Exception {
        return Component.class.isAssignableFrom(Class.forName(stackTraceElement.getClassName()));
    }

    public abstract void indicate(EDTRuleViolation var1);
}

