/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.thread;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CVThreadPool {
    private ThreadPoolExecutor threadPoolExecutor;
    private Logger logger;
    private Thread newThread;
    private String name;
    private MyWorkingQueue myWorkingQueue = new MyWorkingQueue();

    public CVThreadPool(String string, int n, int n2, long l, TimeUnit timeUnit, ThreadFactory threadFactory) {
        this.threadPoolExecutor = new ThreadPoolExecutor(n, n2, l, timeUnit, new LinkedBlockingQueue<Runnable>(), threadFactory);
        this.initializeDataAndStartThread(string);
    }

    public CVThreadPool(String string, int n, int n2, long l, TimeUnit timeUnit) {
        this.threadPoolExecutor = new ThreadPoolExecutor(n, n2, l, timeUnit, new LinkedBlockingQueue<Runnable>());
        this.initializeDataAndStartThread(string);
    }

    private void initializeDataAndStartThread(String string) {
        this.name = string;
        this.logger = Logger.getLogger("CVThreadPool - " + string + "\n");
        ThreadPoolScheduler threadPoolScheduler = new ThreadPoolScheduler();
        this.newThread = new Thread(threadPoolScheduler);
        this.newThread.start();
    }

    public void doWork(int n, Runnable runnable) {
        if (this.myWorkingQueue.getMapSerialIdQueue().containsKey(n)) {
            this.myWorkingQueue.getMapSerialIdQueue().get(n).add(runnable);
        } else {
            WaitingQueue waitingQueue = new WaitingQueue(n);
            waitingQueue.add(runnable);
            this.myWorkingQueue.getQueueOfQueues().add(waitingQueue);
            this.myWorkingQueue.getMapSerialIdQueue().put(n, waitingQueue);
            this.logger.log(Level.INFO, "[CVThreadPool - " + this.name + "]: Number of completed tasks = " + this.threadPoolExecutor.getCompletedTaskCount() + "\n");
        }
    }

    public void doWork(Runnable runnable) {
        this.doWork(0, runnable);
    }

    public void shutdown() {
        this.newThread.interrupt();
        this.threadPoolExecutor.shutdown();
    }

    public List<Runnable> shutdownNow() {
        this.newThread.interrupt();
        return this.threadPoolExecutor.shutdownNow();
    }

    public void awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        this.threadPoolExecutor.awaitTermination(l, timeUnit);
    }

    private class ThreadPoolScheduler
    implements Runnable {
        private ThreadPoolScheduler() {
        }

        @Override
        public void run() {
            try {
                block2: while (true) {
                    Iterator<WaitingQueue> iterator;
                    if (CVThreadPool.this.threadPoolExecutor.getMaximumPoolSize() - CVThreadPool.this.threadPoolExecutor.getActiveCount() < 3) {
                        CVThreadPool.this.logger.log(Level.WARNING, " [CVThreadPool - " + CVThreadPool.this.name + "]: Number of inactive threads = " + (CVThreadPool.this.threadPoolExecutor.getMaximumPoolSize() - CVThreadPool.this.threadPoolExecutor.getActiveCount()) + "\n");
                    }
                    if (!(iterator = CVThreadPool.this.myWorkingQueue.iterator()).hasNext()) {
                        Thread.sleep(1239L);
                    }
                    while (true) {
                        Future<?> future;
                        Runnable runnable;
                        if (!iterator.hasNext()) continue block2;
                        WaitingQueue waitingQueue = iterator.next();
                        if (waitingQueue.getSerialId() == 0) {
                            runnable = (Runnable)waitingQueue.poll();
                            if (runnable != null) {
                                future = CVThreadPool.this.threadPoolExecutor.submit(runnable);
                                waitingQueue.setFutureLastJob(future);
                                continue;
                            }
                            if (!CVThreadPool.this.myWorkingQueue.getQueueOfQueues().remove(waitingQueue)) continue;
                            CVThreadPool.this.logger.log(Level.INFO, " [CVThreadPool - " + CVThreadPool.this.name + "]: Queue with serialId=" + waitingQueue.getSerialId() + " removed");
                            continue;
                        }
                        runnable = (Runnable)waitingQueue.peek();
                        if (runnable != null) {
                            future = waitingQueue.getFutureLastJob();
                            if (future != null && future.isDone()) {
                                future = CVThreadPool.this.threadPoolExecutor.submit(runnable);
                                waitingQueue.setFutureLastJob(future);
                                waitingQueue.poll();
                                continue;
                            }
                            if (future != null && !future.isDone() || future != null) continue;
                            future = CVThreadPool.this.threadPoolExecutor.submit(runnable);
                            waitingQueue.setFutureLastJob(future);
                            waitingQueue.poll();
                            continue;
                        }
                        if (!CVThreadPool.this.myWorkingQueue.getQueueOfQueues().remove(waitingQueue)) continue;
                        CVThreadPool.this.logger.log(Level.INFO, " [CVThreadPool - " + CVThreadPool.this.name + "]: Queue with serialId=" + waitingQueue.getSerialId() + " removed");
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                CVThreadPool.this.logger.log(Level.WARNING, " [CVThreadPool - " + CVThreadPool.this.name + "]: ThreadPoolScheduler thread Interrupted\n");
                return;
            }
        }
    }

    private class WaitingQueue
    extends LinkedBlockingQueue<Runnable> {
        private static final long serialVersionUID = 1L;
        private int serialId;
        private Future<?> futureLastJob;

        public WaitingQueue(int n) {
            this.serialId = n;
        }

        public int getSerialId() {
            return this.serialId;
        }

        public void setFutureLastJob(Future<?> future) {
            this.futureLastJob = future;
        }

        public Future<?> getFutureLastJob() {
            return this.futureLastJob;
        }
    }

    private class MyWorkingQueue {
        private final BlockingQueue<WaitingQueue> queueOfQueues = new LinkedBlockingQueue<WaitingQueue>();
        private final Hashtable<Integer, BlockingQueue<Runnable>> mapSerialIdQueue = new Hashtable();

        private MyWorkingQueue() {
        }

        public BlockingQueue<WaitingQueue> getQueueOfQueues() {
            return this.queueOfQueues;
        }

        public Hashtable<Integer, BlockingQueue<Runnable>> getMapSerialIdQueue() {
            return this.mapSerialIdQueue;
        }

        public Iterator<WaitingQueue> iterator() {
            return this.queueOfQueues.iterator();
        }
    }
}

