/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.reports.util;

import commvault.cte.reports.util.Capacity;
import commvault.cte.reports.util.ReportConstants;
import commvault.cte.util.Logger;
import java.text.NumberFormat;
import java.text.ParseException;

public class DataSize
extends Capacity {
    Capacity.Formatter formatter = null;

    public DataSize(long l) {
        super.setValue(l);
    }

    public DataSize(long l, Capacity.Formatter formatter) {
        this.setValue(l);
        this.formatter = formatter;
    }

    public DataSize(double d, Capacity.Formatter formatter) {
        this.setValue((long)d);
        this.formatter = formatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        if (this.getText() == null) {
            DataSize dataSize = this;
            synchronized (dataSize) {
                if (this.formatter == null) {
                    return super.toString();
                }
                this.setText(this.isNA() ? ReportConstants.NA_STRING : this.formatValue());
            }
        }
        return this.getText();
    }

    private final String formatValue() {
        String string = null;
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        double d = 0.0;
        String string2 = "0.0";
        double d2 = this.formatter.getMinFactor();
        d = (double)super.getValue() / d2;
        string2 = numberFormat.format(d);
        string = string2 + " " + this.formatter.getUnits();
        double d3 = 0.0;
        try {
            d3 = numberFormat.parse(string2).doubleValue();
            d3 *= d2;
        }
        catch (ParseException parseException) {
            d3 = d;
            Object[] objectArray = new Object[]{"Error. Determining capacity fuzzy value." + parseException};
            Logger.instance().println(objectArray);
        }
        super.setFuzzyValue(d3);
        return string;
    }
}

