/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.registry;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import commvault.cte.registry.CvRegistryBase;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;

public class WindowRegistry
extends CvRegistryBase {
    public static final String DEFAULT_REGISTRY_PATH = "SOFTWARE\\CommVault Systems\\Galaxy\\";
    private static final WinReg.HKEY WINDOWNS_ROOT_HKEY = WinReg.HKEY_LOCAL_MACHINE;

    public WindowRegistry(String string) {
        super(string);
    }

    @Override
    protected String getDefaultRegistryPath() {
        return DEFAULT_REGISTRY_PATH;
    }

    @Override
    public Boolean isKeyExists(String string) {
        return this.isKeyExists(string, false);
    }

    @Override
    public Boolean isKeyExists(String string, boolean bl) {
        try {
            String string2 = bl ? this.clusterRootKey : this.rootKey;
            return Advapi32Util.registryKeyExists((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)(string2 + string));
        }
        catch (Win32Exception win32Exception) {
            win32Exception.printStackTrace();
            return false;
        }
    }

    @Override
    public Boolean isValueExists(String string, String string2) {
        return this.isValueExists(string, string2, false);
    }

    @Override
    public Boolean isValueExists(String string, String string2, boolean bl) {
        try {
            String string3 = bl ? this.clusterRootKey : this.rootKey;
            return Advapi32Util.registryValueExists((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)(string3 + string), (String)string2);
        }
        catch (Win32Exception win32Exception) {
            win32Exception.printStackTrace();
            return false;
        }
    }

    @Override
    public byte[] getByteValue(String string, String string2) {
        return this.getByteValue(string, string2, false);
    }

    @Override
    public byte[] getByteValue(String string, String string2, boolean bl) {
        try {
            String string3;
            String string4 = string3 = bl ? this.clusterRootKey : this.rootKey;
            if (Advapi32Util.registryKeyExists((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)(string3 + string)) && Advapi32Util.registryValueExists((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)(string3 + string), (String)string2)) {
                return Advapi32Util.registryGetBinaryValue((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)(string3 + string), (String)string2);
            }
        }
        catch (Win32Exception win32Exception) {
            win32Exception.printStackTrace();
        }
        return null;
    }

    @Override
    public Integer getIntValue(String string, String string2) {
        return this.getIntValue(string, string2, false);
    }

    @Override
    public Integer getIntValue(String string, String string2, boolean bl) {
        try {
            String string3;
            String string4 = string3 = bl ? this.clusterRootKey : this.rootKey;
            if (Advapi32Util.registryKeyExists((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)(string3 + string)) && Advapi32Util.registryValueExists((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)(string3 + string), (String)string2)) {
                return Advapi32Util.registryGetIntValue((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)(string3 + string), (String)string2);
            }
        }
        catch (Win32Exception win32Exception) {
            win32Exception.printStackTrace();
        }
        return null;
    }

    @Override
    public Long getLongValue(String string, String string2) {
        return this.getLongValue(string, string2, false);
    }

    @Override
    public Long getLongValue(String string, String string2, boolean bl) {
        try {
            String string3;
            String string4 = string3 = bl ? this.clusterRootKey : this.rootKey;
            if (Advapi32Util.registryKeyExists((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)(string3 + string)) && Advapi32Util.registryValueExists((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)(string3 + string), (String)string2)) {
                return Advapi32Util.registryGetLongValue((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)(string3 + string), (String)string2);
            }
        }
        catch (Win32Exception win32Exception) {
            win32Exception.printStackTrace();
        }
        return null;
    }

    @Override
    public String getStringValue(String string, String string2) {
        return this.getStringValue(string, string2, false);
    }

    @Override
    public String getStringValue(String string, String string2, boolean bl) {
        try {
            String string3;
            String string4 = string3 = bl ? this.clusterRootKey : this.rootKey;
            if (Advapi32Util.registryKeyExists((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)(string3 + string)) && Advapi32Util.registryValueExists((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)(string3 + string), (String)string2)) {
                return Advapi32Util.registryGetStringValue((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)(string3 + string), (String)string2);
            }
        }
        catch (Win32Exception win32Exception) {
            win32Exception.printStackTrace();
        }
        return null;
    }

    @Override
    public String getExpandedStringValue(String string, String string2) {
        return this.getExpandedStringValue(string, string2, false);
    }

    @Override
    public String getExpandedStringValue(String string, String string2, boolean bl) {
        try {
            String string3;
            String string4 = string3 = bl ? this.clusterRootKey : this.rootKey;
            if (Advapi32Util.registryKeyExists((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)(string3 + string)) && Advapi32Util.registryValueExists((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)(string3 + string), (String)string2)) {
                return Advapi32Util.registryGetExpandableStringValue((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)(string3 + string), (String)string2);
            }
        }
        catch (Win32Exception win32Exception) {
            win32Exception.printStackTrace();
        }
        return null;
    }

    @Override
    public String[] getMultiStringValue(String string, String string2) {
        return this.getMultiStringValue(string, string2, false);
    }

    @Override
    public String[] getMultiStringValue(String string, String string2, boolean bl) {
        try {
            String string3;
            String string4 = string3 = bl ? this.clusterRootKey : this.rootKey;
            if (Advapi32Util.registryKeyExists((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)(string3 + string)) && Advapi32Util.registryValueExists((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)(string3 + string), (String)string2)) {
                return Advapi32Util.registryGetStringArray((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)(string3 + string), (String)string2);
            }
        }
        catch (Win32Exception win32Exception) {
            win32Exception.printStackTrace();
        }
        return null;
    }

    @Override
    public TreeMap<String, Object> getValues(String string) {
        return this.getValues(string, false);
    }

    @Override
    public TreeMap<String, Object> getValues(String string, boolean bl) {
        try {
            String string2;
            String string3 = string2 = bl ? this.clusterRootKey : this.rootKey;
            if (Advapi32Util.registryKeyExists((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)(string2 + string))) {
                return Advapi32Util.registryGetValues((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)(string2 + string));
            }
        }
        catch (Win32Exception win32Exception) {
            win32Exception.printStackTrace();
        }
        return null;
    }

    @Override
    public List<String> getKeys(String string) {
        return this.getKeys(string, false);
    }

    @Override
    public List<String> getKeys(String string, boolean bl) {
        try {
            String string2;
            String string3 = string2 = bl ? this.clusterRootKey : this.rootKey;
            if (Advapi32Util.registryKeyExists((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)(string2 + string))) {
                return Arrays.asList(Advapi32Util.registryGetKeys((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)(string2 + string)));
            }
        }
        catch (Win32Exception win32Exception) {
            win32Exception.printStackTrace();
        }
        return null;
    }

    @Override
    public void setByteValue(String string, String string2, byte[] byArray) {
        this.setByteValue(string, string2, byArray, false);
    }

    @Override
    public void setByteValue(String string, String string2, byte[] byArray, boolean bl) {
        try {
            String string3;
            String string4 = string3 = bl ? this.clusterRootKey : this.rootKey;
            if (!Advapi32Util.registryKeyExists((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)(string3 + string))) {
                Advapi32Util.registryCreateKey((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)string3, (String)string);
            }
            Advapi32Util.registrySetBinaryValue((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)(string3 + string), (String)string2, (byte[])byArray);
        }
        catch (Win32Exception win32Exception) {
            win32Exception.printStackTrace();
        }
    }

    @Override
    public void setIntValue(String string, String string2, Integer n) {
        this.setIntValue(string, string2, n, false);
    }

    @Override
    public void setIntValue(String string, String string2, Integer n, boolean bl) {
        try {
            String string3;
            String string4 = string3 = bl ? this.clusterRootKey : this.rootKey;
            if (!Advapi32Util.registryKeyExists((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)(string3 + string))) {
                Advapi32Util.registryCreateKey((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)string3, (String)string);
            }
            Advapi32Util.registrySetIntValue((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)(string3 + string), (String)string2, (int)n);
        }
        catch (Win32Exception win32Exception) {
            win32Exception.printStackTrace();
        }
    }

    @Override
    public void setLongValue(String string, String string2, Long l) {
        this.setLongValue(string, string2, l, false);
    }

    @Override
    public void setLongValue(String string, String string2, Long l, boolean bl) {
        try {
            String string3;
            String string4 = string3 = bl ? this.clusterRootKey : this.rootKey;
            if (!Advapi32Util.registryKeyExists((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)(string3 + string))) {
                Advapi32Util.registryCreateKey((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)string3, (String)string);
            }
            Advapi32Util.registrySetLongValue((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)(string3 + string), (String)string2, (long)l);
        }
        catch (Win32Exception win32Exception) {
            win32Exception.printStackTrace();
        }
    }

    @Override
    public void setStringValue(String string, String string2, String string3) {
        this.setStringValue(string, string2, string3, false);
    }

    @Override
    public void setStringValue(String string, String string2, String string3, boolean bl) {
        try {
            String string4;
            String string5 = string4 = bl ? this.clusterRootKey : this.rootKey;
            if (!Advapi32Util.registryKeyExists((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)(string4 + string))) {
                Advapi32Util.registryCreateKey((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)string4, (String)string);
            }
            Advapi32Util.registrySetStringValue((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)(string4 + string), (String)string2, (String)string3);
        }
        catch (Win32Exception win32Exception) {
            win32Exception.printStackTrace();
        }
    }

    @Override
    public void setExpandedStringValue(String string, String string2, String string3) {
        this.setExpandedStringValue(string, string2, string3, false);
    }

    @Override
    public void setExpandedStringValue(String string, String string2, String string3, boolean bl) {
        try {
            String string4;
            String string5 = string4 = bl ? this.clusterRootKey : this.rootKey;
            if (!Advapi32Util.registryKeyExists((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)(string4 + string))) {
                Advapi32Util.registryCreateKey((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)string4, (String)string);
            }
            Advapi32Util.registrySetExpandableStringValue((WinReg.HKEY)WINDOWNS_ROOT_HKEY, (String)(string4 + string), (String)string2, (String)string3);
        }
        catch (Win32Exception win32Exception) {
            win32Exception.printStackTrace();
        }
    }
}

