/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.registry;

import commvault.cte.registry.CvRegistryBase;
import commvault.cte.registry.UnixRegistryProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class UnixRegistry
extends CvRegistryBase {
    public static final String DEFAULT_REGISTRY_PATH = "/etc/CommVaultRegistry/Galaxy/";
    private static final String REG_FILE = "/.properties";

    public UnixRegistry(String string) {
        super(string);
    }

    @Override
    protected String getDefaultRegistryPath() {
        return DEFAULT_REGISTRY_PATH;
    }

    @Override
    public Boolean isKeyExists(String string) {
        return this.isKeyExists(string, false);
    }

    @Override
    public Boolean isKeyExists(String string, boolean bl) {
        String string2 = bl ? this.clusterRootKey : this.rootKey;
        return Files.exists(Paths.get(string2 + string + REG_FILE, new String[0]), new LinkOption[0]);
    }

    @Override
    public Boolean isValueExists(String string, String string2) {
        return this.isValueExists(string, string2, false);
    }

    @Override
    public Boolean isValueExists(String string, String string2, boolean bl) {
        try {
            if (this.isKeyExists(string, bl).booleanValue()) {
                String string3 = bl ? this.clusterRootKey : this.rootKey;
                File file = new File(string3 + string + REG_FILE);
                UnixRegistryProperties unixRegistryProperties = new UnixRegistryProperties();
                unixRegistryProperties.load(new FileInputStream(file));
                return unixRegistryProperties.containsKey(string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    @Override
    public byte[] getByteValue(String string, String string2) {
        return this.getByteValue(string, string2, false);
    }

    @Override
    public byte[] getByteValue(String string, String string2, boolean bl) {
        try {
            if (this.isKeyExists(string, bl).booleanValue()) {
                String string3 = bl ? this.clusterRootKey : this.rootKey;
                File file = new File(string3 + string + REG_FILE);
                UnixRegistryProperties unixRegistryProperties = new UnixRegistryProperties();
                unixRegistryProperties.load(new FileInputStream(file));
                Object object = unixRegistryProperties.get(string2);
                return object != null ? String.valueOf(object).getBytes() : null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    @Override
    public Integer getIntValue(String string, String string2) {
        return this.getIntValue(string, string2, false);
    }

    @Override
    public Integer getIntValue(String string, String string2, boolean bl) {
        try {
            if (this.isKeyExists(string, bl).booleanValue()) {
                String string3 = bl ? this.clusterRootKey : this.rootKey;
                File file = new File(string3 + string + REG_FILE);
                UnixRegistryProperties unixRegistryProperties = new UnixRegistryProperties();
                unixRegistryProperties.load(new FileInputStream(file));
                Object object = unixRegistryProperties.get(string2);
                return object != null ? Integer.valueOf(Integer.parseInt(String.valueOf(object))) : null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    @Override
    public Long getLongValue(String string, String string2) {
        return this.getLongValue(string, string2, false);
    }

    @Override
    public Long getLongValue(String string, String string2, boolean bl) {
        try {
            if (this.isKeyExists(string, bl).booleanValue()) {
                String string3 = bl ? this.clusterRootKey : this.rootKey;
                File file = new File(string3 + string + REG_FILE);
                UnixRegistryProperties unixRegistryProperties = new UnixRegistryProperties();
                unixRegistryProperties.load(new FileInputStream(file));
                Object object = unixRegistryProperties.get(string2);
                return object != null ? Long.valueOf(Long.parseLong(String.valueOf(object))) : null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    @Override
    public String getStringValue(String string, String string2) {
        return this.getStringValue(string, string2, false);
    }

    @Override
    public String getStringValue(String string, String string2, boolean bl) {
        try {
            if (this.isKeyExists(string, bl).booleanValue()) {
                String string3 = bl ? this.clusterRootKey : this.rootKey;
                File file = new File(string3 + string + REG_FILE);
                UnixRegistryProperties unixRegistryProperties = new UnixRegistryProperties();
                unixRegistryProperties.load(new FileInputStream(file));
                Object object = unixRegistryProperties.get(string2);
                return object != null ? String.valueOf(object) : null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    @Override
    public String getExpandedStringValue(String string, String string2) {
        return this.getExpandedStringValue(string, string2, false);
    }

    @Override
    public String getExpandedStringValue(String string, String string2, boolean bl) {
        try {
            if (this.isKeyExists(string, bl).booleanValue()) {
                String string3 = bl ? this.clusterRootKey : this.rootKey;
                File file = new File(string3 + string + REG_FILE);
                UnixRegistryProperties unixRegistryProperties = new UnixRegistryProperties();
                unixRegistryProperties.load(new FileInputStream(file));
                Object object = unixRegistryProperties.get(string2);
                return object != null ? String.valueOf(object) : null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    @Override
    public String[] getMultiStringValue(String string, String string2) {
        return this.getMultiStringValue(string, string2, false);
    }

    @Override
    public String[] getMultiStringValue(String string, String string2, boolean bl) {
        try {
            if (this.isKeyExists(string, bl).booleanValue()) {
                String string3 = bl ? this.clusterRootKey : this.rootKey;
                File file = new File(string3 + string + REG_FILE);
                UnixRegistryProperties unixRegistryProperties = new UnixRegistryProperties();
                unixRegistryProperties.load(new FileInputStream(file));
                Object object = unixRegistryProperties.get(string2);
                return object != null ? String.valueOf(object).split(" ") : null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    @Override
    public TreeMap<String, Object> getValues(String string) {
        return this.getValues(string, false);
    }

    @Override
    public TreeMap<String, Object> getValues(String string, boolean bl) {
        try {
            if (this.isKeyExists(string, bl).booleanValue()) {
                String string2 = bl ? this.clusterRootKey : this.rootKey;
                File file = new File(string2 + string + REG_FILE);
                UnixRegistryProperties unixRegistryProperties = new UnixRegistryProperties();
                unixRegistryProperties.load(new FileInputStream(file));
                TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
                for (Object object : unixRegistryProperties.keySet()) {
                    treeMap.put(object.toString(), unixRegistryProperties.get(object));
                }
                return treeMap;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    @Override
    public List<String> getKeys(String string) {
        return this.getKeys(string, false);
    }

    @Override
    public List<String> getKeys(String string, boolean bl) {
        try {
            if (this.isKeyExists(string, bl).booleanValue()) {
                String string2 = bl ? this.clusterRootKey : this.rootKey;
                File file = new File(string2 + string + REG_FILE);
                UnixRegistryProperties unixRegistryProperties = new UnixRegistryProperties();
                unixRegistryProperties.load(new FileInputStream(file));
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Object object : unixRegistryProperties.keySet()) {
                    arrayList.add(object.toString());
                }
                return arrayList;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    protected Boolean createKey(String string, boolean bl) throws IOException {
        String string2 = bl ? this.clusterRootKey : this.rootKey;
        File file = new File(string2 + string);
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Failed to create folder for registry key: " + file);
        }
        return false;
    }

    @Override
    public void setByteValue(String string, String string2, byte[] byArray) {
        this.setByteValue(string, string2, byArray, false);
    }

    @Override
    public void setByteValue(String string, String string2, byte[] byArray, boolean bl) {
        try {
            String string3 = bl ? this.clusterRootKey : this.rootKey;
            File file = new File(string3 + string + REG_FILE);
            UnixRegistryProperties unixRegistryProperties = new UnixRegistryProperties();
            this.createKey(string, bl);
            if (file.exists()) {
                unixRegistryProperties.load(new FileInputStream(file));
            }
            unixRegistryProperties.setProperty(string2, new String(byArray, "UTF-8"));
            FileWriter fileWriter = new FileWriter(file);
            unixRegistryProperties.store(fileWriter, "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void setIntValue(String string, String string2, Integer n) {
        this.setIntValue(string, string2, n, false);
    }

    @Override
    public void setIntValue(String string, String string2, Integer n, boolean bl) {
        try {
            String string3 = bl ? this.clusterRootKey : this.rootKey;
            File file = new File(string3 + string + REG_FILE);
            UnixRegistryProperties unixRegistryProperties = new UnixRegistryProperties();
            this.createKey(string, bl);
            if (file.exists()) {
                unixRegistryProperties.load(new FileInputStream(file));
            }
            unixRegistryProperties.setProperty(string2, String.valueOf(n));
            FileWriter fileWriter = new FileWriter(file);
            unixRegistryProperties.store(fileWriter, "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void setLongValue(String string, String string2, Long l) {
        this.setLongValue(string2, string2, l, false);
    }

    @Override
    public void setLongValue(String string, String string2, Long l, boolean bl) {
        try {
            String string3 = bl ? this.clusterRootKey : this.rootKey;
            File file = new File(string3 + string + REG_FILE);
            UnixRegistryProperties unixRegistryProperties = new UnixRegistryProperties();
            this.createKey(string, bl);
            if (file.exists()) {
                unixRegistryProperties.load(new FileInputStream(file));
            }
            unixRegistryProperties.setProperty(string2, String.valueOf(l));
            FileWriter fileWriter = new FileWriter(file);
            unixRegistryProperties.store(fileWriter, "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void setStringValue(String string, String string2, String string3) {
        this.setStringValue(string, string2, string3, false);
    }

    @Override
    public void setStringValue(String string, String string2, String string3, boolean bl) {
        try {
            String string4 = bl ? this.clusterRootKey : this.rootKey;
            File file = new File(string4 + string + REG_FILE);
            UnixRegistryProperties unixRegistryProperties = new UnixRegistryProperties();
            this.createKey(string, bl);
            if (file.exists()) {
                unixRegistryProperties.load(new FileInputStream(file));
            }
            unixRegistryProperties.setProperty(string2, string3);
            FileWriter fileWriter = new FileWriter(file);
            unixRegistryProperties.store(fileWriter, "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void setExpandedStringValue(String string, String string2, String string3) {
        this.setExpandedStringValue(string, string2, string3, false);
    }

    @Override
    public void setExpandedStringValue(String string, String string2, String string3, boolean bl) {
        try {
            String string4 = bl ? this.clusterRootKey : this.rootKey;
            File file = new File(string4 + string + REG_FILE);
            UnixRegistryProperties unixRegistryProperties = new UnixRegistryProperties();
            this.createKey(string, bl);
            if (file.exists()) {
                unixRegistryProperties.load(new FileInputStream(file));
            }
            unixRegistryProperties.setProperty(string2, string3);
            FileWriter fileWriter = new FileWriter(file);
            unixRegistryProperties.store(fileWriter, "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

