/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.db;

import commvault.cte.db.CTEDBColumn;
import commvault.cte.db.CTEDBColumnStorage;
import commvault.cte.db.CTEDBException;
import commvault.cte.db.CTEDBStorageType;
import java.sql.ResultSet;

public abstract class CTEDBStorage {
    protected final CTEDBColumnStorage m_columns = new CTEDBColumnStorage();
    protected boolean m_bound = false;

    public String toString() {
        return this.getName();
    }

    public abstract String getName();

    public abstract CTEDBStorageType getType();

    protected abstract void initialize();

    public CTEDBColumnStorage getColumnStorage() {
        return this.m_columns;
    }

    protected void populate(ResultSet resultSet) throws CTEDBException {
        for (CTEDBColumn cTEDBColumn : this.m_columns.getAllColumns()) {
            if (!cTEDBColumn.isSelectable()) continue;
            cTEDBColumn.set(resultSet);
        }
        this.m_bound = true;
    }

    protected void populateIndex(ResultSet resultSet) throws CTEDBException {
        for (CTEDBColumn cTEDBColumn : this.m_columns.getAllColumns()) {
            cTEDBColumn.set(resultSet, cTEDBColumn.getIndex());
        }
        this.m_bound = true;
    }

    protected void resetModfiedFlag() {
        for (CTEDBColumn cTEDBColumn : this.m_columns.getAllColumns()) {
            cTEDBColumn.resetModifiedFlag();
        }
    }

    public boolean isRowBound() {
        return this.m_bound;
    }
}

